/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.cloud.bigquery.storage.v1beta1.stub.BigQueryStorageStub;
import com.google.cloud.bigquery.storage.v1beta1.stub.BigQueryStorageStubSettings;
import com.google.cloud.bigquery.storage.v1beta1.stub.GrpcBigQueryStorageCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcBigQueryStorageStub
extends BigQueryStorageStub {
    private static final MethodDescriptor<Storage.CreateReadSessionRequest, Storage.ReadSession> createReadSessionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.storage.v1beta1.BigQueryStorage/CreateReadSession").setRequestMarshaller(ProtoUtils.marshaller(Storage.CreateReadSessionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Storage.ReadSession.getDefaultInstance())).build();
    private static final MethodDescriptor<Storage.ReadRowsRequest, Storage.ReadRowsResponse> readRowsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.cloud.bigquery.storage.v1beta1.BigQueryStorage/ReadRows").setRequestMarshaller(ProtoUtils.marshaller(Storage.ReadRowsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Storage.ReadRowsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<Storage.BatchCreateReadSessionStreamsRequest, Storage.BatchCreateReadSessionStreamsResponse> batchCreateReadSessionStreamsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.storage.v1beta1.BigQueryStorage/BatchCreateReadSessionStreams").setRequestMarshaller(ProtoUtils.marshaller(Storage.BatchCreateReadSessionStreamsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Storage.BatchCreateReadSessionStreamsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<Storage.FinalizeStreamRequest, Empty> finalizeStreamMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.storage.v1beta1.BigQueryStorage/FinalizeStream").setRequestMarshaller(ProtoUtils.marshaller(Storage.FinalizeStreamRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<Storage.SplitReadStreamRequest, Storage.SplitReadStreamResponse> splitReadStreamMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.storage.v1beta1.BigQueryStorage/SplitReadStream").setRequestMarshaller(ProtoUtils.marshaller(Storage.SplitReadStreamRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Storage.SplitReadStreamResponse.getDefaultInstance())).build();
    private final UnaryCallable<Storage.CreateReadSessionRequest, Storage.ReadSession> createReadSessionCallable;
    private final ServerStreamingCallable<Storage.ReadRowsRequest, Storage.ReadRowsResponse> readRowsCallable;
    private final UnaryCallable<Storage.BatchCreateReadSessionStreamsRequest, Storage.BatchCreateReadSessionStreamsResponse> batchCreateReadSessionStreamsCallable;
    private final UnaryCallable<Storage.FinalizeStreamRequest, Empty> finalizeStreamCallable;
    private final UnaryCallable<Storage.SplitReadStreamRequest, Storage.SplitReadStreamResponse> splitReadStreamCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcBigQueryStorageStub create(BigQueryStorageStubSettings settings) throws IOException {
        return new GrpcBigQueryStorageStub(settings, ClientContext.create(settings));
    }

    public static final GrpcBigQueryStorageStub create(ClientContext clientContext) throws IOException {
        return new GrpcBigQueryStorageStub(BigQueryStorageStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcBigQueryStorageStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcBigQueryStorageStub(BigQueryStorageStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcBigQueryStorageStub(BigQueryStorageStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcBigQueryStorageCallableFactory());
    }

    protected GrpcBigQueryStorageStub(BigQueryStorageStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create(clientContext, callableFactory);
        GrpcCallSettings<Storage.CreateReadSessionRequest, Storage.ReadSession> createReadSessionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createReadSessionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("table_reference.dataset_id", String.valueOf(request.getTableReference().getDatasetId()));
            builder.add("table_reference.project_id", String.valueOf(request.getTableReference().getProjectId()));
            return builder.build();
        }).build();
        GrpcCallSettings<Storage.ReadRowsRequest, Storage.ReadRowsResponse> readRowsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(readRowsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("read_position.stream.name", String.valueOf(request.getReadPosition().getStream().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings<Storage.BatchCreateReadSessionStreamsRequest, Storage.BatchCreateReadSessionStreamsResponse> batchCreateReadSessionStreamsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchCreateReadSessionStreamsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("session.name", String.valueOf(request.getSession().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings<Storage.FinalizeStreamRequest, Empty> finalizeStreamTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(finalizeStreamMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("stream.name", String.valueOf(request.getStream().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings<Storage.SplitReadStreamRequest, Storage.SplitReadStreamResponse> splitReadStreamTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(splitReadStreamMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("original_stream.name", String.valueOf(request.getOriginalStream().getName()));
            return builder.build();
        }).build();
        this.createReadSessionCallable = callableFactory.createUnaryCallable(createReadSessionTransportSettings, settings.createReadSessionSettings(), clientContext);
        this.readRowsCallable = callableFactory.createServerStreamingCallable(readRowsTransportSettings, settings.readRowsSettings(), clientContext);
        this.batchCreateReadSessionStreamsCallable = callableFactory.createUnaryCallable(batchCreateReadSessionStreamsTransportSettings, settings.batchCreateReadSessionStreamsSettings(), clientContext);
        this.finalizeStreamCallable = callableFactory.createUnaryCallable(finalizeStreamTransportSettings, settings.finalizeStreamSettings(), clientContext);
        this.splitReadStreamCallable = callableFactory.createUnaryCallable(splitReadStreamTransportSettings, settings.splitReadStreamSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<Storage.CreateReadSessionRequest, Storage.ReadSession> createReadSessionCallable() {
        return this.createReadSessionCallable;
    }

    @Override
    public ServerStreamingCallable<Storage.ReadRowsRequest, Storage.ReadRowsResponse> readRowsCallable() {
        return this.readRowsCallable;
    }

    @Override
    public UnaryCallable<Storage.BatchCreateReadSessionStreamsRequest, Storage.BatchCreateReadSessionStreamsResponse> batchCreateReadSessionStreamsCallable() {
        return this.batchCreateReadSessionStreamsCallable;
    }

    @Override
    public UnaryCallable<Storage.FinalizeStreamRequest, Empty> finalizeStreamCallable() {
        return this.finalizeStreamCallable;
    }

    @Override
    public UnaryCallable<Storage.SplitReadStreamRequest, Storage.SplitReadStreamResponse> splitReadStreamCallable() {
        return this.splitReadStreamCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    @Override
    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

