/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientStream;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.bigquery.storage.v1.AppendRowsRequest;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import io.grpc.CallOptions;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class StreamConnection {
    private BidiStreamingCallable<AppendRowsRequest, AppendRowsResponse> bidiStreamingCallable;
    private ClientStream<AppendRowsRequest> clientStream;
    private RequestCallback requestCallback;
    private DoneCallback doneCallback;
    private static final Logger log = Logger.getLogger(StreamConnection.class.getName());

    public StreamConnection(BigQueryWriteClient client, RequestCallback requestCallback, DoneCallback doneCallback, @Nullable String compressorName) {
        this.requestCallback = requestCallback;
        this.doneCallback = doneCallback;
        GrpcCallContext apiCallContext = null;
        if (compressorName != null) {
            apiCallContext = GrpcCallContext.createDefault().withCallOptions(CallOptions.DEFAULT.withCompression(compressorName));
            log.info("gRPC compression is enabled with " + compressorName + " compression");
        }
        this.bidiStreamingCallable = client.appendRowsCallable();
        this.clientStream = this.bidiStreamingCallable.splitCall(new ResponseObserver<AppendRowsResponse>(){

            @Override
            public void onStart(StreamController controller) {
            }

            @Override
            public void onResponse(AppendRowsResponse response) {
                StreamConnection.this.requestCallback.run(response);
            }

            @Override
            public void onError(Throwable t) {
                StreamConnection.this.doneCallback.run(t);
            }

            @Override
            public void onComplete() {
                StreamConnection.this.doneCallback.run(new StatusRuntimeException(Status.fromCode(Status.Code.CANCELLED).withDescription("Stream is closed by user.")));
            }
        }, apiCallContext);
    }

    public void send(AppendRowsRequest request) {
        this.clientStream.send(request);
    }

    public void close() {
        this.clientStream.closeSend();
    }

    public static interface DoneCallback {
        public void run(Throwable var1);
    }

    public static interface RequestCallback {
        public void run(AppendRowsResponse var1);
    }
}

