/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.cloud.bigquery.storage.v1.ArrowSchema;
import com.google.cloud.bigquery.storage.v1.ArrowSchemaOrBuilder;
import com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions;
import com.google.cloud.bigquery.storage.v1.ArrowSerializationOptionsOrBuilder;
import com.google.cloud.bigquery.storage.v1.AvroSchema;
import com.google.cloud.bigquery.storage.v1.AvroSchemaOrBuilder;
import com.google.cloud.bigquery.storage.v1.AvroSerializationOptions;
import com.google.cloud.bigquery.storage.v1.AvroSerializationOptionsOrBuilder;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.cloud.bigquery.storage.v1.ReadSessionOrBuilder;
import com.google.cloud.bigquery.storage.v1.ReadStream;
import com.google.cloud.bigquery.storage.v1.ReadStreamOrBuilder;
import com.google.cloud.bigquery.storage.v1.StreamProto;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ReadSession
extends GeneratedMessageV3
implements ReadSessionOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    private int schemaCase_ = 0;
    private Object schema_;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_ = "";
    public static final int EXPIRE_TIME_FIELD_NUMBER = 2;
    private Timestamp expireTime_;
    public static final int DATA_FORMAT_FIELD_NUMBER = 3;
    private int dataFormat_ = 0;
    public static final int AVRO_SCHEMA_FIELD_NUMBER = 4;
    public static final int ARROW_SCHEMA_FIELD_NUMBER = 5;
    public static final int TABLE_FIELD_NUMBER = 6;
    private volatile Object table_ = "";
    public static final int TABLE_MODIFIERS_FIELD_NUMBER = 7;
    private TableModifiers tableModifiers_;
    public static final int READ_OPTIONS_FIELD_NUMBER = 8;
    private TableReadOptions readOptions_;
    public static final int STREAMS_FIELD_NUMBER = 10;
    private List<ReadStream> streams_;
    public static final int ESTIMATED_TOTAL_BYTES_SCANNED_FIELD_NUMBER = 12;
    private long estimatedTotalBytesScanned_ = 0L;
    public static final int ESTIMATED_TOTAL_PHYSICAL_FILE_SIZE_FIELD_NUMBER = 15;
    private long estimatedTotalPhysicalFileSize_ = 0L;
    public static final int ESTIMATED_ROW_COUNT_FIELD_NUMBER = 14;
    private long estimatedRowCount_ = 0L;
    public static final int TRACE_ID_FIELD_NUMBER = 13;
    private volatile Object traceId_ = "";
    private byte memoizedIsInitialized = (byte)-1;
    private static final ReadSession DEFAULT_INSTANCE = new ReadSession();
    private static final Parser<ReadSession> PARSER = new AbstractParser<ReadSession>(){

        @Override
        public ReadSession parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = ReadSession.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private ReadSession(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private ReadSession() {
        this.name_ = "";
        this.dataFormat_ = 0;
        this.table_ = "";
        this.streams_ = Collections.emptyList();
        this.traceId_ = "";
    }

    @Override
    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new ReadSession();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return StreamProto.internal_static_google_cloud_bigquery_storage_v1_ReadSession_descriptor;
    }

    @Override
    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return StreamProto.internal_static_google_cloud_bigquery_storage_v1_ReadSession_fieldAccessorTable.ensureFieldAccessorsInitialized(ReadSession.class, Builder.class);
    }

    @Override
    public SchemaCase getSchemaCase() {
        return SchemaCase.forNumber(this.schemaCase_);
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)ref);
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasExpireTime() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public Timestamp getExpireTime() {
        return this.expireTime_ == null ? Timestamp.getDefaultInstance() : this.expireTime_;
    }

    @Override
    public TimestampOrBuilder getExpireTimeOrBuilder() {
        return this.expireTime_ == null ? Timestamp.getDefaultInstance() : this.expireTime_;
    }

    @Override
    public int getDataFormatValue() {
        return this.dataFormat_;
    }

    @Override
    public DataFormat getDataFormat() {
        DataFormat result = DataFormat.forNumber(this.dataFormat_);
        return result == null ? DataFormat.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasAvroSchema() {
        return this.schemaCase_ == 4;
    }

    @Override
    public AvroSchema getAvroSchema() {
        if (this.schemaCase_ == 4) {
            return (AvroSchema)this.schema_;
        }
        return AvroSchema.getDefaultInstance();
    }

    @Override
    public AvroSchemaOrBuilder getAvroSchemaOrBuilder() {
        if (this.schemaCase_ == 4) {
            return (AvroSchema)this.schema_;
        }
        return AvroSchema.getDefaultInstance();
    }

    @Override
    public boolean hasArrowSchema() {
        return this.schemaCase_ == 5;
    }

    @Override
    public ArrowSchema getArrowSchema() {
        if (this.schemaCase_ == 5) {
            return (ArrowSchema)this.schema_;
        }
        return ArrowSchema.getDefaultInstance();
    }

    @Override
    public ArrowSchemaOrBuilder getArrowSchemaOrBuilder() {
        if (this.schemaCase_ == 5) {
            return (ArrowSchema)this.schema_;
        }
        return ArrowSchema.getDefaultInstance();
    }

    @Override
    public String getTable() {
        Object ref = this.table_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.table_ = s;
        return s;
    }

    @Override
    public ByteString getTableBytes() {
        Object ref = this.table_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)ref);
            this.table_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasTableModifiers() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public TableModifiers getTableModifiers() {
        return this.tableModifiers_ == null ? TableModifiers.getDefaultInstance() : this.tableModifiers_;
    }

    @Override
    public TableModifiersOrBuilder getTableModifiersOrBuilder() {
        return this.tableModifiers_ == null ? TableModifiers.getDefaultInstance() : this.tableModifiers_;
    }

    @Override
    public boolean hasReadOptions() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public TableReadOptions getReadOptions() {
        return this.readOptions_ == null ? TableReadOptions.getDefaultInstance() : this.readOptions_;
    }

    @Override
    public TableReadOptionsOrBuilder getReadOptionsOrBuilder() {
        return this.readOptions_ == null ? TableReadOptions.getDefaultInstance() : this.readOptions_;
    }

    @Override
    public List<ReadStream> getStreamsList() {
        return this.streams_;
    }

    @Override
    public List<? extends ReadStreamOrBuilder> getStreamsOrBuilderList() {
        return this.streams_;
    }

    @Override
    public int getStreamsCount() {
        return this.streams_.size();
    }

    @Override
    public ReadStream getStreams(int index) {
        return this.streams_.get(index);
    }

    @Override
    public ReadStreamOrBuilder getStreamsOrBuilder(int index) {
        return this.streams_.get(index);
    }

    @Override
    public long getEstimatedTotalBytesScanned() {
        return this.estimatedTotalBytesScanned_;
    }

    @Override
    public long getEstimatedTotalPhysicalFileSize() {
        return this.estimatedTotalPhysicalFileSize_;
    }

    @Override
    public long getEstimatedRowCount() {
        return this.estimatedRowCount_;
    }

    @Override
    public String getTraceId() {
        Object ref = this.traceId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.traceId_ = s;
        return s;
    }

    @Override
    public ByteString getTraceIdBytes() {
        Object ref = this.traceId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)ref);
            this.traceId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    @Override
    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty(this.name_)) {
            GeneratedMessageV3.writeString(output, 1, this.name_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(2, this.getExpireTime());
        }
        if (this.dataFormat_ != DataFormat.DATA_FORMAT_UNSPECIFIED.getNumber()) {
            output.writeEnum(3, this.dataFormat_);
        }
        if (this.schemaCase_ == 4) {
            output.writeMessage(4, (AvroSchema)this.schema_);
        }
        if (this.schemaCase_ == 5) {
            output.writeMessage(5, (ArrowSchema)this.schema_);
        }
        if (!GeneratedMessageV3.isStringEmpty(this.table_)) {
            GeneratedMessageV3.writeString(output, 6, this.table_);
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(7, this.getTableModifiers());
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(8, this.getReadOptions());
        }
        for (int i = 0; i < this.streams_.size(); ++i) {
            output.writeMessage(10, this.streams_.get(i));
        }
        if (this.estimatedTotalBytesScanned_ != 0L) {
            output.writeInt64(12, this.estimatedTotalBytesScanned_);
        }
        if (!GeneratedMessageV3.isStringEmpty(this.traceId_)) {
            GeneratedMessageV3.writeString(output, 13, this.traceId_);
        }
        if (this.estimatedRowCount_ != 0L) {
            output.writeInt64(14, this.estimatedRowCount_);
        }
        if (this.estimatedTotalPhysicalFileSize_ != 0L) {
            output.writeInt64(15, this.estimatedTotalPhysicalFileSize_);
        }
        this.getUnknownFields().writeTo(output);
    }

    @Override
    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty(this.name_)) {
            size += GeneratedMessageV3.computeStringSize(1, this.name_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize(2, this.getExpireTime());
        }
        if (this.dataFormat_ != DataFormat.DATA_FORMAT_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize(3, this.dataFormat_);
        }
        if (this.schemaCase_ == 4) {
            size += CodedOutputStream.computeMessageSize(4, (AvroSchema)this.schema_);
        }
        if (this.schemaCase_ == 5) {
            size += CodedOutputStream.computeMessageSize(5, (ArrowSchema)this.schema_);
        }
        if (!GeneratedMessageV3.isStringEmpty(this.table_)) {
            size += GeneratedMessageV3.computeStringSize(6, this.table_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize(7, this.getTableModifiers());
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize(8, this.getReadOptions());
        }
        for (int i = 0; i < this.streams_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize(10, this.streams_.get(i));
        }
        if (this.estimatedTotalBytesScanned_ != 0L) {
            size += CodedOutputStream.computeInt64Size(12, this.estimatedTotalBytesScanned_);
        }
        if (!GeneratedMessageV3.isStringEmpty(this.traceId_)) {
            size += GeneratedMessageV3.computeStringSize(13, this.traceId_);
        }
        if (this.estimatedRowCount_ != 0L) {
            size += CodedOutputStream.computeInt64Size(14, this.estimatedRowCount_);
        }
        if (this.estimatedTotalPhysicalFileSize_ != 0L) {
            size += CodedOutputStream.computeInt64Size(15, this.estimatedTotalPhysicalFileSize_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ReadSession)) {
            return super.equals(obj);
        }
        ReadSession other = (ReadSession)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.hasExpireTime() != other.hasExpireTime()) {
            return false;
        }
        if (this.hasExpireTime() && !this.getExpireTime().equals(other.getExpireTime())) {
            return false;
        }
        if (this.dataFormat_ != other.dataFormat_) {
            return false;
        }
        if (!this.getTable().equals(other.getTable())) {
            return false;
        }
        if (this.hasTableModifiers() != other.hasTableModifiers()) {
            return false;
        }
        if (this.hasTableModifiers() && !this.getTableModifiers().equals(other.getTableModifiers())) {
            return false;
        }
        if (this.hasReadOptions() != other.hasReadOptions()) {
            return false;
        }
        if (this.hasReadOptions() && !this.getReadOptions().equals(other.getReadOptions())) {
            return false;
        }
        if (!this.getStreamsList().equals(other.getStreamsList())) {
            return false;
        }
        if (this.getEstimatedTotalBytesScanned() != other.getEstimatedTotalBytesScanned()) {
            return false;
        }
        if (this.getEstimatedTotalPhysicalFileSize() != other.getEstimatedTotalPhysicalFileSize()) {
            return false;
        }
        if (this.getEstimatedRowCount() != other.getEstimatedRowCount()) {
            return false;
        }
        if (!this.getTraceId().equals(other.getTraceId())) {
            return false;
        }
        if (!this.getSchemaCase().equals(other.getSchemaCase())) {
            return false;
        }
        switch (this.schemaCase_) {
            case 4: {
                if (this.getAvroSchema().equals(other.getAvroSchema())) break;
                return false;
            }
            case 5: {
                if (this.getArrowSchema().equals(other.getArrowSchema())) break;
                return false;
            }
        }
        return this.getUnknownFields().equals(other.getUnknownFields());
    }

    @Override
    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + ReadSession.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        if (this.hasExpireTime()) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getExpireTime().hashCode();
        }
        hash = 37 * hash + 3;
        hash = 53 * hash + this.dataFormat_;
        hash = 37 * hash + 6;
        hash = 53 * hash + this.getTable().hashCode();
        if (this.hasTableModifiers()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getTableModifiers().hashCode();
        }
        if (this.hasReadOptions()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getReadOptions().hashCode();
        }
        if (this.getStreamsCount() > 0) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getStreamsList().hashCode();
        }
        hash = 37 * hash + 12;
        hash = 53 * hash + Internal.hashLong(this.getEstimatedTotalBytesScanned());
        hash = 37 * hash + 15;
        hash = 53 * hash + Internal.hashLong(this.getEstimatedTotalPhysicalFileSize());
        hash = 37 * hash + 14;
        hash = 53 * hash + Internal.hashLong(this.getEstimatedRowCount());
        hash = 37 * hash + 13;
        hash = 53 * hash + this.getTraceId().hashCode();
        switch (this.schemaCase_) {
            case 4: {
                hash = 37 * hash + 4;
                hash = 53 * hash + this.getAvroSchema().hashCode();
                break;
            }
            case 5: {
                hash = 37 * hash + 5;
                hash = 53 * hash + this.getArrowSchema().hashCode();
                break;
            }
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static ReadSession parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static ReadSession parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static ReadSession parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static ReadSession parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static ReadSession parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static ReadSession parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static ReadSession parseFrom(InputStream input) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static ReadSession parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static ReadSession parseDelimitedFrom(InputStream input) throws IOException {
        return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static ReadSession parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }

    public static ReadSession parseFrom(CodedInputStream input) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static ReadSession parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
    }

    @Override
    public Builder newBuilderForType() {
        return ReadSession.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ReadSession prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @Override
    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @Override
    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static ReadSession getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<ReadSession> parser() {
        return PARSER;
    }

    public Parser<ReadSession> getParserForType() {
        return PARSER;
    }

    @Override
    public ReadSession getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class TableReadOptions
    extends GeneratedMessageV3
    implements TableReadOptionsOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        private int outputFormatSerializationOptionsCase_ = 0;
        private Object outputFormatSerializationOptions_;
        public static final int SELECTED_FIELDS_FIELD_NUMBER = 1;
        private LazyStringArrayList selectedFields_ = LazyStringArrayList.emptyList();
        public static final int ROW_RESTRICTION_FIELD_NUMBER = 2;
        private volatile Object rowRestriction_ = "";
        public static final int ARROW_SERIALIZATION_OPTIONS_FIELD_NUMBER = 3;
        public static final int AVRO_SERIALIZATION_OPTIONS_FIELD_NUMBER = 4;
        public static final int SAMPLE_PERCENTAGE_FIELD_NUMBER = 5;
        private double samplePercentage_ = 0.0;
        public static final int RESPONSE_COMPRESSION_CODEC_FIELD_NUMBER = 6;
        private int responseCompressionCodec_ = 0;
        private byte memoizedIsInitialized = (byte)-1;
        private static final TableReadOptions DEFAULT_INSTANCE = new TableReadOptions();
        private static final Parser<TableReadOptions> PARSER = new AbstractParser<TableReadOptions>(){

            @Override
            public TableReadOptions parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = TableReadOptions.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private TableReadOptions(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private TableReadOptions() {
            this.selectedFields_ = LazyStringArrayList.emptyList();
            this.rowRestriction_ = "";
            this.responseCompressionCodec_ = 0;
        }

        @Override
        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new TableReadOptions();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return StreamProto.internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableReadOptions_descriptor;
        }

        @Override
        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return StreamProto.internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableReadOptions_fieldAccessorTable.ensureFieldAccessorsInitialized(TableReadOptions.class, Builder.class);
        }

        @Override
        public OutputFormatSerializationOptionsCase getOutputFormatSerializationOptionsCase() {
            return OutputFormatSerializationOptionsCase.forNumber(this.outputFormatSerializationOptionsCase_);
        }

        public ProtocolStringList getSelectedFieldsList() {
            return this.selectedFields_;
        }

        @Override
        public int getSelectedFieldsCount() {
            return this.selectedFields_.size();
        }

        @Override
        public String getSelectedFields(int index) {
            return this.selectedFields_.get(index);
        }

        @Override
        public ByteString getSelectedFieldsBytes(int index) {
            return this.selectedFields_.getByteString(index);
        }

        @Override
        public String getRowRestriction() {
            Object ref = this.rowRestriction_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.rowRestriction_ = s;
            return s;
        }

        @Override
        public ByteString getRowRestrictionBytes() {
            Object ref = this.rowRestriction_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.rowRestriction_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public boolean hasArrowSerializationOptions() {
            return this.outputFormatSerializationOptionsCase_ == 3;
        }

        @Override
        public ArrowSerializationOptions getArrowSerializationOptions() {
            if (this.outputFormatSerializationOptionsCase_ == 3) {
                return (ArrowSerializationOptions)this.outputFormatSerializationOptions_;
            }
            return ArrowSerializationOptions.getDefaultInstance();
        }

        @Override
        public ArrowSerializationOptionsOrBuilder getArrowSerializationOptionsOrBuilder() {
            if (this.outputFormatSerializationOptionsCase_ == 3) {
                return (ArrowSerializationOptions)this.outputFormatSerializationOptions_;
            }
            return ArrowSerializationOptions.getDefaultInstance();
        }

        @Override
        public boolean hasAvroSerializationOptions() {
            return this.outputFormatSerializationOptionsCase_ == 4;
        }

        @Override
        public AvroSerializationOptions getAvroSerializationOptions() {
            if (this.outputFormatSerializationOptionsCase_ == 4) {
                return (AvroSerializationOptions)this.outputFormatSerializationOptions_;
            }
            return AvroSerializationOptions.getDefaultInstance();
        }

        @Override
        public AvroSerializationOptionsOrBuilder getAvroSerializationOptionsOrBuilder() {
            if (this.outputFormatSerializationOptionsCase_ == 4) {
                return (AvroSerializationOptions)this.outputFormatSerializationOptions_;
            }
            return AvroSerializationOptions.getDefaultInstance();
        }

        @Override
        public boolean hasSamplePercentage() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public double getSamplePercentage() {
            return this.samplePercentage_;
        }

        @Override
        public boolean hasResponseCompressionCodec() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public int getResponseCompressionCodecValue() {
            return this.responseCompressionCodec_;
        }

        @Override
        public ResponseCompressionCodec getResponseCompressionCodec() {
            ResponseCompressionCodec result = ResponseCompressionCodec.forNumber(this.responseCompressionCodec_);
            return result == null ? ResponseCompressionCodec.UNRECOGNIZED : result;
        }

        @Override
        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        @Override
        public void writeTo(CodedOutputStream output) throws IOException {
            for (int i = 0; i < this.selectedFields_.size(); ++i) {
                GeneratedMessageV3.writeString(output, 1, this.selectedFields_.getRaw(i));
            }
            if (!GeneratedMessageV3.isStringEmpty(this.rowRestriction_)) {
                GeneratedMessageV3.writeString(output, 2, this.rowRestriction_);
            }
            if (this.outputFormatSerializationOptionsCase_ == 3) {
                output.writeMessage(3, (ArrowSerializationOptions)this.outputFormatSerializationOptions_);
            }
            if (this.outputFormatSerializationOptionsCase_ == 4) {
                output.writeMessage(4, (AvroSerializationOptions)this.outputFormatSerializationOptions_);
            }
            if ((this.bitField0_ & 1) != 0) {
                output.writeDouble(5, this.samplePercentage_);
            }
            if ((this.bitField0_ & 2) != 0) {
                output.writeEnum(6, this.responseCompressionCodec_);
            }
            this.getUnknownFields().writeTo(output);
        }

        @Override
        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            int dataSize = 0;
            for (int i = 0; i < this.selectedFields_.size(); ++i) {
                dataSize += TableReadOptions.computeStringSizeNoTag(this.selectedFields_.getRaw(i));
            }
            size += dataSize;
            size += 1 * this.getSelectedFieldsList().size();
            if (!GeneratedMessageV3.isStringEmpty(this.rowRestriction_)) {
                size += GeneratedMessageV3.computeStringSize(2, this.rowRestriction_);
            }
            if (this.outputFormatSerializationOptionsCase_ == 3) {
                size += CodedOutputStream.computeMessageSize(3, (ArrowSerializationOptions)this.outputFormatSerializationOptions_);
            }
            if (this.outputFormatSerializationOptionsCase_ == 4) {
                size += CodedOutputStream.computeMessageSize(4, (AvroSerializationOptions)this.outputFormatSerializationOptions_);
            }
            if ((this.bitField0_ & 1) != 0) {
                size += CodedOutputStream.computeDoubleSize(5, this.samplePercentage_);
            }
            if ((this.bitField0_ & 2) != 0) {
                size += CodedOutputStream.computeEnumSize(6, this.responseCompressionCodec_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof TableReadOptions)) {
                return super.equals(obj);
            }
            TableReadOptions other = (TableReadOptions)obj;
            if (!this.getSelectedFieldsList().equals(other.getSelectedFieldsList())) {
                return false;
            }
            if (!this.getRowRestriction().equals(other.getRowRestriction())) {
                return false;
            }
            if (this.hasSamplePercentage() != other.hasSamplePercentage()) {
                return false;
            }
            if (this.hasSamplePercentage() && Double.doubleToLongBits(this.getSamplePercentage()) != Double.doubleToLongBits(other.getSamplePercentage())) {
                return false;
            }
            if (this.hasResponseCompressionCodec() != other.hasResponseCompressionCodec()) {
                return false;
            }
            if (this.hasResponseCompressionCodec() && this.responseCompressionCodec_ != other.responseCompressionCodec_) {
                return false;
            }
            if (!this.getOutputFormatSerializationOptionsCase().equals(other.getOutputFormatSerializationOptionsCase())) {
                return false;
            }
            switch (this.outputFormatSerializationOptionsCase_) {
                case 3: {
                    if (this.getArrowSerializationOptions().equals(other.getArrowSerializationOptions())) break;
                    return false;
                }
                case 4: {
                    if (this.getAvroSerializationOptions().equals(other.getAvroSerializationOptions())) break;
                    return false;
                }
            }
            return this.getUnknownFields().equals(other.getUnknownFields());
        }

        @Override
        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + TableReadOptions.getDescriptor().hashCode();
            if (this.getSelectedFieldsCount() > 0) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.getSelectedFieldsList().hashCode();
            }
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getRowRestriction().hashCode();
            if (this.hasSamplePercentage()) {
                hash = 37 * hash + 5;
                hash = 53 * hash + Internal.hashLong(Double.doubleToLongBits(this.getSamplePercentage()));
            }
            if (this.hasResponseCompressionCodec()) {
                hash = 37 * hash + 6;
                hash = 53 * hash + this.responseCompressionCodec_;
            }
            switch (this.outputFormatSerializationOptionsCase_) {
                case 3: {
                    hash = 37 * hash + 3;
                    hash = 53 * hash + this.getArrowSerializationOptions().hashCode();
                    break;
                }
                case 4: {
                    hash = 37 * hash + 4;
                    hash = 53 * hash + this.getAvroSerializationOptions().hashCode();
                    break;
                }
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static TableReadOptions parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static TableReadOptions parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static TableReadOptions parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static TableReadOptions parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static TableReadOptions parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static TableReadOptions parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static TableReadOptions parseFrom(InputStream input) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static TableReadOptions parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static TableReadOptions parseDelimitedFrom(InputStream input) throws IOException {
            return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
        }

        public static TableReadOptions parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }

        public static TableReadOptions parseFrom(CodedInputStream input) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static TableReadOptions parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
        }

        @Override
        public Builder newBuilderForType() {
            return TableReadOptions.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(TableReadOptions prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @Override
        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static TableReadOptions getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<TableReadOptions> parser() {
            return PARSER;
        }

        public Parser<TableReadOptions> getParserForType() {
            return PARSER;
        }

        @Override
        public TableReadOptions getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements TableReadOptionsOrBuilder {
            private int outputFormatSerializationOptionsCase_ = 0;
            private Object outputFormatSerializationOptions_;
            private int bitField0_;
            private LazyStringArrayList selectedFields_ = LazyStringArrayList.emptyList();
            private Object rowRestriction_ = "";
            private SingleFieldBuilderV3<ArrowSerializationOptions, ArrowSerializationOptions.Builder, ArrowSerializationOptionsOrBuilder> arrowSerializationOptionsBuilder_;
            private SingleFieldBuilderV3<AvroSerializationOptions, AvroSerializationOptions.Builder, AvroSerializationOptionsOrBuilder> avroSerializationOptionsBuilder_;
            private double samplePercentage_;
            private int responseCompressionCodec_ = 0;

            public static final Descriptors.Descriptor getDescriptor() {
                return StreamProto.internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableReadOptions_descriptor;
            }

            @Override
            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return StreamProto.internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableReadOptions_fieldAccessorTable.ensureFieldAccessorsInitialized(TableReadOptions.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            @Override
            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.selectedFields_ = LazyStringArrayList.emptyList();
                this.rowRestriction_ = "";
                if (this.arrowSerializationOptionsBuilder_ != null) {
                    this.arrowSerializationOptionsBuilder_.clear();
                }
                if (this.avroSerializationOptionsBuilder_ != null) {
                    this.avroSerializationOptionsBuilder_.clear();
                }
                this.samplePercentage_ = 0.0;
                this.responseCompressionCodec_ = 0;
                this.outputFormatSerializationOptionsCase_ = 0;
                this.outputFormatSerializationOptions_ = null;
                return this;
            }

            @Override
            public Descriptors.Descriptor getDescriptorForType() {
                return StreamProto.internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableReadOptions_descriptor;
            }

            @Override
            public TableReadOptions getDefaultInstanceForType() {
                return TableReadOptions.getDefaultInstance();
            }

            @Override
            public TableReadOptions build() {
                TableReadOptions result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException(result);
                }
                return result;
            }

            @Override
            public TableReadOptions buildPartial() {
                TableReadOptions result = new TableReadOptions(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.buildPartialOneofs(result);
                this.onBuilt();
                return result;
            }

            private void buildPartial0(TableReadOptions result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    this.selectedFields_.makeImmutable();
                    result.selectedFields_ = this.selectedFields_;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.rowRestriction_ = this.rowRestriction_;
                }
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 0x10) != 0) {
                    result.samplePercentage_ = this.samplePercentage_;
                    to_bitField0_ |= 1;
                }
                if ((from_bitField0_ & 0x20) != 0) {
                    result.responseCompressionCodec_ = this.responseCompressionCodec_;
                    to_bitField0_ |= 2;
                }
                result.bitField0_ |= to_bitField0_;
            }

            private void buildPartialOneofs(TableReadOptions result) {
                result.outputFormatSerializationOptionsCase_ = this.outputFormatSerializationOptionsCase_;
                result.outputFormatSerializationOptions_ = this.outputFormatSerializationOptions_;
                if (this.outputFormatSerializationOptionsCase_ == 3 && this.arrowSerializationOptionsBuilder_ != null) {
                    result.outputFormatSerializationOptions_ = this.arrowSerializationOptionsBuilder_.build();
                }
                if (this.outputFormatSerializationOptionsCase_ == 4 && this.avroSerializationOptionsBuilder_ != null) {
                    result.outputFormatSerializationOptions_ = this.avroSerializationOptionsBuilder_.build();
                }
            }

            @Override
            public Builder clone() {
                return (Builder)super.clone();
            }

            @Override
            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            @Override
            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            @Override
            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            @Override
            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            @Override
            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            @Override
            public Builder mergeFrom(Message other) {
                if (other instanceof TableReadOptions) {
                    return this.mergeFrom((TableReadOptions)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(TableReadOptions other) {
                if (other == TableReadOptions.getDefaultInstance()) {
                    return this;
                }
                if (!other.selectedFields_.isEmpty()) {
                    if (this.selectedFields_.isEmpty()) {
                        this.selectedFields_ = other.selectedFields_;
                        this.bitField0_ |= 1;
                    } else {
                        this.ensureSelectedFieldsIsMutable();
                        this.selectedFields_.addAll(other.selectedFields_);
                    }
                    this.onChanged();
                }
                if (!other.getRowRestriction().isEmpty()) {
                    this.rowRestriction_ = other.rowRestriction_;
                    this.bitField0_ |= 2;
                    this.onChanged();
                }
                if (other.hasSamplePercentage()) {
                    this.setSamplePercentage(other.getSamplePercentage());
                }
                if (other.hasResponseCompressionCodec()) {
                    this.setResponseCompressionCodec(other.getResponseCompressionCodec());
                }
                switch (other.getOutputFormatSerializationOptionsCase()) {
                    case ARROW_SERIALIZATION_OPTIONS: {
                        this.mergeArrowSerializationOptions(other.getArrowSerializationOptions());
                        break;
                    }
                    case AVRO_SERIALIZATION_OPTIONS: {
                        this.mergeAvroSerializationOptions(other.getAvroSerializationOptions());
                        break;
                    }
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            @Override
            public final boolean isInitialized() {
                return true;
            }

            @Override
            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block14: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block14;
                            }
                            case 10: {
                                String s = input.readStringRequireUtf8();
                                this.ensureSelectedFieldsIsMutable();
                                this.selectedFields_.add(s);
                                continue block14;
                            }
                            case 18: {
                                this.rowRestriction_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 2;
                                continue block14;
                            }
                            case 26: {
                                input.readMessage(this.getArrowSerializationOptionsFieldBuilder().getBuilder(), extensionRegistry);
                                this.outputFormatSerializationOptionsCase_ = 3;
                                continue block14;
                            }
                            case 34: {
                                input.readMessage(this.getAvroSerializationOptionsFieldBuilder().getBuilder(), extensionRegistry);
                                this.outputFormatSerializationOptionsCase_ = 4;
                                continue block14;
                            }
                            case 41: {
                                this.samplePercentage_ = input.readDouble();
                                this.bitField0_ |= 0x10;
                                continue block14;
                            }
                            case 48: {
                                this.responseCompressionCodec_ = input.readEnum();
                                this.bitField0_ |= 0x20;
                                continue block14;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public OutputFormatSerializationOptionsCase getOutputFormatSerializationOptionsCase() {
                return OutputFormatSerializationOptionsCase.forNumber(this.outputFormatSerializationOptionsCase_);
            }

            public Builder clearOutputFormatSerializationOptions() {
                this.outputFormatSerializationOptionsCase_ = 0;
                this.outputFormatSerializationOptions_ = null;
                this.onChanged();
                return this;
            }

            private void ensureSelectedFieldsIsMutable() {
                if (!this.selectedFields_.isModifiable()) {
                    this.selectedFields_ = new LazyStringArrayList(this.selectedFields_);
                }
                this.bitField0_ |= 1;
            }

            public ProtocolStringList getSelectedFieldsList() {
                this.selectedFields_.makeImmutable();
                return this.selectedFields_;
            }

            @Override
            public int getSelectedFieldsCount() {
                return this.selectedFields_.size();
            }

            @Override
            public String getSelectedFields(int index) {
                return this.selectedFields_.get(index);
            }

            @Override
            public ByteString getSelectedFieldsBytes(int index) {
                return this.selectedFields_.getByteString(index);
            }

            public Builder setSelectedFields(int index, String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureSelectedFieldsIsMutable();
                this.selectedFields_.set(index, value);
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder addSelectedFields(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureSelectedFieldsIsMutable();
                this.selectedFields_.add(value);
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder addAllSelectedFields(Iterable<String> values) {
                this.ensureSelectedFieldsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.selectedFields_);
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearSelectedFields() {
                this.selectedFields_ = LazyStringArrayList.emptyList();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            public Builder addSelectedFieldsBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                TableReadOptions.checkByteStringIsUtf8(value);
                this.ensureSelectedFieldsIsMutable();
                this.selectedFields_.add(value);
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            @Override
            public String getRowRestriction() {
                Object ref = this.rowRestriction_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.rowRestriction_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getRowRestrictionBytes() {
                Object ref = this.rowRestriction_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)ref);
                    this.rowRestriction_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setRowRestriction(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.rowRestriction_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearRowRestriction() {
                this.rowRestriction_ = TableReadOptions.getDefaultInstance().getRowRestriction();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
                return this;
            }

            public Builder setRowRestrictionBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                TableReadOptions.checkByteStringIsUtf8(value);
                this.rowRestriction_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasArrowSerializationOptions() {
                return this.outputFormatSerializationOptionsCase_ == 3;
            }

            @Override
            public ArrowSerializationOptions getArrowSerializationOptions() {
                if (this.arrowSerializationOptionsBuilder_ == null) {
                    if (this.outputFormatSerializationOptionsCase_ == 3) {
                        return (ArrowSerializationOptions)this.outputFormatSerializationOptions_;
                    }
                    return ArrowSerializationOptions.getDefaultInstance();
                }
                if (this.outputFormatSerializationOptionsCase_ == 3) {
                    return this.arrowSerializationOptionsBuilder_.getMessage();
                }
                return ArrowSerializationOptions.getDefaultInstance();
            }

            public Builder setArrowSerializationOptions(ArrowSerializationOptions value) {
                if (this.arrowSerializationOptionsBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.outputFormatSerializationOptions_ = value;
                    this.onChanged();
                } else {
                    this.arrowSerializationOptionsBuilder_.setMessage(value);
                }
                this.outputFormatSerializationOptionsCase_ = 3;
                return this;
            }

            public Builder setArrowSerializationOptions(ArrowSerializationOptions.Builder builderForValue) {
                if (this.arrowSerializationOptionsBuilder_ == null) {
                    this.outputFormatSerializationOptions_ = builderForValue.build();
                    this.onChanged();
                } else {
                    this.arrowSerializationOptionsBuilder_.setMessage(builderForValue.build());
                }
                this.outputFormatSerializationOptionsCase_ = 3;
                return this;
            }

            public Builder mergeArrowSerializationOptions(ArrowSerializationOptions value) {
                if (this.arrowSerializationOptionsBuilder_ == null) {
                    this.outputFormatSerializationOptions_ = this.outputFormatSerializationOptionsCase_ == 3 && this.outputFormatSerializationOptions_ != ArrowSerializationOptions.getDefaultInstance() ? ArrowSerializationOptions.newBuilder((ArrowSerializationOptions)this.outputFormatSerializationOptions_).mergeFrom(value).buildPartial() : value;
                    this.onChanged();
                } else if (this.outputFormatSerializationOptionsCase_ == 3) {
                    this.arrowSerializationOptionsBuilder_.mergeFrom(value);
                } else {
                    this.arrowSerializationOptionsBuilder_.setMessage(value);
                }
                this.outputFormatSerializationOptionsCase_ = 3;
                return this;
            }

            public Builder clearArrowSerializationOptions() {
                if (this.arrowSerializationOptionsBuilder_ == null) {
                    if (this.outputFormatSerializationOptionsCase_ == 3) {
                        this.outputFormatSerializationOptionsCase_ = 0;
                        this.outputFormatSerializationOptions_ = null;
                        this.onChanged();
                    }
                } else {
                    if (this.outputFormatSerializationOptionsCase_ == 3) {
                        this.outputFormatSerializationOptionsCase_ = 0;
                        this.outputFormatSerializationOptions_ = null;
                    }
                    this.arrowSerializationOptionsBuilder_.clear();
                }
                return this;
            }

            public ArrowSerializationOptions.Builder getArrowSerializationOptionsBuilder() {
                return this.getArrowSerializationOptionsFieldBuilder().getBuilder();
            }

            @Override
            public ArrowSerializationOptionsOrBuilder getArrowSerializationOptionsOrBuilder() {
                if (this.outputFormatSerializationOptionsCase_ == 3 && this.arrowSerializationOptionsBuilder_ != null) {
                    return this.arrowSerializationOptionsBuilder_.getMessageOrBuilder();
                }
                if (this.outputFormatSerializationOptionsCase_ == 3) {
                    return (ArrowSerializationOptions)this.outputFormatSerializationOptions_;
                }
                return ArrowSerializationOptions.getDefaultInstance();
            }

            private SingleFieldBuilderV3<ArrowSerializationOptions, ArrowSerializationOptions.Builder, ArrowSerializationOptionsOrBuilder> getArrowSerializationOptionsFieldBuilder() {
                if (this.arrowSerializationOptionsBuilder_ == null) {
                    if (this.outputFormatSerializationOptionsCase_ != 3) {
                        this.outputFormatSerializationOptions_ = ArrowSerializationOptions.getDefaultInstance();
                    }
                    this.arrowSerializationOptionsBuilder_ = new SingleFieldBuilderV3((ArrowSerializationOptions)this.outputFormatSerializationOptions_, this.getParentForChildren(), this.isClean());
                    this.outputFormatSerializationOptions_ = null;
                }
                this.outputFormatSerializationOptionsCase_ = 3;
                this.onChanged();
                return this.arrowSerializationOptionsBuilder_;
            }

            @Override
            public boolean hasAvroSerializationOptions() {
                return this.outputFormatSerializationOptionsCase_ == 4;
            }

            @Override
            public AvroSerializationOptions getAvroSerializationOptions() {
                if (this.avroSerializationOptionsBuilder_ == null) {
                    if (this.outputFormatSerializationOptionsCase_ == 4) {
                        return (AvroSerializationOptions)this.outputFormatSerializationOptions_;
                    }
                    return AvroSerializationOptions.getDefaultInstance();
                }
                if (this.outputFormatSerializationOptionsCase_ == 4) {
                    return this.avroSerializationOptionsBuilder_.getMessage();
                }
                return AvroSerializationOptions.getDefaultInstance();
            }

            public Builder setAvroSerializationOptions(AvroSerializationOptions value) {
                if (this.avroSerializationOptionsBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.outputFormatSerializationOptions_ = value;
                    this.onChanged();
                } else {
                    this.avroSerializationOptionsBuilder_.setMessage(value);
                }
                this.outputFormatSerializationOptionsCase_ = 4;
                return this;
            }

            public Builder setAvroSerializationOptions(AvroSerializationOptions.Builder builderForValue) {
                if (this.avroSerializationOptionsBuilder_ == null) {
                    this.outputFormatSerializationOptions_ = builderForValue.build();
                    this.onChanged();
                } else {
                    this.avroSerializationOptionsBuilder_.setMessage(builderForValue.build());
                }
                this.outputFormatSerializationOptionsCase_ = 4;
                return this;
            }

            public Builder mergeAvroSerializationOptions(AvroSerializationOptions value) {
                if (this.avroSerializationOptionsBuilder_ == null) {
                    this.outputFormatSerializationOptions_ = this.outputFormatSerializationOptionsCase_ == 4 && this.outputFormatSerializationOptions_ != AvroSerializationOptions.getDefaultInstance() ? AvroSerializationOptions.newBuilder((AvroSerializationOptions)this.outputFormatSerializationOptions_).mergeFrom(value).buildPartial() : value;
                    this.onChanged();
                } else if (this.outputFormatSerializationOptionsCase_ == 4) {
                    this.avroSerializationOptionsBuilder_.mergeFrom(value);
                } else {
                    this.avroSerializationOptionsBuilder_.setMessage(value);
                }
                this.outputFormatSerializationOptionsCase_ = 4;
                return this;
            }

            public Builder clearAvroSerializationOptions() {
                if (this.avroSerializationOptionsBuilder_ == null) {
                    if (this.outputFormatSerializationOptionsCase_ == 4) {
                        this.outputFormatSerializationOptionsCase_ = 0;
                        this.outputFormatSerializationOptions_ = null;
                        this.onChanged();
                    }
                } else {
                    if (this.outputFormatSerializationOptionsCase_ == 4) {
                        this.outputFormatSerializationOptionsCase_ = 0;
                        this.outputFormatSerializationOptions_ = null;
                    }
                    this.avroSerializationOptionsBuilder_.clear();
                }
                return this;
            }

            public AvroSerializationOptions.Builder getAvroSerializationOptionsBuilder() {
                return this.getAvroSerializationOptionsFieldBuilder().getBuilder();
            }

            @Override
            public AvroSerializationOptionsOrBuilder getAvroSerializationOptionsOrBuilder() {
                if (this.outputFormatSerializationOptionsCase_ == 4 && this.avroSerializationOptionsBuilder_ != null) {
                    return this.avroSerializationOptionsBuilder_.getMessageOrBuilder();
                }
                if (this.outputFormatSerializationOptionsCase_ == 4) {
                    return (AvroSerializationOptions)this.outputFormatSerializationOptions_;
                }
                return AvroSerializationOptions.getDefaultInstance();
            }

            private SingleFieldBuilderV3<AvroSerializationOptions, AvroSerializationOptions.Builder, AvroSerializationOptionsOrBuilder> getAvroSerializationOptionsFieldBuilder() {
                if (this.avroSerializationOptionsBuilder_ == null) {
                    if (this.outputFormatSerializationOptionsCase_ != 4) {
                        this.outputFormatSerializationOptions_ = AvroSerializationOptions.getDefaultInstance();
                    }
                    this.avroSerializationOptionsBuilder_ = new SingleFieldBuilderV3((AvroSerializationOptions)this.outputFormatSerializationOptions_, this.getParentForChildren(), this.isClean());
                    this.outputFormatSerializationOptions_ = null;
                }
                this.outputFormatSerializationOptionsCase_ = 4;
                this.onChanged();
                return this.avroSerializationOptionsBuilder_;
            }

            @Override
            public boolean hasSamplePercentage() {
                return (this.bitField0_ & 0x10) != 0;
            }

            @Override
            public double getSamplePercentage() {
                return this.samplePercentage_;
            }

            public Builder setSamplePercentage(double value) {
                this.samplePercentage_ = value;
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            public Builder clearSamplePercentage() {
                this.bitField0_ &= 0xFFFFFFEF;
                this.samplePercentage_ = 0.0;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasResponseCompressionCodec() {
                return (this.bitField0_ & 0x20) != 0;
            }

            @Override
            public int getResponseCompressionCodecValue() {
                return this.responseCompressionCodec_;
            }

            public Builder setResponseCompressionCodecValue(int value) {
                this.responseCompressionCodec_ = value;
                this.bitField0_ |= 0x20;
                this.onChanged();
                return this;
            }

            @Override
            public ResponseCompressionCodec getResponseCompressionCodec() {
                ResponseCompressionCodec result = ResponseCompressionCodec.forNumber(this.responseCompressionCodec_);
                return result == null ? ResponseCompressionCodec.UNRECOGNIZED : result;
            }

            public Builder setResponseCompressionCodec(ResponseCompressionCodec value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.bitField0_ |= 0x20;
                this.responseCompressionCodec_ = value.getNumber();
                this.onChanged();
                return this;
            }

            public Builder clearResponseCompressionCodec() {
                this.bitField0_ &= 0xFFFFFFDF;
                this.responseCompressionCodec_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            @Override
            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }

        public static enum OutputFormatSerializationOptionsCase implements Internal.EnumLite,
        AbstractMessageLite.InternalOneOfEnum
        {
            ARROW_SERIALIZATION_OPTIONS(3),
            AVRO_SERIALIZATION_OPTIONS(4),
            OUTPUTFORMATSERIALIZATIONOPTIONS_NOT_SET(0);

            private final int value;

            private OutputFormatSerializationOptionsCase(int value) {
                this.value = value;
            }

            @Deprecated
            public static OutputFormatSerializationOptionsCase valueOf(int value) {
                return OutputFormatSerializationOptionsCase.forNumber(value);
            }

            public static OutputFormatSerializationOptionsCase forNumber(int value) {
                switch (value) {
                    case 3: {
                        return ARROW_SERIALIZATION_OPTIONS;
                    }
                    case 4: {
                        return AVRO_SERIALIZATION_OPTIONS;
                    }
                    case 0: {
                        return OUTPUTFORMATSERIALIZATIONOPTIONS_NOT_SET;
                    }
                }
                return null;
            }

            @Override
            public int getNumber() {
                return this.value;
            }
        }

        public static enum ResponseCompressionCodec implements ProtocolMessageEnum
        {
            RESPONSE_COMPRESSION_CODEC_UNSPECIFIED(0),
            RESPONSE_COMPRESSION_CODEC_LZ4(2),
            UNRECOGNIZED(-1);

            public static final int RESPONSE_COMPRESSION_CODEC_UNSPECIFIED_VALUE = 0;
            public static final int RESPONSE_COMPRESSION_CODEC_LZ4_VALUE = 2;
            private static final Internal.EnumLiteMap<ResponseCompressionCodec> internalValueMap;
            private static final ResponseCompressionCodec[] VALUES;
            private final int value;

            @Override
            public final int getNumber() {
                if (this == UNRECOGNIZED) {
                    throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
                }
                return this.value;
            }

            @Deprecated
            public static ResponseCompressionCodec valueOf(int value) {
                return ResponseCompressionCodec.forNumber(value);
            }

            public static ResponseCompressionCodec forNumber(int value) {
                switch (value) {
                    case 0: {
                        return RESPONSE_COMPRESSION_CODEC_UNSPECIFIED;
                    }
                    case 2: {
                        return RESPONSE_COMPRESSION_CODEC_LZ4;
                    }
                }
                return null;
            }

            public static Internal.EnumLiteMap<ResponseCompressionCodec> internalGetValueMap() {
                return internalValueMap;
            }

            @Override
            public final Descriptors.EnumValueDescriptor getValueDescriptor() {
                if (this == UNRECOGNIZED) {
                    throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
                }
                return ResponseCompressionCodec.getDescriptor().getValues().get(this.ordinal());
            }

            @Override
            public final Descriptors.EnumDescriptor getDescriptorForType() {
                return ResponseCompressionCodec.getDescriptor();
            }

            public static final Descriptors.EnumDescriptor getDescriptor() {
                return TableReadOptions.getDescriptor().getEnumTypes().get(0);
            }

            public static ResponseCompressionCodec valueOf(Descriptors.EnumValueDescriptor desc) {
                if (desc.getType() != ResponseCompressionCodec.getDescriptor()) {
                    throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
                }
                if (desc.getIndex() == -1) {
                    return UNRECOGNIZED;
                }
                return VALUES[desc.getIndex()];
            }

            private ResponseCompressionCodec(int value) {
                this.value = value;
            }

            static {
                internalValueMap = new Internal.EnumLiteMap<ResponseCompressionCodec>(){

                    @Override
                    public ResponseCompressionCodec findValueByNumber(int number) {
                        return ResponseCompressionCodec.forNumber(number);
                    }
                };
                VALUES = ResponseCompressionCodec.values();
            }
        }
    }

    public static final class TableModifiers
    extends GeneratedMessageV3
    implements TableModifiersOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        public static final int SNAPSHOT_TIME_FIELD_NUMBER = 1;
        private Timestamp snapshotTime_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final TableModifiers DEFAULT_INSTANCE = new TableModifiers();
        private static final Parser<TableModifiers> PARSER = new AbstractParser<TableModifiers>(){

            @Override
            public TableModifiers parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = TableModifiers.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private TableModifiers(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private TableModifiers() {
        }

        @Override
        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new TableModifiers();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return StreamProto.internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableModifiers_descriptor;
        }

        @Override
        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return StreamProto.internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableModifiers_fieldAccessorTable.ensureFieldAccessorsInitialized(TableModifiers.class, Builder.class);
        }

        @Override
        public boolean hasSnapshotTime() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public Timestamp getSnapshotTime() {
            return this.snapshotTime_ == null ? Timestamp.getDefaultInstance() : this.snapshotTime_;
        }

        @Override
        public TimestampOrBuilder getSnapshotTimeOrBuilder() {
            return this.snapshotTime_ == null ? Timestamp.getDefaultInstance() : this.snapshotTime_;
        }

        @Override
        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        @Override
        public void writeTo(CodedOutputStream output) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                output.writeMessage(1, this.getSnapshotTime());
            }
            this.getUnknownFields().writeTo(output);
        }

        @Override
        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if ((this.bitField0_ & 1) != 0) {
                size += CodedOutputStream.computeMessageSize(1, this.getSnapshotTime());
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof TableModifiers)) {
                return super.equals(obj);
            }
            TableModifiers other = (TableModifiers)obj;
            if (this.hasSnapshotTime() != other.hasSnapshotTime()) {
                return false;
            }
            if (this.hasSnapshotTime() && !this.getSnapshotTime().equals(other.getSnapshotTime())) {
                return false;
            }
            return this.getUnknownFields().equals(other.getUnknownFields());
        }

        @Override
        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + TableModifiers.getDescriptor().hashCode();
            if (this.hasSnapshotTime()) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.getSnapshotTime().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static TableModifiers parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static TableModifiers parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static TableModifiers parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static TableModifiers parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static TableModifiers parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static TableModifiers parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static TableModifiers parseFrom(InputStream input) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static TableModifiers parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static TableModifiers parseDelimitedFrom(InputStream input) throws IOException {
            return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
        }

        public static TableModifiers parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }

        public static TableModifiers parseFrom(CodedInputStream input) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static TableModifiers parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
        }

        @Override
        public Builder newBuilderForType() {
            return TableModifiers.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(TableModifiers prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @Override
        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static TableModifiers getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<TableModifiers> parser() {
            return PARSER;
        }

        public Parser<TableModifiers> getParserForType() {
            return PARSER;
        }

        @Override
        public TableModifiers getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements TableModifiersOrBuilder {
            private int bitField0_;
            private Timestamp snapshotTime_;
            private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> snapshotTimeBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return StreamProto.internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableModifiers_descriptor;
            }

            @Override
            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return StreamProto.internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableModifiers_fieldAccessorTable.ensureFieldAccessorsInitialized(TableModifiers.class, Builder.class);
            }

            private Builder() {
                this.maybeForceBuilderInitialization();
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                this.maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
                if (alwaysUseFieldBuilders) {
                    this.getSnapshotTimeFieldBuilder();
                }
            }

            @Override
            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.snapshotTime_ = null;
                if (this.snapshotTimeBuilder_ != null) {
                    this.snapshotTimeBuilder_.dispose();
                    this.snapshotTimeBuilder_ = null;
                }
                return this;
            }

            @Override
            public Descriptors.Descriptor getDescriptorForType() {
                return StreamProto.internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableModifiers_descriptor;
            }

            @Override
            public TableModifiers getDefaultInstanceForType() {
                return TableModifiers.getDefaultInstance();
            }

            @Override
            public TableModifiers build() {
                TableModifiers result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException(result);
                }
                return result;
            }

            @Override
            public TableModifiers buildPartial() {
                TableModifiers result = new TableModifiers(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(TableModifiers result) {
                int from_bitField0_ = this.bitField0_;
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 1) != 0) {
                    result.snapshotTime_ = this.snapshotTimeBuilder_ == null ? this.snapshotTime_ : this.snapshotTimeBuilder_.build();
                    to_bitField0_ |= 1;
                }
                result.bitField0_ |= to_bitField0_;
            }

            @Override
            public Builder clone() {
                return (Builder)super.clone();
            }

            @Override
            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            @Override
            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            @Override
            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            @Override
            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            @Override
            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            @Override
            public Builder mergeFrom(Message other) {
                if (other instanceof TableModifiers) {
                    return this.mergeFrom((TableModifiers)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(TableModifiers other) {
                if (other == TableModifiers.getDefaultInstance()) {
                    return this;
                }
                if (other.hasSnapshotTime()) {
                    this.mergeSnapshotTime(other.getSnapshotTime());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            @Override
            public final boolean isInitialized() {
                return true;
            }

            @Override
            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block9: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block9;
                            }
                            case 10: {
                                input.readMessage(this.getSnapshotTimeFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 1;
                                continue block9;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasSnapshotTime() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public Timestamp getSnapshotTime() {
                if (this.snapshotTimeBuilder_ == null) {
                    return this.snapshotTime_ == null ? Timestamp.getDefaultInstance() : this.snapshotTime_;
                }
                return this.snapshotTimeBuilder_.getMessage();
            }

            public Builder setSnapshotTime(Timestamp value) {
                if (this.snapshotTimeBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.snapshotTime_ = value;
                } else {
                    this.snapshotTimeBuilder_.setMessage(value);
                }
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder setSnapshotTime(Timestamp.Builder builderForValue) {
                if (this.snapshotTimeBuilder_ == null) {
                    this.snapshotTime_ = builderForValue.build();
                } else {
                    this.snapshotTimeBuilder_.setMessage(builderForValue.build());
                }
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder mergeSnapshotTime(Timestamp value) {
                if (this.snapshotTimeBuilder_ == null) {
                    if ((this.bitField0_ & 1) != 0 && this.snapshotTime_ != null && this.snapshotTime_ != Timestamp.getDefaultInstance()) {
                        this.getSnapshotTimeBuilder().mergeFrom(value);
                    } else {
                        this.snapshotTime_ = value;
                    }
                } else {
                    this.snapshotTimeBuilder_.mergeFrom(value);
                }
                if (this.snapshotTime_ != null) {
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                return this;
            }

            public Builder clearSnapshotTime() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.snapshotTime_ = null;
                if (this.snapshotTimeBuilder_ != null) {
                    this.snapshotTimeBuilder_.dispose();
                    this.snapshotTimeBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public Timestamp.Builder getSnapshotTimeBuilder() {
                this.bitField0_ |= 1;
                this.onChanged();
                return this.getSnapshotTimeFieldBuilder().getBuilder();
            }

            @Override
            public TimestampOrBuilder getSnapshotTimeOrBuilder() {
                if (this.snapshotTimeBuilder_ != null) {
                    return this.snapshotTimeBuilder_.getMessageOrBuilder();
                }
                return this.snapshotTime_ == null ? Timestamp.getDefaultInstance() : this.snapshotTime_;
            }

            private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getSnapshotTimeFieldBuilder() {
                if (this.snapshotTimeBuilder_ == null) {
                    this.snapshotTimeBuilder_ = new SingleFieldBuilderV3(this.getSnapshotTime(), this.getParentForChildren(), this.isClean());
                    this.snapshotTime_ = null;
                }
                return this.snapshotTimeBuilder_;
            }

            @Override
            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            @Override
            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements ReadSessionOrBuilder {
        private int schemaCase_ = 0;
        private Object schema_;
        private int bitField0_;
        private Object name_ = "";
        private Timestamp expireTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> expireTimeBuilder_;
        private int dataFormat_ = 0;
        private SingleFieldBuilderV3<AvroSchema, AvroSchema.Builder, AvroSchemaOrBuilder> avroSchemaBuilder_;
        private SingleFieldBuilderV3<ArrowSchema, ArrowSchema.Builder, ArrowSchemaOrBuilder> arrowSchemaBuilder_;
        private Object table_ = "";
        private TableModifiers tableModifiers_;
        private SingleFieldBuilderV3<TableModifiers, TableModifiers.Builder, TableModifiersOrBuilder> tableModifiersBuilder_;
        private TableReadOptions readOptions_;
        private SingleFieldBuilderV3<TableReadOptions, TableReadOptions.Builder, TableReadOptionsOrBuilder> readOptionsBuilder_;
        private List<ReadStream> streams_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<ReadStream, ReadStream.Builder, ReadStreamOrBuilder> streamsBuilder_;
        private long estimatedTotalBytesScanned_;
        private long estimatedTotalPhysicalFileSize_;
        private long estimatedRowCount_;
        private Object traceId_ = "";

        public static final Descriptors.Descriptor getDescriptor() {
            return StreamProto.internal_static_google_cloud_bigquery_storage_v1_ReadSession_descriptor;
        }

        @Override
        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return StreamProto.internal_static_google_cloud_bigquery_storage_v1_ReadSession_fieldAccessorTable.ensureFieldAccessorsInitialized(ReadSession.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getExpireTimeFieldBuilder();
                this.getTableModifiersFieldBuilder();
                this.getReadOptionsFieldBuilder();
                this.getStreamsFieldBuilder();
            }
        }

        @Override
        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.name_ = "";
            this.expireTime_ = null;
            if (this.expireTimeBuilder_ != null) {
                this.expireTimeBuilder_.dispose();
                this.expireTimeBuilder_ = null;
            }
            this.dataFormat_ = 0;
            if (this.avroSchemaBuilder_ != null) {
                this.avroSchemaBuilder_.clear();
            }
            if (this.arrowSchemaBuilder_ != null) {
                this.arrowSchemaBuilder_.clear();
            }
            this.table_ = "";
            this.tableModifiers_ = null;
            if (this.tableModifiersBuilder_ != null) {
                this.tableModifiersBuilder_.dispose();
                this.tableModifiersBuilder_ = null;
            }
            this.readOptions_ = null;
            if (this.readOptionsBuilder_ != null) {
                this.readOptionsBuilder_.dispose();
                this.readOptionsBuilder_ = null;
            }
            if (this.streamsBuilder_ == null) {
                this.streams_ = Collections.emptyList();
            } else {
                this.streams_ = null;
                this.streamsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFEFF;
            this.estimatedTotalBytesScanned_ = 0L;
            this.estimatedTotalPhysicalFileSize_ = 0L;
            this.estimatedRowCount_ = 0L;
            this.traceId_ = "";
            this.schemaCase_ = 0;
            this.schema_ = null;
            return this;
        }

        @Override
        public Descriptors.Descriptor getDescriptorForType() {
            return StreamProto.internal_static_google_cloud_bigquery_storage_v1_ReadSession_descriptor;
        }

        @Override
        public ReadSession getDefaultInstanceForType() {
            return ReadSession.getDefaultInstance();
        }

        @Override
        public ReadSession build() {
            ReadSession result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException(result);
            }
            return result;
        }

        @Override
        public ReadSession buildPartial() {
            ReadSession result = new ReadSession(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.buildPartialOneofs(result);
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(ReadSession result) {
            if (this.streamsBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0) {
                    this.streams_ = Collections.unmodifiableList(this.streams_);
                    this.bitField0_ &= 0xFFFFFEFF;
                }
                result.streams_ = this.streams_;
            } else {
                result.streams_ = this.streamsBuilder_.build();
            }
        }

        private void buildPartial0(ReadSession result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.name_ = this.name_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 2) != 0) {
                result.expireTime_ = this.expireTimeBuilder_ == null ? this.expireTime_ : this.expireTimeBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.dataFormat_ = this.dataFormat_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.table_ = this.table_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.tableModifiers_ = this.tableModifiersBuilder_ == null ? this.tableModifiers_ : this.tableModifiersBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.readOptions_ = this.readOptionsBuilder_ == null ? this.readOptions_ : this.readOptionsBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.estimatedTotalBytesScanned_ = this.estimatedTotalBytesScanned_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.estimatedTotalPhysicalFileSize_ = this.estimatedTotalPhysicalFileSize_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.estimatedRowCount_ = this.estimatedRowCount_;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.traceId_ = this.traceId_;
            }
            result.bitField0_ |= to_bitField0_;
        }

        private void buildPartialOneofs(ReadSession result) {
            result.schemaCase_ = this.schemaCase_;
            result.schema_ = this.schema_;
            if (this.schemaCase_ == 4 && this.avroSchemaBuilder_ != null) {
                result.schema_ = this.avroSchemaBuilder_.build();
            }
            if (this.schemaCase_ == 5 && this.arrowSchemaBuilder_ != null) {
                result.schema_ = this.arrowSchemaBuilder_.build();
            }
        }

        @Override
        public Builder clone() {
            return (Builder)super.clone();
        }

        @Override
        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        @Override
        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        @Override
        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        @Override
        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        @Override
        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        @Override
        public Builder mergeFrom(Message other) {
            if (other instanceof ReadSession) {
                return this.mergeFrom((ReadSession)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(ReadSession other) {
            if (other == ReadSession.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.hasExpireTime()) {
                this.mergeExpireTime(other.getExpireTime());
            }
            if (other.dataFormat_ != 0) {
                this.setDataFormatValue(other.getDataFormatValue());
            }
            if (!other.getTable().isEmpty()) {
                this.table_ = other.table_;
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            if (other.hasTableModifiers()) {
                this.mergeTableModifiers(other.getTableModifiers());
            }
            if (other.hasReadOptions()) {
                this.mergeReadOptions(other.getReadOptions());
            }
            if (this.streamsBuilder_ == null) {
                if (!other.streams_.isEmpty()) {
                    if (this.streams_.isEmpty()) {
                        this.streams_ = other.streams_;
                        this.bitField0_ &= 0xFFFFFEFF;
                    } else {
                        this.ensureStreamsIsMutable();
                        this.streams_.addAll(other.streams_);
                    }
                    this.onChanged();
                }
            } else if (!other.streams_.isEmpty()) {
                if (this.streamsBuilder_.isEmpty()) {
                    this.streamsBuilder_.dispose();
                    this.streamsBuilder_ = null;
                    this.streams_ = other.streams_;
                    this.bitField0_ &= 0xFFFFFEFF;
                    this.streamsBuilder_ = alwaysUseFieldBuilders ? this.getStreamsFieldBuilder() : null;
                } else {
                    this.streamsBuilder_.addAllMessages(other.streams_);
                }
            }
            if (other.getEstimatedTotalBytesScanned() != 0L) {
                this.setEstimatedTotalBytesScanned(other.getEstimatedTotalBytesScanned());
            }
            if (other.getEstimatedTotalPhysicalFileSize() != 0L) {
                this.setEstimatedTotalPhysicalFileSize(other.getEstimatedTotalPhysicalFileSize());
            }
            if (other.getEstimatedRowCount() != 0L) {
                this.setEstimatedRowCount(other.getEstimatedRowCount());
            }
            if (!other.getTraceId().isEmpty()) {
                this.traceId_ = other.traceId_;
                this.bitField0_ |= 0x1000;
                this.onChanged();
            }
            switch (other.getSchemaCase()) {
                case AVRO_SCHEMA: {
                    this.mergeAvroSchema(other.getAvroSchema());
                    break;
                }
                case ARROW_SCHEMA: {
                    this.mergeArrowSchema(other.getArrowSchema());
                    break;
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        @Override
        public final boolean isInitialized() {
            return true;
        }

        @Override
        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block21: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block21;
                        }
                        case 10: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block21;
                        }
                        case 18: {
                            input.readMessage(this.getExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 2;
                            continue block21;
                        }
                        case 24: {
                            this.dataFormat_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block21;
                        }
                        case 34: {
                            input.readMessage(this.getAvroSchemaFieldBuilder().getBuilder(), extensionRegistry);
                            this.schemaCase_ = 4;
                            continue block21;
                        }
                        case 42: {
                            input.readMessage(this.getArrowSchemaFieldBuilder().getBuilder(), extensionRegistry);
                            this.schemaCase_ = 5;
                            continue block21;
                        }
                        case 50: {
                            this.table_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x20;
                            continue block21;
                        }
                        case 58: {
                            input.readMessage(this.getTableModifiersFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x40;
                            continue block21;
                        }
                        case 66: {
                            input.readMessage(this.getReadOptionsFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x80;
                            continue block21;
                        }
                        case 82: {
                            ReadStream m = input.readMessage(ReadStream.parser(), extensionRegistry);
                            if (this.streamsBuilder_ == null) {
                                this.ensureStreamsIsMutable();
                                this.streams_.add(m);
                                continue block21;
                            }
                            this.streamsBuilder_.addMessage(m);
                            continue block21;
                        }
                        case 96: {
                            this.estimatedTotalBytesScanned_ = input.readInt64();
                            this.bitField0_ |= 0x200;
                            continue block21;
                        }
                        case 106: {
                            this.traceId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x1000;
                            continue block21;
                        }
                        case 112: {
                            this.estimatedRowCount_ = input.readInt64();
                            this.bitField0_ |= 0x800;
                            continue block21;
                        }
                        case 120: {
                            this.estimatedTotalPhysicalFileSize_ = input.readInt64();
                            this.bitField0_ |= 0x400;
                            continue block21;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public SchemaCase getSchemaCase() {
            return SchemaCase.forNumber(this.schemaCase_);
        }

        public Builder clearSchema() {
            this.schemaCase_ = 0;
            this.schema_ = null;
            this.onChanged();
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = ReadSession.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ReadSession.checkByteStringIsUtf8(value);
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasExpireTime() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public Timestamp getExpireTime() {
            if (this.expireTimeBuilder_ == null) {
                return this.expireTime_ == null ? Timestamp.getDefaultInstance() : this.expireTime_;
            }
            return this.expireTimeBuilder_.getMessage();
        }

        public Builder setExpireTime(Timestamp value) {
            if (this.expireTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.expireTime_ = value;
            } else {
                this.expireTimeBuilder_.setMessage(value);
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder setExpireTime(Timestamp.Builder builderForValue) {
            if (this.expireTimeBuilder_ == null) {
                this.expireTime_ = builderForValue.build();
            } else {
                this.expireTimeBuilder_.setMessage(builderForValue.build());
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder mergeExpireTime(Timestamp value) {
            if (this.expireTimeBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0 && this.expireTime_ != null && this.expireTime_ != Timestamp.getDefaultInstance()) {
                    this.getExpireTimeBuilder().mergeFrom(value);
                } else {
                    this.expireTime_ = value;
                }
            } else {
                this.expireTimeBuilder_.mergeFrom(value);
            }
            if (this.expireTime_ != null) {
                this.bitField0_ |= 2;
                this.onChanged();
            }
            return this;
        }

        public Builder clearExpireTime() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.expireTime_ = null;
            if (this.expireTimeBuilder_ != null) {
                this.expireTimeBuilder_.dispose();
                this.expireTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getExpireTimeBuilder() {
            this.bitField0_ |= 2;
            this.onChanged();
            return this.getExpireTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getExpireTimeOrBuilder() {
            if (this.expireTimeBuilder_ != null) {
                return this.expireTimeBuilder_.getMessageOrBuilder();
            }
            return this.expireTime_ == null ? Timestamp.getDefaultInstance() : this.expireTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getExpireTimeFieldBuilder() {
            if (this.expireTimeBuilder_ == null) {
                this.expireTimeBuilder_ = new SingleFieldBuilderV3(this.getExpireTime(), this.getParentForChildren(), this.isClean());
                this.expireTime_ = null;
            }
            return this.expireTimeBuilder_;
        }

        @Override
        public int getDataFormatValue() {
            return this.dataFormat_;
        }

        public Builder setDataFormatValue(int value) {
            this.dataFormat_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public DataFormat getDataFormat() {
            DataFormat result = DataFormat.forNumber(this.dataFormat_);
            return result == null ? DataFormat.UNRECOGNIZED : result;
        }

        public Builder setDataFormat(DataFormat value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.dataFormat_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearDataFormat() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.dataFormat_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasAvroSchema() {
            return this.schemaCase_ == 4;
        }

        @Override
        public AvroSchema getAvroSchema() {
            if (this.avroSchemaBuilder_ == null) {
                if (this.schemaCase_ == 4) {
                    return (AvroSchema)this.schema_;
                }
                return AvroSchema.getDefaultInstance();
            }
            if (this.schemaCase_ == 4) {
                return this.avroSchemaBuilder_.getMessage();
            }
            return AvroSchema.getDefaultInstance();
        }

        public Builder setAvroSchema(AvroSchema value) {
            if (this.avroSchemaBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.schema_ = value;
                this.onChanged();
            } else {
                this.avroSchemaBuilder_.setMessage(value);
            }
            this.schemaCase_ = 4;
            return this;
        }

        public Builder setAvroSchema(AvroSchema.Builder builderForValue) {
            if (this.avroSchemaBuilder_ == null) {
                this.schema_ = builderForValue.build();
                this.onChanged();
            } else {
                this.avroSchemaBuilder_.setMessage(builderForValue.build());
            }
            this.schemaCase_ = 4;
            return this;
        }

        public Builder mergeAvroSchema(AvroSchema value) {
            if (this.avroSchemaBuilder_ == null) {
                this.schema_ = this.schemaCase_ == 4 && this.schema_ != AvroSchema.getDefaultInstance() ? AvroSchema.newBuilder((AvroSchema)this.schema_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.schemaCase_ == 4) {
                this.avroSchemaBuilder_.mergeFrom(value);
            } else {
                this.avroSchemaBuilder_.setMessage(value);
            }
            this.schemaCase_ = 4;
            return this;
        }

        public Builder clearAvroSchema() {
            if (this.avroSchemaBuilder_ == null) {
                if (this.schemaCase_ == 4) {
                    this.schemaCase_ = 0;
                    this.schema_ = null;
                    this.onChanged();
                }
            } else {
                if (this.schemaCase_ == 4) {
                    this.schemaCase_ = 0;
                    this.schema_ = null;
                }
                this.avroSchemaBuilder_.clear();
            }
            return this;
        }

        public AvroSchema.Builder getAvroSchemaBuilder() {
            return this.getAvroSchemaFieldBuilder().getBuilder();
        }

        @Override
        public AvroSchemaOrBuilder getAvroSchemaOrBuilder() {
            if (this.schemaCase_ == 4 && this.avroSchemaBuilder_ != null) {
                return this.avroSchemaBuilder_.getMessageOrBuilder();
            }
            if (this.schemaCase_ == 4) {
                return (AvroSchema)this.schema_;
            }
            return AvroSchema.getDefaultInstance();
        }

        private SingleFieldBuilderV3<AvroSchema, AvroSchema.Builder, AvroSchemaOrBuilder> getAvroSchemaFieldBuilder() {
            if (this.avroSchemaBuilder_ == null) {
                if (this.schemaCase_ != 4) {
                    this.schema_ = AvroSchema.getDefaultInstance();
                }
                this.avroSchemaBuilder_ = new SingleFieldBuilderV3((AvroSchema)this.schema_, this.getParentForChildren(), this.isClean());
                this.schema_ = null;
            }
            this.schemaCase_ = 4;
            this.onChanged();
            return this.avroSchemaBuilder_;
        }

        @Override
        public boolean hasArrowSchema() {
            return this.schemaCase_ == 5;
        }

        @Override
        public ArrowSchema getArrowSchema() {
            if (this.arrowSchemaBuilder_ == null) {
                if (this.schemaCase_ == 5) {
                    return (ArrowSchema)this.schema_;
                }
                return ArrowSchema.getDefaultInstance();
            }
            if (this.schemaCase_ == 5) {
                return this.arrowSchemaBuilder_.getMessage();
            }
            return ArrowSchema.getDefaultInstance();
        }

        public Builder setArrowSchema(ArrowSchema value) {
            if (this.arrowSchemaBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.schema_ = value;
                this.onChanged();
            } else {
                this.arrowSchemaBuilder_.setMessage(value);
            }
            this.schemaCase_ = 5;
            return this;
        }

        public Builder setArrowSchema(ArrowSchema.Builder builderForValue) {
            if (this.arrowSchemaBuilder_ == null) {
                this.schema_ = builderForValue.build();
                this.onChanged();
            } else {
                this.arrowSchemaBuilder_.setMessage(builderForValue.build());
            }
            this.schemaCase_ = 5;
            return this;
        }

        public Builder mergeArrowSchema(ArrowSchema value) {
            if (this.arrowSchemaBuilder_ == null) {
                this.schema_ = this.schemaCase_ == 5 && this.schema_ != ArrowSchema.getDefaultInstance() ? ArrowSchema.newBuilder((ArrowSchema)this.schema_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.schemaCase_ == 5) {
                this.arrowSchemaBuilder_.mergeFrom(value);
            } else {
                this.arrowSchemaBuilder_.setMessage(value);
            }
            this.schemaCase_ = 5;
            return this;
        }

        public Builder clearArrowSchema() {
            if (this.arrowSchemaBuilder_ == null) {
                if (this.schemaCase_ == 5) {
                    this.schemaCase_ = 0;
                    this.schema_ = null;
                    this.onChanged();
                }
            } else {
                if (this.schemaCase_ == 5) {
                    this.schemaCase_ = 0;
                    this.schema_ = null;
                }
                this.arrowSchemaBuilder_.clear();
            }
            return this;
        }

        public ArrowSchema.Builder getArrowSchemaBuilder() {
            return this.getArrowSchemaFieldBuilder().getBuilder();
        }

        @Override
        public ArrowSchemaOrBuilder getArrowSchemaOrBuilder() {
            if (this.schemaCase_ == 5 && this.arrowSchemaBuilder_ != null) {
                return this.arrowSchemaBuilder_.getMessageOrBuilder();
            }
            if (this.schemaCase_ == 5) {
                return (ArrowSchema)this.schema_;
            }
            return ArrowSchema.getDefaultInstance();
        }

        private SingleFieldBuilderV3<ArrowSchema, ArrowSchema.Builder, ArrowSchemaOrBuilder> getArrowSchemaFieldBuilder() {
            if (this.arrowSchemaBuilder_ == null) {
                if (this.schemaCase_ != 5) {
                    this.schema_ = ArrowSchema.getDefaultInstance();
                }
                this.arrowSchemaBuilder_ = new SingleFieldBuilderV3((ArrowSchema)this.schema_, this.getParentForChildren(), this.isClean());
                this.schema_ = null;
            }
            this.schemaCase_ = 5;
            this.onChanged();
            return this.arrowSchemaBuilder_;
        }

        @Override
        public String getTable() {
            Object ref = this.table_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.table_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTableBytes() {
            Object ref = this.table_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.table_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setTable(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.table_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearTable() {
            this.table_ = ReadSession.getDefaultInstance().getTable();
            this.bitField0_ &= 0xFFFFFFDF;
            this.onChanged();
            return this;
        }

        public Builder setTableBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ReadSession.checkByteStringIsUtf8(value);
            this.table_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasTableModifiers() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public TableModifiers getTableModifiers() {
            if (this.tableModifiersBuilder_ == null) {
                return this.tableModifiers_ == null ? TableModifiers.getDefaultInstance() : this.tableModifiers_;
            }
            return this.tableModifiersBuilder_.getMessage();
        }

        public Builder setTableModifiers(TableModifiers value) {
            if (this.tableModifiersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.tableModifiers_ = value;
            } else {
                this.tableModifiersBuilder_.setMessage(value);
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder setTableModifiers(TableModifiers.Builder builderForValue) {
            if (this.tableModifiersBuilder_ == null) {
                this.tableModifiers_ = builderForValue.build();
            } else {
                this.tableModifiersBuilder_.setMessage(builderForValue.build());
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder mergeTableModifiers(TableModifiers value) {
            if (this.tableModifiersBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0 && this.tableModifiers_ != null && this.tableModifiers_ != TableModifiers.getDefaultInstance()) {
                    this.getTableModifiersBuilder().mergeFrom(value);
                } else {
                    this.tableModifiers_ = value;
                }
            } else {
                this.tableModifiersBuilder_.mergeFrom(value);
            }
            if (this.tableModifiers_ != null) {
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            return this;
        }

        public Builder clearTableModifiers() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.tableModifiers_ = null;
            if (this.tableModifiersBuilder_ != null) {
                this.tableModifiersBuilder_.dispose();
                this.tableModifiersBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public TableModifiers.Builder getTableModifiersBuilder() {
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this.getTableModifiersFieldBuilder().getBuilder();
        }

        @Override
        public TableModifiersOrBuilder getTableModifiersOrBuilder() {
            if (this.tableModifiersBuilder_ != null) {
                return this.tableModifiersBuilder_.getMessageOrBuilder();
            }
            return this.tableModifiers_ == null ? TableModifiers.getDefaultInstance() : this.tableModifiers_;
        }

        private SingleFieldBuilderV3<TableModifiers, TableModifiers.Builder, TableModifiersOrBuilder> getTableModifiersFieldBuilder() {
            if (this.tableModifiersBuilder_ == null) {
                this.tableModifiersBuilder_ = new SingleFieldBuilderV3(this.getTableModifiers(), this.getParentForChildren(), this.isClean());
                this.tableModifiers_ = null;
            }
            return this.tableModifiersBuilder_;
        }

        @Override
        public boolean hasReadOptions() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public TableReadOptions getReadOptions() {
            if (this.readOptionsBuilder_ == null) {
                return this.readOptions_ == null ? TableReadOptions.getDefaultInstance() : this.readOptions_;
            }
            return this.readOptionsBuilder_.getMessage();
        }

        public Builder setReadOptions(TableReadOptions value) {
            if (this.readOptionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.readOptions_ = value;
            } else {
                this.readOptionsBuilder_.setMessage(value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder setReadOptions(TableReadOptions.Builder builderForValue) {
            if (this.readOptionsBuilder_ == null) {
                this.readOptions_ = builderForValue.build();
            } else {
                this.readOptionsBuilder_.setMessage(builderForValue.build());
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder mergeReadOptions(TableReadOptions value) {
            if (this.readOptionsBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0 && this.readOptions_ != null && this.readOptions_ != TableReadOptions.getDefaultInstance()) {
                    this.getReadOptionsBuilder().mergeFrom(value);
                } else {
                    this.readOptions_ = value;
                }
            } else {
                this.readOptionsBuilder_.mergeFrom(value);
            }
            if (this.readOptions_ != null) {
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            return this;
        }

        public Builder clearReadOptions() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.readOptions_ = null;
            if (this.readOptionsBuilder_ != null) {
                this.readOptionsBuilder_.dispose();
                this.readOptionsBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public TableReadOptions.Builder getReadOptionsBuilder() {
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this.getReadOptionsFieldBuilder().getBuilder();
        }

        @Override
        public TableReadOptionsOrBuilder getReadOptionsOrBuilder() {
            if (this.readOptionsBuilder_ != null) {
                return this.readOptionsBuilder_.getMessageOrBuilder();
            }
            return this.readOptions_ == null ? TableReadOptions.getDefaultInstance() : this.readOptions_;
        }

        private SingleFieldBuilderV3<TableReadOptions, TableReadOptions.Builder, TableReadOptionsOrBuilder> getReadOptionsFieldBuilder() {
            if (this.readOptionsBuilder_ == null) {
                this.readOptionsBuilder_ = new SingleFieldBuilderV3(this.getReadOptions(), this.getParentForChildren(), this.isClean());
                this.readOptions_ = null;
            }
            return this.readOptionsBuilder_;
        }

        private void ensureStreamsIsMutable() {
            if ((this.bitField0_ & 0x100) == 0) {
                this.streams_ = new ArrayList<ReadStream>(this.streams_);
                this.bitField0_ |= 0x100;
            }
        }

        @Override
        public List<ReadStream> getStreamsList() {
            if (this.streamsBuilder_ == null) {
                return Collections.unmodifiableList(this.streams_);
            }
            return this.streamsBuilder_.getMessageList();
        }

        @Override
        public int getStreamsCount() {
            if (this.streamsBuilder_ == null) {
                return this.streams_.size();
            }
            return this.streamsBuilder_.getCount();
        }

        @Override
        public ReadStream getStreams(int index) {
            if (this.streamsBuilder_ == null) {
                return this.streams_.get(index);
            }
            return this.streamsBuilder_.getMessage(index);
        }

        public Builder setStreams(int index, ReadStream value) {
            if (this.streamsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureStreamsIsMutable();
                this.streams_.set(index, value);
                this.onChanged();
            } else {
                this.streamsBuilder_.setMessage(index, value);
            }
            return this;
        }

        public Builder setStreams(int index, ReadStream.Builder builderForValue) {
            if (this.streamsBuilder_ == null) {
                this.ensureStreamsIsMutable();
                this.streams_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.streamsBuilder_.setMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addStreams(ReadStream value) {
            if (this.streamsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureStreamsIsMutable();
                this.streams_.add(value);
                this.onChanged();
            } else {
                this.streamsBuilder_.addMessage(value);
            }
            return this;
        }

        public Builder addStreams(int index, ReadStream value) {
            if (this.streamsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureStreamsIsMutable();
                this.streams_.add(index, value);
                this.onChanged();
            } else {
                this.streamsBuilder_.addMessage(index, value);
            }
            return this;
        }

        public Builder addStreams(ReadStream.Builder builderForValue) {
            if (this.streamsBuilder_ == null) {
                this.ensureStreamsIsMutable();
                this.streams_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.streamsBuilder_.addMessage(builderForValue.build());
            }
            return this;
        }

        public Builder addStreams(int index, ReadStream.Builder builderForValue) {
            if (this.streamsBuilder_ == null) {
                this.ensureStreamsIsMutable();
                this.streams_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.streamsBuilder_.addMessage(index, builderForValue.build());
            }
            return this;
        }

        public Builder addAllStreams(Iterable<? extends ReadStream> values) {
            if (this.streamsBuilder_ == null) {
                this.ensureStreamsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.streams_);
                this.onChanged();
            } else {
                this.streamsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearStreams() {
            if (this.streamsBuilder_ == null) {
                this.streams_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFEFF;
                this.onChanged();
            } else {
                this.streamsBuilder_.clear();
            }
            return this;
        }

        public Builder removeStreams(int index) {
            if (this.streamsBuilder_ == null) {
                this.ensureStreamsIsMutable();
                this.streams_.remove(index);
                this.onChanged();
            } else {
                this.streamsBuilder_.remove(index);
            }
            return this;
        }

        public ReadStream.Builder getStreamsBuilder(int index) {
            return this.getStreamsFieldBuilder().getBuilder(index);
        }

        @Override
        public ReadStreamOrBuilder getStreamsOrBuilder(int index) {
            if (this.streamsBuilder_ == null) {
                return this.streams_.get(index);
            }
            return this.streamsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ReadStreamOrBuilder> getStreamsOrBuilderList() {
            if (this.streamsBuilder_ != null) {
                return this.streamsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.streams_);
        }

        public ReadStream.Builder addStreamsBuilder() {
            return this.getStreamsFieldBuilder().addBuilder(ReadStream.getDefaultInstance());
        }

        public ReadStream.Builder addStreamsBuilder(int index) {
            return this.getStreamsFieldBuilder().addBuilder(index, ReadStream.getDefaultInstance());
        }

        public List<ReadStream.Builder> getStreamsBuilderList() {
            return this.getStreamsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<ReadStream, ReadStream.Builder, ReadStreamOrBuilder> getStreamsFieldBuilder() {
            if (this.streamsBuilder_ == null) {
                this.streamsBuilder_ = new RepeatedFieldBuilderV3(this.streams_, (this.bitField0_ & 0x100) != 0, this.getParentForChildren(), this.isClean());
                this.streams_ = null;
            }
            return this.streamsBuilder_;
        }

        @Override
        public long getEstimatedTotalBytesScanned() {
            return this.estimatedTotalBytesScanned_;
        }

        public Builder setEstimatedTotalBytesScanned(long value) {
            this.estimatedTotalBytesScanned_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder clearEstimatedTotalBytesScanned() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.estimatedTotalBytesScanned_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getEstimatedTotalPhysicalFileSize() {
            return this.estimatedTotalPhysicalFileSize_;
        }

        public Builder setEstimatedTotalPhysicalFileSize(long value) {
            this.estimatedTotalPhysicalFileSize_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearEstimatedTotalPhysicalFileSize() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.estimatedTotalPhysicalFileSize_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getEstimatedRowCount() {
            return this.estimatedRowCount_;
        }

        public Builder setEstimatedRowCount(long value) {
            this.estimatedRowCount_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearEstimatedRowCount() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.estimatedRowCount_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public String getTraceId() {
            Object ref = this.traceId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.traceId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTraceIdBytes() {
            Object ref = this.traceId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.traceId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setTraceId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.traceId_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder clearTraceId() {
            this.traceId_ = ReadSession.getDefaultInstance().getTraceId();
            this.bitField0_ &= 0xFFFFEFFF;
            this.onChanged();
            return this;
        }

        public Builder setTraceIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ReadSession.checkByteStringIsUtf8(value);
            this.traceId_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        @Override
        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        @Override
        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum SchemaCase implements Internal.EnumLite,
    AbstractMessageLite.InternalOneOfEnum
    {
        AVRO_SCHEMA(4),
        ARROW_SCHEMA(5),
        SCHEMA_NOT_SET(0);

        private final int value;

        private SchemaCase(int value) {
            this.value = value;
        }

        @Deprecated
        public static SchemaCase valueOf(int value) {
            return SchemaCase.forNumber(value);
        }

        public static SchemaCase forNumber(int value) {
            switch (value) {
                case 4: {
                    return AVRO_SCHEMA;
                }
                case 5: {
                    return ARROW_SCHEMA;
                }
                case 0: {
                    return SCHEMA_NOT_SET;
                }
            }
            return null;
        }

        @Override
        public int getNumber() {
            return this.value;
        }
    }

    public static interface TableReadOptionsOrBuilder
    extends MessageOrBuilder {
        public List<String> getSelectedFieldsList();

        public int getSelectedFieldsCount();

        public String getSelectedFields(int var1);

        public ByteString getSelectedFieldsBytes(int var1);

        public String getRowRestriction();

        public ByteString getRowRestrictionBytes();

        public boolean hasArrowSerializationOptions();

        public ArrowSerializationOptions getArrowSerializationOptions();

        public ArrowSerializationOptionsOrBuilder getArrowSerializationOptionsOrBuilder();

        public boolean hasAvroSerializationOptions();

        public AvroSerializationOptions getAvroSerializationOptions();

        public AvroSerializationOptionsOrBuilder getAvroSerializationOptionsOrBuilder();

        public boolean hasSamplePercentage();

        public double getSamplePercentage();

        public boolean hasResponseCompressionCodec();

        public int getResponseCompressionCodecValue();

        public TableReadOptions.ResponseCompressionCodec getResponseCompressionCodec();

        public TableReadOptions.OutputFormatSerializationOptionsCase getOutputFormatSerializationOptionsCase();
    }

    public static interface TableModifiersOrBuilder
    extends MessageOrBuilder {
        public boolean hasSnapshotTime();

        public Timestamp getSnapshotTime();

        public TimestampOrBuilder getSnapshotTimeOrBuilder();
    }
}

