/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.common.primitives.Bytes;
import com.google.protobuf.ByteString;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BigDecimalByteStringEncoder {
    private static int NUMERIC_SCALE = 9;
    private static final BigDecimal MAX_NUMERIC_VALUE = new BigDecimal("99999999999999999999999999999.999999999");
    private static final BigDecimal MIN_NUMERIC_VALUE = new BigDecimal("-99999999999999999999999999999.999999999");
    private static final int BIGNUMERIC_SCALE = 38;
    private static final BigDecimal MAX_BIGNUMERIC_VALUE = new BigDecimal("578960446186580977117854925043439539266.34992332820282019728792003956564819967");
    private static final BigDecimal MIN_BIGNUMERIC_VALUE = new BigDecimal("-578960446186580977117854925043439539266.34992332820282019728792003956564819968");

    public static ByteString encodeToNumericByteString(BigDecimal bigDecimal) {
        ByteString byteString = BigDecimalByteStringEncoder.serializeBigDecimal(bigDecimal, NUMERIC_SCALE, MAX_NUMERIC_VALUE, MIN_NUMERIC_VALUE, "ByteString");
        return byteString;
    }

    public static ByteString encodeToBigNumericByteString(BigDecimal bigDecimal) {
        ByteString byteString = BigDecimalByteStringEncoder.serializeBigDecimal(bigDecimal, 38, MAX_BIGNUMERIC_VALUE, MIN_BIGNUMERIC_VALUE, "ByteString");
        return byteString;
    }

    public static BigDecimal decodeNumericByteString(ByteString byteString) {
        BigDecimal bigDecimal = BigDecimalByteStringEncoder.deserializeBigDecimal(byteString, NUMERIC_SCALE, MAX_NUMERIC_VALUE, MIN_NUMERIC_VALUE, "BigDecimal");
        return bigDecimal;
    }

    public static BigDecimal decodeBigNumericByteString(ByteString byteString) {
        BigDecimal bigDecimal = BigDecimalByteStringEncoder.deserializeBigDecimal(byteString, 38, MAX_BIGNUMERIC_VALUE, MIN_BIGNUMERIC_VALUE, "BigDecimal");
        return bigDecimal;
    }

    private static BigDecimal deserializeBigDecimal(ByteString serializedValue, int scale, BigDecimal maxValue, BigDecimal minValue, String typeName) {
        byte[] bytes = serializedValue.toByteArray();
        Bytes.reverse((byte[])bytes);
        BigInteger scaledValue = new BigInteger(bytes);
        BigDecimal decimalValue = new BigDecimal(scaledValue, scale);
        if (decimalValue.compareTo(maxValue) > 0 || decimalValue.compareTo(minValue) < 0) {
            throw new IllegalArgumentException(typeName + " overflow: " + decimalValue.toPlainString());
        }
        return decimalValue;
    }

    private static ByteString serializeBigDecimal(BigDecimal v, int scale, BigDecimal maxValue, BigDecimal minValue, String typeName) {
        if (v.scale() > scale) {
            throw new IllegalArgumentException(typeName + " scale cannot exceed " + scale + ": " + v.toPlainString());
        }
        if (v.compareTo(maxValue) > 0 || v.compareTo(minValue) < 0) {
            throw new IllegalArgumentException(typeName + " overflow: " + v.toPlainString());
        }
        byte[] bytes = v.setScale(scale).unscaledValue().toByteArray();
        Bytes.reverse((byte[])bytes);
        return ByteString.copyFrom(bytes);
    }
}

