/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.spi.v2;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.core.InternalApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetList;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.GetIamPolicyRequest;
import com.google.api.services.bigquery.model.GetPolicyOptions;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobList;
import com.google.api.services.bigquery.model.JobStatus;
import com.google.api.services.bigquery.model.ListModelsResponse;
import com.google.api.services.bigquery.model.ListRoutinesResponse;
import com.google.api.services.bigquery.model.Model;
import com.google.api.services.bigquery.model.ModelReference;
import com.google.api.services.bigquery.model.Policy;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.api.services.bigquery.model.QueryResponse;
import com.google.api.services.bigquery.model.Routine;
import com.google.api.services.bigquery.model.RoutineReference;
import com.google.api.services.bigquery.model.SetIamPolicyRequest;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableDataInsertAllRequest;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableDataList;
import com.google.api.services.bigquery.model.TableList;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TestIamPermissionsRequest;
import com.google.api.services.bigquery.model.TestIamPermissionsResponse;
import com.google.cloud.Tuple;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.spi.v2.BigQueryRpc;
import com.google.cloud.http.HttpTransportOptions;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

@InternalExtensionOnly
public class HttpBigQueryRpc
implements BigQueryRpc {
    public static final String DEFAULT_PROJECTION = "full";
    private static final String BASE_RESUMABLE_URI = "upload/bigquery/v2/projects/";
    private static final int HTTP_RESUME_INCOMPLETE = 308;
    private final BigQueryOptions options;
    private final Bigquery bigquery;
    @InternalApi(value="Visible for testing")
    static final Function<DatasetList.Datasets, Dataset> LIST_TO_DATASET = new Function<DatasetList.Datasets, Dataset>(){

        public Dataset apply(DatasetList.Datasets datasetPb) {
            return new Dataset().setDatasetReference(datasetPb.getDatasetReference()).setFriendlyName(datasetPb.getFriendlyName()).setId(datasetPb.getId()).setKind(datasetPb.getKind()).setLabels(datasetPb.getLabels());
        }
    };

    public HttpBigQueryRpc(BigQueryOptions options) {
        HttpTransportOptions transportOptions = (HttpTransportOptions)options.getTransportOptions();
        HttpTransport transport = transportOptions.getHttpTransportFactory().create();
        HttpRequestInitializer initializer = transportOptions.getHttpRequestInitializer(options);
        this.options = options;
        this.bigquery = new Bigquery.Builder(transport, new GsonFactory(), initializer).setRootUrl(options.getResolvedApiaryHost("bigquery")).setApplicationName(options.getApplicationName()).build();
    }

    private static BigQueryException translate(IOException exception) {
        return new BigQueryException(exception);
    }

    private void validateRPC() throws BigQueryException, IOException {
        if (!this.options.hasValidUniverseDomain()) {
            String errorMessage = String.format("The configured universe domain %s does not match the universe domain found in the credentials %s. If you haven't configured the universe domain explicitly, `googleapis.com` is the default.", this.options.getUniverseDomain(), this.options.getCredentials().getUniverseDomain());
            throw new BigQueryException(401, errorMessage);
        }
    }

    @Override
    public Dataset getDataset(String projectId, String datasetId, Map<BigQueryRpc.Option, ?> options) {
        try {
            this.validateRPC();
            return (Dataset)this.bigquery.datasets().get(projectId, datasetId).setFields(BigQueryRpc.Option.FIELDS.getString(options)).setPrettyPrint(false).execute();
        }
        catch (IOException ex) {
            BigQueryException serviceException = HttpBigQueryRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                return null;
            }
            throw serviceException;
        }
    }

    @Override
    public Tuple<String, Iterable<Dataset>> listDatasets(String projectId, Map<BigQueryRpc.Option, ?> options) {
        try {
            this.validateRPC();
            DatasetList datasetsList = (DatasetList)this.bigquery.datasets().list(projectId).setPrettyPrint(false).setAll(BigQueryRpc.Option.ALL_DATASETS.getBoolean(options)).setFilter(BigQueryRpc.Option.LABEL_FILTER.getString(options)).setMaxResults(BigQueryRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(BigQueryRpc.Option.PAGE_TOKEN.getString(options)).execute();
            ImmutableList datasets = datasetsList.getDatasets();
            return Tuple.of(datasetsList.getNextPageToken(), Iterables.transform((Iterable)(datasets != null ? datasets : ImmutableList.of()), LIST_TO_DATASET));
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @Override
    public Dataset create(Dataset dataset, Map<BigQueryRpc.Option, ?> options) {
        try {
            this.validateRPC();
            return (Dataset)this.bigquery.datasets().insert(dataset.getDatasetReference().getProjectId(), dataset).setPrettyPrint(false).setFields(BigQueryRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @Override
    public Table create(Table table, Map<BigQueryRpc.Option, ?> options) {
        try {
            this.validateRPC();
            table.setType(null);
            TableReference reference = table.getTableReference();
            return (Table)this.bigquery.tables().insert(reference.getProjectId(), reference.getDatasetId(), table).setPrettyPrint(false).setFields(BigQueryRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @Override
    public Routine create(Routine routine, Map<BigQueryRpc.Option, ?> options) {
        try {
            this.validateRPC();
            RoutineReference reference = routine.getRoutineReference();
            return (Routine)this.bigquery.routines().insert(reference.getProjectId(), reference.getDatasetId(), routine).setPrettyPrint(false).setFields(BigQueryRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @Override
    public Job create(Job job, Map<BigQueryRpc.Option, ?> options) {
        try {
            this.validateRPC();
            String projectId = job.getJobReference() != null ? job.getJobReference().getProjectId() : this.options.getProjectId();
            return (Job)this.bigquery.jobs().insert(projectId, job).setPrettyPrint(false).setFields(BigQueryRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @Override
    public Job createJobForQuery(Job job) {
        try {
            this.validateRPC();
            String projectId = job.getJobReference() != null ? job.getJobReference().getProjectId() : this.options.getProjectId();
            return (Job)this.bigquery.jobs().insert(projectId, job).setPrettyPrint(false).execute();
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @Override
    public boolean deleteDataset(String projectId, String datasetId, Map<BigQueryRpc.Option, ?> options) {
        try {
            this.validateRPC();
            this.bigquery.datasets().delete(projectId, datasetId).setPrettyPrint(false).setDeleteContents(BigQueryRpc.Option.DELETE_CONTENTS.getBoolean(options)).execute();
            return true;
        }
        catch (IOException ex) {
            BigQueryException serviceException = HttpBigQueryRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                return false;
            }
            throw serviceException;
        }
    }

    @Override
    public Dataset patch(Dataset dataset, Map<BigQueryRpc.Option, ?> options) {
        try {
            this.validateRPC();
            DatasetReference reference = dataset.getDatasetReference();
            return (Dataset)this.bigquery.datasets().patch(reference.getProjectId(), reference.getDatasetId(), dataset).setPrettyPrint(false).setFields(BigQueryRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @Override
    public Table patch(Table table, Map<BigQueryRpc.Option, ?> options) {
        try {
            this.validateRPC();
            table.setType(null);
            TableReference reference = table.getTableReference();
            return (Table)this.bigquery.tables().patch(reference.getProjectId(), reference.getDatasetId(), reference.getTableId(), table).setPrettyPrint(false).setFields(BigQueryRpc.Option.FIELDS.getString(options)).setAutodetectSchema(BigQueryRpc.Option.AUTODETECT_SCHEMA.getBoolean(options)).execute();
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @Override
    public Table getTable(String projectId, String datasetId, String tableId, Map<BigQueryRpc.Option, ?> options) {
        try {
            this.validateRPC();
            return (Table)this.bigquery.tables().get(projectId, datasetId, tableId).setPrettyPrint(false).setFields(BigQueryRpc.Option.FIELDS.getString(options)).setView(this.getTableMetadataOption(options)).execute();
        }
        catch (IOException ex) {
            BigQueryException serviceException = HttpBigQueryRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                return null;
            }
            throw serviceException;
        }
    }

    private String getTableMetadataOption(Map<BigQueryRpc.Option, ?> options) {
        if (options.containsKey((Object)BigQueryRpc.Option.TABLE_METADATA_VIEW)) {
            return options.get((Object)BigQueryRpc.Option.TABLE_METADATA_VIEW).toString();
        }
        return "STORAGE_STATS";
    }

    @Override
    public Tuple<String, Iterable<Table>> listTables(String projectId, String datasetId, Map<BigQueryRpc.Option, ?> options) {
        try {
            this.validateRPC();
            TableList tableList = (TableList)this.bigquery.tables().list(projectId, datasetId).setPrettyPrint(false).setMaxResults(BigQueryRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(BigQueryRpc.Option.PAGE_TOKEN.getString(options)).execute();
            ImmutableList tables = tableList.getTables();
            return Tuple.of(tableList.getNextPageToken(), Iterables.transform((Iterable)(tables != null ? tables : ImmutableList.of()), (Function)new Function<TableList.Tables, Table>(){

                public Table apply(TableList.Tables tablePb) {
                    return new Table().setFriendlyName(tablePb.getFriendlyName()).setId(tablePb.getId()).setKind(tablePb.getKind()).setTableReference(tablePb.getTableReference()).setType(tablePb.getType()).setCreationTime(tablePb.getCreationTime()).setTimePartitioning(tablePb.getTimePartitioning()).setRangePartitioning(tablePb.getRangePartitioning());
                }
            }));
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @Override
    public boolean deleteTable(String projectId, String datasetId, String tableId) {
        try {
            this.validateRPC();
            this.bigquery.tables().delete(projectId, datasetId, tableId).execute();
            return true;
        }
        catch (IOException ex) {
            BigQueryException serviceException = HttpBigQueryRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                return false;
            }
            throw serviceException;
        }
    }

    @Override
    public Model patch(Model model, Map<BigQueryRpc.Option, ?> options) {
        try {
            this.validateRPC();
            ModelReference reference = model.getModelReference();
            return (Model)this.bigquery.models().patch(reference.getProjectId(), reference.getDatasetId(), reference.getModelId(), model).setPrettyPrint(false).setFields(BigQueryRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @Override
    public Model getModel(String projectId, String datasetId, String modelId, Map<BigQueryRpc.Option, ?> options) {
        try {
            this.validateRPC();
            return (Model)this.bigquery.models().get(projectId, datasetId, modelId).setPrettyPrint(false).setFields(BigQueryRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            BigQueryException serviceException = HttpBigQueryRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                return null;
            }
            throw serviceException;
        }
    }

    @Override
    public Tuple<String, Iterable<Model>> listModels(String projectId, String datasetId, Map<BigQueryRpc.Option, ?> options) {
        try {
            this.validateRPC();
            ListModelsResponse modelList = (ListModelsResponse)this.bigquery.models().list(projectId, datasetId).setPrettyPrint(false).setMaxResults(BigQueryRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(BigQueryRpc.Option.PAGE_TOKEN.getString(options)).execute();
            Object models = modelList.getModels() != null ? modelList.getModels() : ImmutableList.of();
            return Tuple.of(modelList.getNextPageToken(), models);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @Override
    public boolean deleteModel(String projectId, String datasetId, String modelId) {
        try {
            this.validateRPC();
            this.bigquery.models().delete(projectId, datasetId, modelId).execute();
            return true;
        }
        catch (IOException ex) {
            BigQueryException serviceException = HttpBigQueryRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                return false;
            }
            throw serviceException;
        }
    }

    @Override
    public Routine update(Routine routine, Map<BigQueryRpc.Option, ?> options) {
        try {
            this.validateRPC();
            RoutineReference reference = routine.getRoutineReference();
            return (Routine)this.bigquery.routines().update(reference.getProjectId(), reference.getDatasetId(), reference.getRoutineId(), routine).setPrettyPrint(false).setFields(BigQueryRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @Override
    public Routine getRoutine(String projectId, String datasetId, String routineId, Map<BigQueryRpc.Option, ?> options) {
        try {
            this.validateRPC();
            return (Routine)this.bigquery.routines().get(projectId, datasetId, routineId).setPrettyPrint(false).setFields(BigQueryRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            BigQueryException serviceException = HttpBigQueryRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                return null;
            }
            throw serviceException;
        }
    }

    @Override
    public Tuple<String, Iterable<Routine>> listRoutines(String projectId, String datasetId, Map<BigQueryRpc.Option, ?> options) {
        try {
            this.validateRPC();
            ListRoutinesResponse routineList = (ListRoutinesResponse)this.bigquery.routines().list(projectId, datasetId).setPrettyPrint(false).setMaxResults(BigQueryRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(BigQueryRpc.Option.PAGE_TOKEN.getString(options)).execute();
            Object routines = routineList.getRoutines() != null ? routineList.getRoutines() : ImmutableList.of();
            return Tuple.of(routineList.getNextPageToken(), routines);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @Override
    public boolean deleteRoutine(String projectId, String datasetId, String routineId) {
        try {
            this.validateRPC();
            this.bigquery.routines().delete(projectId, datasetId, routineId).execute();
            return true;
        }
        catch (IOException ex) {
            BigQueryException serviceException = HttpBigQueryRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                return false;
            }
            throw serviceException;
        }
    }

    @Override
    public TableDataInsertAllResponse insertAll(String projectId, String datasetId, String tableId, TableDataInsertAllRequest request) {
        try {
            this.validateRPC();
            return (TableDataInsertAllResponse)this.bigquery.tabledata().insertAll(projectId, datasetId, tableId, request).setPrettyPrint(false).execute();
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @Override
    public TableDataList listTableData(String projectId, String datasetId, String tableId, Map<BigQueryRpc.Option, ?> options) {
        try {
            this.validateRPC();
            return (TableDataList)this.bigquery.tabledata().list(projectId, datasetId, tableId).setPrettyPrint(false).setMaxResults(BigQueryRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(BigQueryRpc.Option.PAGE_TOKEN.getString(options)).setStartIndex(BigQueryRpc.Option.START_INDEX.getLong(options) != null ? BigInteger.valueOf(BigQueryRpc.Option.START_INDEX.getLong(options)) : null).execute();
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @Override
    public TableDataList listTableDataWithRowLimit(String projectId, String datasetId, String tableId, Integer maxResultPerPage, String pageToken) {
        try {
            this.validateRPC();
            return (TableDataList)this.bigquery.tabledata().list(projectId, datasetId, tableId).setPrettyPrint(false).setMaxResults((long)maxResultPerPage).setPageToken(pageToken).execute();
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @Override
    public Job getJob(String projectId, String jobId, String location, Map<BigQueryRpc.Option, ?> options) {
        try {
            this.validateRPC();
            return (Job)this.bigquery.jobs().get(projectId, jobId).setPrettyPrint(false).setLocation(location).setFields(BigQueryRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            BigQueryException serviceException = HttpBigQueryRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                return null;
            }
            throw serviceException;
        }
    }

    @Override
    public Job getQueryJob(String projectId, String jobId, String location) {
        try {
            this.validateRPC();
            return (Job)this.bigquery.jobs().get(projectId, jobId).setPrettyPrint(false).setLocation(location).execute();
        }
        catch (IOException ex) {
            BigQueryException serviceException = HttpBigQueryRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                return null;
            }
            throw serviceException;
        }
    }

    @Override
    public Tuple<String, Iterable<Job>> listJobs(String projectId, Map<BigQueryRpc.Option, ?> options) {
        try {
            this.validateRPC();
            Bigquery.Jobs.List request = this.bigquery.jobs().list(projectId).setPrettyPrint(false).setAllUsers(BigQueryRpc.Option.ALL_USERS.getBoolean(options)).setFields(BigQueryRpc.Option.FIELDS.getString(options)).setStateFilter((List)BigQueryRpc.Option.STATE_FILTER.get(options)).setMaxResults(BigQueryRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(BigQueryRpc.Option.PAGE_TOKEN.getString(options)).setProjection(DEFAULT_PROJECTION).setParentJobId(BigQueryRpc.Option.PARENT_JOB_ID.getString(options));
            if (BigQueryRpc.Option.MIN_CREATION_TIME.getLong(options) != null) {
                request.setMinCreationTime(BigInteger.valueOf(BigQueryRpc.Option.MIN_CREATION_TIME.getLong(options)));
            }
            if (BigQueryRpc.Option.MAX_CREATION_TIME.getLong(options) != null) {
                request.setMaxCreationTime(BigInteger.valueOf(BigQueryRpc.Option.MAX_CREATION_TIME.getLong(options)));
            }
            JobList jobsList = (JobList)request.execute();
            ImmutableList jobs = jobsList.getJobs();
            return Tuple.of(jobsList.getNextPageToken(), Iterables.transform((Iterable)(jobs != null ? jobs : ImmutableList.of()), (Function)new Function<JobList.Jobs, Job>(){

                public Job apply(JobList.Jobs jobPb) {
                    JobStatus statusPb;
                    JobStatus jobStatus = statusPb = jobPb.getStatus() != null ? jobPb.getStatus() : new JobStatus();
                    if (statusPb.getState() == null) {
                        statusPb.setState(jobPb.getState());
                    }
                    if (statusPb.getErrorResult() == null) {
                        statusPb.setErrorResult(jobPb.getErrorResult());
                    }
                    return new Job().setConfiguration(jobPb.getConfiguration()).setId(jobPb.getId()).setJobReference(jobPb.getJobReference()).setKind(jobPb.getKind()).setStatistics(jobPb.getStatistics()).setStatus(statusPb).setUserEmail(jobPb.getUserEmail());
                }
            }));
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @Override
    public boolean cancel(String projectId, String jobId, String location) {
        try {
            this.validateRPC();
            this.bigquery.jobs().cancel(projectId, jobId).setLocation(location).setPrettyPrint(false).execute();
            return true;
        }
        catch (IOException ex) {
            BigQueryException serviceException = HttpBigQueryRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                return false;
            }
            throw serviceException;
        }
    }

    @Override
    public boolean deleteJob(String projectId, String jobName, String location) {
        try {
            this.validateRPC();
            this.bigquery.jobs().delete(projectId, jobName).setLocation(location).setPrettyPrint(false).execute();
            return true;
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @Override
    public GetQueryResultsResponse getQueryResults(String projectId, String jobId, String location, Map<BigQueryRpc.Option, ?> options) {
        try {
            this.validateRPC();
            return (GetQueryResultsResponse)this.bigquery.jobs().getQueryResults(projectId, jobId).setPrettyPrint(false).setLocation(location).setMaxResults(BigQueryRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(BigQueryRpc.Option.PAGE_TOKEN.getString(options)).setStartIndex(BigQueryRpc.Option.START_INDEX.getLong(options) != null ? BigInteger.valueOf(BigQueryRpc.Option.START_INDEX.getLong(options)) : null).setTimeoutMs(BigQueryRpc.Option.TIMEOUT.getLong(options)).execute();
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @Override
    public GetQueryResultsResponse getQueryResultsWithRowLimit(String projectId, String jobId, String location, Integer maxResultPerPage, Long timeoutMs) {
        try {
            this.validateRPC();
            return (GetQueryResultsResponse)this.bigquery.jobs().getQueryResults(projectId, jobId).setPrettyPrint(false).setLocation(location).setMaxResults((long)maxResultPerPage).setTimeoutMs(timeoutMs).execute();
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @Override
    public QueryResponse queryRpc(String projectId, QueryRequest content) {
        try {
            this.validateRPC();
            return (QueryResponse)this.bigquery.jobs().query(projectId, content).execute();
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @Override
    public String open(Job loadJob) {
        try {
            String builder = this.options.getResolvedApiaryHost("bigquery");
            if (!builder.endsWith("/")) {
                builder = builder + "/";
            }
            builder = builder + BASE_RESUMABLE_URI + this.options.getProjectId() + "/jobs";
            GenericUrl url = new GenericUrl(builder);
            url.set("uploadType", "resumable");
            JsonFactory jsonFactory = this.bigquery.getJsonFactory();
            HttpRequestFactory requestFactory = this.bigquery.getRequestFactory();
            HttpRequest httpRequest = requestFactory.buildPostRequest(url, new JsonHttpContent(jsonFactory, loadJob));
            httpRequest.getHeaders().set("X-Upload-Content-Value", "application/octet-stream");
            HttpResponse response = httpRequest.execute();
            return response.getHeaders().getLocation();
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @Override
    public Job write(String uploadId, byte[] toWrite, int toWriteOffset, long destOffset, int length, boolean last) {
        try {
            String message;
            int code;
            if (length == 0) {
                return null;
            }
            GenericUrl url = new GenericUrl(uploadId);
            HttpRequest httpRequest = this.bigquery.getRequestFactory().buildPutRequest(url, new ByteArrayContent(null, toWrite, toWriteOffset, length));
            httpRequest.setParser(this.bigquery.getObjectParser());
            long limit = destOffset + (long)length;
            StringBuilder range = new StringBuilder("bytes ");
            range.append(destOffset).append('-').append(limit - 1L).append('/');
            if (last) {
                range.append(limit);
            } else {
                range.append('*');
            }
            httpRequest.getHeaders().setContentRange(range.toString());
            HttpResponseException exception = null;
            HttpResponse response = null;
            try {
                response = httpRequest.execute();
                code = response.getStatusCode();
                message = response.getStatusMessage();
            }
            catch (HttpResponseException ex) {
                exception = ex;
                code = ex.getStatusCode();
                message = ex.getStatusMessage();
            }
            if (!last && code != 308 || last && code != 200 && code != 201) {
                if (exception != null) {
                    throw exception;
                }
                throw new BigQueryException(code, message);
            }
            return last && response != null ? response.parseAs(Job.class) : null;
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @Override
    public Policy getIamPolicy(String resourceId, Map<BigQueryRpc.Option, ?> options) {
        try {
            this.validateRPC();
            GetIamPolicyRequest policyRequest = new GetIamPolicyRequest();
            if (null != BigQueryRpc.Option.REQUESTED_POLICY_VERSION.getLong(options)) {
                policyRequest = policyRequest.setOptions(new GetPolicyOptions().setRequestedPolicyVersion(BigQueryRpc.Option.REQUESTED_POLICY_VERSION.getLong(options).intValue()));
            }
            return (Policy)this.bigquery.tables().getIamPolicy(resourceId, policyRequest).setPrettyPrint(false).execute();
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @Override
    public Policy setIamPolicy(String resourceId, Policy policy, Map<BigQueryRpc.Option, ?> options) {
        try {
            this.validateRPC();
            SetIamPolicyRequest policyRequest = new SetIamPolicyRequest().setPolicy(policy);
            return (Policy)this.bigquery.tables().setIamPolicy(resourceId, policyRequest).setPrettyPrint(false).execute();
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @Override
    public TestIamPermissionsResponse testIamPermissions(String resourceId, List<String> permissions, Map<BigQueryRpc.Option, ?> options) {
        try {
            this.validateRPC();
            TestIamPermissionsRequest permissionsRequest = new TestIamPermissionsRequest().setPermissions(permissions);
            return (TestIamPermissionsResponse)this.bigquery.tables().testIamPermissions(resourceId, permissionsRequest).setPrettyPrint(false).execute();
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }
}

