/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.benchmark;

import com.google.api.client.json.gson.GsonFactory;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.TableResult;
import java.io.FileInputStream;
import java.util.List;
import org.threeten.bp.Clock;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;

public class Benchmark {
    private static final double NS_PER_SECOND = 1.0E9;

    private Benchmark() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("need path to queries.json");
            return;
        }
        String[] requests = new GsonFactory().createJsonParser(new FileInputStream(args[0])).parseAndClose(String[].class);
        Clock clock = Clock.systemUTC();
        BigQuery bq = (BigQuery)BigQueryOptions.getDefaultInstance().getService();
        for (String request : requests) {
            if (request.isEmpty()) continue;
            Instant start = clock.instant();
            TableResult result = bq.query(QueryJobConfiguration.newBuilder(request).setUseLegacySql(false).build(), new BigQuery.JobOption[0]);
            int rows = 0;
            int cols = 0;
            Duration firstByte = null;
            for (List list : result.iterateAll()) {
                ++rows;
                if (cols == 0) {
                    cols = list.size();
                    firstByte = Duration.between(start, clock.instant());
                    continue;
                }
                if (cols == list.size()) continue;
                throw new IllegalStateException(String.format("expected %d cols, found %d", cols, list.size()));
            }
            Duration total = Duration.between(start, clock.instant());
            assert (firstByte != null);
            double d = (double)firstByte.getNano() / 1.0E9 + (double)firstByte.getSeconds();
            double totalSec = (double)total.getNano() / 1.0E9 + (double)total.getSeconds();
            System.out.println(String.format("query \"%s\": read %d rows, %d cols, first byte %f sec, total %f sec", request, rows, cols, d, totalSec));
        }
    }
}

