/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.client.util.Data;
import com.google.api.core.BetaApi;
import com.google.auto.value.AutoValue;
import com.google.cloud.bigquery.AutoValue_TimePartitioning;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import javax.annotation.Nullable;

@AutoValue
public abstract class TimePartitioning
implements Serializable {
    private static final long serialVersionUID = -8565064035346940951L;

    TimePartitioning() {
    }

    public abstract Type getType();

    @Nullable
    public abstract Long getExpirationMs();

    @BetaApi
    @Nullable
    public abstract String getField();

    @BetaApi
    @Nullable
    public abstract Boolean getRequirePartitionFilter();

    public abstract Builder toBuilder();

    public static Builder newBuilder(Type type) {
        return new AutoValue_TimePartitioning.Builder().setType(type);
    }

    public static TimePartitioning of(Type type) {
        return TimePartitioning.newBuilder(type).build();
    }

    public static TimePartitioning of(Type type, long expirationMs) {
        return TimePartitioning.newBuilder(type).setExpirationMs(expirationMs).build();
    }

    com.google.api.services.bigquery.model.TimePartitioning toPb() {
        com.google.api.services.bigquery.model.TimePartitioning partitioningPb = new com.google.api.services.bigquery.model.TimePartitioning();
        partitioningPb.setType(this.getType().name());
        partitioningPb.setExpirationMs((Long)MoreObjects.firstNonNull((Object)this.getExpirationMs(), (Object)Data.NULL_LONG));
        partitioningPb.setRequirePartitionFilter(this.getRequirePartitionFilter());
        partitioningPb.setField(this.getField());
        return partitioningPb;
    }

    static TimePartitioning fromPb(com.google.api.services.bigquery.model.TimePartitioning partitioningPb) {
        Long expirationMs = partitioningPb.getExpirationMs();
        if (Data.isNull(expirationMs)) {
            expirationMs = null;
        }
        return TimePartitioning.newBuilder(Type.valueOf((String)MoreObjects.firstNonNull((Object)partitioningPb.getType(), (Object)Type.DAY.name()))).setExpirationMs(expirationMs).setField(partitioningPb.getField()).setRequirePartitionFilter(partitioningPb.getRequirePartitionFilter()).build();
    }

    public static enum Type {
        DAY,
        HOUR,
        MONTH,
        YEAR;

    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract Builder setType(Type var1);

        public abstract Builder setExpirationMs(Long var1);

        @BetaApi
        public abstract Builder setRequirePartitionFilter(Boolean var1);

        @BetaApi
        public abstract Builder setField(String var1);

        public abstract TimePartitioning build();
    }
}

