/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.api.core.ApiFunction;
import com.google.api.core.InternalApi;
import com.google.cloud.Binding;
import com.google.cloud.Condition;
import com.google.cloud.Identity;
import com.google.cloud.Role;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import com.google.iam.v1.Binding;
import com.google.iam.v1.Policy;
import com.google.protobuf.ByteString;
import com.google.type.Expr;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class Policy
implements Serializable {
    private static final long serialVersionUID = -3348914530232544290L;
    private final ImmutableList<Binding> bindingsList;
    private final String etag;
    private final int version;

    private static boolean isConditional(int version, List<Binding> bindingsList) {
        for (Binding binding : bindingsList) {
            if (binding.getCondition() == null) continue;
            return true;
        }
        return version == 3;
    }

    private Policy(Builder builder) {
        this.bindingsList = ImmutableList.copyOf((Collection)builder.bindingsList);
        this.etag = builder.etag;
        this.version = builder.version;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Map<Role, Set<Identity>> getBindings() {
        Preconditions.checkArgument((!Policy.isConditional(this.version, this.bindingsList) ? 1 : 0) != 0, (Object)"getBindings() is only supported with version 1 policies and non-conditional policies");
        ImmutableMap.Builder bindingsV1Builder = ImmutableMap.builder();
        for (Binding binding : this.bindingsList) {
            ImmutableSet.Builder identities = ImmutableSet.builder();
            for (String member : binding.getMembers()) {
                identities.add((Object)Identity.valueOf(member));
            }
            bindingsV1Builder.put((Object)Role.of(binding.getRole()), (Object)identities.build());
        }
        return bindingsV1Builder.build();
    }

    public ImmutableList<Binding> getBindingsList() {
        return this.bindingsList;
    }

    public String getEtag() {
        return this.etag;
    }

    public int getVersion() {
        return this.version;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bindings", this.bindingsList).add("etag", (Object)this.etag).add("version", this.version).toString();
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.bindingsList, this.etag, this.version);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Policy)) {
            return false;
        }
        Policy other = (Policy)obj;
        if (this.bindingsList == null && other.getBindingsList() == null) {
            return true;
        }
        if (this.bindingsList == null && other.getBindingsList() != null || this.bindingsList != null && other.getBindingsList() == null || this.bindingsList.size() != other.getBindingsList().size()) {
            return false;
        }
        for (Binding binding : this.bindingsList) {
            if (other.getBindingsList().contains((Object)binding)) continue;
            return false;
        }
        return Objects.equals(this.etag, other.getEtag()) && this.version == other.getVersion();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final List<Binding> bindingsList = new ArrayList<Binding>();
        private String etag;
        private int version;

        @InternalApi(value="This class should only be extended within google-cloud-java")
        protected Builder() {
        }

        @InternalApi(value="This class should only be extended within google-cloud-java")
        protected Builder(Policy policy) {
            this.bindingsList.addAll((Collection<Binding>)policy.bindingsList);
            this.setEtag(policy.etag);
            this.setVersion(policy.version);
        }

        public final Builder setBindings(Map<Role, Set<Identity>> bindings) {
            Preconditions.checkNotNull(bindings, (Object)"The provided map of bindings cannot be null.");
            Preconditions.checkArgument((!Policy.isConditional(this.version, this.bindingsList) ? 1 : 0) != 0, (Object)"setBindings() is only supported with version 1 policies and non-conditional policies");
            for (Map.Entry<Role, Set<Identity>> binding : bindings.entrySet()) {
                Preconditions.checkNotNull((Object)binding.getKey(), (Object)"The role cannot be null.");
                Set<Identity> identities = binding.getValue();
                Preconditions.checkNotNull(identities, (Object)"A role cannot be assigned to a null set of identities.");
                Preconditions.checkArgument((!identities.contains(null) ? 1 : 0) != 0, (Object)"Null identities are not permitted.");
            }
            this.bindingsList.clear();
            for (Map.Entry<Role, Set<Identity>> binding : bindings.entrySet()) {
                Binding.Builder bindingBuilder = Binding.newBuilder();
                bindingBuilder.setRole(binding.getKey().getValue());
                ImmutableList.Builder membersBuilder = ImmutableList.builder();
                for (Identity identity : binding.getValue()) {
                    membersBuilder.add((Object)identity.strValue());
                }
                bindingBuilder.setMembers((Iterable<String>)membersBuilder.build());
                this.bindingsList.add(bindingBuilder.build());
            }
            return this;
        }

        public final Builder setBindings(List<Binding> bindings) {
            this.bindingsList.clear();
            for (Binding binding : bindings) {
                Binding.Builder bindingBuilder = Binding.newBuilder();
                bindingBuilder.setMembers((Iterable<String>)ImmutableList.copyOf(binding.getMembers()));
                bindingBuilder.setRole(binding.getRole());
                bindingBuilder.setCondition(binding.getCondition());
                this.bindingsList.add(bindingBuilder.build());
            }
            return this;
        }

        public final Builder removeRole(Role role) {
            Preconditions.checkArgument((!Policy.isConditional(this.version, this.bindingsList) ? 1 : 0) != 0, (Object)"removeRole() is only supported with version 1 policies and non-conditional policies");
            Iterator<Binding> iterator = this.bindingsList.iterator();
            while (iterator.hasNext()) {
                Binding binding = iterator.next();
                if (!binding.getRole().equals(role.getValue())) continue;
                iterator.remove();
                return this;
            }
            return this;
        }

        public final Builder addIdentity(Role role, Identity first, Identity ... others) {
            Preconditions.checkArgument((!Policy.isConditional(this.version, this.bindingsList) ? 1 : 0) != 0, (Object)"addIdentity() is only supported with version 1 policies and non-conditional policies");
            String nullIdentityMessage = "Null identities are not permitted.";
            Preconditions.checkNotNull((Object)first, (Object)nullIdentityMessage);
            Preconditions.checkNotNull((Object)others, (Object)nullIdentityMessage);
            Preconditions.checkNotNull((Object)role, (Object)"The role cannot be null.");
            for (int i = 0; i < this.bindingsList.size(); ++i) {
                Binding binding = this.bindingsList.get(i);
                if (!binding.getRole().equals(role.getValue())) continue;
                Binding.Builder bindingBuilder = binding.toBuilder();
                ImmutableSet.Builder membersBuilder = ImmutableSet.builder();
                membersBuilder.addAll(binding.getMembers());
                membersBuilder.add((Object)first.strValue());
                for (Identity identity : others) {
                    membersBuilder.add((Object)identity.strValue());
                }
                bindingBuilder.setMembers((Iterable<String>)membersBuilder.build());
                this.bindingsList.set(i, bindingBuilder.build());
                return this;
            }
            Binding.Builder bindingBuilder = Binding.newBuilder().setRole(role.getValue());
            ImmutableSet.Builder membersBuilder = ImmutableSet.builder();
            membersBuilder.add((Object)first.strValue());
            for (Identity identity : others) {
                membersBuilder.add((Object)identity.strValue());
            }
            bindingBuilder.setMembers((Iterable<String>)membersBuilder.build());
            this.bindingsList.add(bindingBuilder.build());
            return this;
        }

        public final Builder removeIdentity(Role role, Identity first, Identity ... others) {
            Binding binding;
            Preconditions.checkArgument((!Policy.isConditional(this.version, this.bindingsList) ? 1 : 0) != 0, (Object)"removeIdentity() is only supported with version 1 policies and non-conditional policies");
            String nullIdentityMessage = "Null identities are not permitted.";
            Preconditions.checkNotNull((Object)first, (Object)nullIdentityMessage);
            Preconditions.checkNotNull((Object)others, (Object)nullIdentityMessage);
            Preconditions.checkNotNull((Object)role, (Object)"The role cannot be null.");
            for (int i = 0; i < this.bindingsList.size(); ++i) {
                binding = this.bindingsList.get(i);
                if (!binding.getRole().equals(role.getValue())) continue;
                Binding.Builder bindingBuilder = binding.toBuilder().removeMembers(first.strValue());
                for (Identity identity : others) {
                    bindingBuilder.removeMembers(identity.strValue());
                }
                Binding updatedBindings = bindingBuilder.build();
                this.bindingsList.set(i, updatedBindings);
                break;
            }
            Iterator<Binding> iterator = this.bindingsList.iterator();
            while (iterator.hasNext()) {
                binding = iterator.next();
                if (!binding.getRole().equals(role.getValue()) || binding.getMembers().size() != 0) continue;
                iterator.remove();
                break;
            }
            return this;
        }

        public final Builder setEtag(String etag) {
            this.etag = etag;
            return this;
        }

        public final Builder setVersion(int version) {
            this.version = version;
            return this;
        }

        public final Policy build() {
            return new Policy(this);
        }
    }

    public static class DefaultMarshaller
    extends Marshaller<com.google.iam.v1.Policy> {
        @Override
        protected Policy fromPb(com.google.iam.v1.Policy policyPb) {
            ImmutableList.Builder bindingsListBuilder = ImmutableList.builder();
            for (com.google.iam.v1.Binding bindingPb : policyPb.getBindingsList()) {
                Binding.Builder convertedBinding = Binding.newBuilder().setRole(bindingPb.getRole()).setMembers(bindingPb.getMembersList());
                if (bindingPb.hasCondition()) {
                    Expr expr = bindingPb.getCondition();
                    convertedBinding.setCondition(Condition.newBuilder().setTitle(expr.getTitle()).setDescription(expr.getDescription()).setExpression(expr.getExpression()).build());
                }
                bindingsListBuilder.add((Object)convertedBinding.build());
            }
            return Policy.newBuilder().setBindings((List<Binding>)bindingsListBuilder.build()).setEtag(policyPb.getEtag().isEmpty() ? null : BaseEncoding.base64().encode(policyPb.getEtag().toByteArray())).setVersion(policyPb.getVersion()).build();
        }

        @Override
        protected com.google.iam.v1.Policy toPb(Policy policy) {
            Policy.Builder policyBuilder = com.google.iam.v1.Policy.newBuilder();
            LinkedList<com.google.iam.v1.Binding> bindingPbList = new LinkedList<com.google.iam.v1.Binding>();
            for (Binding binding : policy.getBindingsList()) {
                Binding.Builder bindingBuilder = com.google.iam.v1.Binding.newBuilder();
                bindingBuilder.setRole(binding.getRole());
                bindingBuilder.addAllMembers(binding.getMembers());
                if (binding.getCondition() != null) {
                    Condition condition = binding.getCondition();
                    bindingBuilder.setCondition(Expr.newBuilder().setTitle(condition.getTitle()).setDescription(condition.getDescription()).setExpression(condition.getExpression()).build());
                }
                bindingPbList.add(bindingBuilder.build());
            }
            policyBuilder.addAllBindings(bindingPbList);
            if (policy.etag != null) {
                policyBuilder.setEtag(ByteString.copyFrom(BaseEncoding.base64().decode((CharSequence)policy.etag)));
            }
            policyBuilder.setVersion(policy.version);
            return policyBuilder.build();
        }
    }

    public static abstract class Marshaller<T> {
        protected static final ApiFunction<String, Identity> IDENTITY_VALUE_OF_FUNCTION = new ApiFunction<String, Identity>(){

            @Override
            public Identity apply(String identityPb) {
                return Identity.valueOf(identityPb);
            }
        };
        protected static final ApiFunction<Identity, String> IDENTITY_STR_VALUE_FUNCTION = new ApiFunction<Identity, String>(){

            @Override
            public String apply(Identity identity) {
                return identity.strValue();
            }
        };

        @InternalApi(value="This class should only be extended within google-cloud-java")
        protected Marshaller() {
        }

        protected abstract Policy fromPb(T var1);

        protected abstract T toPb(Policy var1);
    }
}

