/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.gax.httpjson.RestSerializationException;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProtoRestSerializer<RequestT extends Message> {
    private final TypeRegistry registry;

    private ProtoRestSerializer(TypeRegistry registry) {
        this.registry = registry;
    }

    public static <RequestT extends Message> ProtoRestSerializer<RequestT> create() {
        return ProtoRestSerializer.create(TypeRegistry.getEmptyTypeRegistry());
    }

    static <RequestT extends Message> ProtoRestSerializer<RequestT> create(TypeRegistry registry) {
        return new ProtoRestSerializer<RequestT>(registry);
    }

    String toJson(Message message, boolean numericEnum) {
        try {
            JsonFormat.Printer printer = JsonFormat.printer().usingTypeRegistry(this.registry);
            if (numericEnum) {
                return printer.printingEnumsAsInts().print(message);
            }
            return printer.print(message);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RestSerializationException("Failed to serialize message to JSON", e);
        }
    }

    RequestT fromJson(Reader json, Message.Builder builder) {
        try {
            JsonFormat.parser().usingTypeRegistry(this.registry).ignoringUnknownFields().merge(json, builder);
            return (RequestT)builder.build();
        }
        catch (IOException e) {
            throw new RestSerializationException("Failed to parse response message", e);
        }
    }

    public void putPathParam(Map<String, String> fields, String fieldName, Object fieldValue) {
        fields.put(fieldName, String.valueOf(fieldValue));
    }

    private void putDecomposedMessageQueryParam(Map<String, List<String>> fields, String fieldName, JsonElement parsed) {
        if (parsed.isJsonPrimitive() || parsed.isJsonNull()) {
            this.putQueryParam(fields, fieldName, parsed.getAsString());
        } else if (parsed.isJsonArray()) {
            for (JsonElement element : parsed.getAsJsonArray()) {
                this.putDecomposedMessageQueryParam(fields, fieldName, element);
            }
        } else {
            for (String key : parsed.getAsJsonObject().keySet()) {
                this.putDecomposedMessageQueryParam(fields, String.format("%s.%s", fieldName, key), parsed.getAsJsonObject().get(key));
            }
        }
    }

    public void putQueryParam(Map<String, List<String>> fields, String fieldName, Object fieldValue) {
        ArrayList<String> currentParamValueList = new ArrayList<String>();
        List toProcess = fieldValue instanceof List ? (List)fieldValue : ImmutableList.of((Object)fieldValue);
        for (Object fieldValueItem : toProcess) {
            if (fieldValueItem instanceof Message) {
                String json = this.toJson((Message)fieldValueItem, true);
                JsonElement parsed = JsonParser.parseString((String)json);
                this.putDecomposedMessageQueryParam(fields, fieldName, parsed);
                continue;
            }
            currentParamValueList.add(String.valueOf(fieldValueItem));
        }
        if (currentParamValueList.isEmpty()) {
            return;
        }
        List accumulativeParamValueList = fields.getOrDefault(fieldName, new ArrayList());
        accumulativeParamValueList.addAll(currentParamValueList);
        fields.put(fieldName, accumulativeParamValueList);
    }

    public String toBody(String fieldName, RequestT fieldValue) {
        return this.toJson((Message)fieldValue, false);
    }

    public String toBody(String fieldName, RequestT fieldValue, boolean numericEnum) {
        return this.toJson((Message)fieldValue, numericEnum);
    }
}

