/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.vo;

import com.moonlit.logfaces.server.log4j.LfsLevel;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.DefaultThreadContextStack;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.joda.time.DateTime;

public class LoggingEventVO
implements com.moonlit.logfaces.server.core.LogEvent {
    private static final long serialVersionUID = 1439016070020L;
    private Object id;
    private long loggerTimeStamp;
    private long sequenceNumber;
    private boolean thrown;
    private int loggerLevel;
    private String loggerName = "";
    private String hostName = "";
    private String domainName = "";
    private String locLineNumber = "";
    private String locFileName = "";
    private String locClassName = "";
    private String locMethodName = "";
    private String message = "";
    private String threadName = "";
    private String ndc = "";
    private String throwableInfo = "";
    private Map properties;

    public LoggingEventVO() {
        this.properties = new HashMap();
    }

    public LoggingEventVO(LogEvent logEvent) {
        this.properties = new HashMap(logEvent.getContextData().toMap());
        this.loggerTimeStamp = logEvent.getTimeMillis();
        this.loggerLevel = LfsLevel.toLevel(logEvent.getLevel().name()).intLevel();
        this.setDomainName((String)this.properties.get("application"));
        this.setHostName((String)this.properties.get("hostname"));
        this.setThrowableInfo(this.getThrowableString(logEvent));
        this.setLoggerName(logEvent.getLoggerName());
        this.setMessage(logEvent.getMessage().getFormattedMessage());
        this.setThreadName(logEvent.getThreadName());
        this.setNdc(logEvent.getContextStack().peek());
        StackTraceElement stackTraceElement = logEvent.getSource();
        if (stackTraceElement != null) {
            this.setLocLineNumber("" + stackTraceElement.getLineNumber());
            this.setLocFileName(stackTraceElement.getFileName());
            this.setLocClassName(stackTraceElement.getClassName());
            this.setLocMethodName(stackTraceElement.getMethodName());
        }
        this.properties.remove("application");
        this.properties.remove("hostname");
    }

    private String getThrowableString(LogEvent logEvent) {
        ThrowableProxy throwableProxy = logEvent.getThrownProxy();
        return throwableProxy != null ? throwableProxy.getExtendedStackTraceAsString() : null;
    }

    public LogEvent toLoggingEvent() {
        SortedArrayStringMap sortedArrayStringMap = new SortedArrayStringMap(this.properties);
        sortedArrayStringMap.putValue("hostname", (Object)this.getHostName());
        sortedArrayStringMap.putValue("application", (Object)this.getDomainName());
        Log4jLogEvent.Builder builder = new Log4jLogEvent.Builder();
        builder.setLoggerName(this.loggerName).setMarker(null).setLoggerFqcn(this.loggerName).setTimeMillis(this.loggerTimeStamp).setLevel(LfsLevel.toLog4jLevel(this.loggerLevel)).setThreadName(this.threadName).setMessage((Message)new SimpleMessage(this.message.toString())).setSource(this.makeLocationInformation()).setContextData((StringMap)sortedArrayStringMap);
        String string = this.getThrowableInfo();
        if (string != null && !string.isEmpty()) {
            builder.setThrown(new Throwable(string));
        }
        if (this.ndc != null && !this.ndc.isEmpty()) {
            DefaultThreadContextStack defaultThreadContextStack = new DefaultThreadContextStack(true);
            defaultThreadContextStack.push(this.ndc);
            builder.setContextStack((ThreadContext.ContextStack)defaultThreadContextStack);
        }
        return builder.build();
    }

    @Override
    public LoggingEventVO clone() {
        LoggingEventVO loggingEventVO = new LoggingEventVO();
        loggingEventVO.id = this.id;
        loggingEventVO.loggerTimeStamp = this.loggerTimeStamp;
        loggingEventVO.sequenceNumber = this.sequenceNumber;
        loggingEventVO.loggerName = new String(this.loggerName);
        loggingEventVO.loggerLevel = this.loggerLevel;
        loggingEventVO.hostName = new String(this.hostName);
        loggingEventVO.domainName = new String(this.domainName);
        loggingEventVO.locLineNumber = new String(this.locLineNumber);
        loggingEventVO.locFileName = new String(this.locFileName);
        loggingEventVO.locClassName = new String(this.locClassName);
        loggingEventVO.locMethodName = new String(this.locMethodName);
        loggingEventVO.message = new String(this.message);
        loggingEventVO.threadName = new String(this.threadName);
        loggingEventVO.ndc = new String(this.ndc);
        loggingEventVO.properties = new HashMap(this.properties);
        loggingEventVO.thrown = this.thrown;
        loggingEventVO.throwableInfo = new String(this.throwableInfo != null ? this.throwableInfo : "");
        return loggingEventVO;
    }

    public boolean equals(Object object) {
        if (object instanceof LoggingEventVO) {
            LoggingEventVO loggingEventVO = (LoggingEventVO)object;
            if (this.loggerTimeStamp != loggingEventVO.loggerTimeStamp) {
                return false;
            }
            if (this.sequenceNumber != loggingEventVO.sequenceNumber) {
                return false;
            }
            if (this.loggerLevel != loggingEventVO.loggerLevel) {
                return false;
            }
            if (this.thrown != loggingEventVO.thrown) {
                return false;
            }
            if (!this.hostName.equals(loggingEventVO.hostName)) {
                return false;
            }
            if (!this.domainName.equals(loggingEventVO.domainName)) {
                return false;
            }
            if (!this.loggerName.equals(loggingEventVO.loggerName)) {
                return false;
            }
            return this.threadName.equals(loggingEventVO.threadName);
        }
        return false;
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String string) {
        this.loggerName = string != null ? string : "";
    }

    public String getLoggerNameShort() {
        if (this.loggerName == null) {
            return null;
        }
        int n2 = this.loggerName.lastIndexOf(46);
        if (n2 != -1) {
            return this.loggerName.substring(n2 + 1);
        }
        return this.loggerName;
    }

    public String getLoggerNamePackage() {
        if (this.loggerName == null) {
            return null;
        }
        int n2 = this.loggerName.lastIndexOf(46);
        if (n2 == -1) {
            return this.loggerName;
        }
        return this.loggerName.substring(0, n2);
    }

    @Override
    public int getLoggerLevel() {
        return this.loggerLevel;
    }

    public void setLoggerLevel(int n2) {
        this.loggerLevel = n2;
    }

    @Override
    public String getLocClassName() {
        return this.locClassName;
    }

    public void setLocClassName(String string) {
        this.locClassName = string != null ? string : null;
    }

    @Override
    public String getLocFileName() {
        return this.locFileName;
    }

    public void setLocFileName(String string) {
        this.locFileName = string != null ? string : "";
    }

    @Override
    public String getLocLineNumber() {
        return this.locLineNumber;
    }

    public void setLocLineNumber(String string) {
        this.locLineNumber = string != null ? string : "";
    }

    @Override
    public String getLocMethodName() {
        return this.locMethodName;
    }

    public void setLocMethodName(String string) {
        this.locMethodName = string != null ? string : "";
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string != null ? string : "";
    }

    public String getNdc() {
        return this.ndc;
    }

    public void setNdc(String string) {
        this.ndc = string != null ? string : "";
    }

    public String getLocationInformation() {
        int n2 = 0;
        try {
            n2 = Integer.parseInt(this.getLocLineNumber());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        StackTraceElement stackTraceElement = new StackTraceElement(this.locFileName, this.locClassName, this.locMethodName, n2);
        return stackTraceElement.toString();
    }

    public StackTraceElement getStackTrace() {
        int n2 = 0;
        try {
            n2 = Integer.parseInt(this.getLocLineNumber());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new StackTraceElement(this.getLocClassName(), this.getLocMethodName(), this.getLocFileName(), n2);
    }

    @Override
    public Map getProperties() {
        return this.properties;
    }

    public void setProperty(String string, String string2) {
        if (string != null && string2 != null) {
            this.properties.put(string, string2);
        }
    }

    public String getProperty(String string) {
        return string != null ? (String)this.properties.get(string) : null;
    }

    @Override
    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long l2) {
        this.sequenceNumber = l2;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String string) {
        this.threadName = string != null ? string : "";
    }

    @Override
    public String getThrowableInfo() {
        return this.throwableInfo;
    }

    public void setThrowableInfo(String string) {
        if (string == null) {
            this.thrown = false;
            this.throwableInfo = "";
            return;
        }
        this.throwableInfo = string;
        if (string.trim().length() > 1) {
            this.thrown = true;
        }
    }

    @Override
    public long getLoggerTimeStamp() {
        return this.loggerTimeStamp;
    }

    @Override
    public void setLoggerTimeStamp(long l2) {
        this.loggerTimeStamp = l2;
    }

    @Override
    public String getDomainName() {
        return this.domainName;
    }

    @Override
    public void setDomainName(String string) {
        this.domainName = string != null ? string : "";
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public void setHostName(String string) {
        this.hostName = string != null ? string : "";
    }

    @Override
    public String resolve(String string) {
        String string2 = new String(string);
        string2 = StringUtils.replace((String)string2, (String)"${domainName}", (String)this.getDomainName());
        string2 = StringUtils.replace((String)string2, (String)"${hostName}", (String)this.getHostName());
        string2 = StringUtils.replace((String)string2, (String)"${loggerName}", (String)this.getLoggerName());
        string2 = StringUtils.replace((String)string2, (String)"${loggerTimeStamp}", (String)new DateTime(this.loggerTimeStamp).toString("dd-MMM-YYYY HH:mm:ss"));
        string2 = StringUtils.replace((String)string2, (String)"${message}", (String)this.getMessage());
        string2 = StringUtils.replace((String)string2, (String)"${throwableInfo}", (String)(this.throwableInfo != null ? this.throwableInfo : ""));
        for (String string3 : this.properties.keySet()) {
            String string4 = String.format("${%s}", string3);
            string2 = StringUtils.replace((String)string2, (String)string4, (String)((String)this.properties.get(string3)));
        }
        return string2;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    public boolean isThrown() {
        return this.thrown;
    }

    public void setThrown(boolean bl) {
        this.thrown = bl;
    }

    public String getExceptionClass() {
        if (!this.isThrown() || this.throwableInfo == null || this.throwableInfo.length() == 0) {
            return null;
        }
        int n2 = this.throwableInfo.indexOf(10);
        if (n2 > 0 && n2 < this.throwableInfo.indexOf(58)) {
            return this.throwableInfo.substring(0, n2);
        }
        String[] stringArray = this.throwableInfo.split(":");
        return stringArray.length > 0 ? stringArray[0] : null;
    }

    public StackTraceElement makeLocationInformation() {
        int n2 = 0;
        try {
            n2 = Integer.parseInt(this.locLineNumber);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new StackTraceElement(this.locFileName, this.locClassName, this.locMethodName, n2);
    }

    public void setId(Object object) {
        this.id = object;
    }
}

