/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.util;

import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.moonlit.logfaces.server.conf.d;
import com.moonlit.logfaces.server.conf.k;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.core.v;
import com.moonlit.logfaces.server.criteria.Condition;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.JexlCriteria;
import com.moonlit.logfaces.server.criteria.Operation;
import com.moonlit.logfaces.server.criteria.Rule;
import com.moonlit.logfaces.server.database.F;
import com.moonlit.logfaces.server.database.n;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import com.moonlit.logfaces.server.vo.RepositoryEntryVO;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONArray;
import org.json.JSONObject;

public class a {
    private Gson a = new Gson();
    private v b;
    private n c = n.a();
    private DateTimeFormatter d = ISODateTimeFormat.dateTime().withZoneUTC();
    private int e = 0;

    public a() {
        this.a();
        try {
            String string = System.getProperty("com.moonlit.logfaces.resources.mongoIdGenerator", F.class.getName());
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(obj instanceof v)) {
                throw new Exception("object ID generators must implement OIDGenerator interface");
            }
            this.b = (v)obj;
        }
        catch (Throwable throwable) {
            this.b = new F();
        }
    }

    public void a() {
        d d2 = com.moonlit.logfaces.server.conf.d.a();
        this.e = d2.J().b() ? 0 : 1024 * d2.H();
    }

    public List a(List list, boolean bl) {
        ArrayList arrayList = Lists.newArrayList();
        if (list == null || list.isEmpty()) {
            return arrayList;
        }
        for (LogEvent logEvent : list) {
            arrayList.add(this.a(logEvent, bl));
        }
        return arrayList;
    }

    public BasicDBObject a(LogEvent logEvent, boolean bl) {
        if (logEvent == null) {
            return null;
        }
        BasicDBObject basicDBObject = new BasicDBObject();
        if (bl) {
            basicDBObject.put((Object)"_id", this.b.a(logEvent));
        }
        if (logEvent instanceof LoggingEventVO) {
            LoggingEventVO loggingEventVO = (LoggingEventVO)logEvent;
            basicDBObject.put((Object)EventAttribute.loggerTimeStamp.toMongoColumn(), (Object)new Date(loggingEventVO.getLoggerTimeStamp()));
            basicDBObject.put((Object)EventAttribute.sequenceNumber.toMongoColumn(), (Object)loggingEventVO.getSequenceNumber());
            basicDBObject.put((Object)EventAttribute.loggerLevel.toMongoColumn(), (Object)loggingEventVO.getLoggerLevel());
            this.a((DBObject)basicDBObject, EventAttribute.threadName.toMongoColumn(), (Object)loggingEventVO.getThreadName());
            this.a((DBObject)basicDBObject, EventAttribute.hostName.toMongoColumn(), (Object)loggingEventVO.getHostName());
            this.a((DBObject)basicDBObject, EventAttribute.domainName.toMongoColumn(), (Object)loggingEventVO.getDomainName());
            this.a((DBObject)basicDBObject, EventAttribute.thrown.toMongoColumn(), (Object)loggingEventVO.isThrown());
            this.a((DBObject)basicDBObject, EventAttribute.ndc.toMongoColumn(), (Object)loggingEventVO.getNdc());
            this.a((DBObject)basicDBObject, EventAttribute.loggerName.toMongoColumn(), (Object)loggingEventVO.getLoggerName());
            this.a((DBObject)basicDBObject, EventAttribute.throwableInfo.toMongoColumn(), (Object)loggingEventVO.getThrowableInfo());
            this.a((DBObject)basicDBObject, EventAttribute.locFileName.toMongoColumn(), (Object)loggingEventVO.getLocFileName());
            this.a((DBObject)basicDBObject, EventAttribute.locMethodName.toMongoColumn(), (Object)loggingEventVO.getLocMethodName());
            this.a((DBObject)basicDBObject, EventAttribute.locLineNumber.toMongoColumn(), (Object)loggingEventVO.getLocLineNumber());
            this.a((DBObject)basicDBObject, EventAttribute.locClassName.toMongoColumn(), (Object)loggingEventVO.getLocClassName());
            this.a((DBObject)basicDBObject, EventAttribute.message.toMongoColumn(), (Object)(this.e > 0 ? this.c.a(loggingEventVO.getMessage(), this.e) : loggingEventVO.getMessage()));
            this.a((DBObject)basicDBObject, loggingEventVO.getProperties());
        }
        return basicDBObject;
    }

    public BasicDBObject a(LogEvent logEvent) {
        return this.a(logEvent, true);
    }

    public DBObject b(LogEvent logEvent, boolean bl) {
        BasicDBObject basicDBObject = this.a(logEvent, false);
        basicDBObject.put("_id", (Object)new BasicDBObject("$oid", (Object)("" + logEvent.getId())));
        if (!bl) {
            basicDBObject.removeField(EventAttribute.throwableInfo.toMongoColumn());
        }
        return basicDBObject;
    }

    public Map b(LogEvent logEvent) {
        HashMap hashMap = Maps.newHashMap();
        if (logEvent instanceof LoggingEventVO) {
            LoggingEventVO loggingEventVO = (LoggingEventVO)logEvent;
            hashMap.put("_id", this.b.a(logEvent).toString());
            hashMap.put(EventAttribute.loggerTimeStamp.toMongoColumn(), this.d.print(loggingEventVO.getLoggerTimeStamp()));
            hashMap.put(EventAttribute.sequenceNumber.toMongoColumn(), loggingEventVO.getSequenceNumber());
            hashMap.put(EventAttribute.loggerLevel.toMongoColumn(), loggingEventVO.getLoggerLevel());
            this.a(hashMap, EventAttribute.threadName.toMongoColumn(), (Object)loggingEventVO.getThreadName());
            this.a(hashMap, EventAttribute.hostName.toMongoColumn(), (Object)loggingEventVO.getHostName());
            this.a(hashMap, EventAttribute.domainName.toMongoColumn(), (Object)loggingEventVO.getDomainName());
            this.a(hashMap, EventAttribute.thrown.toMongoColumn(), (Object)loggingEventVO.isThrown());
            this.a(hashMap, EventAttribute.ndc.toMongoColumn(), (Object)loggingEventVO.getNdc());
            this.a(hashMap, EventAttribute.loggerName.toMongoColumn(), (Object)loggingEventVO.getLoggerName());
            this.a(hashMap, EventAttribute.throwableInfo.toMongoColumn(), (Object)loggingEventVO.getThrowableInfo());
            this.a(hashMap, EventAttribute.locFileName.toMongoColumn(), (Object)loggingEventVO.getLocFileName());
            this.a(hashMap, EventAttribute.locMethodName.toMongoColumn(), (Object)loggingEventVO.getLocMethodName());
            this.a(hashMap, EventAttribute.locLineNumber.toMongoColumn(), (Object)loggingEventVO.getLocLineNumber());
            this.a(hashMap, EventAttribute.locClassName.toMongoColumn(), (Object)loggingEventVO.getLocClassName());
            this.a(hashMap, EventAttribute.message.toMongoColumn(), (Object)(this.e > 0 ? this.c.a(loggingEventVO.getMessage(), this.e) : loggingEventVO.getMessage()));
            String string = EventAttribute.mdc.toMongoColumn();
            for (String string2 : loggingEventVO.getProperties().keySet()) {
                int n2 = k.c(string2);
                if (n2 < 0) continue;
                this.a(hashMap, string + (n2 + 1), (Object)loggingEventVO.getProperty(string2));
            }
        }
        return hashMap;
    }

    public List a(Collection collection, long l2) {
        long l3 = 0L;
        ArrayList arrayList = Lists.newArrayList();
        if (collection == null) {
            return arrayList;
        }
        JSONArray jSONArray = new JSONArray();
        arrayList.add(jSONArray);
        for (LogEvent logEvent : collection) {
            JSONObject jSONObject = new JSONObject(this.b(logEvent));
            int n2 = jSONObject.toString().getBytes(StandardCharsets.UTF_8).length;
            if ((long)n2 > l2) continue;
            if ((l3 += (long)n2) >= l2) {
                if (jSONArray.isEmpty()) {
                    arrayList.remove(jSONArray);
                }
                jSONArray = new JSONArray();
                jSONArray.put((Object)jSONObject);
                arrayList.add(jSONArray);
                l3 = n2;
                continue;
            }
            jSONArray.put((Object)jSONObject);
        }
        if (!arrayList.isEmpty() && ((JSONArray)arrayList.get(0)).isEmpty()) {
            arrayList.remove(0);
        }
        return arrayList;
    }

    public Map a(RepositoryEntryVO repositoryEntryVO) {
        return this.a(repositoryEntryVO, false).toMap();
    }

    public String a(DBObject dBObject) {
        Object object = dBObject.get(EventAttribute.loggerTimeStamp.toMongoColumn());
        if (object != null) {
            if (object instanceof Date) {
                dBObject.put(EventAttribute.loggerTimeStamp.toMongoColumn(), (Object)new BasicDBObject("$date", (Object)this.d.print(((Date)object).getTime())));
            } else if (object instanceof Long) {
                dBObject.put(EventAttribute.loggerTimeStamp.toMongoColumn(), (Object)new BasicDBObject("$date", (Object)this.d.print(((Long)object).longValue())));
            }
        }
        if ((object = dBObject.get(EventAttribute.sequenceNumber.toMongoColumn())) != null && object instanceof Long) {
            dBObject.put(EventAttribute.sequenceNumber.toMongoColumn(), (Object)((Long)object));
        }
        return dBObject.toString();
    }

    public String a(FieldValueList fieldValueList) {
        HashMap hashMap = Maps.newHashMap();
        String string = "_id";
        hashMap.put(string, this.a(fieldValueList, string, String.class, ""));
        string = EventAttribute.domainName.toMongoColumn();
        hashMap.put(string, this.a(fieldValueList, string, String.class, ""));
        string = EventAttribute.hostName.toMongoColumn();
        hashMap.put(string, this.a(fieldValueList, string, String.class, ""));
        string = EventAttribute.loggerName.toMongoColumn();
        hashMap.put(string, this.a(fieldValueList, string, String.class, ""));
        string = EventAttribute.loggerTimeStamp.toMongoColumn();
        hashMap.put(string, this.a(fieldValueList, string, 0L));
        string = EventAttribute.sequenceNumber.toMongoColumn();
        hashMap.put(string, this.a(fieldValueList, string, Long.class, 0));
        string = EventAttribute.loggerLevel.toMongoColumn();
        hashMap.put(string, this.a(fieldValueList, string, Integer.class, LfsLevel.TRACE.intLevel()));
        string = EventAttribute.message.toMongoColumn();
        hashMap.put(string, this.a(fieldValueList, string, String.class, ""));
        string = EventAttribute.threadName.toMongoColumn();
        hashMap.put(string, this.a(fieldValueList, string, String.class, ""));
        string = EventAttribute.throwableInfo.toMongoColumn();
        hashMap.put(string, this.a(fieldValueList, string, String.class, ""));
        string = EventAttribute.thrown.toMongoColumn();
        hashMap.put(string, this.a(fieldValueList, string, Boolean.class, false));
        string = EventAttribute.locLineNumber.toMongoColumn();
        hashMap.put(string, this.a(fieldValueList, string, String.class, ""));
        string = EventAttribute.locFileName.toMongoColumn();
        hashMap.put(string, this.a(fieldValueList, string, String.class, ""));
        string = EventAttribute.locClassName.toMongoColumn();
        hashMap.put(string, this.a(fieldValueList, string, String.class, ""));
        string = EventAttribute.locMethodName.toMongoColumn();
        hashMap.put(string, this.a(fieldValueList, string, String.class, ""));
        string = EventAttribute.ndc.toMongoColumn();
        hashMap.put(string, this.a(fieldValueList, string, String.class, ""));
        String string2 = EventAttribute.mdc.toMongoColumn();
        Iterator iterator = k.e().iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            String string3 = (String)this.a(fieldValueList, string2 + (n2 + 1), String.class, "");
            if (string3.isEmpty()) continue;
            hashMap.put("p_" + k.a(n2), string3);
        }
        return this.a.toJson((Object)hashMap);
    }

    public LoggingEventVO b(FieldValueList fieldValueList) {
        LoggingEventVO loggingEventVO = new LoggingEventVO();
        loggingEventVO.setId(this.a(fieldValueList, "_id", String.class, ""));
        loggingEventVO.setDomainName((String)this.a(fieldValueList, EventAttribute.domainName.toMongoColumn(), String.class, ""));
        loggingEventVO.setHostName((String)this.a(fieldValueList, EventAttribute.hostName.toMongoColumn(), String.class, ""));
        loggingEventVO.setLoggerName((String)this.a(fieldValueList, EventAttribute.loggerName.toMongoColumn(), String.class, ""));
        loggingEventVO.setMessage((String)this.a(fieldValueList, EventAttribute.message.toMongoColumn(), String.class, ""));
        loggingEventVO.setThreadName((String)this.a(fieldValueList, EventAttribute.threadName.toMongoColumn(), String.class, ""));
        loggingEventVO.setThrowableInfo((String)this.a(fieldValueList, EventAttribute.throwableInfo.toMongoColumn(), String.class, ""));
        loggingEventVO.setLocLineNumber((String)this.a(fieldValueList, EventAttribute.locLineNumber.toMongoColumn(), String.class, ""));
        loggingEventVO.setLocFileName((String)this.a(fieldValueList, EventAttribute.locFileName.toMongoColumn(), String.class, ""));
        loggingEventVO.setLocClassName((String)this.a(fieldValueList, EventAttribute.locClassName.toMongoColumn(), String.class, ""));
        loggingEventVO.setLocMethodName((String)this.a(fieldValueList, EventAttribute.locMethodName.toMongoColumn(), String.class, ""));
        loggingEventVO.setNdc((String)this.a(fieldValueList, EventAttribute.ndc.toMongoColumn(), String.class, ""));
        loggingEventVO.setSequenceNumber((Long)this.a(fieldValueList, EventAttribute.sequenceNumber.toMongoColumn(), Long.class, 0));
        loggingEventVO.setLoggerLevel((Integer)this.a(fieldValueList, EventAttribute.loggerLevel.toMongoColumn(), Integer.class, LfsLevel.TRACE.intLevel()));
        loggingEventVO.setThrown((Boolean)this.a(fieldValueList, EventAttribute.thrown.toMongoColumn(), Boolean.class, false));
        loggingEventVO.setLoggerTimeStamp(this.a(fieldValueList, EventAttribute.loggerTimeStamp.toMongoColumn(), 0L));
        String string = EventAttribute.mdc.toMongoColumn();
        Iterator iterator = k.e().iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            String string2 = (String)this.a(fieldValueList, string + (n2 + 1), String.class, "");
            if (string2.isEmpty()) continue;
            loggingEventVO.setProperty(k.a(n2), string2);
        }
        return loggingEventVO;
    }

    public LoggingEventVO b(DBObject dBObject) {
        LoggingEventVO loggingEventVO = new LoggingEventVO();
        loggingEventVO.setId(0L);
        try {
            Object object = dBObject.get(EventAttribute.loggerTimeStamp.toMongoColumn());
            if (object instanceof Long) {
                loggingEventVO.setLoggerTimeStamp((Long)object);
            } else if (object instanceof Date) {
                loggingEventVO.setLoggerTimeStamp(((Date)object).getTime());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            loggingEventVO.setSequenceNumber((Long)dBObject.get(EventAttribute.sequenceNumber.toMongoColumn()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            loggingEventVO.setLoggerLevel((Integer)dBObject.get(EventAttribute.loggerLevel.toMongoColumn()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        loggingEventVO.setThreadName((String)dBObject.get(EventAttribute.threadName.toMongoColumn()));
        loggingEventVO.setMessage((String)dBObject.get(EventAttribute.message.toMongoColumn()));
        loggingEventVO.setHostName((String)dBObject.get(EventAttribute.hostName.toMongoColumn()));
        loggingEventVO.setDomainName((String)dBObject.get(EventAttribute.domainName.toMongoColumn()));
        loggingEventVO.setLoggerName((String)dBObject.get(EventAttribute.loggerName.toMongoColumn()));
        loggingEventVO.setNdc((String)dBObject.get(EventAttribute.ndc.toMongoColumn()));
        loggingEventVO.setThrowableInfo((String)dBObject.get(EventAttribute.throwableInfo.toMongoColumn()));
        loggingEventVO.setLocFileName((String)dBObject.get(EventAttribute.locFileName.toMongoColumn()));
        loggingEventVO.setLocMethodName((String)dBObject.get(EventAttribute.locMethodName.toMongoColumn()));
        loggingEventVO.setLocLineNumber((String)dBObject.get(EventAttribute.locLineNumber.toMongoColumn()));
        loggingEventVO.setLocClassName((String)dBObject.get(EventAttribute.locClassName.toMongoColumn()));
        try {
            loggingEventVO.setThrown((Boolean)dBObject.get(EventAttribute.thrown.toMongoColumn()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.a(dBObject, loggingEventVO);
        return loggingEventVO;
    }

    public BasicDBObject b(RepositoryEntryVO repositoryEntryVO) {
        if (repositoryEntryVO == null) {
            return null;
        }
        return this.a(repositoryEntryVO, true);
    }

    public BasicDBObject a(RepositoryEntryVO repositoryEntryVO, boolean bl) {
        if (repositoryEntryVO == null) {
            return null;
        }
        BasicDBObject basicDBObject = new BasicDBObject();
        if (bl) {
            basicDBObject.put((Object)"_id", this.b.a(System.currentTimeMillis(), repositoryEntryVO.getDomainName(), repositoryEntryVO.getHostName(), repositoryEntryVO.getLoggerName()));
        }
        this.a((DBObject)basicDBObject, EventAttribute.domainName.toMongoColumn(), (Object)repositoryEntryVO.getDomainName());
        this.a((DBObject)basicDBObject, EventAttribute.hostName.toMongoColumn(), (Object)repositoryEntryVO.getHostName());
        this.a((DBObject)basicDBObject, EventAttribute.loggerName.toMongoColumn(), (Object)repositoryEntryVO.getLoggerName());
        return basicDBObject;
    }

    public List a(Collection collection) {
        ArrayList arrayList = Lists.newArrayList();
        if (collection == null) {
            return arrayList;
        }
        for (RepositoryEntryVO repositoryEntryVO : collection) {
            arrayList.add(this.a(repositoryEntryVO, false));
        }
        return arrayList;
    }

    public RepositoryEntryVO c(DBObject dBObject) {
        RepositoryEntryVO repositoryEntryVO = new RepositoryEntryVO();
        if (dBObject.containsField(EventAttribute.domainName.toMongoColumn())) {
            repositoryEntryVO.setDomainName((String)dBObject.get(EventAttribute.domainName.toMongoColumn()));
        }
        if (dBObject.containsField(EventAttribute.hostName.toMongoColumn())) {
            repositoryEntryVO.setHostName((String)dBObject.get(EventAttribute.hostName.toMongoColumn()));
        }
        if (dBObject.containsField(EventAttribute.loggerName.toMongoColumn())) {
            repositoryEntryVO.setLoggerName((String)dBObject.get(EventAttribute.loggerName.toMongoColumn()));
        }
        return repositoryEntryVO;
    }

    public RepositoryEntryVO c(FieldValueList fieldValueList) {
        return new RepositoryEntryVO(fieldValueList.get(0).isNull() ? null : fieldValueList.get(0).getStringValue(), fieldValueList.get(1).isNull() ? null : fieldValueList.get(1).getStringValue(), fieldValueList.get(2).isNull() ? null : fieldValueList.get(2).getStringValue());
    }

    public DBObject a(CriteriaFilter criteriaFilter) {
        BasicDBObject basicDBObject = new BasicDBObject();
        BasicDBList basicDBList = new BasicDBList();
        if (criteriaFilter != null) {
            for (Rule rule : criteriaFilter.getRules()) {
                BasicDBList basicDBList2 = new BasicDBList();
                for (Condition condition : rule.getConditions()) {
                    basicDBList2.add((Object)new BasicDBObject().append("attr", (Object)condition.getAttribute().toString()).append("oper", (Object)condition.getOperation().toString()).append("expr", (Object)condition.getValue().toString()));
                }
                basicDBList.add((Object)basicDBList2);
            }
        }
        basicDBObject.put("criteria", (Object)basicDBList);
        return basicDBObject;
    }

    public DBObject a(boolean bl) {
        BasicDBList basicDBList = new BasicDBList();
        for (EventAttribute eventAttribute : EventAttribute.values()) {
            if (eventAttribute == EventAttribute.mdc || eventAttribute == EventAttribute.sequenceNumber || eventAttribute == EventAttribute.loggerTimeStamp) continue;
            BasicDBList basicDBList2 = new BasicDBList();
            basicDBList2.add((Object)Operation.is.toString());
            basicDBList2.add((Object)Operation.isnot.toString());
            switch (eventAttribute) {
                case loggerLevel: {
                    basicDBList2.add((Object)Operation.more.toString());
                    basicDBList2.add((Object)Operation.emore.toString());
                    basicDBList2.add((Object)Operation.less.toString());
                    basicDBList2.add((Object)Operation.eless.toString());
                    break;
                }
                case thrown: {
                    break;
                }
                case domainName: {
                    basicDBList2.add((Object)Operation.contains.toString());
                    basicDBList2.add((Object)Operation.notcontains.toString());
                    if (!bl) break;
                    basicDBList2.add((Object)Operation.regex.toString());
                    basicDBList2.add((Object)Operation.noregex.toString());
                    break;
                }
                case hostName: {
                    basicDBList2.add((Object)Operation.contains.toString());
                    basicDBList2.add((Object)Operation.notcontains.toString());
                    if (!bl) break;
                    basicDBList2.add((Object)Operation.regex.toString());
                    basicDBList2.add((Object)Operation.noregex.toString());
                    break;
                }
                case loggerName: {
                    basicDBList2.add((Object)Operation.contains.toString());
                    basicDBList2.add((Object)Operation.notcontains.toString());
                    if (!bl) break;
                    basicDBList2.add((Object)Operation.regex.toString());
                    basicDBList2.add((Object)Operation.noregex.toString());
                    break;
                }
                case throwableInfo: {
                    basicDBList2.add((Object)Operation.contains.toString());
                    basicDBList2.add((Object)Operation.notcontains.toString());
                    if (!bl) break;
                    basicDBList2.add((Object)Operation.regex.toString());
                    basicDBList2.add((Object)Operation.noregex.toString());
                    break;
                }
                default: {
                    basicDBList2.add((Object)Operation.contains.toString());
                    basicDBList2.add((Object)Operation.notcontains.toString());
                    if (!bl) break;
                    basicDBList2.add((Object)Operation.regex.toString());
                    basicDBList2.add((Object)Operation.noregex.toString());
                }
            }
            basicDBList.add((Object)new BasicDBObject().append("name", (Object)eventAttribute.toString()).append("operations", (Object)basicDBList2));
        }
        for (String string : k.d()) {
            if (string == null || string.isEmpty()) continue;
            BasicDBList basicDBList3 = new BasicDBList();
            basicDBList3.add((Object)Operation.is.toString());
            basicDBList3.add((Object)Operation.isnot.toString());
            basicDBList3.add((Object)Operation.contains.toString());
            basicDBList3.add((Object)Operation.notcontains.toString());
            if (bl) {
                basicDBList3.add((Object)Operation.regex.toString());
                basicDBList3.add((Object)Operation.noregex.toString());
            }
            basicDBList.add((Object)new BasicDBObject().append("name", (Object)string).append("operations", (Object)basicDBList3));
        }
        return basicDBList;
    }

    public CriteriaFilter a(String string) {
        JexlCriteria jexlCriteria = new JexlCriteria();
        BasicDBObject basicDBObject = BasicDBObject.parse((String)string);
        BasicDBList basicDBList = (BasicDBList)basicDBObject.get("criteria");
        for (int i2 = 0; i2 < basicDBList.size(); ++i2) {
            Rule rule = jexlCriteria.addRule();
            BasicDBList basicDBList2 = (BasicDBList)basicDBList.get(i2);
            for (int i3 = 0; i3 < basicDBList2.size(); ++i3) {
                DBObject dBObject = (DBObject)basicDBList2.get(i3);
                rule.addCondition((String)dBObject.get("attr"), (Object)Operation.fromString((String)dBObject.get("oper")), (String)dBObject.get("expr"));
            }
        }
        return jexlCriteria;
    }

    public void a(Map map) {
        if (!map.containsKey("criteria")) {
            return;
        }
        Object v2 = map.get("criteria");
        JexlCriteria jexlCriteria = new JexlCriteria();
        if (v2 instanceof Map) {
            Map map2 = (Map)v2;
            List list = (List)map2.get("rules");
            for (Object e2 : list) {
                Rule rule = jexlCriteria.addRule();
                Map map3 = (Map)e2;
                List list2 = (List)map3.get("conditions");
                for (Object e3 : list2) {
                    Map map4 = (Map)e3;
                    rule.addCondition(map4.get("attribute"), (Object)Operation.fromString(map4.get("operation").toString()), map4.get("value"));
                }
            }
        } else if (v2 instanceof List) {
            List list = (List)map.get("criteria");
            for (Object e4 : list) {
                List list3 = (List)e4;
                Rule rule = jexlCriteria.addRule();
                for (Object e5 : list3) {
                    Map map5 = (Map)e5;
                    rule.addCondition(map5.get("attr"), (Object)Operation.fromString(map5.get("oper").toString()), map5.get("expr"));
                }
            }
        }
        map.put("criteria", jexlCriteria);
    }

    protected void a(DBObject dBObject, Map map) {
        for (String string : map.keySet()) {
            if (string.equals("hostname") || string.equals("application") || string.equals("log4j.remoteSourceInfo") || string.equals("log4jmachinename")) continue;
            String string2 = StringUtils.replace((String)string, (String)".", (String)"_");
            this.a(dBObject, "p_" + string2, (Object)((String)map.get(string)).toString());
        }
    }

    protected void a(DBObject dBObject, LoggingEventVO loggingEventVO) {
        for (String string : dBObject.keySet()) {
            if (!string.startsWith("p_")) continue;
            String string2 = string.substring(2, string.length());
            loggingEventVO.setProperty(string2, (String)dBObject.get(string));
        }
    }

    protected void a(DBObject dBObject, String string, Object object) {
        if (object != null) {
            if (object instanceof String) {
                String string2 = (String)object;
                if (string2.trim().length() > 0) {
                    dBObject.put(string, (Object)string2);
                }
            } else {
                dBObject.put(string, object);
            }
        }
    }

    protected void a(Map map, String string, Object object) {
        if (object != null) {
            if (object instanceof String) {
                String string2 = (String)object;
                if (string2.trim().length() > 0) {
                    map.put(string, string2);
                }
            } else {
                map.put(string, object);
            }
        }
    }

    protected void a(JSONObject jSONObject, String string, Object object) {
        if (object != null) {
            if (object instanceof String) {
                String string2 = (String)object;
                if (string2.trim().length() > 0) {
                    jSONObject.put(string, (Object)string2);
                }
            } else {
                jSONObject.put(string, object);
            }
        }
    }

    protected Object a(FieldValueList fieldValueList, String string, Class clazz, Object object) {
        Object object2 = object;
        try {
            FieldValue fieldValue = fieldValueList.get(string);
            if (fieldValue.isNull()) {
                return object2;
            }
            object2 = Integer.class.equals((Object)clazz) ? Integer.valueOf(fieldValue.getNumericValue().intValue()) : (Long.class.equals((Object)clazz) ? Long.valueOf(fieldValue.getNumericValue().longValue()) : (String.class.equals((Object)clazz) ? fieldValue.getStringValue() : (Boolean.class.equals((Object)clazz) ? Boolean.valueOf(fieldValue.getBooleanValue()) : "")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object2;
    }

    protected long a(FieldValueList fieldValueList, String string, long l2) {
        try {
            FieldValue fieldValue = fieldValueList.get(string);
            return fieldValue.getTimestampValue() / 1000L;
        }
        catch (Exception exception) {
            return l2;
        }
    }
}

