/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.util;

import com.moonlit.logfaces.server.util.C;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;

public class Revision
implements Comparable {
    private int major;
    private int minor;
    private int update;
    private int build;
    private long date;
    public static final String DELIM = ".";
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyy");

    private Revision(int n2, int n3, int n4, int n5, long l2) {
        this.major = n2;
        this.minor = n3;
        this.update = n4;
        this.build = n5;
        this.date = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Revision getRevision() {
        Object object;
        Attributes attributes;
        block28: {
            Revision revision;
            Class<Revision> clazz = Revision.class;
            ZipFile zipFile = null;
            attributes = null;
            try {
                object = clazz.getProtectionDomain().getCodeSource().getLocation();
                zipFile = new JarFile(new File(((URL)object).toURI()));
                attributes = ((JarFile)zipFile).getManifest().getMainAttributes();
                if (!attributes.getValue("Implementation-Title").equals("lfs")) {
                    Revision revision2 = Revision.getRevision("/revision");
                    return revision2;
                }
                if (attributes.getValue("Description").contains("logFaces")) break block28;
                revision = Revision.getRevision("/revision");
            }
            catch (Exception exception) {
                Revision revision3 = Revision.getRevision("/revision");
                return revision3;
            }
            finally {
                try {
                    zipFile.close();
                }
                catch (Exception exception) {}
            }
            return revision;
        }
        object = attributes.getValue("Implementation-Version");
        if (object == null || ((String)object).isBlank()) {
            return Revision.getUnknown();
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        long l2 = 0L;
        String[] stringArray = ((String)object).split("\\.");
        try {
            n2 = Integer.parseInt(stringArray[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n3 = Integer.parseInt(stringArray[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n4 = Integer.parseInt(stringArray[2]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n5 = Integer.parseInt(attributes.getValue("Build-Number"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            l2 = simpleDateFormat.parse(attributes.getValue("Built-Date")).getTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Revision(n2, n3, n4, n5, l2);
    }

    public static Revision getRevision(String string) {
        try {
            int n2;
            InputStream inputStream = Revision.class.getResourceAsStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            StringWriter stringWriter = new StringWriter();
            while ((n2 = ((Reader)inputStreamReader).read()) >= 0) {
                stringWriter.write(n2);
            }
            ((Reader)inputStreamReader).close();
            stringWriter.close();
            return Revision.parse(stringWriter.toString());
        }
        catch (Exception exception) {
            return Revision.getUnknown();
        }
    }

    public static Revision getUnknown() {
        return new Revision(0, 0, 0, 0, 0L);
    }

    public static Revision parse(String string) {
        try {
            if (string == null) {
                throw new Exception("unvalid revision stamp (null)");
            }
            String[] stringArray = string.split("\\.");
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            long l2 = 0L;
            try {
                n2 = Integer.parseInt(stringArray[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                n3 = Integer.parseInt(stringArray[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                n4 = Integer.parseInt(stringArray[2]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                n5 = Integer.parseInt(stringArray[3]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                l2 = dateFormat.parse(stringArray[4]).getTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new Revision(n2, n3, n4, n5, l2);
        }
        catch (Exception exception) {
            return Revision.getUnknown();
        }
    }

    public synchronized int getMajor() {
        return this.major;
    }

    public synchronized int getMinor() {
        return this.minor;
    }

    public synchronized int getRelease() {
        return this.update;
    }

    public synchronized int getBuild() {
        return this.build;
    }

    public int compareTo(Revision revision) {
        Revision revision2 = revision;
        if (this.major > revision2.major) {
            return 1;
        }
        if (this.minor > revision2.minor && this.major == revision2.major) {
            return 1;
        }
        if (this.update > revision2.update && this.minor == revision2.minor && this.major == revision2.major) {
            return 1;
        }
        if (this.build > revision2.build && this.update == revision2.update && this.minor == revision2.minor && this.major == revision2.major) {
            return 1;
        }
        if (this.build == revision2.build && this.major == revision2.major && this.minor == revision2.minor && this.update == revision2.update) {
            return 0;
        }
        return -1;
    }

    public String toString() {
        return this.major + DELIM + this.minor + DELIM + this.update + DELIM + this.build;
    }

    public String toShortString() {
        return this.major + DELIM + this.minor + DELIM + this.update;
    }

    public String toFullString() {
        return this.toString() + DELIM + dateFormat.format(new Date(this.date));
    }

    public long getDate() {
        return this.date;
    }

    public String getDateString() {
        return C.a(this.date, "dd MMM YYYY");
    }
}

