/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.updates;

import com.moonlit.logfaces.server.conf.i;
import com.moonlit.logfaces.server.core.y;
import com.moonlit.logfaces.server.updates.a;
import com.moonlit.logfaces.server.updates.b;
import com.moonlit.logfaces.server.util.Revision;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.tanukisoftware.wrapper.WrapperManager;

public class LfsInstaller {
    private static LfsInstaller a;
    private File b;
    private File c;
    private Logger d = LogManager.getLogger(this.getClass());

    public static LfsInstaller a() {
        if (a == null) {
            a = new LfsInstaller();
        }
        return a;
    }

    private LfsInstaller() {
        this.g();
        this.b = new File(i.f());
        this.c = new File(i.e());
    }

    public b b() {
        try {
            this.d.info("getting update info");
            URL uRL = new URL(System.getProperty("com.moonlit.logfaces.url.updates", "https://www.moonlit-software.com/logfaces/downloads/lfs-updates.xml"));
            a a2 = new a();
            b b2 = com.moonlit.logfaces.server.updates.b.a(a2.a(uRL));
            this.d.info("update available: {}", (Object)b2);
            return b2;
        }
        catch (Exception exception) {
            this.d.error("check update failed", (Throwable)exception);
            throw exception;
        }
    }

    public File a(b b2, y y2) {
        try {
            String string = System.getProperty("com.moonlit.logfaces.url.updates", "https://www.moonlit-software.com/logfaces/downloads/lfs-updates.xml");
            URL uRL = new URL(String.format("%s/%s", string.substring(0, string.lastIndexOf("/")), b2.a()));
            File file = new File(i.c(b2.a()));
            file.delete();
            a a2 = new a();
            a2.a(uRL, file, b2.c(), y2);
            if (y2 != null) {
                y2.done();
            }
            FileUtils.deleteQuietly((File)this.c);
            this.c.mkdir();
            this.a(file, this.c.getCanonicalPath());
            return file;
        }
        catch (Exception exception) {
            this.d.error("download update failed", (Throwable)exception);
            throw exception;
        }
    }

    public void c() {
        this.d.info("preparing wrapper for installer launch");
        File file = this.h();
        File file2 = this.i();
        this.d.info("updating {} to use {}", (Object)file.getCanonicalPath(), (Object)file2.getCanonicalPath());
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, true));
        bufferedWriter.append(String.format("%n#include %s", file2.getCanonicalPath()));
        bufferedWriter.flush();
        bufferedWriter.close();
        this.d.info("restarting wrapper JVM");
        WrapperManager.restartAndReturn();
    }

    public void d() {
        try {
            this.d.info("preparing wrapper for logFaces server launch");
            File file = this.j();
            File file2 = this.h();
            File file3 = new File(String.format("%s%slfs.temp", file.getCanonicalPath(), File.separator));
            FileUtils.copyFile((File)file2, (File)file3);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file3));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2, false));
            String string = null;
            String string2 = System.getProperty("line.separator");
            while ((string = bufferedReader.readLine()) != null) {
                if (string.contains("lfs-updates.conf")) continue;
                bufferedWriter.write(string);
                bufferedWriter.write(string2);
            }
            bufferedReader.close();
            bufferedWriter.flush();
            bufferedWriter.close();
            file3.delete();
        }
        catch (Throwable throwable) {
            this.d.fatal(throwable.getMessage(), throwable);
        }
        this.d.info("restarting JVM...");
        WrapperManager.restartAndReturn();
    }

    public void e() {
        this.d.info("installing updates using installer revision: {}", (Object)Revision.getRevision().toString());
        try {
            if (!this.c.exists()) {
                File file = new File(i.c(null));
                if (!file.exists()) {
                    throw new Exception("update pack is not found in " + (File)file);
                }
                this.c.mkdir();
                this.a(file, this.c.getCanonicalPath());
            }
            for (File file : this.c.listFiles(File::isDirectory)) {
                if (file.getName().contains("install")) continue;
                File file2 = new File(String.format("%s%s%s", this.b.getCanonicalPath(), File.separator, file.getName()));
                FileUtils.deleteQuietly((File)file2);
                FileUtils.copyDirectory((File)file, (File)file2);
                this.d.info("updated {}", (Object)file2.getCanonicalPath());
            }
            this.d.info("update package is installed successully");
            FileUtils.deleteQuietly((File)this.c);
        }
        catch (Throwable throwable) {
            this.d.fatal("install failed", throwable);
        }
        this.d();
    }

    public static void f() {
        File file = new File(String.format("%s%s%s", i.f(), File.separator, "depricated"));
        FileUtils.deleteQuietly((File)file);
        file = new File(String.format("%s%s%s", i.f(), File.separator, "lfsinstaller.jar"));
        FileUtils.deleteQuietly((File)file);
    }

    protected void g() {
        if (WrapperManager.getProperties().getProperty("wrapper.restart.reload_configuration", null) != null) {
            return;
        }
        try {
            File file = new File(WrapperManager.getProperties().getProperty("wrapper.working.dir", "."));
            File file2 = new File(String.format("%s%slfs.conf", file.getCanonicalPath(), File.separator));
            if (!file2.exists()) {
                this.d.fatal("wrapper configuration file missing: {}", (Object)file2.getCanonicalPath());
                return;
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2, true));
            String string = System.getProperty("line.separator");
            bufferedWriter.append(string);
            bufferedWriter.append(string);
            bufferedWriter.append("#********************************************************************" + string);
            bufferedWriter.append("# Allow wrapper to reload configuration when restarted" + string);
            bufferedWriter.append("# Set TRUE to enable auto-updates installer (recommended)" + string);
            bufferedWriter.append("#********************************************************************" + string);
            bufferedWriter.append("wrapper.restart.reload_configuration=TRUE" + string);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (Throwable throwable) {
            this.d.fatal("ensureCfgReload failed: " + throwable.getMessage(), throwable);
        }
    }

    protected File h() {
        File file = new File(String.format("%s%s%s", this.j().getCanonicalPath(), File.separator, "lfs.conf"));
        if (!file.exists()) {
            this.d.warn("wrapper config file {} is not found", (Object)file.getCanonicalPath());
            throw new Exception("wrapper config file is not found");
        }
        return file;
    }

    protected File i() {
        File file = new File(String.format("%s%s%s%s%s", this.c.getCanonicalPath(), File.separator, "installer", File.separator, "lfs-updates.conf"));
        if (!file.exists()) {
            this.d.warn("wrapper update file {} is not found", (Object)file.getCanonicalPath());
            throw new Exception("wrapper update file is not found");
        }
        return file;
    }

    protected File j() {
        return new File(WrapperManager.getProperties().getProperty("wrapper.working.dir", "."));
    }

    protected void a(File file, String string) {
        if (file.getName().endsWith(".tar.gz")) {
            this.c(file, string);
        } else if (file.getName().endsWith(".zip")) {
            this.a(file, string, null);
        } else {
            throw new Exception("archive format not supported: " + file.getName());
        }
    }

    protected void b(File file, String string) {
        this.a(file, string, null);
    }

    protected void a(File file, String string, String string2) {
        this.d.info("extracting {} from {} into {}", (Object)(string2 == null ? "all" : string2), (Object)file.getCanonicalPath(), (Object)string);
        ZipEntry zipEntry = null;
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));){
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (string2 != null) {
                    if (!zipEntry.getName().endsWith(string2)) continue;
                    this.a(zipInputStream, string, zipEntry.getName());
                    break;
                }
                if (zipEntry.isDirectory()) {
                    String string3 = String.format("%s%s%s", string, File.separator, zipEntry.getName());
                    File file2 = new File(string3);
                    this.d.info("extracting {}", (Object)file2.getCanonicalPath());
                    if (file2.exists()) continue;
                    file2.mkdir();
                    continue;
                }
                this.a(zipInputStream, string, zipEntry.getName());
            }
        }
    }

    private void a(ZipInputStream zipInputStream, String string, String string2) {
        int n2 = 0;
        byte[] byArray = new byte[4096];
        File file = new File(String.format("%s%s%s", string, File.separator, string2));
        this.d.info("extracting {}", (Object)file.getCanonicalPath());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), byArray.length);
        while ((n2 = zipInputStream.read(byArray, 0, byArray.length)) != -1) {
            bufferedOutputStream.write(byArray, 0, n2);
        }
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
    }

    private void c(File file, String string) {
        int n2 = 8192;
        Path path = Paths.get(string, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        } else if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IOException("Destination is not a directory: " + string);
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
             GzipCompressorInputStream gzipCompressorInputStream = new GzipCompressorInputStream((InputStream)bufferedInputStream);
             TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream((InputStream)gzipCompressorInputStream);){
            TarArchiveEntry tarArchiveEntry;
            while ((tarArchiveEntry = tarArchiveInputStream.getNextEntry()) != null) {
                Path path2 = path.resolve(tarArchiveEntry.getName()).normalize();
                if (!path2.startsWith(path)) {
                    throw new IOException("Entry is outside the target directory: " + tarArchiveEntry.getName());
                }
                if (tarArchiveEntry.isDirectory()) {
                    Files.createDirectories(path2, new FileAttribute[0]);
                    this.a(path2, tarArchiveEntry.getMode());
                    continue;
                }
                Files.createDirectories(path2.getParent(), new FileAttribute[0]);
                try (FileOutputStream fileOutputStream = new FileOutputStream(path2.toFile());
                     BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, n2);){
                    IOUtils.copy((InputStream)tarArchiveInputStream, (OutputStream)bufferedOutputStream);
                }
                this.a(path2, tarArchiveEntry.getMode());
            }
        }
    }

    private void a(Path path, int n2) {
        if (Files.getFileStore(path).supportsFileAttributeView("posix") && n2 != 0) {
            HashSet<PosixFilePermission> hashSet = new HashSet<PosixFilePermission>();
            if ((n2 & 0x100) != 0) {
                hashSet.add(PosixFilePermission.OWNER_READ);
            }
            if ((n2 & 0x80) != 0) {
                hashSet.add(PosixFilePermission.OWNER_WRITE);
            }
            if ((n2 & 0x40) != 0) {
                hashSet.add(PosixFilePermission.OWNER_EXECUTE);
            }
            if ((n2 & 0x20) != 0) {
                hashSet.add(PosixFilePermission.GROUP_READ);
            }
            if ((n2 & 0x10) != 0) {
                hashSet.add(PosixFilePermission.GROUP_WRITE);
            }
            if ((n2 & 8) != 0) {
                hashSet.add(PosixFilePermission.GROUP_EXECUTE);
            }
            if ((n2 & 4) != 0) {
                hashSet.add(PosixFilePermission.OTHERS_READ);
            }
            if ((n2 & 2) != 0) {
                hashSet.add(PosixFilePermission.OTHERS_WRITE);
            }
            if ((n2 & 1) != 0) {
                hashSet.add(PosixFilePermission.OTHERS_EXECUTE);
            }
            Files.setPosixFilePermissions(path, hashSet);
        }
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        System.setProperty("lfs.inst", string);
        System.setProperty("lfs.home", string);
        i.a(string);
        LfsInstaller lfsInstaller = new LfsInstaller();
        b b2 = lfsInstaller.b();
        lfsInstaller.a(b2, null);
        lfsInstaller.e();
    }
}

