/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.reports;

import com.moonlit.logfaces.server.conf.DestinationEmail;
import com.moonlit.logfaces.server.conf.d;
import com.moonlit.logfaces.server.conf.i;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.database.x;
import com.moonlit.logfaces.server.reports.b;
import com.moonlit.logfaces.server.util.C;
import com.moonlit.logfaces.server.util.l;
import com.moonlit.logfaces.server.util.m;
import com.moonlit.logfaces.server.util.t;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.zeroturnaround.zip.ZipUtil;

public class ReportJob
implements Job {
    private static Logger log = LogManager.getLogger(ReportJob.class);
    private b report;
    private File tempDir;
    private File outfile;
    private File zipfile;
    private LogEvent firstEvent;
    private String message;
    private String subject;

    public void execute(JobExecutionContext jobExecutionContext) {
        this.report = (b)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"report");
        if (this.report == null) {
            log.error("no report attached to job context");
            return;
        }
        try {
            this.report.f(C.a(jobExecutionContext.getTrigger().getNextFireTime()));
            log.info(String.format("report [%s] fired", this.report.e()));
            this.initAndValidate();
            if (this.fetchDataToFile() > 0L) {
                this.makeEmail(true);
            } else {
                log.info(String.format("report [%s] is empty, nothing to send", this.report.e()));
            }
        }
        catch (Exception exception) {
            log.error(String.format("failed to execute job [%s]", this.report.e()), (Throwable)exception);
            m.a().a(l.F);
            return;
        }
        finally {
            this.cleanup();
        }
    }

    public String test(b b2, boolean bl) {
        this.report = b2;
        log.info(String.format("testing report [%s]", b2.e()));
        try {
            this.initAndValidate();
            if (this.fetchDataToFile() == 0L) {
                throw new Exception("No data found in database for specified criteria");
            }
            this.makeEmail(bl);
            String string = this.outfile.getPath();
            return string;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (bl) {
                this.cleanup();
            }
        }
    }

    protected void initAndValidate() {
        if (this.report.g() == null) {
            throw new IllegalArgumentException("missing 'mailTo' parameter");
        }
        if (this.report.k() == 0.0f) {
            throw new IllegalArgumentException("missing 'sizeInHours' parameter");
        }
        if (d.a().m().length() == 0) {
            throw new IllegalArgumentException("email server is not set");
        }
        this.tempDir = new File(String.format("%s%srjob%d-%d", i.b(), File.separator, this.report.b(), System.currentTimeMillis()));
        this.outfile = new File(String.format("%s%s%s.log", this.tempDir.getPath(), File.separator, this.report.e()));
        this.zipfile = new File(String.format("%s%s%s.zip", this.tempDir.getPath(), File.separator, this.report.e()));
        FileUtils.forceMkdir((File)this.tempDir);
    }

    protected Map constructQueryParams() {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        long l2 = (long)(this.report.k() * 3600000.0f);
        treeMap.put("fromTime", System.currentTimeMillis() - l2);
        treeMap.put("toTime", System.currentTimeMillis());
        treeMap.put("fetchThrowable", true);
        treeMap.put("criteria", this.report.d());
        return treeMap;
    }

    protected long fetchDataToFile() {
        t t2 = new t();
        t2.g().setProperty("file", this.outfile.getPath());
        t2.g().setProperty("format", this.report.j());
        Map map = this.constructQueryParams();
        x x2 = new x(t2, map);
        long l2 = x2.a();
        this.firstEvent = x2.b();
        return l2;
    }

    protected void makeEmail(boolean bl) {
        DestinationEmail destinationEmail = this.report.n();
        if (this.outfile.length() > (long)(this.report.i() * 1024)) {
            ZipUtil.packEntry((File)this.outfile, (File)this.zipfile);
            destinationEmail.attach(this.zipfile, this.zipfile.getName());
        } else {
            destinationEmail.attach(this.outfile, this.outfile.getName());
        }
        if (log.isTraceEnabled()) {
            d d2 = d.a();
            log.trace(String.format("sending report [%s] to %s, account: %s, server: %s", this.report.e(), this.report.g(), d2.n(), d2.m()));
        }
        this.subject = this.makeSubject();
        this.message = this.makeMessage();
        if (bl) {
            destinationEmail.send(this.message, this.subject, null, this);
        }
        log.info(String.format("report [%s] sent to %s, attachment size: %s", this.report.e(), this.report.g(), C.c(this.outfile.length())));
    }

    protected String makeSubject() {
        String string = this.report.m();
        if (StringUtils.isBlank((CharSequence)string)) {
            return StringUtils.isBlank((CharSequence)this.report.e()) ? "logFaces scheduled report" : this.report.e();
        }
        if (this.firstEvent == null || !string.contains("${")) {
            return string;
        }
        string = this.firstEvent.resolve(string);
        string = StringUtils.replace((String)string, (String)"${serverTime}", (String)new DateTime().toString("dd-MMM-YYYY HH:mm:ss"));
        return StringUtils.abbreviate((String)string, (int)80);
    }

    protected String makeMessage() {
        String string = C.b(this.outfile.getPath(), 100);
        return String.format("This is scheduled logFaces report named [%s].%nFirst lines are included below, the rest are in the attachment.%n%n--------- begin report log ---------%n%s%n...", this.report.e(), string);
    }

    public void cleanup() {
        try {
            if (this.tempDir != null) {
                FileUtils.deleteDirectory((File)this.tempDir);
            }
        }
        catch (Exception exception) {
            log.warn("problem removing {}, error: {}", (Object)this.tempDir.getPath(), (Object)exception.getMessage(), (Object)exception);
        }
    }

    public String getSubject() {
        return this.subject;
    }

    public String getMessage() {
        return this.message;
    }
}

