/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.remoting;

import com.caucho.services.server.GenericService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.moonlit.logfaces.server.access.c;
import com.moonlit.logfaces.server.access.d;
import com.moonlit.logfaces.server.access.g;
import com.moonlit.logfaces.server.conf.k;
import com.moonlit.logfaces.server.conf.n;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.database.r;
import com.moonlit.logfaces.server.database.u;
import com.moonlit.logfaces.server.e;
import com.moonlit.logfaces.server.h;
import com.moonlit.logfaces.server.i;
import com.moonlit.logfaces.server.l;
import com.moonlit.logfaces.server.l.b;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import com.moonlit.logfaces.server.receivers.j;
import com.moonlit.logfaces.server.remoting.LfsRemote;
import com.moonlit.logfaces.server.remoting.a;
import com.moonlit.logfaces.server.util.Revision;
import com.moonlit.logfaces.server.util.s;
import com.moonlit.logfaces.server.util.y;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.ServletConfig;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.springframework.security.core.Authentication;

public class LfsService
extends GenericService
implements LfsRemote {
    private Logger log = LogManager.getLogger(this.getClass());
    private Map sessions;
    private com.moonlit.logfaces.server.conf.d configurator = com.moonlit.logfaces.server.conf.d.a();
    private e engine = e.a();
    private static LfsService instance;

    public void init(ServletConfig servletConfig) {
        this.sessions = new HashMap();
        instance = this;
        this.log.info("ready to handle remote calls");
    }

    public void destroy() {
        this.removeAllSessions();
        instance = null;
        this.log.info("service is down");
    }

    public static LfsService getInstance() {
        return instance;
    }

    public synchronized void removeAllSessions() {
        this.sessions.clear();
    }

    private void isEngineRunning() {
        if (!this.engine.i()) {
            throw new RemoteException("This instance of logFaces server requires valid license. If you have the license, please install it through server administration. Otherwise contact us for obtaining valid license.");
        }
        if (!this.engine.e()) {
            throw new RemoteException("logFaces engine is not running.");
        }
    }

    private synchronized h getSession(String string) {
        this.isEngineRunning();
        h h2 = (h)this.sessions.get(string);
        if (h2 == null) {
            throw new RemoteException("access is denied, no session");
        }
        return h2;
    }

    @Override
    public void uploadConfiguration(boolean bl, InputStream inputStream) {
        File file;
        try {
            this.log.info("deploying configuration archive");
            file = com.moonlit.logfaces.server.conf.i.c();
            IOUtils.copy((InputStream)inputStream, (OutputStream)new FileOutputStream(file));
        }
        catch (Exception exception) {
            throw new RemoteException(exception.getMessage());
        }
        if (bl) {
            try {
                this.engine.a(file);
            }
            catch (Exception exception) {
                throw new RemoteException(exception.getMessage());
            }
        }
    }

    public void applyAuthorization() {
        for (h h2 : this.sessions.values()) {
            Authentication authentication = h2.j().e();
            g g2 = d.a().a(authentication);
            h2.a(g2);
        }
    }

    public synchronized int getClientsCounter() {
        return this.sessions.size();
    }

    public synchronized void checkOrphans() {
        HashSet<h> hashSet = new HashSet<h>();
        for (h h2 : this.sessions.values()) {
            if (System.currentTimeMillis() - h2.h() <= this.configurator.s()) continue;
            h2.a();
            hashSet.add(h2);
        }
        for (h h2 : hashSet) {
            this.sessions.remove(h2.b());
            this.log.info(String.format("%s removed, total: %d", h2, this.sessions.size()));
        }
    }

    public synchronized Collection getPairedPerspectives() {
        ArrayList arrayList = new ArrayList();
        for (h h2 : this.sessions.values()) {
            arrayList.addAll(h2.c());
        }
        return arrayList;
    }

    @Override
    public synchronized String connect() {
        this.isEngineRunning();
        if (!com.moonlit.logfaces.server.l.e.a().a(b.f)) {
            this.log.warn("attempt to connect while remoting feature is disabled");
            throw new RemoteException("access is denied, remoting feature is disabled");
        }
        int n2 = com.moonlit.logfaces.server.l.e.a().h();
        if (this.sessions.size() >= n2) {
            this.log.warn("attempt to connect too many clients");
            throw new RemoteException("current license doesn't allow more than " + n2 + " clients connected at the same time.");
        }
        if (!this.configurator.y().c()) {
            return null;
        }
        h h2 = new h(new c());
        this.sessions.put(h2.b(), h2);
        this.log.info(String.format("%s created, total: %d", h2, this.sessions.size()));
        return h2.b();
    }

    @Override
    public synchronized String login(String string, String string2) {
        this.isEngineRunning();
        try {
            g g2 = com.moonlit.logfaces.server.access.i.a().a(string, string2);
            h h2 = new h(g2);
            this.sessions.put(h2.b(), h2);
            this.log.info(String.format("%s created, total: %d", h2, this.sessions.size()));
            return h2.b();
        }
        catch (Exception exception) {
            this.log.warn("unsuccessfull login attempt for user: " + string);
            return null;
        }
    }

    @Override
    public synchronized void disconnect(String string) {
        h h2 = this.getSession(string);
        h2.a();
        this.sessions.remove(string);
        this.log.info(String.format("%s removed, total: %d", h2, this.sessions.size()));
    }

    @Override
    public synchronized String pair(String string) {
        this.isEngineRunning();
        if (!com.moonlit.logfaces.server.l.e.a().a(b.k)) {
            this.log.warn("attempt to connect while pairing feature is disabled");
            throw new RemoteException("access is denied, pairing feature is disabled");
        }
        int n2 = com.moonlit.logfaces.server.l.e.a().h();
        if (this.sessions.size() >= n2) {
            this.log.warn("attempt to connect too many clients");
            throw new RemoteException("current license doesn't allow more than " + n2 + " clients connected at the same time.");
        }
        h h2 = new h(new c());
        h2.j(string);
        this.sessions.put(h2.b(), h2);
        this.log.info(String.format("%s created pair from [%s], total sessions: %d", h2, string, this.sessions.size()));
        return h2.b();
    }

    @Override
    public synchronized Set getPairs() {
        if (!com.moonlit.logfaces.server.l.e.a().a(b.k)) {
            this.log.warn("attempt to use disabled feature: pairing");
            throw new RemoteException("access is denied, pairing feature is disabled");
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (h h2 : this.sessions.values()) {
            String string = h2.k();
            if (string == null) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    @Override
    public void terminate() {
        new Thread(new a(this)).start();
    }

    @Override
    public long getSessionTimeout() {
        return this.configurator.s() / 2L;
    }

    @Override
    public void isAlive(String string) {
        this.getSession(string).i();
    }

    @Override
    public String getLicenseString() {
        this.isEngineRunning();
        try {
            return com.moonlit.logfaces.server.l.e.a().d();
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage(), (Throwable)exception);
            throw new RemoteException("Unable to obtain license content or license is invalid");
        }
    }

    @Override
    public Map getLicenseInfo() {
        this.isEngineRunning();
        try {
            return com.moonlit.logfaces.server.l.e.a().e();
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage(), (Throwable)exception);
            throw new RemoteException("Unable to obtain license info or license is invalid");
        }
    }

    @Override
    public String getRevision() {
        this.isEngineRunning();
        return Revision.getRevision().toString();
    }

    @Override
    public boolean isDatabaseEnabled() {
        this.isEngineRunning();
        if (com.moonlit.logfaces.server.conf.d.a().J().d()) {
            return false;
        }
        u u2 = r.a().g();
        return u2.f();
    }

    @Override
    public String getDatabaseDialect() {
        this.isEngineRunning();
        u u2 = r.a().g();
        return u2.s().name();
    }

    @Override
    public long getDatabaseSize() {
        this.isEngineRunning();
        try {
            u u2 = r.a().g();
            if (!u2.s().a() && !this.configurator.C()) {
                return -1L;
            }
            return u2.b(true);
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage(), (Throwable)exception);
            throw new RemoteException(String.format("getDatabaseSize failed: %s", exception.getMessage()));
        }
    }

    @Override
    public Map getMdcMapping() {
        return k.f();
    }

    @Override
    public void activatePerspective(String string, String string2) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        h h2 = this.getSession(string);
        try {
            h2.a(string2);
        }
        catch (Exception exception) {
            throw new RemoteException(String.format("activatePerspective failed: %s", exception.getMessage()));
        }
    }

    @Override
    public void deactivatePerspective(String string, String string2) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        h h2 = this.getSession(string);
        try {
            h2.b(string2);
        }
        catch (Exception exception) {
            throw new RemoteException(String.format("deactivatePerspective failed: %s", exception.getMessage()));
        }
    }

    @Override
    public List getListOfPerspectives(String string) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        h h2 = this.getSession(string);
        try {
            return h2.d();
        }
        catch (Exception exception) {
            throw new RemoteException(String.format("getListOfPerspectives failed: %s", exception.getMessage()));
        }
    }

    @Override
    public List getRepositoryData(String string) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        h h2 = this.getSession(string);
        try {
            return h2.e();
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage(), (Throwable)exception);
            throw new RemoteException(String.format("getRepositoryData failed: %s", exception.getMessage()));
        }
    }

    @Override
    public InputStream getRepositoryStream(String string) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        h h2 = this.getSession(string);
        try {
            return h2.g();
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage(), (Throwable)exception);
            throw new RemoteException(String.format("getRepositoryData failed: %s", exception.getMessage()));
        }
    }

    @Override
    public List getRepositoryHosts(String string) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        h h2 = this.getSession(string);
        try {
            return h2.f();
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage(), (Throwable)exception);
            throw new RemoteException(String.format("getRepositoryHosts failed: %s", exception.getMessage()));
        }
    }

    @Override
    public List pollPerspective(String string, String string2, long l2) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        h h2 = this.getSession(string);
        try {
            return h2.a(string2, l2);
        }
        catch (Exception exception) {
            throw new RemoteException(String.format("pollPerspective failed: %s", exception.getMessage()));
        }
    }

    @Override
    public List queryDistribution(String string, Map map) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        h h2 = this.getSession(string);
        try {
            return h2.a(map);
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage(), (Throwable)exception);
            throw new RemoteException(String.format("queryDistribution failed: %s", exception.getMessage()));
        }
    }

    @Override
    public List queryBegin(String string, String string2, Map map, int n2, int n3) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        h h2 = this.getSession(string);
        try {
            return h2.a(string2, map, n2, n3);
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage(), (Throwable)exception);
            throw new RemoteException(String.format("queryBegin failed: %s", exception.getMessage()));
        }
    }

    @Override
    public InputStream queryTurbo(String string, String string2, Map map) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        h h2 = this.getSession(string);
        try {
            return h2.b(string2, map);
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage(), (Throwable)exception);
            throw new RemoteException(String.format("queryTurbo failed: %s", exception.getMessage()));
        }
    }

    @Override
    public Object queryOne(String string, Object object, String string2) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        h h2 = this.getSession(string);
        try {
            return h2.a(object, string2);
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage(), (Throwable)exception);
            throw new RemoteException(String.format("queryOne failed: %s", exception.getMessage()));
        }
    }

    @Override
    public int queryCount(String string, String string2) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        h h2 = this.getSession(string);
        try {
            return h2.e(string2);
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage(), (Throwable)exception);
            throw new RemoteException(String.format("queryCount failed: %s", exception.getMessage()));
        }
    }

    @Override
    public void queryEnd(String string, String string2) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        h h2 = this.getSession(string);
        try {
            h2.i(string2);
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage(), (Throwable)exception);
            throw new RemoteException(String.format("queryEnd failed: %s", exception.getMessage()));
        }
    }

    @Override
    public List queryFirst(String string, String string2, int n2) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        h h2 = this.getSession(string);
        try {
            return h2.b(string2, n2);
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage(), (Throwable)exception);
            throw new RemoteException(String.format("queryFirst failed: %s", exception.getMessage()));
        }
    }

    @Override
    public List queryLast(String string, String string2) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        h h2 = this.getSession(string);
        try {
            return h2.h(string2);
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage(), (Throwable)exception);
            throw new RemoteException(String.format("queryLast failed: %s", exception.getMessage()));
        }
    }

    @Override
    public List queryNext(String string, String string2) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        h h2 = this.getSession(string);
        try {
            return h2.f(string2);
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage(), (Throwable)exception);
            throw new RemoteException(String.format("queryNext failed: %s", exception.getMessage()));
        }
    }

    @Override
    public List queryPrev(String string, String string2) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        h h2 = this.getSession(string);
        try {
            return h2.g(string2);
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage(), (Throwable)exception);
            throw new RemoteException(String.format("queryPrev failed: %s", exception.getMessage()));
        }
    }

    @Override
    public void removePerspective(String string, String string2) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        h h2 = this.getSession(string);
        try {
            h2.d(string2);
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage(), (Throwable)exception);
            throw new RemoteException(String.format("removePerspective failed: %s", exception.getMessage()));
        }
    }

    @Override
    public void setupPerspective(String string, String string2, CriteriaFilter criteriaFilter) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        h h2 = this.getSession(string);
        try {
            h2.a(string2, criteriaFilter);
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage(), (Throwable)exception);
            throw new RemoteException(String.format("setupPerspective failed: %s", exception.getMessage()));
        }
    }

    @Override
    public void setupCounters(String string, String string2, Map map) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        h h2 = this.getSession(string);
        try {
            h2.a(string2, map);
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage(), (Throwable)exception);
            throw new RemoteException(String.format("setupCounters failed: %s", exception.getMessage()));
        }
    }

    @Override
    public Map pollCounters(String string, String string2, long l2) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        h h2 = this.getSession(string);
        try {
            return h2.b(string2, l2);
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage() + " - " + string2);
            throw new RemoteException(String.format("pollCounters failed: %s", exception.getMessage()));
        }
    }

    @Override
    public void resetCounters(String string, String string2) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        h h2 = this.getSession(string);
        try {
            h2.c(string2);
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage(), (Throwable)exception);
            throw new RemoteException(String.format("resetCounters failed: %s", exception.getMessage()));
        }
    }

    @Override
    public List getCounterEvents(String string, String string2, int n2) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        h h2 = this.getSession(string);
        try {
            return h2.a(string2, n2);
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage(), (Throwable)exception);
            throw new RemoteException(String.format("getCounterEvents failed: %s", exception.getMessage()));
        }
    }

    @Override
    public synchronized void importData(String string, List list) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        h h2 = this.getSession(string);
        this.log.info(String.format("%s - importing %d events", string, list.size()));
        try {
            h2.a(list);
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage(), (Throwable)exception);
            throw new RemoteException(String.format("importData failed: %s", exception.getMessage()));
        }
    }

    @Override
    public int removeRepositoryData(String string, List list, boolean bl) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        this.log.info(String.format("%s - removing %d repository entries %s", string, list.size(), bl ? "and data" : ""));
        h h2 = this.getSession(string);
        try {
            return h2.a(list, bl);
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage(), (Throwable)exception);
            throw new RemoteException(String.format("removeRepositoryData failed: %s", exception.getMessage()));
        }
    }

    @Override
    public InputStream saveQueryToFile(String string, Map map, String string2) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        h h2 = this.getSession(string);
        this.log.info(String.format("%s - saving query to file", string));
        try {
            return h2.a(map, string2);
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage(), (Throwable)exception);
            throw new RemoteException(String.format("saveQueryToFile failed: %s", exception.getMessage()));
        }
    }

    @Override
    public boolean isApiEnabled() {
        return com.moonlit.logfaces.server.l.e.a().a(b.h);
    }

    @Override
    public Map getCustomLevels() {
        HashMap hashMap = Maps.newHashMap();
        for (LfsLevel lfsLevel : LfsLevel.getCustomLevels()) {
            hashMap.put(lfsLevel.intLevel(), lfsLevel.name());
        }
        return hashMap;
    }

    @Override
    public List listWorkspaces(String string) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        this.getSession(string);
        List list = l.a().b();
        this.log.info(String.format("%s - listing shared workspaces: %s", string, list));
        return list;
    }

    @Override
    public void uploadWorkspace(String string, String string2, boolean bl, InputStream inputStream) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        this.getSession(string);
        try {
            l.a().a(string2, inputStream, bl);
            this.log.info(String.format("%s - saved workspace: %s", string, string2));
        }
        catch (Exception exception) {
            this.log.error(exception.getMessage(), (Throwable)exception);
            throw new RemoteException(String.format("uploadWorkspace failed: %s", exception.getMessage()));
        }
    }

    @Override
    public InputStream downloadWorkspace(String string, String string2) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        this.getSession(string);
        try {
            this.log.info(String.format("%s - downloading workspace '%s'", string, string2));
            return l.a().a(string2);
        }
        catch (Exception exception) {
            this.log.error(exception.getMessage(), (Throwable)exception);
            throw new RemoteException(String.format("downloadWorkspace failed: %s", exception.getMessage()));
        }
    }

    @Override
    public InputStream getPatternLibrary(String string) {
        try {
            return new FileInputStream(com.moonlit.logfaces.server.conf.i.N());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RemoteException(fileNotFoundException.getMessage());
        }
    }

    @Override
    public void savePatternLibrary(String string, InputStream inputStream) {
        ThreadContext.put((String)"sid", (String)(string != null ? string : "?"));
        this.getSession(string);
        this.log.info(String.format("%s - saving pattern library", string));
        try {
            com.moonlit.logfaces.server.conf.b.a().a("patterns.properties");
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)new File(com.moonlit.logfaces.server.conf.i.N()));
            y.a().d();
            s.a().post((Object)com.moonlit.logfaces.server.core.l.j);
        }
        catch (Exception exception) {
            throw new RemoteException(exception.getMessage());
        }
    }

    @Override
    public Map getParsers(String string) {
        TreeMap treeMap = Maps.newTreeMap();
        for (com.moonlit.logfaces.server.core.u u2 : j.i().f()) {
            if (!u2.d().c()) continue;
            n n2 = u2.c();
            HashMap hashMap = Maps.newHashMap();
            hashMap.put("pattern", n2.getString("pattern"));
            hashMap.put("xpattern", n2.getString("xpattern"));
            hashMap.put("dtf", n2.getString("dtf"));
            treeMap.put(n2.getString("description"), hashMap);
        }
        return treeMap;
    }

    @Override
    public InputStream downloadPlugins(String string, List list) {
        try {
            this.log.info(String.format("%s - downloading plugins", string));
            File file = com.moonlit.logfaces.server.d.d.a().a(list);
            return new FileInputStream(file);
        }
        catch (Exception exception) {
            throw new RemoteException(exception.getMessage());
        }
    }

    @Override
    public List listPlugins(String string) {
        try {
            this.log.info(String.format("%s - listing plugins", string));
            ArrayList arrayList = Lists.newArrayList();
            List list = com.moonlit.logfaces.server.d.d.a().d();
            for (com.moonlit.logfaces.server.d.a a2 : list) {
                arrayList.add(a2.getName());
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new RemoteException(exception.getMessage());
        }
    }

    @Override
    public List listAlerts(String string, long l2, long l3) {
        h h2 = this.getSession(string);
        return h2.a(l2, l3);
    }

    @Override
    public void ackAlerts(String string, List list) {
        this.getSession(string);
        this.log.info("{} - ack alerts {}", (Object)string, (Object)list);
        com.moonlit.logfaces.server.e.a.a().a(list);
    }

    @Override
    public List listPins(String string) {
        this.getSession(string);
        this.log.info("{} - list pins", (Object)string);
        try {
            return i.a().b();
        }
        catch (Exception exception) {
            throw new RemoteException(exception.getMessage());
        }
    }

    @Override
    public void addPin(String string, String string2, String string3) {
        this.getSession(string).a(string2, string3);
    }

    @Override
    public void removePin(String string, String string2) {
        this.getSession(string).k(string2);
    }
}

