/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.log4j;

import com.moonlit.logfaces.server.log4j.a;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Level;

public class LfsLevel
implements Serializable,
Comparable {
    private static final long serialVersionUID = 1581082L;
    public static final LfsLevel OFF;
    public static final LfsLevel FATAL;
    public static final LfsLevel ERROR;
    public static final LfsLevel WARN;
    public static final LfsLevel INFO;
    public static final LfsLevel DEBUG;
    public static final LfsLevel TRACE;
    public static final LfsLevel ALL;
    public static final int OFF_INT = Integer.MIN_VALUE;
    public static final int FATAL_INT = 50000;
    public static final int ERROR_INT = 40000;
    public static final int WARN_INT = 30000;
    public static final int INFO_INT = 20000;
    public static final int DEBUG_INT = 10000;
    public static final int TRACE_INT = 5000;
    public static final int ALL_INT = Integer.MIN_VALUE;
    private static final ConcurrentMap LEVELS;
    private final String name;
    private final int intLevel;

    private LfsLevel(String string, int n2) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Illegal null or empty Level name.");
        }
        this.name = string;
        this.intLevel = n2;
        if (LEVELS.putIfAbsent(string, this) != null) {
            throw new IllegalStateException("Level " + string + " has already been defined.");
        }
    }

    public int compareTo(LfsLevel lfsLevel) {
        return this.intLevel < lfsLevel.intLevel ? -1 : (this.intLevel > lfsLevel.intLevel ? 1 : 0);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public int intLevel() {
        return this.intLevel;
    }

    public String name() {
        return this.name;
    }

    public static LfsLevel forName(String string, int n2) {
        LfsLevel lfsLevel = (LfsLevel)LEVELS.get(string);
        if (lfsLevel != null) {
            return lfsLevel;
        }
        try {
            return new LfsLevel(string, n2);
        }
        catch (IllegalStateException illegalStateException) {
            return (LfsLevel)LEVELS.get(string);
        }
    }

    public static LfsLevel getLevel(String string) {
        return (LfsLevel)LEVELS.get(string);
    }

    public static LfsLevel toLevel(int n2) {
        for (LfsLevel lfsLevel : LEVELS.values()) {
            if (lfsLevel.intLevel() != n2) continue;
            return lfsLevel;
        }
        return DEBUG;
    }

    public static LfsLevel toLevel(String string) {
        return LfsLevel.toLevel(string, DEBUG);
    }

    public static Level toLog4jLevel(String string) {
        return Level.toLevel((String)string);
    }

    public static Level toLog4jLevel(int n2) {
        return Level.toLevel((String)LfsLevel.toLevel(n2).name());
    }

    public static LfsLevel toLevel(String string, LfsLevel lfsLevel) {
        if (string == null) {
            return lfsLevel;
        }
        LfsLevel lfsLevel2 = (LfsLevel)LEVELS.get(LfsLevel.toUpperCase(string.trim()));
        return lfsLevel2 == null ? lfsLevel : lfsLevel2;
    }

    private static String toUpperCase(String string) {
        return string.toUpperCase(Locale.ENGLISH);
    }

    public static List toList() {
        ArrayList arrayList = new ArrayList(LEVELS.values());
        Collections.sort(arrayList, new a());
        return arrayList;
    }

    public static LfsLevel valueOf(String string) {
        String string2 = LfsLevel.toUpperCase(string.trim());
        LfsLevel lfsLevel = (LfsLevel)LEVELS.get(string2);
        if (lfsLevel != null) {
            return lfsLevel;
        }
        throw new IllegalArgumentException("Unknown level constant [" + string2 + "].");
    }

    public static boolean removeLevel(int n2) {
        if (!LfsLevel.isCustomLevel(n2)) {
            return false;
        }
        for (LfsLevel lfsLevel : LEVELS.values()) {
            if (lfsLevel.intLevel != n2) continue;
            return LEVELS.remove(lfsLevel.name) != null;
        }
        return false;
    }

    public boolean isCustom() {
        return LfsLevel.isCustomLevel(this.intLevel);
    }

    public static boolean isCustomLevel(int n2) {
        if (LfsLevel.OFF.intLevel == n2) {
            return false;
        }
        if (LfsLevel.FATAL.intLevel == n2) {
            return false;
        }
        if (LfsLevel.ERROR.intLevel == n2) {
            return false;
        }
        if (LfsLevel.WARN.intLevel == n2) {
            return false;
        }
        if (LfsLevel.INFO.intLevel == n2) {
            return false;
        }
        if (LfsLevel.DEBUG.intLevel == n2) {
            return false;
        }
        if (LfsLevel.TRACE.intLevel == n2) {
            return false;
        }
        return LfsLevel.ALL.intLevel != n2;
    }

    public static List getCustomLevels() {
        ArrayList<LfsLevel> arrayList = new ArrayList<LfsLevel>();
        if (LEVELS.size() == 8) {
            return arrayList;
        }
        for (LfsLevel lfsLevel : LEVELS.values()) {
            int n2 = lfsLevel.intLevel;
            if (LfsLevel.OFF.intLevel == n2 || LfsLevel.FATAL.intLevel == n2 || LfsLevel.ERROR.intLevel == n2 || LfsLevel.WARN.intLevel == n2 || LfsLevel.INFO.intLevel == n2 || LfsLevel.DEBUG.intLevel == n2 || LfsLevel.TRACE.intLevel == n2 || LfsLevel.ALL.intLevel == n2) continue;
            arrayList.add(lfsLevel);
        }
        return arrayList;
    }

    public static void addCustomLevels(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            LfsLevel.forName((String)map.get(n2), n2);
        }
    }

    static {
        LEVELS = new ConcurrentHashMap();
        OFF = new LfsLevel("OFF", Integer.MAX_VALUE);
        FATAL = new LfsLevel("FATAL", 50000);
        ERROR = new LfsLevel("ERROR", 40000);
        WARN = new LfsLevel("WARN", 30000);
        INFO = new LfsLevel("INFO", 20000);
        DEBUG = new LfsLevel("DEBUG", 10000);
        TRACE = new LfsLevel("TRACE", 5000);
        ALL = new LfsLevel("ALL", Integer.MIN_VALUE);
    }
}

