/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.jobs;

import com.moonlit.logfaces.server.core.t;
import com.moonlit.logfaces.server.e;
import com.moonlit.logfaces.server.receivers.r;
import com.moonlit.logfaces.server.util.C;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.Scheduler;
import org.quartz.SchedulerContext;
import org.quartz.Trigger;

public class OverflowMonitorJob
implements Job {
    private static final Logger log = LogManager.getLogger((String)OverflowMonitorJob.class.getName());

    public void execute(JobExecutionContext jobExecutionContext) {
        this.checkAndPurge(jobExecutionContext, com.moonlit.logfaces.server.database.r.a().l(), 1);
        this.checkAndPurge(jobExecutionContext, r.o().j(), 2);
    }

    private void checkAndPurge(JobExecutionContext jobExecutionContext, t t2, int n2) {
        if (t2 == null || !t2.e()) {
            return;
        }
        try {
            SchedulerContext schedulerContext = jobExecutionContext.getScheduler().getContext();
            long l2 = schedulerContext.getLong("overflowSize" + n2);
            long l3 = t2.h();
            long l4 = schedulerContext.getLong("incrementTime" + n2);
            if (l3 > l2) {
                log.info(String.format("%s overflow allocation changed from %s to %s on local disk", n2 == 1 ? "database" : "router", C.c(l2), C.c(l3)));
                schedulerContext.put("incrementTime" + n2, System.currentTimeMillis());
            } else if (this.isTimeToPurge(l4) && t2.g() == 0L) {
                t2.k();
                schedulerContext.put("incrementTime" + n2, 0L);
                log.info(String.format("%s overflow disk space returned to OS (purged)", n2 == 1 ? "database" : "router"));
            }
            schedulerContext.put("overflowSize" + n2, t2.h());
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
        }
    }

    private boolean isTimeToPurge(long l2) {
        if (l2 <= 0L) {
            return false;
        }
        long l3 = 60000L * (long)Integer.parseInt(System.getProperty("com.moonlit.logfaces.monitoring.overflowIdleTimeout", "5"));
        return System.currentTimeMillis() - l2 > l3;
    }

    public static void start() {
        try {
            Scheduler scheduler = e.a().g();
            SchedulerContext schedulerContext = scheduler.getContext();
            JobDetail jobDetail = scheduler.getJobDetail("OverflowMonitor", "lfs");
            if (jobDetail != null) {
                return;
            }
            t t2 = com.moonlit.logfaces.server.database.r.a().l();
            if (t2 != null) {
                schedulerContext.put("overflowSize1", t2.h());
            }
            if ((t2 = r.o().j()) != null) {
                schedulerContext.put("overflowSize2", t2.h());
            }
            schedulerContext.put("incrementTime1", System.currentTimeMillis());
            schedulerContext.put("incrementTime2", System.currentTimeMillis());
            jobDetail = new JobDetail("OverflowMonitor", "lfs", OverflowMonitorJob.class);
            jobDetail.setVolatility(true);
            CronTrigger cronTrigger = new CronTrigger();
            cronTrigger.setGroup("lfs");
            cronTrigger.setName("OverflowMonitor");
            cronTrigger.setCronExpression("0 0/1 * * * ?");
            scheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
            cronTrigger.getNextFireTime();
        }
        catch (Exception exception) {
            log.fatal(exception.getMessage(), (Throwable)exception);
        }
    }
}

