/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.jobs;

import com.moonlit.logfaces.server.util.C;
import com.moonlit.logfaces.server.util.l;
import com.moonlit.logfaces.server.util.m;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MemoryMonitor {
    private static MemoryMonitor instance;
    private Logger log = LogManager.getLogger(this.getClass());
    float lowMemoryThreshold = 98.0f;
    int lowMemoryCount = 3;
    int currentLowMemoryCount = 0;
    int highThreadCount = 200;

    private MemoryMonitor() {
        try {
            this.lowMemoryCount = Integer.parseInt(System.getProperty("com.moonlit.logfaces.monitoring.lowMemoryCount", "3"));
            this.lowMemoryThreshold = 100.0f - Float.parseFloat(System.getProperty("com.moonlit.logfaces.monitoring.lowMemoryThreshold", "2"));
            this.highThreadCount = Integer.parseInt(System.getProperty("com.moonlit.logfaces.monitoring.highThreadCount", "200"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static MemoryMonitor getInstance() {
        if (instance == null) {
            instance = new MemoryMonitor();
        }
        return instance;
    }

    public void check() {
        Runtime runtime = Runtime.getRuntime();
        long l2 = runtime.maxMemory();
        long l3 = runtime.totalMemory() - runtime.freeMemory();
        if ((float)(l3 * 100L) / (float)l2 > this.lowMemoryThreshold) {
            if (++this.currentLowMemoryCount >= this.lowMemoryCount) {
                this.currentLowMemoryCount = 0;
                this.log.warn(String.format("low memory detected %d times in a row; used: %s, max: %s", this.lowMemoryCount, C.c(l3), C.c(l2)));
                m.a().a(l.b);
            }
        } else {
            this.currentLowMemoryCount = 0;
        }
        if (Thread.getAllStackTraces().keySet().size() > this.highThreadCount) {
            m.a().a(l.e);
        }
    }
}

