/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.jobs;

import com.moonlit.logfaces.server.conf.d;
import com.moonlit.logfaces.server.core.LfsEvent;
import com.moonlit.logfaces.server.database.r;
import com.moonlit.logfaces.server.e;
import com.moonlit.logfaces.server.util.s;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.Scheduler;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class DatabaseRecoveryJob
implements Job {
    private static final Logger log = LogManager.getLogger((String)DatabaseRecoveryJob.class.getName());

    public static void start() {
        try {
            Scheduler scheduler = e.a().g();
            JobDetail jobDetail = scheduler.getJobDetail("DatabaseRecovery", "lfs");
            if (jobDetail != null) {
                log.info("recovery job already scheduled and running");
                return;
            }
            jobDetail = new JobDetail("DatabaseRecovery", "lfs", DatabaseRecoveryJob.class);
            jobDetail.getJobDataMap().put("attempt", 1);
            SimpleTrigger simpleTrigger = new SimpleTrigger("DatabaseRecovery", "lfs", new Date(System.currentTimeMillis() + 2000L));
            scheduler.scheduleJob(jobDetail, (Trigger)simpleTrigger);
            log.info("database recovery job scheduled");
        }
        catch (Exception exception) {
            log.fatal(exception.getMessage(), (Throwable)exception);
        }
    }

    public void execute(JobExecutionContext jobExecutionContext) {
        int n2 = jobExecutionContext.getJobDetail().getJobDataMap().getInt("attempt");
        try {
            log.info(String.format("database recovery attempt #%d", n2));
            r.a().g().d();
            e.a().g().unscheduleJob("DatabaseRecovery", "lfs");
            s.a().post(LfsEvent.databaseRecoveryOK());
        }
        catch (Throwable throwable) {
            log.error(String.format("database recovery attempt #%d failed", n2), throwable);
            this.retry(n2 + 1);
            return;
        }
    }

    private void retry(int n2) {
        try {
            Scheduler scheduler = e.a().g();
            scheduler.unscheduleJob("DatabaseRecovery", "lfs");
            int n3 = d.a().v();
            if (n3 > 0 && n2 > n3) {
                log.warn("database recovery attempts exhausted");
                s.a().post(LfsEvent.databaseRecoveryFailed());
                return;
            }
            Date date = new Date(System.currentTimeMillis() + d.a().u());
            JobDetail jobDetail = new JobDetail("DatabaseRecovery", "lfs", DatabaseRecoveryJob.class);
            jobDetail.getJobDataMap().put("attempt", n2);
            SimpleTrigger simpleTrigger = new SimpleTrigger("DatabaseRecovery", "lfs", date);
            scheduler.scheduleJob(jobDetail, (Trigger)simpleTrigger);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
        }
    }
}

