/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.database;

import com.google.api.gax.core.CredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableResult;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.bigquery.testing.RemoteBigQueryHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import com.moonlit.logfaces.server.conf.d;
import com.moonlit.logfaces.server.conf.i;
import com.moonlit.logfaces.server.conf.k;
import com.moonlit.logfaces.server.core.D;
import com.moonlit.logfaces.server.core.LfsEvent;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.database.f;
import com.moonlit.logfaces.server.database.j;
import com.moonlit.logfaces.server.database.q;
import com.moonlit.logfaces.server.database.r;
import com.moonlit.logfaces.server.database.u;
import com.moonlit.logfaces.server.database.y;
import com.moonlit.logfaces.server.util.a;
import com.moonlit.logfaces.server.util.l;
import com.moonlit.logfaces.server.util.m;
import com.moonlit.logfaces.server.util.s;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.prefs.Preferences;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class e
implements CredentialsProvider,
u {
    private boolean a;
    private long b;
    private String c;
    private Logger d = LogManager.getLogger(this.getClass());
    private com.moonlit.logfaces.server.conf.a e;
    private BigQuery f;

    @Override
    public void a() {
        if (this.a) {
            return;
        }
        this.a((String)null);
        s.a().register(this);
        this.e = new com.moonlit.logfaces.server.conf.a();
        if (!this.e.j()) {
            this.a("BigQuery client is not configured");
            throw new IllegalStateException(this.v());
        }
        try {
            this.f = (BigQuery)((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setProjectId(this.e.b())).setCredentials((Credentials)ServiceAccountCredentials.fromStream((InputStream)this.e.e()))).build().getService();
        }
        catch (Throwable throwable) {
            this.d.info("falling back to Application Default Credentials (ADC)");
            this.f = (BigQuery)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setProjectId(this.e.b())).build().getService();
        }
        if (this.getCredentials() == null) {
            this.a("No BigQuery credentials found, place your credentials in /conf/bq.credentials.json or use Application Default Credentials (ADC), see Google documentation for more details.");
            throw new IllegalStateException(this.v());
        }
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        this.b = preferences.getLong("count", 0L);
        this.d.info("initializing BigQuery client");
        this.B();
        this.w();
        this.x();
        this.C();
        this.a = true;
        this.d.info(String.format("connected to the following database:%n%s%n", this.u()));
    }

    public Credentials getCredentials() {
        return this.f != null ? ((BigQueryOptions)this.f.getOptions()).getCredentials() : null;
    }

    @Subscribe
    public void a(LfsEvent lfsEvent) {
        if (lfsEvent.is(com.moonlit.logfaces.server.core.l.g)) {
            this.d.info("processing database options change event");
            if (!this.f()) {
                this.a();
                return;
            }
            try {
                this.C();
            }
            catch (Exception exception) {
                this.d.error(exception.getMessage(), (Throwable)exception);
                m.a().a(exception);
                this.a(false);
            }
            return;
        }
    }

    public BigQuery b() {
        return this.f;
    }

    @Override
    public void c() {
        throw new IllegalAccessException("not supported operation");
    }

    @Override
    public void a(boolean bl) {
        this.a = false;
        s.a().unregister(this);
        this.d.info("biqquery client terminated");
    }

    @Override
    public void d() {
        this.a(false);
        this.a();
    }

    @Override
    public boolean e() {
        return false;
    }

    @Override
    public boolean f() {
        return this.a;
    }

    @Override
    public void g() {
        this.h();
    }

    @Override
    public void h() {
        this.d.info("recreating schema...");
        RemoteBigQueryHelper.forceDelete((BigQuery)this.f, (String)this.e.c());
        this.d.info("forceDelete of {} is done", (Object)this.e.c());
        r.a().e();
    }

    public void i() {
        TableId tableId = TableId.of((String)this.e.c(), (String)"lfs_repo");
        if (this.f.getTable(tableId, new BigQuery.TableOption[0]) != null) {
            boolean bl = this.f.delete(tableId);
            this.d.info(String.format("table %s is %s", tableId, bl ? "deleted" : "not deleted"));
            this.w();
        }
    }

    @Override
    public void a(List list) {
        LogEvent logEvent2;
        TableId tableId = TableId.of((String)this.e.c(), (String)"lfs_log");
        InsertAllRequest.Builder builder = InsertAllRequest.newBuilder((TableId)tableId);
        a a2 = new a();
        for (LogEvent logEvent2 : list) {
            builder.addRow(a2.b(logEvent2));
        }
        InsertAllRequest insertAllRequest = builder.build();
        logEvent2 = this.f.insertAll(insertAllRequest);
        if (logEvent2.hasErrors()) {
            this.d.error("done inserting, there are errors");
        } else {
            this.d.info("done inserting");
        }
    }

    @Override
    public int a(List list, boolean bl) {
        return 0;
    }

    @Override
    public void a(Collection collection) {
    }

    @Override
    public long b(boolean bl) {
        if (!bl) {
            return this.b;
        }
        String string = String.format("SELECT COUNT(*) FROM %s.%s", this.e.c(), "lfs_log");
        TableResult tableResult = this.f.query(QueryJobConfiguration.newBuilder((String)string).setUseLegacySql(Boolean.valueOf(false)).build(), new BigQuery.JobOption[0]);
        this.b = ((FieldValueList)tableResult.getValues().iterator().next()).get(0).getLongValue();
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        preferences.putLong("count", this.b);
        this.d.info("count = " + this.b);
        return this.b;
    }

    @Override
    public void j() {
    }

    @Override
    public void k() {
        File file = new File(i.C());
        List list = q.a(file);
        for (String string : list) {
            try {
                this.d.info(String.format("executing maintenance statement: %s", string));
                QueryJobConfiguration queryJobConfiguration = QueryJobConfiguration.newBuilder((String)string).setUseLegacySql(Boolean.valueOf(false)).build();
                JobId jobId = JobId.of((String)UUID.randomUUID().toString());
                Job job = this.f.create(JobInfo.newBuilder((JobConfiguration)queryJobConfiguration).setJobId(jobId).build(), new BigQuery.JobOption[0]);
                job = job.waitFor(new RetryOption[0]);
                if (job == null) {
                    this.d.error("bigquery job no longer exists");
                    continue;
                }
                if (job.getStatus().getError() != null) {
                    this.d.error(String.format("query job failed: %s", job.getStatus().getError().toString()));
                    continue;
                }
                this.d.info("maintenance statement done");
            }
            catch (Throwable throwable) {
                m.a().a(l.y);
            }
        }
    }

    @Override
    public long c(boolean bl) {
        return 0L;
    }

    @Override
    public boolean l() {
        return true;
    }

    @Override
    public boolean m() {
        return true;
    }

    @Override
    public boolean n() {
        return true;
    }

    @Override
    public boolean o() {
        return false;
    }

    @Override
    public void d(boolean bl) {
    }

    @Override
    public boolean p() {
        return true;
    }

    @Override
    public boolean q() {
        return false;
    }

    @Override
    public boolean r() {
        return true;
    }

    @Override
    public y s() {
        return y.j;
    }

    @Override
    public Map t() {
        TreeMap treeMap = Maps.newTreeMap();
        if (this.a) {
            treeMap.put("Database type", "Google Cloud BigQuery");
            treeMap.put("Dataset", String.format("%s:%s", this.e.b(), this.e.c()));
            treeMap.put("Location", this.e.d());
            treeMap.put("Write API", this.e.g() ? "gRPC" : "HTTP");
        }
        return treeMap;
    }

    public String u() {
        StringBuffer stringBuffer = new StringBuffer();
        Map map = this.t();
        for (String string : this.t().keySet()) {
            stringBuffer.append(String.format("%n%1$-25s : %2$s", string, map.get(string)));
        }
        stringBuffer.append(System.getProperty("line.separator"));
        return stringBuffer.toString();
    }

    @Override
    public String v() {
        return this.c;
    }

    @Override
    public void a(String string) {
        if (string != null) {
            this.d.warn(string);
        }
        this.c = string;
    }

    @Override
    public void a(File file, boolean bl) {
    }

    private void B() {
        Dataset dataset = this.f.getDataset(this.e.c(), new BigQuery.DatasetOption[0]);
        if (dataset != null) {
            this.e.c(dataset.getLocation());
            return;
        }
        DatasetInfo.Builder builder = DatasetInfo.newBuilder((String)this.e.c());
        builder.setLocation(this.e.d());
        dataset = this.f.create(builder.build(), new BigQuery.DatasetOption[0]);
        this.e.c(dataset.getLocation());
    }

    public void w() {
        TableId tableId = TableId.of((String)this.e.c(), (String)"lfs_repo");
        if (this.f.getTable(tableId, new BigQuery.TableOption[0]) != null) {
            this.d.info(String.format("using existing %s table", "lfs_repo"));
            return;
        }
        this.d.info(String.format("creating %s table", "lfs_repo"));
        Schema schema = Schema.of((Field[])new Field[]{Field.of((String)EventAttribute.domainName.toMongoColumn(), (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]), Field.of((String)EventAttribute.hostName.toMongoColumn(), (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]), Field.of((String)EventAttribute.loggerName.toMongoColumn(), (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0])});
        StandardTableDefinition standardTableDefinition = StandardTableDefinition.of((Schema)schema);
        this.f.create(TableInfo.of((TableId)tableId, (TableDefinition)standardTableDefinition), new BigQuery.TableOption[0]);
        this.d.info(String.format("table %s is created", tableId));
    }

    public void x() {
        TableId tableId = TableId.of((String)this.e.c(), (String)"lfs_log");
        if (this.f.getTable(tableId, new BigQuery.TableOption[0]) != null) {
            this.d.info(String.format("using existing %s table", "lfs_log"));
            return;
        }
        this.d.info(String.format("creating %s table", "lfs_log"));
        D d2 = com.moonlit.logfaces.server.conf.d.a().i();
        if (!d2.d() || d2.c()) {
            d2 = D.k;
        }
        TimePartitioning timePartitioning = TimePartitioning.newBuilder((TimePartitioning.Type)TimePartitioning.Type.DAY).setField(EventAttribute.loggerTimeStamp.toMongoColumn()).setExpirationMs(Long.valueOf(86400000L * (long)d2.b())).build();
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(Field.of((String)"_id", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]));
        arrayList.add(Field.of((String)EventAttribute.loggerTimeStamp.toMongoColumn(), (LegacySQLTypeName)LegacySQLTypeName.TIMESTAMP, (Field[])new Field[0]));
        arrayList.add(Field.of((String)EventAttribute.sequenceNumber.toMongoColumn(), (LegacySQLTypeName)LegacySQLTypeName.NUMERIC, (Field[])new Field[0]));
        arrayList.add(Field.of((String)EventAttribute.domainName.toMongoColumn(), (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]));
        arrayList.add(Field.of((String)EventAttribute.hostName.toMongoColumn(), (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]));
        arrayList.add(Field.of((String)EventAttribute.loggerName.toMongoColumn(), (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]));
        arrayList.add(Field.of((String)EventAttribute.loggerLevel.toMongoColumn(), (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0]));
        arrayList.add(Field.of((String)EventAttribute.threadName.toMongoColumn(), (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]));
        arrayList.add(Field.of((String)EventAttribute.throwableInfo.toMongoColumn(), (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]));
        arrayList.add(Field.of((String)EventAttribute.thrown.toMongoColumn(), (LegacySQLTypeName)LegacySQLTypeName.BOOLEAN, (Field[])new Field[0]));
        arrayList.add(Field.of((String)EventAttribute.locLineNumber.toMongoColumn(), (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0]));
        arrayList.add(Field.of((String)EventAttribute.locClassName.toMongoColumn(), (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]));
        arrayList.add(Field.of((String)EventAttribute.locFileName.toMongoColumn(), (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]));
        arrayList.add(Field.of((String)EventAttribute.locMethodName.toMongoColumn(), (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]));
        arrayList.add(Field.of((String)EventAttribute.ndc.toMongoColumn(), (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]));
        int n2 = Math.max(10, k.e().size());
        String string = EventAttribute.mdc.toMongoColumn();
        for (int i2 = 1; i2 <= n2; ++i2) {
            arrayList.add(Field.of((String)(string + i2), (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]));
        }
        arrayList.add(Field.of((String)EventAttribute.message.toMongoColumn(), (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]));
        StandardTableDefinition standardTableDefinition = StandardTableDefinition.newBuilder().setSchema(Schema.of((Iterable)arrayList)).setTimePartitioning(timePartitioning).build();
        this.f.create(TableInfo.of((TableId)tableId, (TableDefinition)standardTableDefinition), new BigQuery.TableOption[0]);
        this.d.info(String.format("partitioned table %s is created", tableId));
    }

    public List y() {
        ArrayList arrayList = Lists.newArrayList();
        Table table = this.f.getTable(TableId.of((String)this.e.c(), (String)"lfs_log"), new BigQuery.TableOption[0]);
        if (table == null) {
            return arrayList;
        }
        int n2 = k.e().size();
        FieldList fieldList = table.getDefinition().getSchema().getFields();
        String string = EventAttribute.mdc.toMongoColumn();
        for (int i2 = 1; i2 <= n2; ++i2) {
            try {
                if (fieldList.get(string + i2) != null) continue;
                arrayList.add(string + i2);
                continue;
            }
            catch (Exception exception) {
                arrayList.add(string + i2);
            }
        }
        return arrayList;
    }

    private void C() {
        long l2;
        TableId tableId = TableId.of((String)this.e.c(), (String)"lfs_log");
        StandardTableDefinition standardTableDefinition = (StandardTableDefinition)this.f.getTable(tableId, new BigQuery.TableOption[0]).getDefinition();
        D d2 = com.moonlit.logfaces.server.conf.d.a().i();
        d2 = d2.d() ? d2 : D.o;
        long l3 = d2.b();
        if (l3 != (l2 = standardTableDefinition.getTimePartitioning().getExpirationMs() / 86400000L)) {
            this.d.info(String.format("altering retention to %d days", l3));
            TimePartitioning timePartitioning = standardTableDefinition.getTimePartitioning().toBuilder().setExpirationMs(Long.valueOf(l3 * 86400000L)).build();
            StandardTableDefinition standardTableDefinition2 = standardTableDefinition.toBuilder().setTimePartitioning(timePartitioning).build();
            this.f.update(TableInfo.of((TableId)tableId, (TableDefinition)standardTableDefinition2), new BigQuery.TableOption[0]);
            this.d.info(String.format("successfully altered retention to %d days", l3));
        }
    }

    public com.moonlit.logfaces.server.core.s z() {
        return this.e.g() ? new j() : new f();
    }

    public com.moonlit.logfaces.server.conf.a A() {
        return this.e;
    }
}

