/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.database;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoTimeoutException;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Projections;
import com.mongodb.client.result.DeleteResult;
import com.moonlit.logfaces.server.conf.i;
import com.moonlit.logfaces.server.conf.j;
import com.moonlit.logfaces.server.conf.l;
import com.moonlit.logfaces.server.core.D;
import com.moonlit.logfaces.server.core.LfsEvent;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.core.d;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.database.G;
import com.moonlit.logfaces.server.database.H;
import com.moonlit.logfaces.server.database.J;
import com.moonlit.logfaces.server.database.r;
import com.moonlit.logfaces.server.database.u;
import com.moonlit.logfaces.server.database.y;
import com.moonlit.logfaces.server.util.C;
import com.moonlit.logfaces.server.util.a;
import com.moonlit.logfaces.server.util.s;
import com.moonlit.logfaces.server.vo.RepositoryEntryVO;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.joda.time.Interval;
import org.joda.time.LocalDate;

public class E
implements u {
    private Logger a = LogManager.getLogger(this.getClass());
    private Map b;
    private boolean c;
    private MongoClient d;
    private l e;
    private H f;
    private String g = EventAttribute.loggerTimeStamp.toMongoColumn();
    private long h = 0x100000L;
    private String i;
    private long j;
    private long k;

    @Override
    public void a() {
        if (this.c) {
            return;
        }
        this.a((String)null);
        this.e = new l(com.moonlit.logfaces.server.conf.i.J());
        this.a.info("setting up mongo client to " + this.e);
        this.d = MongoClients.create((MongoClientSettings)this.e.c());
        this.b = null;
        this.t();
        this.f = H.a(this.d, this.e);
        this.A();
        this.c = true;
        this.a.info(String.format("connected to the following database:%n%s%n", this.w()));
    }

    public void a(l l2) {
        this.a.info("applying new mongodb settings");
        com.moonlit.logfaces.server.conf.d d2 = com.moonlit.logfaces.server.conf.d.a();
        D d3 = d2.i();
        l l3 = this.e.a();
        if (!this.e.d().equals(l2.d())) {
            for (String string : this.d.listDatabaseNames()) {
                if (!string.equals(l2.d())) continue;
                throw new Exception(String.format("database '%s' already exists in this mongo instance%nplease verify and drop it manually before use", string));
            }
        }
        if (!l2.v() && l3.v()) {
            d2.a(D.r);
        }
        if (l2.v() && !l3.v()) {
            d2.a(D.f);
        }
        try {
            this.a(false);
            l2.b();
            this.a();
            d2.f();
            if (!l3.w() && this.e.w()) {
                this.h();
            }
            s.a().post(LfsEvent.dbHandlerRestarted());
        }
        catch (Throwable throwable) {
            this.a.error(throwable.getMessage(), throwable);
            l3.b();
            d2.a(d3);
            this.a();
            throw new Exception(throwable.getMessage());
        }
    }

    private void A() {
        d d2 = this.e.y();
        if (!d2.d()) {
            this.C();
        }
        try {
            MongoCollection mongoCollection = this.b().withWriteConcern(WriteConcern.ACKNOWLEDGED);
            this.a(mongoCollection, !d2.a());
            mongoCollection = this.u().withWriteConcern(WriteConcern.ACKNOWLEDGED);
            this.a(mongoCollection, true);
        }
        catch (Exception exception) {
            this.a.error(String.format("database is not writeable: %s", exception.getMessage()));
            throw exception;
        }
    }

    private Set B() {
        HashSet hashSet = Sets.newHashSet();
        for (Document document : this.b().listIndexes()) {
            Document document2 = (Document)document.get((Object)"key", Document.class);
            if (document2.containsKey((Object)"_id")) continue;
            hashSet.addAll(document2.keySet());
        }
        return hashSet;
    }

    private void a(MongoCollection mongoCollection, boolean bl) {
        BasicDBObject basicDBObject = new BasicDBObject("dummy", (Object)1);
        mongoCollection.insertOne((Object)basicDBObject);
        if (bl) {
            mongoCollection.deleteOne((Bson)basicDBObject);
        }
    }

    private void C() {
        MongoDatabase mongoDatabase = (MongoDatabase)this.f.i().get(0);
        MongoCollection mongoCollection = this.b();
        d d2 = this.E();
        d d3 = this.e.y();
        this.a.info(String.format("current is %s, required is %s", new Object[]{d2, d3}));
        if (!d2.a() && d3.a()) {
            if (d2.b()) {
                mongoCollection.dropIndex((Bson)new BasicDBObject(this.g, (Object)1));
                this.a.info(String.format("index dropped: %s", this.g));
            }
            this.a(mongoCollection, true);
            Document document = new Document("convertToCapped", (Object)"log").append("size", (Object)(this.e.s() * this.h));
            mongoDatabase.runCommand((Bson)document);
            this.a.info(String.format("converted to capped collection of %d MB", this.e.s()));
        } else {
            if (d2.a() && !d3.a()) {
                String string = "converting capped to non-capped collections is not allowed";
                this.e.a(true, (long)this.x() / this.h);
                this.e.b();
                this.a(string);
                throw new Exception(string);
            }
            if (d2.c() && d3.b()) {
                try {
                    mongoCollection.dropIndex((Bson)new Document(this.g, (Object)1));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.D();
            } else if (d2.b() && d3.b()) {
                if (this.e.u() * 86400000L / 1000L != this.F()) {
                    mongoCollection.dropIndex((Bson)new Document(this.g, (Object)1));
                    this.D();
                }
            } else if (d2.b() && d3.c()) {
                mongoCollection.dropIndex((Bson)new Document(this.g, (Object)1));
            }
        }
    }

    private void D() {
        MongoCollection mongoCollection = this.b();
        IndexOptions indexOptions = new IndexOptions().expireAfter(Long.valueOf(this.e.u()), TimeUnit.DAYS);
        mongoCollection.createIndex((Bson)new Document(this.g, (Object)1), indexOptions);
        this.a.info(String.format("TTL index created for %d days", this.e.u()));
    }

    private d E() {
        try {
            if (this.e.w()) {
                return com.moonlit.logfaces.server.core.d.d;
            }
            MongoDatabase mongoDatabase = (MongoDatabase)this.f.i().get(0);
            MongoCollection mongoCollection = this.b();
            Document document = new Document("collStats", (Object)"log");
            Document document2 = mongoDatabase.runCommand((Bson)document);
            if (document2.getBoolean((Object)"capped", false)) {
                return com.moonlit.logfaces.server.core.d.b;
            }
            for (Document document3 : mongoCollection.listIndexes()) {
                Document document4 = (Document)document3.get((Object)"key", Document.class);
                if (!document4.containsKey((Object)this.g) || document3.get((Object)"expireAfterSeconds") == null) continue;
                return com.moonlit.logfaces.server.core.d.c;
            }
        }
        catch (MongoTimeoutException mongoTimeoutException) {
            throw mongoTimeoutException;
        }
        catch (Exception exception) {
            this.a.warn(String.format("can't determine collection type: %s, using default", exception.getMessage()));
        }
        return com.moonlit.logfaces.server.core.d.a;
    }

    private long F() {
        for (Document document : this.b().listIndexes()) {
            Document document2 = (Document)document.get((Object)"key", Document.class);
            Object object = document.get((Object)"expireAfterSeconds");
            if (!document2.containsKey((Object)this.g) || object == null) continue;
            if (object instanceof Integer) {
                return ((Integer)object).intValue();
            }
            if (!(object instanceof Long)) continue;
            return (Long)object;
        }
        return 0L;
    }

    @Override
    public void c() {
        this.a();
    }

    @Override
    public void a(boolean bl) {
        if (!this.c) {
            return;
        }
        try {
            this.e.b();
        }
        catch (Exception exception) {
            this.a.error("failed saving properties", (Throwable)exception);
        }
        this.f.c();
        this.d.close();
        this.c = false;
    }

    @Override
    public void d() {
        this.a.info("restarting database handler");
        this.a(false);
        this.a();
        s.a().post(LfsEvent.dbHandlerRestarted());
    }

    public MongoCollection a(long l2) {
        G g2 = this.f.a(l2);
        return g2 != null ? g2.a("log") : null;
    }

    public MongoCollection b() {
        G g2 = this.f.l();
        return g2 != null ? g2.a("log") : null;
    }

    public List i() {
        ArrayList arrayList = Lists.newArrayList();
        for (MongoDatabase mongoDatabase : this.f.i()) {
            arrayList.add(mongoDatabase.getCollection("log", DBObject.class));
        }
        return arrayList;
    }

    public List a(Interval interval) {
        return this.f.a(interval);
    }

    public MongoCollection u() {
        return this.f.m();
    }

    @Override
    public boolean r() {
        return this.e != null ? this.e.w() : false;
    }

    @Override
    public boolean e() {
        return false;
    }

    @Override
    public boolean f() {
        return this.c;
    }

    @Override
    public void a(List list) {
        if (!this.c) {
            throw new Exception("mongodb handler is not initialized");
        }
        if (list == null || list.size() == 0) {
            return;
        }
        com.moonlit.logfaces.server.c.u u2 = r.a().k();
        a a2 = new a();
        J j2 = new J();
        for (LogEvent logEvent : list) {
            j2.a(logEvent.getLoggerTimeStamp(), a2.a(logEvent));
        }
        for (LogEvent logEvent : j2.b()) {
            MongoCollection mongoCollection = this.a(logEvent.toDate().getTime());
            if (mongoCollection == null) {
                this.a.warn(String.format("no partition to commit %s", logEvent));
                j2.b((LocalDate)logEvent);
                continue;
            }
            try {
                mongoCollection.insertMany(j2.a((LocalDate)logEvent));
            }
            catch (Exception exception) {
                this.a.warn(exception.getMessage(), (Throwable)exception);
            }
        }
        for (LogEvent logEvent : list) {
            u2.d(logEvent);
        }
    }

    @Override
    public int a(List list, boolean bl) {
        if (!this.c) {
            return 0;
        }
        int n2 = 0;
        MongoCollection mongoCollection = this.u();
        for (RepositoryEntryVO repositoryEntryVO : list) {
            DeleteResult deleteResult;
            Object object;
            ArrayList arrayList = Lists.newArrayList();
            if (!StringUtils.isBlank((CharSequence)repositoryEntryVO.getDomainName())) {
                arrayList.add(Filters.eq((String)EventAttribute.domainName.toMongoColumn(), (Object)repositoryEntryVO.getDomainName()));
            }
            if (!StringUtils.isBlank((CharSequence)repositoryEntryVO.getHostName())) {
                arrayList.add(Filters.eq((String)EventAttribute.hostName.toMongoColumn(), (Object)repositoryEntryVO.getHostName()));
            }
            if (!StringUtils.isBlank((CharSequence)repositoryEntryVO.getLoggerName())) {
                object = Pattern.compile("^" + repositoryEntryVO.getLoggerName() + ".*");
                arrayList.add(Filters.regex((String)EventAttribute.loggerName.toMongoColumn(), (Pattern)object));
            }
            object = Filters.and((Iterable)arrayList);
            if (bl) {
                deleteResult = this.i().iterator();
                while (deleteResult.hasNext()) {
                    MongoCollection mongoCollection2 = (MongoCollection)deleteResult.next();
                    DeleteResult deleteResult2 = mongoCollection2.deleteMany(object);
                    try {
                        n2 = (int)((long)n2 + (deleteResult2.wasAcknowledged() ? deleteResult2.getDeletedCount() : 0L));
                    }
                    catch (Exception exception) {}
                }
            }
            this.a.info("deleted {} repository records, {} log events", (deleteResult = mongoCollection.deleteMany(object)).wasAcknowledged() ? Long.valueOf(deleteResult.getDeletedCount()) : "?", (Object)n2);
        }
        r.a().k().d();
        return n2;
    }

    @Override
    public void a(Collection collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        this.a.info(String.format("applying hosts: %s", collection));
        this.a(collection, this.u());
        for (MongoCollection mongoCollection : this.i()) {
            this.a(collection, mongoCollection);
        }
        this.a.info("done applying hosts");
    }

    protected void a(Collection collection, MongoCollection mongoCollection) {
        if (collection.isEmpty()) {
            return;
        }
        j j2 = com.moonlit.logfaces.server.conf.j.a();
        String string = EventAttribute.hostName.toMongoColumn();
        Bson bson = Filters.in((String)EventAttribute.hostName.toMongoColumn(), (Iterable)collection);
        Bson bson2 = Projections.include((String[])new String[]{"_id", string});
        for (DBObject dBObject : mongoCollection.find(bson).projection(bson2)) {
            Document document = new Document("_id", dBObject.get("_id"));
            String string2 = dBObject.get(string).toString();
            String string3 = j2.b(string2);
            Document document2 = new Document("$set", (Object)new Document(string, (Object)string3));
            try {
                mongoCollection.updateMany((Bson)document, (Bson)document2);
            }
            catch (Exception exception) {
                this.a.error(exception.getMessage(), (Throwable)exception);
            }
        }
    }

    @Override
    public void h() {
        if (!this.c) {
            throw new Exception("mongodb handler is not initialized");
        }
        this.a.info("re-creating database");
        this.f.f();
        this.f.c();
        this.f = H.a(this.d, this.e);
        this.A();
        r.a().k().d();
        this.a.info("database recreated");
    }

    @Override
    public void g() {
        this.h();
    }

    @Override
    public long b(boolean bl) {
        if (!this.c) {
            return 0L;
        }
        if (!bl) {
            return this.j;
        }
        this.j = 0L;
        EstimatedDocumentCountOptions estimatedDocumentCountOptions = new EstimatedDocumentCountOptions();
        estimatedDocumentCountOptions.maxTime(1L, TimeUnit.MINUTES);
        for (MongoCollection mongoCollection : this.i()) {
            this.j += mongoCollection.estimatedDocumentCount(estimatedDocumentCountOptions);
        }
        this.a.info("count() = {} records", (Object)this.j);
        return this.j;
    }

    @Override
    public void j() {
        if (!this.c) {
            throw new Exception("mongodb handler is not initialized");
        }
        this.a.info("repairing database, current storage size: " + C.c(this.c(true)));
        for (MongoDatabase mongoDatabase : this.f.i()) {
            Document document = new Document("repairDatabase", (Object)1);
            mongoDatabase.runCommand((Bson)document);
            this.a.info("repairing done, current storage size: " + C.c(this.c(true)));
        }
    }

    @Override
    public void k() {
    }

    @Override
    public boolean l() {
        return true;
    }

    @Override
    public boolean m() {
        if (!this.c) {
            return false;
        }
        if (!this.e.z()) {
            return false;
        }
        return this.B().contains(this.g);
    }

    @Override
    public boolean n() {
        return this.e != null ? this.e.v() : false;
    }

    @Override
    public boolean p() {
        if (this.e == null) {
            return false;
        }
        return this.e.t();
    }

    @Override
    public boolean q() {
        return true;
    }

    @Override
    public y s() {
        return y.i;
    }

    protected String w() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.b.keySet()) {
            stringBuffer.append(String.format("%n%1$-25s : %2$s", string, this.b.get(string)));
        }
        stringBuffer.append(System.getProperty("line.separator"));
        return stringBuffer.toString();
    }

    @Override
    public Map t() {
        if (this.b != null && !this.b.isEmpty()) {
            return this.b;
        }
        this.b = Maps.newTreeMap();
        if (this.d == null) {
            return this.b;
        }
        List list = this.e.A();
        this.b.put("Database product", "MongoDB (" + (list == null ? "???" : StringUtils.join((Iterable)list, (String)", ")) + ")");
        this.b.put("MongoDB driver", this.z());
        this.b.put("MongoDB storage", this.y().y().toString());
        try {
            BasicDBObject basicDBObject = new BasicDBObject("buildinfo", (Object)1);
            Document document = this.d.getDatabase("test").runCommand((Bson)basicDBObject);
            this.b.put("Database version", document.getString((Object)"version"));
        }
        catch (Throwable throwable) {
            this.b.put("Database version", "unknown version");
        }
        return this.b;
    }

    @Override
    public long c(boolean bl) {
        if (!this.c) {
            return 0L;
        }
        if (!bl) {
            return this.k;
        }
        this.k = 0L;
        for (MongoDatabase mongoDatabase : this.f.i()) {
            try {
                Float f2;
                Document document = new Document("dbStats", (Object)1);
                Document document2 = mongoDatabase.runCommand((Bson)document);
                if (document2 != null && document2.containsKey((Object)"fileSize")) {
                    f2 = Float.valueOf(Float.parseFloat(document2.get((Object)"fileSize").toString()));
                    this.k += f2.longValue();
                    continue;
                }
                if (document2 == null || !document2.containsKey((Object)"storageSize") || !document2.containsKey((Object)"indexSize")) continue;
                f2 = Float.valueOf(Float.parseFloat(document2.get((Object)"storageSize").toString()));
                this.k += f2.longValue();
                f2 = Float.valueOf(Float.parseFloat(document2.get((Object)"indexSize").toString()));
                this.k += f2.longValue();
            }
            catch (Exception exception) {
                this.a.error(String.format("unable to determinate database disk size, error: %s", exception.getMessage()));
            }
        }
        return this.k;
    }

    @Override
    public String v() {
        return this.i;
    }

    @Override
    public void a(String string) {
        if (string != null) {
            this.a.warn(string);
        }
        this.i = string;
    }

    @Override
    public boolean o() {
        return true;
    }

    @Override
    public void d(boolean bl) {
    }

    @Override
    public void a(File file, boolean bl) {
        this.e.a(file, bl);
    }

    public int x() {
        Document document;
        MongoDatabase mongoDatabase = (MongoDatabase)this.f.i().get(0);
        Document document2 = mongoDatabase.runCommand((Bson)(document = new Document("collStats", (Object)"log")));
        if (document2.getBoolean((Object)"capped", false)) {
            return document2.getInteger((Object)"maxSize");
        }
        return document2.getInteger((Object)"storageSize");
    }

    public l y() {
        return this.e;
    }

    public String z() {
        String string = "unknown version";
        try {
            URL uRL = MongoClient.class.getProtectionDomain().getCodeSource().getLocation();
            string = new File(uRL.getFile()).getName();
            int n2 = string.lastIndexOf(".");
            if (n2 > 0) {
                string = string.substring(0, n2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }
}

