/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.criteria;

public enum Operation {
    none,
    is,
    isnot,
    contains,
    notcontains,
    regex,
    noregex,
    more,
    less,
    emore,
    eless;


    public String toString() {
        switch (this) {
            case is: {
                return "is";
            }
            case isnot: {
                return "is not";
            }
            case contains: {
                return "contains";
            }
            case notcontains: {
                return "contains not";
            }
            case regex: {
                return "matches regex";
            }
            case noregex: {
                return "no match regex";
            }
            case more: {
                return "higher";
            }
            case less: {
                return "lower";
            }
            case emore: {
                return "higher or equals";
            }
            case eless: {
                return "lower or equals";
            }
        }
        return "";
    }

    public String toExpression() {
        switch (this) {
            case is: {
                return "==";
            }
            case isnot: {
                return "!=";
            }
            case contains: {
                return this.toString();
            }
            case notcontains: {
                return this.toString();
            }
            case regex: {
                return "=~";
            }
            case noregex: {
                return "!~";
            }
            case more: {
                return ">";
            }
            case less: {
                return "<";
            }
            case emore: {
                return ">=";
            }
            case eless: {
                return "<=";
            }
        }
        return "";
    }

    public static Operation fromString(String string) {
        if (string == null || string.isEmpty()) {
            return none;
        }
        for (Operation operation : Operation.values()) {
            if (!string.equalsIgnoreCase(operation.name()) && !string.equalsIgnoreCase(operation.toString())) continue;
            return operation;
        }
        return none;
    }
}

