/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.criteria;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.criteria.Condition;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.CriteriaType;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.JexlRule;
import com.moonlit.logfaces.server.criteria.Operation;
import com.moonlit.logfaces.server.criteria.Rule;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.dom4j.Element;
import org.dom4j.Node;

public class JexlCriteria
implements CriteriaFilter,
Cloneable {
    private CriteriaType type;
    private List rules = new ArrayList();
    private transient Expression expression;
    private transient JexlContext context;
    private transient JexlEngine jexl;

    public JexlCriteria() {
        this(CriteriaType.OR);
    }

    public JexlCriteria(CriteriaType criteriaType) {
        this.type = criteriaType;
    }

    public JexlCriteria(Element element) {
        this();
        this.load(element);
    }

    public JexlCriteria(List list) {
        this();
        this.setRules(list);
    }

    public JexlCriteria(List list, CriteriaType criteriaType) {
        this(criteriaType);
        this.setRules(list);
    }

    public static CriteriaFilter makeAllInclusiveCriteria() {
        JexlCriteria jexlCriteria = new JexlCriteria();
        jexlCriteria.addRule().addCondition((Object)EventAttribute.loggerLevel, (Object)Operation.emore, LfsLevel.TRACE);
        return jexlCriteria;
    }

    @Override
    public void setType(CriteriaType criteriaType) {
        this.type = criteriaType;
    }

    @Override
    public CriteriaType getType() {
        return this.type;
    }

    @Override
    public List getRules() {
        return this.rules;
    }

    @Override
    public void setRules(List list) {
        this.rules = list;
    }

    @Override
    public void addRules(List list) {
        this.rules.addAll(list);
    }

    @Override
    public CriteriaFilter clone() {
        JexlCriteria jexlCriteria = new JexlCriteria();
        for (Rule rule : this.rules) {
            jexlCriteria.rules.add(rule.clone());
        }
        return jexlCriteria;
    }

    @Override
    public Collection getAttrNames() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Rule rule : this.rules) {
            for (Condition condition : rule.getConditions()) {
                treeSet.add(condition.getAttribute());
            }
        }
        return treeSet;
    }

    @Override
    public void isolate(List list) {
        for (Rule rule : Lists.newArrayList((Iterable)this.rules)) {
            for (Object object : Lists.newArrayList((Iterable)rule.getConditions())) {
                if (list.contains(object.getAttribute())) continue;
                rule.removeCondition((Condition)object);
            }
            if (!rule.getConditions().isEmpty()) continue;
            for (Object object : list) {
                rule.addCondition(object, (Object)Operation.isnot, "");
            }
        }
    }

    @Override
    public String resolve(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        String string2 = new String(string);
        ArrayList arrayList = Lists.newArrayList((Object[])new Operation[]{Operation.is, Operation.contains, Operation.regex});
        int n2 = 0;
        while ((n2 = string2.indexOf("${", n2)) != -1) {
            int n3 = string2.indexOf("}", n2);
            if (n3 == -1) {
                return string2;
            }
            String string3 = string2.substring(n2, n3 + 1);
            String string4 = string2.substring(n2 + 2, n3);
            for (Rule rule : this.rules) {
                for (Condition condition : rule.getConditions()) {
                    if (condition.getValue() == null || !condition.getAttribute().equals(string4) || !arrayList.contains((Object)condition.getOperation())) continue;
                    try {
                        string2 = StringUtils.replaceOnce((String)string2, (String)string3, (String)condition.getValue().toString());
                    }
                    catch (Exception exception) {}
                }
            }
            ++n2;
        }
        return string2;
    }

    @Override
    public synchronized void prepare() {
        this.jexl = new JexlEngine();
        this.jexl.setCache(512);
        this.jexl.setLenient(false);
        this.jexl.setSilent(false);
        this.context = new MapContext();
        String string = this.makeExpression();
        try {
            this.expression = this.jexl.createExpression(string);
        }
        catch (Exception exception) {
            LogManager.getLogger(this.getClass()).error(String.format("unable to compile criteria: %s", string), (Throwable)exception);
        }
    }

    private String makeExpression() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.rules.size(); ++i2) {
            Rule rule = (Rule)this.rules.get(i2);
            stringBuffer.append("(");
            List list = rule.getConditions();
            for (int i3 = 0; i3 < list.size(); ++i3) {
                Condition condition = (Condition)list.get(i3);
                if (!condition.isValid()) continue;
                Object object = this.convertValue(condition);
                String string = this.convertAttribute(condition);
                switch (condition.getOperation()) {
                    case contains: {
                        stringBuffer.append(String.format("( e.%s.contains(\"%s\") )", string, object));
                        break;
                    }
                    case notcontains: {
                        stringBuffer.append(String.format("( !e.%s.contains(\"%s\") )", string, object));
                        break;
                    }
                    default: {
                        stringBuffer.append(String.format("( e.%s %s \"%s\" )", string, condition.getOperation().toExpression(), object));
                    }
                }
                if (i3 + 1 >= list.size() || !((Condition)list.get(i3 + 1)).isValid()) continue;
                stringBuffer.append(this.type.inverse().toExpression());
            }
            stringBuffer.append(")");
            if (i2 + 1 >= this.rules.size()) continue;
            stringBuffer.append(this.type.toExpression());
        }
        return stringBuffer.toString();
    }

    private String convertAttribute(Condition condition) {
        EventAttribute eventAttribute = EventAttribute.fromString(condition.getAttribute());
        return eventAttribute.isMDC() ? String.format("properties.get('%s')", condition.getAttribute()) : condition.getAttribute();
    }

    private Object convertValue(Condition condition) {
        Object object = condition.getValue();
        if (object == null) {
            return "";
        }
        if (EventAttribute.loggerLevel.name().equals(condition.getAttribute())) {
            if (object instanceof Integer) {
                return object;
            }
            if (object instanceof LfsLevel) {
                return ((LfsLevel)object).intLevel();
            }
            if (object instanceof String) {
                try {
                    return LfsLevel.toLevel(Integer.parseInt(object.toString())).intLevel();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return LfsLevel.toLevel(object.toString()).intLevel();
        }
        return StringEscapeUtils.escapeJava((String)object.toString());
    }

    @Override
    public boolean qualify(Object object) {
        if (!(object instanceof LogEvent) && this.expression != null) {
            return false;
        }
        try {
            this.context.set("e", object);
            return (Boolean)this.expression.evaluate(this.context);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public Rule addRule() {
        JexlRule jexlRule = new JexlRule();
        this.rules.add(jexlRule);
        return jexlRule;
    }

    @Override
    public void removeRule(Rule rule) {
        this.rules.remove(rule);
    }

    @Override
    public void clear() {
        this.rules.clear();
        this.expression = null;
    }

    public String toString() {
        if (this.expression != null) {
            return this.expression.getExpression();
        }
        return this.makeExpression();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JexlCriteria)) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    @Override
    public boolean isEmpty() {
        return this.rules.isEmpty();
    }

    @Override
    public void save(Element element) {
        if (element == null) {
            return;
        }
        Element element2 = (Element)element.selectSingleNode("criteria");
        if (element2 != null) {
            element.remove(element2);
        }
        element2 = element.addElement("criteria");
        for (Rule rule : this.getRules()) {
            Element element3 = element2.addElement("rule");
            for (Condition condition : rule.getConditions()) {
                element3.addElement("condition").addAttribute("attr", condition.getAttribute().toString()).addAttribute("oper", condition.getOperation().toString()).addAttribute("value", condition.getValue().toString());
            }
        }
    }

    @Override
    public void load(Element element) {
        if (element == null) {
            return;
        }
        this.rules.clear();
        Element element2 = (Element)element.selectSingleNode("criteria");
        if (element2 == null) {
            return;
        }
        for (Node node : element2.selectNodes("rule")) {
            Rule rule = this.addRule();
            for (Node node2 : node.selectNodes("condition")) {
                Element element3 = (Element)node2;
                String string = element3.attributeValue("attr");
                EventAttribute eventAttribute = EventAttribute.fromString(string);
                Operation operation = Operation.fromString(element3.attributeValue("oper"));
                String string2 = element3.attributeValue("value");
                rule.addCondition(eventAttribute.isMDC() ? string : eventAttribute, (Object)operation, string2);
            }
        }
        this.prepare();
    }
}

