/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.criteria;

import com.moonlit.logfaces.server.criteria.Condition;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.Operation;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import java.util.ArrayList;
import java.util.List;

public class JexlCondition
implements Condition,
Cloneable {
    private String attribute;
    private Operation operation;
    private Object value;

    public JexlCondition() {
    }

    public JexlCondition(String string, Operation operation, Object object) {
        this.attribute = string;
        this.operation = operation;
        this.value = object;
    }

    @Override
    public Condition clone() {
        JexlCondition jexlCondition = new JexlCondition();
        jexlCondition.attribute = this.attribute;
        jexlCondition.operation = this.operation;
        jexlCondition.value = this.value;
        return jexlCondition;
    }

    @Override
    public String getAttribute() {
        return this.attribute;
    }

    @Override
    public void setAttribute(String string) {
        this.attribute = string;
    }

    @Override
    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object object) {
        this.value = object;
    }

    @Override
    public List getPossibleOperations() {
        ArrayList<Operation> arrayList = new ArrayList<Operation>();
        if (this.attribute == null) {
            return arrayList;
        }
        switch (EventAttribute.fromString(this.attribute)) {
            case thrown: {
                arrayList.add(Operation.is);
                arrayList.add(Operation.isnot);
                break;
            }
            case throwableInfo: {
                arrayList.add(Operation.contains);
                arrayList.add(Operation.notcontains);
                arrayList.add(Operation.regex);
                arrayList.add(Operation.noregex);
                break;
            }
            case sequenceNumber: 
            case loggerTimeStamp: 
            case loggerLevel: {
                arrayList.add(Operation.is);
                arrayList.add(Operation.isnot);
                arrayList.add(Operation.more);
                arrayList.add(Operation.emore);
                arrayList.add(Operation.less);
                arrayList.add(Operation.eless);
                break;
            }
            default: {
                arrayList.add(Operation.is);
                arrayList.add(Operation.isnot);
                arrayList.add(Operation.contains);
                arrayList.add(Operation.notcontains);
                arrayList.add(Operation.regex);
                arrayList.add(Operation.noregex);
            }
        }
        return arrayList;
    }

    @Override
    public List getPossibleValues() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.attribute == null) {
            return arrayList;
        }
        switch (EventAttribute.fromString(this.attribute)) {
            case thrown: {
                arrayList.add(Boolean.TRUE.toString());
                arrayList.add(Boolean.FALSE.toString());
                break;
            }
            case loggerLevel: {
                List list = LfsLevel.toList();
                list.remove(LfsLevel.ALL);
                list.remove(LfsLevel.OFF);
                for (LfsLevel lfsLevel : list) {
                    arrayList.add(lfsLevel.toString());
                }
                break;
            }
        }
        return arrayList;
    }

    @Override
    public boolean isValid() {
        return this.attribute != null && this.operation != null && this.value != null;
    }
}

