/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.criteria;

import com.moonlit.logfaces.server.conf.k;
import java.util.ArrayList;
import java.util.List;

public enum EventAttribute {
    loggerTimeStamp,
    sequenceNumber,
    domainName,
    hostName,
    loggerName,
    loggerLevel,
    message,
    threadName,
    throwableInfo,
    thrown,
    locLineNumber,
    locFileName,
    locClassName,
    locMethodName,
    ndc,
    mdc;


    public static EventAttribute fromString(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        for (EventAttribute eventAttribute : EventAttribute.values()) {
            if (!string.equalsIgnoreCase(eventAttribute.toString())) continue;
            return eventAttribute;
        }
        return mdc;
    }

    public String toString() {
        return this.name();
    }

    public static List toDisplayList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (EventAttribute eventAttribute : EventAttribute.values()) {
            if (eventAttribute.isMDC()) continue;
            arrayList.add(eventAttribute.toString());
        }
        for (String string : k.d()) {
            if (string == null || string.isEmpty()) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public boolean isMDC() {
        return this.equals((Object)mdc);
    }

    public boolean isLocation() {
        return this.equals((Object)locClassName) || this.equals((Object)locFileName) || this.equals((Object)locLineNumber) || this.equals((Object)locMethodName);
    }

    public static String toColumnName(String string) {
        EventAttribute eventAttribute = EventAttribute.fromString(string);
        if (!eventAttribute.isMDC()) {
            return eventAttribute.name();
        }
        return String.format("mdc%d", k.c(string) + 1);
    }

    public static String toBQColumnName(String string) {
        EventAttribute eventAttribute = EventAttribute.fromString(string);
        if (!eventAttribute.isMDC()) {
            return eventAttribute.toMongoColumn();
        }
        return String.format("d%d", k.c(string) + 1);
    }

    public static String toMongoColumn(String string) {
        switch (EventAttribute.fromString(string)) {
            case loggerTimeStamp: {
                return "t";
            }
            case sequenceNumber: {
                return "q";
            }
            case domainName: {
                return "a";
            }
            case hostName: {
                return "h";
            }
            case loggerName: {
                return "g";
            }
            case loggerLevel: {
                return "p";
            }
            case message: {
                return "m";
            }
            case threadName: {
                return "r";
            }
            case throwableInfo: {
                return "i";
            }
            case thrown: {
                return "w";
            }
            case locLineNumber: {
                return "l";
            }
            case locFileName: {
                return "f";
            }
            case locClassName: {
                return "c";
            }
            case locMethodName: {
                return "e";
            }
            case ndc: {
                return "n";
            }
            case mdc: {
                return String.format("p_%s", string != null ? string : "");
            }
        }
        return null;
    }

    public String toMongoColumn() {
        switch (this) {
            case loggerTimeStamp: {
                return "t";
            }
            case sequenceNumber: {
                return "q";
            }
            case domainName: {
                return "a";
            }
            case hostName: {
                return "h";
            }
            case loggerName: {
                return "g";
            }
            case loggerLevel: {
                return "p";
            }
            case message: {
                return "m";
            }
            case threadName: {
                return "r";
            }
            case throwableInfo: {
                return "i";
            }
            case thrown: {
                return "w";
            }
            case locLineNumber: {
                return "l";
            }
            case locFileName: {
                return "f";
            }
            case locClassName: {
                return "c";
            }
            case locMethodName: {
                return "e";
            }
            case ndc: {
                return "n";
            }
            case mdc: {
                return "d";
            }
        }
        return null;
    }
}

