/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.core;

public enum Order {
    ASCENDING,
    DESCENDING,
    NATURAL;


    public String toDisplay() {
        switch (this) {
            case ASCENDING: {
                return "display in ascending order";
            }
            case DESCENDING: {
                return "display in descending order";
            }
            case NATURAL: {
                return "display in natural order";
            }
        }
        return "";
    }

    public static Order fromString(String string) {
        for (Order order : Order.values()) {
            if (!order.toDisplay().equals(string)) continue;
            return order;
        }
        return null;
    }

    public static Order toOrder(Object object) {
        if (object instanceof Order) {
            return (Order)((Object)object);
        }
        if (object instanceof String) {
            try {
                return Order.valueOf(object.toString().toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ASCENDING;
    }

    public boolean isDecsending() {
        return this.equals((Object)DESCENDING);
    }

    public boolean isNatural() {
        return this.equals((Object)NATURAL);
    }

    public int toMongo() {
        switch (this) {
            case ASCENDING: {
                return 1;
            }
            case DESCENDING: {
                return -1;
            }
        }
        return 0;
    }
}

