/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.conf;

import com.mongodb.BasicDBObject;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.core.g;
import com.moonlit.logfaces.server.core.h;
import com.moonlit.logfaces.server.log4j.c;
import com.moonlit.logfaces.server.util.C;
import com.moonlit.logfaces.server.util.e;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import java.io.File;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.dom4j.Element;

public class DestinationSlack
implements g {
    private static Logger log = LogManager.getLogger((String)DestinationSlack.class.getName());
    private String url = "https://hooks.slack.com/services/my-placeholder";
    private String channel = "#lfs";
    private String pattern = "";

    @Override
    public g clone() {
        DestinationSlack destinationSlack = new DestinationSlack();
        destinationSlack.channel = this.channel;
        destinationSlack.url = this.url;
        return destinationSlack;
    }

    @Override
    public void load(Element element) {
        Element element2 = (Element)element.selectSingleNode("property[@name='url']");
        if (element2 != null) {
            this.url = element2.attributeValue("value");
        }
        if ((element2 = (Element)element.selectSingleNode("property[@name='channel']")) != null) {
            this.channel = element2.attributeValue("value");
        }
        if ((element2 = (Element)element.selectSingleNode("property[@name='pattern']")) != null) {
            this.pattern = element2.attributeValue("value");
        }
    }

    @Override
    public void save(Element element) {
        Element element2 = element.addElement("destination").addAttribute("type", h.c.name());
        element2.addElement("property").addAttribute("name", "url").addAttribute("value", this.url);
        element2.addElement("property").addAttribute("name", "channel").addAttribute("value", this.channel);
        element2.addElement("property").addAttribute("name", "pattern").addAttribute("value", this.pattern);
    }

    @Override
    public void attach(File file, String string) {
    }

    @Override
    public void send(String object, String string, List list, Object object2) {
        object = this.buildMessageBody((String)object, list);
        if (StringUtils.isNotEmpty((CharSequence)string)) {
            object = string + C.a + (String)object;
        }
        BasicDBObject basicDBObject = new BasicDBObject("text", object);
        if (!StringUtils.isEmpty((CharSequence)this.channel)) {
            basicDBObject.put((Object)"channel", (Object)this.channel);
        }
        CloseableHttpClient closeableHttpClient = HttpClients.custom().setSSLContext(e.d()).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).useSystemProperties().build();
        HttpPost httpPost = new HttpPost(this.url);
        httpPost.setHeader("Content-Type", "application/json");
        StringEntity stringEntity = new StringEntity(basicDBObject.toString(), "UTF-8");
        stringEntity.setContentType("application/json");
        stringEntity.setContentEncoding("UTF-8");
        httpPost.setEntity((HttpEntity)stringEntity);
        HttpResponse httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
        EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            throw new Exception(String.format("failed sending slack notification: %d", httpResponse.getStatusLine().getStatusCode()));
        }
        log.info(String.format("message pushed to Slack channel '%s'", this.channel));
    }

    private String buildMessageBody(String string, List list) {
        if (StringUtils.isEmpty((CharSequence)this.pattern)) {
            return string;
        }
        PatternLayout patternLayout = c.b(this.pattern);
        StringBuffer stringBuffer = new StringBuffer();
        if (!StringUtils.isEmpty((CharSequence)string)) {
            stringBuffer.append(String.format("%s%n", string));
        }
        for (LogEvent logEvent : list) {
            try {
                String string2 = patternLayout.toSerializable(((LoggingEventVO)logEvent).toLoggingEvent());
                stringBuffer.append(string2);
                string2 = logEvent.getThrowableInfo();
                if (StringUtils.isEmpty((CharSequence)string2)) continue;
                stringBuffer.append(String.format("%s%n", string2));
            }
            catch (Exception exception) {
                log.error("failed to serialize log event, ignoring, error: " + exception.getMessage(), (Throwable)exception);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isValid() {
        return C.c(this.url);
    }

    @Override
    public h getType() {
        return h.c;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String string) {
        this.channel = string;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }
}

