/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.c;

import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.InsertAllResponse;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableResult;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.CustomSql;
import com.moonlit.logfaces.server.access.g;
import com.moonlit.logfaces.server.c.d;
import com.moonlit.logfaces.server.c.h;
import com.moonlit.logfaces.server.c.u;
import com.moonlit.logfaces.server.core.LfsEvent;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.database.e;
import com.moonlit.logfaces.server.receivers.r;
import com.moonlit.logfaces.server.util.a;
import com.moonlit.logfaces.server.util.l;
import com.moonlit.logfaces.server.util.m;
import com.moonlit.logfaces.server.util.s;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import com.moonlit.logfaces.server.vo.RepositoryEntryVO;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class c
extends h
implements u {
    private Logger m = LogManager.getLogger(this.getClass());
    private Set n = Sets.newHashSet();
    private boolean o;
    private boolean p = true;
    private BigQuery q;
    private TableId r;
    private a s;
    private long t;

    public c() {
        super("repository");
        this.a = com.moonlit.logfaces.server.receivers.r.o();
        this.s = new a();
    }

    @Override
    public void b() {
        com.moonlit.logfaces.server.util.s.a().register(this);
        this.p = com.moonlit.logfaces.server.conf.d.a().F();
        e e2 = (e)com.moonlit.logfaces.server.database.r.a().g();
        this.q = e2.b();
        this.r = TableId.of((String)e2.A().c(), (String)"lfs_repo");
        try {
            TableResult tableResult = this.q.listTableData(this.r, new BigQuery.TableDataListOption[]{BigQuery.TableDataListOption.pageSize((long)100L)});
            for (FieldValueList fieldValueList : tableResult.iterateAll()) {
                this.n.add(this.s.c(fieldValueList).hashCode(this.p));
            }
            this.o = true;
        }
        catch (Throwable throwable) {
            this.m.warn("failed getting repository from database: " + throwable.getMessage());
            com.moonlit.logfaces.server.util.m.a().a(com.moonlit.logfaces.server.util.l.t);
        }
        this.l();
        this.m.info(String.format("repo initialized with %d entries", this.n.size()));
    }

    @Override
    public void c() {
        if (!this.o) {
            return;
        }
        try {
            com.moonlit.logfaces.server.util.s.a().unregister(this);
            super.c();
            this.n.clear();
        }
        catch (Exception exception) {
            this.m.error(exception.getMessage(), (Throwable)exception);
        }
        this.o = false;
        this.m.trace("repo terminated");
    }

    @Override
    public void d() {
        this.c();
        this.b();
    }

    @Subscribe
    public void a(LfsEvent lfsEvent) {
        if (lfsEvent == null) {
            return;
        }
        switch (lfsEvent.getType()) {
            case c: {
                try {
                    this.m.info(String.format("%s event received, restarting repo", new Object[]{lfsEvent.getType()}));
                    this.d();
                }
                catch (Exception exception) {
                    this.m.fatal(exception.getMessage(), (Throwable)exception);
                }
                break;
            }
            case k: {
                if (++this.t % 240L != 0L) break;
                this.s();
                break;
            }
            case g: {
                this.p = com.moonlit.logfaces.server.conf.d.a().F();
                break;
            }
        }
    }

    @Override
    public void a() {
        this.c();
    }

    @Override
    public void a(boolean bl) {
        if (bl) {
            try {
                this.b();
            }
            catch (Exception exception) {
                this.m.fatal("repo failed to initialize after recovery", (Throwable)exception);
            }
        }
    }

    @Override
    public boolean a(LogEvent logEvent) {
        return this.o && logEvent.getDomainName() != null;
    }

    @Override
    public List f() {
        ArrayList arrayList = Lists.newArrayList();
        if (!this.o) {
            return arrayList;
        }
        String string = new com.moonlit.logfaces.server.database.h(this.r, true).a(EventAttribute.domainName).a(EventAttribute.hostName).a(EventAttribute.loggerName).a(com.moonlit.logfaces.server.conf.d.a().G()).b();
        QueryJobConfiguration queryJobConfiguration = QueryJobConfiguration.newBuilder((String)string).setUseLegacySql(Boolean.valueOf(false)).build();
        JobId jobId = JobId.of((String)UUID.randomUUID().toString());
        Job job = this.q.create(JobInfo.newBuilder((JobConfiguration)queryJobConfiguration).setJobId(jobId).build(), new BigQuery.JobOption[0]);
        try {
            job = job.waitFor(new RetryOption[0]);
            if (job == null) {
                throw new Exception("bigquery job no longer exists");
            }
            if (job.getStatus().getError() != null) {
                throw new Exception(job.getStatus().getError().toString());
            }
            a a2 = new a();
            TableResult tableResult = job.getQueryResults(new BigQuery.QueryResultsOption[0]);
            for (FieldValueList fieldValueList : tableResult.iterateAll()) {
                RepositoryEntryVO repositoryEntryVO = a2.c(fieldValueList);
                if (repositoryEntryVO.isException()) continue;
                arrayList.add(repositoryEntryVO);
            }
        }
        catch (Exception exception) {
            this.m.error(exception.getMessage(), (Throwable)exception);
        }
        return arrayList;
    }

    @Override
    public InputStream a(g g2) {
        if (!this.o) {
            return null;
        }
        PipedInputStream pipedInputStream = new PipedInputStream();
        PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
        new Thread(new d(this, pipedOutputStream, g2)).start();
        return pipedInputStream;
    }

    @Override
    public List o() {
        return this.a(EventAttribute.domainName);
    }

    @Override
    public List p() {
        if (!this.p) {
            return Lists.newArrayList();
        }
        return this.a(EventAttribute.hostName);
    }

    @Override
    public List q() {
        return this.a(EventAttribute.loggerName);
    }

    @Override
    public List r() {
        return this.a(EventAttribute.throwableInfo);
    }

    @Override
    public void d(LogEvent logEvent) {
        this.c(logEvent);
    }

    @Override
    public void b(boolean bl) {
        this.n.clear();
        if (bl) {
            e e2 = (e)com.moonlit.logfaces.server.database.r.a().g();
            e2.i();
        }
        this.m.info(String.format("repository %s", bl ? "re-created" : "cache cleared"));
    }

    @Override
    public synchronized void c(LogEvent logEvent) {
        String string;
        if (!this.o) {
            return;
        }
        this.a(new RepositoryEntryVO(logEvent));
        if (logEvent instanceof LoggingEventVO && !StringUtils.isEmpty((CharSequence)(string = ((LoggingEventVO)logEvent).getExceptionClass()))) {
            this.a(new RepositoryEntryVO(string));
        }
    }

    private List a(EventAttribute eventAttribute) {
        ArrayList arrayList = Lists.newArrayList();
        String string = null;
        string = eventAttribute == EventAttribute.throwableInfo ? new com.moonlit.logfaces.server.database.h(this.r, true).a(EventAttribute.loggerName).a((Condition)BinaryCondition.like((Object)new CustomSql((Object)EventAttribute.domainName.toMongoColumn()), (Object)"_LFS_EXCEPTION_")).b() : new com.moonlit.logfaces.server.database.h(this.r, true).a(eventAttribute).b();
        QueryJobConfiguration queryJobConfiguration = QueryJobConfiguration.newBuilder((String)string).setUseLegacySql(Boolean.valueOf(false)).build();
        JobId jobId = JobId.of((String)UUID.randomUUID().toString());
        Job job = this.q.create(JobInfo.newBuilder((JobConfiguration)queryJobConfiguration).setJobId(jobId).build(), new BigQuery.JobOption[0]);
        try {
            job = job.waitFor(new RetryOption[0]);
            if (job == null) {
                throw new Exception("bigquery job no longer exists");
            }
            if (job.getStatus().getError() != null) {
                throw new Exception(job.getStatus().getError().toString());
            }
            TableResult tableResult = job.getQueryResults(new BigQuery.QueryResultsOption[0]);
            for (FieldValueList fieldValueList : tableResult.iterateAll()) {
                if (fieldValueList.get(0).isNull()) continue;
                arrayList.add(fieldValueList.get(0).getStringValue());
            }
            return arrayList;
        }
        catch (Exception exception) {
            this.m.error(exception.getMessage(), (Throwable)exception);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Writer writer, g g2) {
        String string = new com.moonlit.logfaces.server.database.h(this.r, true).a(EventAttribute.domainName).a(EventAttribute.loggerName).a(com.moonlit.logfaces.server.conf.d.a().G()).b();
        QueryJobConfiguration queryJobConfiguration = QueryJobConfiguration.newBuilder((String)string).setUseLegacySql(Boolean.valueOf(false)).build();
        JobId jobId = JobId.of((String)UUID.randomUUID().toString());
        Job job = this.q.create(JobInfo.newBuilder((JobConfiguration)queryJobConfiguration).setJobId(jobId).build(), new BigQuery.JobOption[0]);
        HashSet hashSet = Sets.newHashSet();
        try {
            int n2 = 0;
            job = job.waitFor(new RetryOption[0]);
            if (job == null) {
                throw new Exception("bigquery job no longer exists");
            }
            if (job.getStatus().getError() != null) {
                throw new Exception(job.getStatus().getError().toString());
            }
            a a2 = new a();
            TableResult tableResult = job.getQueryResults(new BigQuery.QueryResultsOption[0]);
            for (FieldValueList fieldValueList : tableResult.iterateAll()) {
                RepositoryEntryVO repositoryEntryVO = new RepositoryEntryVO(fieldValueList.get(0).getStringValue(), fieldValueList.get(1).getStringValue());
                if (g2 != null && !g2.a(repositoryEntryVO)) continue;
                if (this.p) {
                    int n3 = repositoryEntryVO.hashCode(false);
                    if (hashSet.contains(n3)) continue;
                    hashSet.add(n3);
                }
                writer.write(String.format("%s%n", a2.b(repositoryEntryVO)));
                ++n2;
            }
            this.m.info(String.format("served %d repo entries", n2));
        }
        catch (Exception exception) {
            this.m.error(exception.getMessage(), (Throwable)exception);
        }
        finally {
            try {
                writer.flush();
                writer.close();
            }
            catch (IOException iOException) {
                this.m.error(iOException.getMessage(), (Throwable)iOException);
            }
        }
    }

    private void a(RepositoryEntryVO repositoryEntryVO) {
        int n2 = repositoryEntryVO.hashCode(this.p);
        if (this.n.contains(n2)) {
            return;
        }
        if (!this.p) {
            repositoryEntryVO.setHostName("");
        }
        InsertAllRequest.Builder builder = InsertAllRequest.newBuilder((TableId)this.r);
        builder.addRow((Map)this.s.a(repositoryEntryVO, false));
        InsertAllRequest insertAllRequest = builder.build();
        InsertAllResponse insertAllResponse = this.q.insertAll(insertAllRequest);
        if (insertAllResponse.hasErrors()) {
            this.m.error(String.format("failed to insert repo entry, error: ", insertAllResponse.toString()));
            return;
        }
        this.m.trace("inserted " + repositoryEntryVO);
        this.n.add(n2);
    }

    protected void s() {
        int n2 = com.moonlit.logfaces.server.conf.d.a().G();
        if (n2 <= 0) {
            return;
        }
        try {
            String string = new com.moonlit.logfaces.server.database.h(this.r).a("*").b();
            TableResult tableResult = this.q.query(QueryJobConfiguration.newBuilder((String)string).setUseLegacySql(Boolean.valueOf(false)).build(), new BigQuery.JobOption[0]);
            long l2 = ((FieldValueList)tableResult.getValues().iterator().next()).get(0).getLongValue();
            if (l2 >= (long)n2) {
                this.m.warn(String.format("repo size of %d reached configured threshold of %d records", l2, n2));
                com.moonlit.logfaces.server.util.m.a().b(com.moonlit.logfaces.server.util.l.z);
            }
        }
        catch (Exception exception) {
            this.m.error(exception.getMessage(), (Throwable)exception);
        }
    }
}

