/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.admin.models;

import com.moonlit.logfaces.server.core.g;
import com.moonlit.logfaces.server.core.h;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import java.io.Serializable;
import org.apache.commons.beanutils.BeanUtils;

public class DestinationModel
implements Serializable {
    private String type;
    private boolean enabled;
    private String label;
    private String color = "gray";
    private String icon;
    private String display = "not specified";
    private String description;

    public DestinationModel(h h2) {
        this.type = h2.name();
        switch (h2) {
            case b: {
                this.description = "Send email with captured log data";
                this.label = "Send email";
                this.icon = "fa-send";
                break;
            }
            case c: {
                this.description = "Send message to specified Slack channel";
                this.label = "Relay to Slack";
                this.icon = "fa-slack";
                break;
            }
            case d: {
                this.description = "Send POST request to a specified web server end point";
                this.label = "Post to web hook";
                this.icon = "fa-cloud-upload";
                break;
            }
            case e: {
                this.description = "Invoke selected plugin functionality";
                this.label = "Invoke plugin";
                this.icon = "fa-plug";
                break;
            }
            case a: {
                this.description = "Raise and maintain alert state with specified severity level";
                this.label = "Raise alert";
                this.icon = "fa-bell";
            }
        }
    }

    public DestinationModel(g g2) {
        this(g2.getType());
        try {
            switch (g2.getType()) {
                case b: {
                    this.display = BeanUtils.getProperty((Object)g2, (String)"recipients");
                    this.enabled = !this.display.isEmpty();
                    this.color = this.enabled ? "green" : "gray";
                    break;
                }
                case c: {
                    this.display = BeanUtils.getProperty((Object)g2, (String)"url");
                    this.enabled = !this.display.isEmpty();
                    this.color = this.enabled ? "blue" : "gray";
                    break;
                }
                case d: {
                    this.display = BeanUtils.getProperty((Object)g2, (String)"url");
                    this.enabled = !this.display.isEmpty();
                    this.color = this.enabled ? "green" : "gray";
                    break;
                }
                case e: {
                    this.display = BeanUtils.getProperty((Object)g2, (String)"name");
                    this.enabled = !this.display.isEmpty();
                    this.color = this.enabled ? "green" : "gray";
                    break;
                }
                case a: {
                    LfsLevel lfsLevel = LfsLevel.toLevel(BeanUtils.getProperty((Object)g2, (String)"level"));
                    this.display = String.format("raise %s level alert", lfsLevel);
                    boolean bl = this.enabled = !this.display.isEmpty();
                    if (!this.enabled) {
                        this.color = "gray";
                        break;
                    }
                    if (lfsLevel == LfsLevel.INFO) {
                        this.color = "green";
                        break;
                    }
                    if (lfsLevel == LfsLevel.ERROR) {
                        this.color = "red";
                        break;
                    }
                    if (lfsLevel != LfsLevel.WARN) break;
                    this.color = "orange";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String string) {
        this.display = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String string) {
        this.color = string;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String string) {
        this.icon = string;
    }
}

