/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.admin;

import com.google.common.collect.Maps;
import com.moonlit.logfaces.server.admin.Command;
import com.moonlit.logfaces.server.admin.CommandInstallUpdate;
import com.moonlit.logfaces.server.admin.Result;
import com.moonlit.logfaces.server.admin.models.MenuModel;
import com.moonlit.logfaces.server.admin.models.PageType;
import com.moonlit.logfaces.server.conf.d;
import com.moonlit.logfaces.server.conf.i;
import com.moonlit.logfaces.server.database.r;
import com.moonlit.logfaces.server.l.e;
import com.moonlit.logfaces.server.util.Revision;
import com.moonlit.logfaces.server.util.m;
import de.schlichtherle.license.LicenseContent;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@Scope(value="session")
@RequestMapping(value={""})
public class StatusTabController {
    private Logger log = LogManager.getLogger((String)this.getClass().getName());

    @RequestMapping(value={"/statusTab"}, method={RequestMethod.GET})
    public ModelAndView renderStatus(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("menu", MenuModel.build(PageType.status));
        hashMap.put("version", Revision.getRevision().toString());
        r r2 = r.a();
        e e2 = e.a();
        LicenseContent licenseContent = e2.m();
        if (licenseContent == null) {
            hashMap.put("license", "<font color='red'>not licensed</font>");
        } else {
            String string = ((Properties)licenseContent.getExtra()).getProperty("id");
            String string2 = ((Properties)licenseContent.getExtra()).getProperty("licenseType");
            String string3 = String.format("%s %s", StringUtils.isBlank((CharSequence)string2) ? "" : string2, StringUtils.isBlank((CharSequence)string) ? "" : string);
            switch (e2.l()) {
                case a: {
                    hashMap.put("license", string3);
                    break;
                }
                case b: {
                    hashMap.put("license", String.format("<span class='blinkwarn'>%s</span>", string3));
                    break;
                }
                case c: {
                    hashMap.put("license", String.format("<font color='red'>%s</font>", string3));
                }
            }
        }
        hashMap.put("virt", i.x());
        hashMap.put("maint", !r2.h());
        hashMap.put("dbsize", r2.i() || r2.h());
        hashMap.put("os", String.format("%s (%s), %s, Java %s (%s)", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), System.getProperty("java.version"), Charset.defaultCharset().name()));
        hashMap.put("dbinfo", r2.o() ? r2.g().t() : Maps.newHashMap());
        return new ModelAndView("status", "params", hashMap);
    }

    @RequestMapping(value={"/showLastErrors"}, method={RequestMethod.GET})
    public ModelAndView showLastErrors(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HashMap<String, List> hashMap = new HashMap<String, List>();
        hashMap.put("menu", MenuModel.build(PageType.none));
        hashMap.put("lastErrors", m.a().b());
        return new ModelAndView("lasterrors", "params", hashMap);
    }

    @RequestMapping(value={"/resetLastErrors"}, method={RequestMethod.POST})
    public void resetLastErrors(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        m.a().c();
        Result result = new Result();
        result.setInfo("Last errors are cleared");
        result.addLink("statusTab", "Continue");
        httpServletRequest.getSession().setAttribute("result", (Object)result);
        httpServletResponse.sendRedirect("result");
    }

    @RequestMapping(value={"/install"}, method={RequestMethod.GET})
    public ModelAndView install(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (d.P()) {
            throw new Exception("This server instance is immutable");
        }
        CommandInstallUpdate commandInstallUpdate = new CommandInstallUpdate("statusTab");
        httpServletRequest.getSession().setAttribute("command", (Object)commandInstallUpdate);
        commandInstallUpdate.execute();
        return new ModelAndView("progress");
    }

    @RequestMapping(value={"/checkProgress"}, method={RequestMethod.GET})
    public void checkProgress(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Command command = (Command)httpServletRequest.getSession().getAttribute("command");
        if (command != null) {
            httpServletResponse.getWriter().write(command.getProgress());
        }
    }

    @RequestMapping(value={"/result"}, method={RequestMethod.GET})
    public ModelAndView result(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("menu", MenuModel.build(PageType.none));
        Result result = (Result)httpServletRequest.getSession().getAttribute("result");
        if (result == null) {
            httpServletResponse.sendRedirect("home");
            return null;
        }
        hashMap.put("result", result);
        return new ModelAndView("result", "params", hashMap);
    }

    @ExceptionHandler
    public ModelAndView handleError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Exception exception) {
        this.log.error(exception.getMessage(), (Throwable)exception);
        Result result = new Result();
        result.addLink("statusTab", "Continue");
        result.setError(String.format("Internal error: %s", exception.getMessage()));
        httpServletRequest.getSession().setAttribute("result", (Object)result);
        try {
            httpServletResponse.sendRedirect("result");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

