/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.admin;

import com.google.common.collect.Lists;
import com.mongodb.DBObject;
import com.moonlit.logfaces.server.access.d;
import com.moonlit.logfaces.server.access.g;
import com.moonlit.logfaces.server.access.i;
import com.moonlit.logfaces.server.admin.Result;
import com.moonlit.logfaces.server.admin.SecurityTabController$Mapper;
import com.moonlit.logfaces.server.admin.WebUtils;
import com.moonlit.logfaces.server.admin.models.GroupModel;
import com.moonlit.logfaces.server.admin.models.MenuModel;
import com.moonlit.logfaces.server.admin.models.OptionModel;
import com.moonlit.logfaces.server.admin.models.PageType;
import com.moonlit.logfaces.server.core.a;
import com.moonlit.logfaces.server.criteria.Condition;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.Operation;
import com.moonlit.logfaces.server.criteria.Rule;
import com.moonlit.logfaces.server.database.r;
import com.moonlit.logfaces.server.e;
import com.moonlit.logfaces.server.l.b;
import com.moonlit.logfaces.server.remoting.LfsService;
import com.moonlit.logfaces.server.util.Password;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.directory.SearchControls;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.ldap.SizeLimitExceededException;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.LikeFilter;
import org.springframework.ldap.filter.OrFilter;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

@Controller
@Scope(value="session")
@RequestMapping(value={""})
public class SecurityTabController {
    private Logger log = LogManager.getLogger(this.getClass());

    @RequestMapping(value={"/securityTab"}, method={RequestMethod.GET})
    public ModelAndView render(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("menu", MenuModel.build(PageType.security));
        if (!e.a().e()) {
            hashMap.put("message", "Engine is not running, please start the engine from status tab or restart the server.");
            return new ModelAndView("notfeatured", "params", hashMap);
        }
        if (!com.moonlit.logfaces.server.l.e.a().a(b.i)) {
            hashMap.put("message", "This feature is not enabled");
            return new ModelAndView("notfeatured", "params", hashMap);
        }
        Properties properties = null;
        com.moonlit.logfaces.server.conf.d d2 = com.moonlit.logfaces.server.conf.d.a();
        hashMap.put("subtab", 0);
        Object object = httpServletRequest.getSession().getAttribute("subtab");
        if (object != null) {
            hashMap.put("subtab", object);
        }
        if ((object = httpServletRequest.getParameter("subtab")) != null) {
            hashMap.put("subtab", Integer.parseInt(object.toString()));
        }
        httpServletRequest.getSession().removeAttribute("subtab");
        if (httpServletRequest.getSession().getAttribute("ldapFailed") != null) {
            hashMap.put("ldapFailed", true);
            properties = (Properties)httpServletRequest.getSession().getAttribute("ldapSettings");
        } else {
            properties = d2.w();
        }
        hashMap.put("keyStoreOK", com.moonlit.logfaces.server.util.e.a());
        hashMap.put("nofTrustCerts", com.moonlit.logfaces.server.util.e.b(false));
        hashMap.put("authorizationEnabled", d2.z());
        hashMap.put("ldapEnabled", d2.y().b());
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(new OptionModel("Authentication", "authentication", d2.y().name(), Lists.newArrayList((Iterable)a.d()), "Authentication method to use with remote clients", "auth.type"));
        User user = i.a().b("client");
        arrayList.add(new OptionModel("User name", "com.logfaces.auth.user", user != null ? user.getUsername() : "client", "Authentication method to use with remote clients", "com.logfaces.auth.user"));
        OptionModel optionModel = new OptionModel("Password", "com.logfaces.auth.pwd", user != null ? Password.b(user.getPassword()) : "guest", "Access password", "com.logfaces.auth.user");
        optionModel.setPassword(true);
        arrayList.add(optionModel);
        arrayList.add(new OptionModel("LDAP server", "com.logfaces.ldap.serverHost", properties.getProperty("com.logfaces.ldap.serverHost"), "LDAP server host name"));
        arrayList.add(new OptionModel("LDAP port", "com.logfaces.ldap.serverPort", properties.getProperty("com.logfaces.ldap.serverPort"), "LDAP server port number"));
        boolean bl = Boolean.parseBoolean(properties.getProperty("com.logfaces.ldap.encryption", "false"));
        arrayList.add(new OptionModel("Use SSL", "com.logfaces.ldap.encryption", bl ? "Yes" : "No", Lists.newArrayList((Object[])new String[]{"No", "Yes"}), "Use SSL to communicate with this LDAP server", "ldap.ssl"));
        arrayList.add(new OptionModel("Bind DN", "com.logfaces.ldap.managerDn", properties.getProperty("com.logfaces.ldap.managerDn"), "Distinguished name for binding, e.g. administrator.", "com.logfaces.ldap.managerDn"));
        optionModel = new OptionModel("Password", "com.logfaces.ldap.managerPw", properties.getProperty("com.logfaces.ldap.managerPw"), "Password for binding", "com.logfaces.ldap.managerPw");
        optionModel.setPassword(true);
        arrayList.add(optionModel);
        arrayList.add(new OptionModel("User base DN", "com.logfaces.ldap.userSearchBase", properties.getProperty("com.logfaces.ldap.userSearchBase"), "Location of LDAP users, specified by the DN of user subtree.", "com.logfaces.ldap.userSearchBase"));
        arrayList.add(new OptionModel("User filter", "com.logfaces.ldap.userSearchFilter", properties.getProperty("com.logfaces.ldap.userSearchFilter"), "LDAP filter for matching users in user base DN.", "com.logfaces.ldap.userSearchFilter"));
        arrayList.add(new OptionModel("Group base DN", "com.logfaces.ldap.groupSearchBase", properties.getProperty("com.logfaces.ldap.groupSearchBase"), "Location of LDAP groups, specified by the DN of group subtree.", "com.logfaces.ldap.groupSearchBase"));
        arrayList.add(new OptionModel("Group filter", "com.logfaces.ldap.groupSearchFilter", properties.getProperty("com.logfaces.ldap.groupSearchFilter"), "LDAP filter for matching user membership in groups", "com.logfaces.ldap.groupSearchFilter"));
        hashMap.put("ldap", arrayList);
        if (d2.y().b()) {
            ArrayList arrayList2 = Lists.newArrayList();
            Map map = d.a().f();
            int n2 = 0;
            for (String string : map.keySet()) {
                Condition condition;
                Rule rule;
                GroupModel groupModel = new GroupModel(string, n2++);
                CriteriaFilter criteriaFilter = (CriteriaFilter)map.get(string);
                if (criteriaFilter.getRules().isEmpty()) {
                    groupModel.setNote("not authorized to access log data", "exclude.gif");
                } else if (criteriaFilter.getRules().size() == 1 && (rule = (Rule)criteriaFilter.getRules().get(0)).getConditions().size() == 1 && (condition = (Condition)rule.getConditions().get(0)).getAttribute().equals(EventAttribute.loggerLevel.toString()) && condition.getOperation().equals((Object)Operation.emore) && condition.getValue().toString().equals("TRACE")) {
                    groupModel.setNote("full access to any log data", "enabled.gif");
                }
                arrayList2.add(groupModel);
            }
            hashMap.put("groups", arrayList2);
        }
        return new ModelAndView("security", "params", hashMap);
    }

    @RequestMapping(value={"/group"}, method={RequestMethod.GET})
    public ModelAndView renderGroup(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HttpSession httpSession = httpServletRequest.getSession();
        d d2 = d.a();
        httpSession.setAttribute("subtab", (Object)2);
        int n2 = Integer.parseInt(httpServletRequest.getParameter("id"));
        String string = d2.a(n2);
        CriteriaFilter criteriaFilter = d2.b(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        com.moonlit.logfaces.server.util.a a2 = new com.moonlit.logfaces.server.util.a();
        DBObject dBObject = a2.a(criteriaFilter);
        dBObject.put("meta", (Object)a2.a(r.a().g().q()));
        hashMap.put("criteria", StringEscapeUtils.escapeHtml4((String)dBObject.toString()));
        hashMap.put("title", string);
        httpSession.setAttribute("groupName", (Object)string);
        return new ModelAndView("groupView", "params", hashMap);
    }

    @RequestMapping(value={"/loginTest"}, method={RequestMethod.POST})
    public void loginTest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Result result = new Result();
        result.addLink("securityTab", "Continue");
        httpServletRequest.getSession().setAttribute("result", (Object)result);
        httpServletRequest.getSession().setAttribute("subtab", (Object)3);
        try {
            String string = httpServletRequest.getParameter("userName");
            String string2 = Password.a(httpServletRequest.getParameter("password"));
            g g2 = i.a().a(string, string2);
            String string3 = this.getAccessString(g2);
            result.setInfo("Logged in successfully.<br>" + g2 + "<hr>" + string3);
            httpServletResponse.sendRedirect("result");
        }
        catch (Exception exception) {
            result.setError(exception.getMessage());
            httpServletResponse.sendRedirect("result");
        }
    }

    @ResponseBody
    @RequestMapping(value={"/updateAuthentication"}, method={RequestMethod.POST})
    public Object updateAuthentication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        com.moonlit.logfaces.server.conf.d d2 = com.moonlit.logfaces.server.conf.d.a();
        Result result = new Result();
        result.addLink("securityTab", "Continue");
        httpServletRequest.getSession().setAttribute("result", (Object)result);
        httpServletRequest.getSession().setAttribute("subtab", (Object)1);
        a a2 = a.valueOf(WebUtils.getParameter(httpServletRequest, "authentication", a.a.name()));
        d2.a(a2);
        switch (a2) {
            case a: {
                i.a().e();
                d2.b(false);
                d2.a(false);
                d2.f();
                LfsService.getInstance().applyAuthorization();
                result.setInfo("Authentication is disabled");
                httpServletRequest.getSession().removeAttribute("ldapFailed");
                return result;
            }
            case b: {
                this.updateRealmUser(httpServletRequest);
                i.a().e();
                d2.b(false);
                d2.a(false);
                d2.f();
                LfsService.getInstance().applyAuthorization();
                result.setInfo("Authentication settings applied");
                httpServletRequest.getSession().removeAttribute("ldapFailed");
                return result;
            }
            case c: {
                Properties properties = this.makeLdapProperties(httpServletRequest);
                try {
                    this.validateLdapParams(httpServletRequest);
                    this.trySecurityContext(properties);
                    d2.a(properties);
                    d2.f();
                    i.a().f();
                    httpServletRequest.getSession().removeAttribute("ldapSettings");
                    httpServletRequest.getSession().removeAttribute("ldapFailed");
                    result.setInfo(String.format("Authentication settings applied successully. Don't forget to test them before actual use.", new Object[0]));
                    return result;
                }
                catch (Exception exception) {
                    this.log.error(exception.getMessage(), (Throwable)exception);
                    result.setError(String.format("Failed applying LDAP setting. Error: %s", exception.getMessage()));
                    httpServletRequest.getSession().setAttribute("ldapSettings", (Object)properties);
                    httpServletRequest.getSession().setAttribute("ldapFailed", (Object)true);
                    return result;
                }
            }
        }
        throw new Exception("authentication type not supported");
    }

    protected Properties makeLdapProperties(HttpServletRequest httpServletRequest) {
        boolean bl = WebUtils.getBoolean(httpServletRequest, "com.logfaces.ldap.encryption", "yes");
        Properties properties = new Properties();
        properties.put("com.logfaces.ldap.serverHost", WebUtils.getParameter(httpServletRequest, "com.logfaces.ldap.serverHost"));
        properties.put("com.logfaces.ldap.encryption", Boolean.toString(bl));
        properties.put("com.logfaces.ldap.protocol", bl ? "ldaps" : "ldap");
        properties.put("com.logfaces.ldap.serverPort", WebUtils.getParameter(httpServletRequest, "com.logfaces.ldap.serverPort"));
        properties.put("com.logfaces.ldap.managerDn", WebUtils.getParameter(httpServletRequest, "com.logfaces.ldap.managerDn"));
        properties.put("com.logfaces.ldap.managerPw", WebUtils.getParameter(httpServletRequest, "com.logfaces.ldap.managerPw"));
        properties.put("com.logfaces.ldap.userSearchBase", WebUtils.getParameter(httpServletRequest, "com.logfaces.ldap.userSearchBase"));
        properties.put("com.logfaces.ldap.userSearchFilter", WebUtils.getParameter(httpServletRequest, "com.logfaces.ldap.userSearchFilter"));
        properties.put("com.logfaces.ldap.groupSearchBase", WebUtils.getParameter(httpServletRequest, "com.logfaces.ldap.groupSearchBase"));
        properties.put("com.logfaces.ldap.groupSearchFilter", WebUtils.getParameter(httpServletRequest, "com.logfaces.ldap.groupSearchFilter"));
        return properties;
    }

    protected void updateRealmUser(HttpServletRequest httpServletRequest) {
        String string = WebUtils.getParameter(httpServletRequest, "com.logfaces.auth.user");
        String string2 = WebUtils.getParameter(httpServletRequest, "com.logfaces.auth.pwd");
        if (StringUtils.isEmpty((CharSequence)string)) {
            throw new Exception("User name is a mandatory parameter");
        }
        if (StringUtils.isEmpty((CharSequence)string2)) {
            throw new Exception("Password is a mandatory parameter");
        }
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(new SimpleGrantedAuthority(i.b));
        User user = new User(string, Password.a(string2), (Collection)arrayList);
        i.a().a(user);
    }

    protected void validateLdapParams(HttpServletRequest httpServletRequest) {
        if (StringUtils.isEmpty((CharSequence)WebUtils.getParameter(httpServletRequest, "com.logfaces.ldap.serverHost"))) {
            throw new Exception("LDAP server host name is a mandatory parameter");
        }
        try {
            int n2 = WebUtils.getInt(httpServletRequest, "com.logfaces.ldap.serverPort", 0);
            if (n2 <= 0 || n2 > 65535) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            throw new Exception("LDAP port number must be positive number in range 1 - 65535.");
        }
        if (StringUtils.isEmpty((CharSequence)WebUtils.getParameter(httpServletRequest, "com.logfaces.ldap.managerDn"))) {
            throw new Exception("Binding user DN is a mandatory parameter used for connecting to your organization directory.");
        }
        if (StringUtils.isEmpty((CharSequence)WebUtils.getParameter(httpServletRequest, "com.logfaces.ldap.managerPw"))) {
            throw new Exception("Binding user passowrd is a mandatory parameter used for connecting to your organization directory.");
        }
        if (StringUtils.isEmpty((CharSequence)WebUtils.getParameter(httpServletRequest, "com.logfaces.ldap.userSearchBase"))) {
            throw new Exception("User base DN is a mandatory parameter used for searching incoming users.");
        }
        if (StringUtils.isEmpty((CharSequence)WebUtils.getParameter(httpServletRequest, "com.logfaces.ldap.userSearchFilter"))) {
            throw new Exception("User filter is a mandatory parameter used for searching incoming users.");
        }
        if (StringUtils.isEmpty((CharSequence)WebUtils.getParameter(httpServletRequest, "com.logfaces.ldap.groupSearchBase"))) {
            throw new Exception("Group base DN is a mandatory parameter, if you don't intend to use authorization, leave default value");
        }
        if (StringUtils.isEmpty((CharSequence)WebUtils.getParameter(httpServletRequest, "com.logfaces.ldap.groupSearchFilter"))) {
            throw new Exception("Group filter is a mandatory parameter, if you don't intend to use authorization, leave default value");
        }
    }

    private void trySecurityContext(Properties properties) {
        ClassPathXmlApplicationContext classPathXmlApplicationContext = null;
        File file = new File(com.moonlit.logfaces.server.conf.i.b() + File.separator + "ldaptest.properties");
        try {
            properties.store(new FileOutputStream(file), "ldap test properties");
            System.setProperty("ldap.properties", "file:" + file.getPath());
            String string = i.a().b();
            classPathXmlApplicationContext = new ClassPathXmlApplicationContext(string);
            LdapContextSource ldapContextSource = (LdapContextSource)classPathXmlApplicationContext.getBean(LdapContextSource.class);
            SpringSecurityLdapTemplate springSecurityLdapTemplate = new SpringSecurityLdapTemplate((ContextSource)ldapContextSource);
            springSecurityLdapTemplate.setIgnorePartialResultException(true);
            AndFilter andFilter = new AndFilter();
            OrFilter orFilter = new OrFilter();
            orFilter.or((Filter)new EqualsFilter("objectclass", "person"));
            orFilter.or((Filter)new EqualsFilter("objectclass", "posixAccount"));
            orFilter.or((Filter)new EqualsFilter("objectclass", "inetOrgPerson"));
            orFilter.or((Filter)new EqualsFilter("objectclass", "organizationalPerson"));
            andFilter.and((Filter)orFilter);
            andFilter.and((Filter)new LikeFilter("cn", "*"));
            SearchControls searchControls = new SearchControls();
            searchControls.setCountLimit(0L);
            searchControls.setReturningObjFlag(true);
            searchControls.setSearchScope(2);
            try {
                springSecurityLdapTemplate.search(properties.getProperty("com.logfaces.ldap.userSearchBase"), andFilter.encode(), searchControls, (AttributesMapper)new SecurityTabController$Mapper(this));
            }
            catch (SizeLimitExceededException sizeLimitExceededException) {
                this.log.warn(sizeLimitExceededException.getMessage());
            }
            OrFilter orFilter2 = new OrFilter();
            orFilter2.or((Filter)new EqualsFilter("objectclass", "group"));
            orFilter2.or((Filter)new EqualsFilter("objectclass", "groupOfNames"));
            orFilter2.or((Filter)new EqualsFilter("objectclass", "groupOfUniqueNames"));
            orFilter2.or((Filter)new EqualsFilter("objectclass", "posixGroup"));
            try {
                springSecurityLdapTemplate.search(properties.getProperty("com.logfaces.ldap.groupSearchBase"), orFilter2.encode(), searchControls, (AttributesMapper)new SecurityTabController$Mapper(this));
            }
            catch (SizeLimitExceededException sizeLimitExceededException) {
                this.log.warn(sizeLimitExceededException.getMessage());
            }
        }
        catch (Exception exception) {
            throw new Exception(exception.getCause() != null ? exception.getCause().toString() : exception.getMessage());
        }
        finally {
            if (classPathXmlApplicationContext != null) {
                classPathXmlApplicationContext.close();
            }
            file.delete();
        }
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    @ExceptionHandler
    public Object handleError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Exception exception) {
        this.log.error(exception.getMessage(), (Throwable)exception);
        Result result = new Result();
        result.setError(exception.getMessage());
        return result;
    }

    private String getAccessString(g g2) {
        if (g2 == null) {
            return "no access";
        }
        if (!com.moonlit.logfaces.server.conf.d.a().y().b()) {
            return "Access control is disabled, full access to all log data is granted to everyone, no login will be requested";
        }
        if (!com.moonlit.logfaces.server.conf.d.a().z()) {
            return "Authroization is disabled, full access to all log data is granted";
        }
        List list = d.a().a(g2);
        if (list.isEmpty()) {
            return "Not authorized to access log data because none of the user groups are mapped for this server to perform authorization. Try to import this user groups and map them to some criteria fitlers.";
        }
        return "Authorized to access logs matching criteria specified in those groups:<br>  <b>" + StringUtils.join((Iterable)list, (String)",") + "</b>";
    }
}

