/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.admin;

import com.moonlit.logfaces.server.admin.Result;
import com.moonlit.logfaces.server.admin.models.MenuModel;
import com.moonlit.logfaces.server.admin.models.PageType;
import com.moonlit.logfaces.server.conf.d;
import com.moonlit.logfaces.server.e;
import de.schlichtherle.license.LicenseContent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@Scope(value="session")
@RequestMapping(value={""})
public class LicenseTabController {
    private Logger log = LogManager.getLogger((String)this.getClass().getName());

    @RequestMapping(value={"/licenseTab"}, method={RequestMethod.GET})
    public ModelAndView render(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        com.moonlit.logfaces.server.l.e e2 = com.moonlit.logfaces.server.l.e.a();
        LicenseContent licenseContent = e2.m();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("menu", MenuModel.build(PageType.license));
        if (licenseContent != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
            hashMap.put("licenseHolder", licenseContent.getHolder());
            hashMap.put("validUntil", licenseContent.getNotAfter() == null ? "unlimited" : simpleDateFormat.format(licenseContent.getNotAfter()));
            hashMap.put("validSince", simpleDateFormat.format(licenseContent.getIssued()));
            hashMap.put("licenseType", ((Properties)licenseContent.getExtra()).getProperty("licenseType"));
            hashMap.put("nofApplications", e2.i() == Integer.MAX_VALUE ? "unlimited" : "" + e2.i());
            hashMap.put("nofClients", e2.h() == Integer.MAX_VALUE ? "unlimited" : "" + e2.h());
            hashMap.put("inflow", e2.j() == Integer.MAX_VALUE ? "unlimited" : String.format("%d MB", e2.j()));
            String string = ((Properties)licenseContent.getExtra()).getProperty("id");
            hashMap.put("licenseID", string == null ? "-" : string);
            switch (e2.l()) {
                case a: {
                    hashMap.put("maintPeriod", String.format("<font color='green'>support for this license will end on %s</font>", simpleDateFormat.format(e2.k())));
                    break;
                }
                case b: {
                    hashMap.put("maintPeriod", String.format("<span class='blinkwarn'>support for this license expires on %s</span> <a target='new' href='%s'>Click here to make an enquiry</a>", simpleDateFormat.format(e2.k()), System.getProperty("com.moonlit.logfaces.url.support", "https://moonlits.atlassian.net/servicedesk/customer/portals")));
                    break;
                }
                case c: {
                    hashMap.put("maintPeriod", String.format("<font color='red'>support for this license is expired on %s</font> <a target='new' href='%s'>Click here to make an enquiry</a>", simpleDateFormat.format(e2.k()), System.getProperty("com.moonlit.logfaces.url.support", "https://moonlits.atlassian.net/servicedesk/customer/portals")));
                }
            }
        } else {
            hashMap.put("licenseType", "no license");
            hashMap.put("licenseID", "");
            hashMap.put("licenseHolder", "");
            hashMap.put("validUntil", "");
            hashMap.put("validSince", "");
            hashMap.put("maintPeriod", "");
            hashMap.put("nofApplications", "");
            hashMap.put("nofClients", "");
            hashMap.put("inflow", "");
        }
        return new ModelAndView("license", "params", hashMap);
    }

    @RequestMapping(value={"/licenseInstall"}, method={RequestMethod.POST})
    public void install(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (d.P()) {
            throw new Exception("This server instance is immutable");
        }
        httpServletRequest.getSession().setAttribute("licenseInstallMessage", null);
        DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
        ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)diskFileItemFactory);
        List list = servletFileUpload.parseRequest(httpServletRequest);
        FileItem fileItem = (FileItem)list.iterator().next();
        if (fileItem == null) {
            throw new Exception("invalid content");
        }
        byte[] byArray = fileItem.get();
        if (byArray == null || byArray.length == 0) {
            throw new Exception("invalid content");
        }
        com.moonlit.logfaces.server.l.e.a().a(byArray);
        this.log.info("new license installed successfully");
        Result result = new Result();
        result.addLink("licenseTab", "Continue");
        httpServletRequest.getSession().setAttribute("result", (Object)result);
        result.setInfo("License is installed successfully, thank you for using logFaces!" + (!e.a().e() ? "<br>Please start the engine from status tab." : ""));
        httpServletResponse.sendRedirect("result");
    }

    @ExceptionHandler(value={Exception.class})
    public ModelAndView handleError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Exception exception) {
        this.log.error(exception.getMessage(), (Throwable)exception);
        Result result = new Result();
        result.addLink("licenseTab", "Continue");
        result.setError(d.P() ? "This server instance is immutable" : "This license is invalid");
        httpServletRequest.getSession().setAttribute("result", (Object)result);
        try {
            httpServletResponse.sendRedirect("result");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

