/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.admin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.moonlit.logfaces.server.admin.Command;
import com.moonlit.logfaces.server.admin.Command$STATUS;
import com.moonlit.logfaces.server.admin.CommandApplyMongoSettings;
import com.moonlit.logfaces.server.admin.JsonController$1;
import com.moonlit.logfaces.server.admin.JsonController$2;
import com.moonlit.logfaces.server.admin.JsonController$3;
import com.moonlit.logfaces.server.admin.WebUtils;
import com.moonlit.logfaces.server.admin.models.DestinationModel;
import com.moonlit.logfaces.server.admin.models.FloodDetectorModel;
import com.moonlit.logfaces.server.admin.models.OptionModel;
import com.moonlit.logfaces.server.admin.models.PairModel;
import com.moonlit.logfaces.server.admin.models.PivotNodeModel;
import com.moonlit.logfaces.server.admin.models.PluginModel;
import com.moonlit.logfaces.server.admin.models.ReceiverModel;
import com.moonlit.logfaces.server.admin.models.ReportModel;
import com.moonlit.logfaces.server.admin.models.TriggerModel;
import com.moonlit.logfaces.server.b.f;
import com.moonlit.logfaces.server.c.u;
import com.moonlit.logfaces.server.conf.DestinationAlert;
import com.moonlit.logfaces.server.conf.DestinationEmail;
import com.moonlit.logfaces.server.conf.DestinationPlugin;
import com.moonlit.logfaces.server.conf.DestinationSlack;
import com.moonlit.logfaces.server.conf.DestinationWebHook;
import com.moonlit.logfaces.server.conf.b;
import com.moonlit.logfaces.server.conf.k;
import com.moonlit.logfaces.server.conf.n;
import com.moonlit.logfaces.server.core.A;
import com.moonlit.logfaces.server.core.D;
import com.moonlit.logfaces.server.core.LfsEvent;
import com.moonlit.logfaces.server.core.g;
import com.moonlit.logfaces.server.core.t;
import com.moonlit.logfaces.server.core.x;
import com.moonlit.logfaces.server.core.z;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.JexlCriteria;
import com.moonlit.logfaces.server.d;
import com.moonlit.logfaces.server.database.E;
import com.moonlit.logfaces.server.database.w;
import com.moonlit.logfaces.server.e;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import com.moonlit.logfaces.server.receivers.C;
import com.moonlit.logfaces.server.receivers.a;
import com.moonlit.logfaces.server.receivers.c;
import com.moonlit.logfaces.server.receivers.h;
import com.moonlit.logfaces.server.receivers.i;
import com.moonlit.logfaces.server.receivers.j;
import com.moonlit.logfaces.server.receivers.l;
import com.moonlit.logfaces.server.receivers.m;
import com.moonlit.logfaces.server.receivers.o;
import com.moonlit.logfaces.server.receivers.r;
import com.moonlit.logfaces.server.remoting.LfsService;
import com.moonlit.logfaces.server.reports.ReportJob;
import com.moonlit.logfaces.server.updates.LfsInstaller;
import com.moonlit.logfaces.server.util.Revision;
import com.moonlit.logfaces.server.util.s;
import com.moonlit.logfaces.server.util.v;
import com.moonlit.logfaces.server.util.y;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.quartz.CronExpression;
import org.springframework.context.annotation.Scope;
import org.springframework.core.io.FileSystemResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@Scope(value="session")
@RequestMapping(value={""})
public class JsonController {
    private static final Logger log = LogManager.getLogger(JsonController.class);
    private String successView = "jsonView";
    private j hub = j.i();
    private e engine = e.a();
    private com.moonlit.logfaces.server.database.r dbx = com.moonlit.logfaces.server.database.r.a();
    private com.moonlit.logfaces.server.conf.d cfg = com.moonlit.logfaces.server.conf.d.a();
    private com.moonlit.logfaces.server.access.d authorizer = com.moonlit.logfaces.server.access.d.a();
    private com.moonlit.logfaces.server.e.l trigs = com.moonlit.logfaces.server.e.l.a();
    private com.moonlit.logfaces.server.reports.a reps = com.moonlit.logfaces.server.reports.a.a();
    private i flood = i.b();

    @RequestMapping(value={"/rest"})
    public ModelAndView handleRestCall(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = WebUtils.getParameter(httpServletRequest, "method");
        if ("getReceiverOptions".equalsIgnoreCase(string)) {
            return this.getReceiverOptions(httpServletRequest, httpServletResponse);
        }
        if ("addReceiver".equalsIgnoreCase(string)) {
            return this.addReceiver(httpServletRequest, httpServletResponse);
        }
        if ("testReceiver".equalsIgnoreCase(string)) {
            return this.testReceiver(httpServletRequest, httpServletResponse);
        }
        if ("generateTestMessage".equalsIgnoreCase(string)) {
            return this.generateTestMessage(httpServletRequest, httpServletResponse);
        }
        if ("updatePatterns".equalsIgnoreCase(string)) {
            return this.updatePatterns(httpServletRequest, httpServletResponse);
        }
        if ("testRegex".equalsIgnoreCase(string)) {
            return this.testRegex(httpServletRequest, httpServletResponse);
        }
        if ("setBlackList".equalsIgnoreCase(string)) {
            return this.setBlackList(httpServletRequest, httpServletResponse);
        }
        if ("pair".equalsIgnoreCase(string)) {
            return this.pair(httpServletRequest, httpServletResponse);
        }
        if ("unpair".equalsIgnoreCase(string)) {
            return this.unpair(httpServletRequest, httpServletResponse);
        }
        if ("getPairs".equalsIgnoreCase(string)) {
            return this.getPairs(httpServletRequest, httpServletResponse);
        }
        if ("syncPairConfig".equalsIgnoreCase(string)) {
            return this.syncPairConfig(httpServletRequest, httpServletResponse);
        }
        if ("getHelp".equalsIgnoreCase(string)) {
            return this.getHelp(httpServletRequest, httpServletResponse);
        }
        if ("getHints".equalsIgnoreCase(string)) {
            return this.getHints(httpServletRequest, httpServletResponse);
        }
        if ("control".equalsIgnoreCase(string)) {
            return this.handleControl(httpServletRequest, httpServletResponse);
        }
        if ("addMdc".equalsIgnoreCase(string)) {
            return this.addMdc(httpServletRequest, httpServletResponse);
        }
        if ("removeMdc".equalsIgnoreCase(string)) {
            return this.removeMdc(httpServletRequest, httpServletResponse);
        }
        if ("updateMdc".equalsIgnoreCase(string)) {
            return this.updateMdc(httpServletRequest, httpServletResponse);
        }
        if ("updateRepo".equalsIgnoreCase(string)) {
            return this.updateRepo(httpServletRequest, httpServletResponse);
        }
        if ("updateHosts".equalsIgnoreCase(string)) {
            return this.updateHosts(httpServletRequest, httpServletResponse);
        }
        if ("updateLevel".equalsIgnoreCase(string)) {
            return this.updateLevel(httpServletRequest, httpServletResponse);
        }
        if ("removeLevel".equalsIgnoreCase(string)) {
            return this.removeLevel(httpServletRequest, httpServletResponse);
        }
        if ("enableAuthorization".equalsIgnoreCase(string)) {
            return this.enableAuthorization(httpServletRequest, httpServletResponse);
        }
        if ("listGroups".equalsIgnoreCase(string)) {
            return this.listGroups(httpServletRequest, httpServletResponse);
        }
        if ("importGroups".equalsIgnoreCase(string)) {
            return this.importGroups(httpServletRequest, httpServletResponse);
        }
        if ("removeGroup".equalsIgnoreCase(string)) {
            return this.removeGroup(httpServletRequest, httpServletResponse);
        }
        if ("updateGroup".equalsIgnoreCase(string)) {
            return this.updateGroup(httpServletRequest, httpServletResponse);
        }
        if ("clearGroups".equalsIgnoreCase(string)) {
            return this.clearGroups(httpServletRequest, httpServletResponse);
        }
        if ("updateDb".equalsIgnoreCase(string)) {
            return this.updateDb(httpServletRequest, httpServletResponse);
        }
        if ("updateMongo".equalsIgnoreCase(string)) {
            return this.updateMongo(httpServletRequest, httpServletResponse);
        }
        if ("updateBQ".equalsIgnoreCase(string)) {
            return this.updateBQ(httpServletRequest, httpServletResponse);
        }
        if ("updateDbCriteria".equalsIgnoreCase(string)) {
            return this.updateDbCriteria(httpServletRequest, httpServletResponse);
        }
        if ("updateEmail".equalsIgnoreCase(string)) {
            return this.updateEmail(httpServletRequest, httpServletResponse);
        }
        if ("testEmail".equalsIgnoreCase(string)) {
            return this.testEmail(httpServletRequest, httpServletResponse);
        }
        if ("updateReport".equalsIgnoreCase(string)) {
            return this.updateReport(httpServletRequest, httpServletResponse);
        }
        if ("addReport".equalsIgnoreCase(string)) {
            return this.addReport(httpServletRequest, httpServletResponse);
        }
        if ("testReport".equalsIgnoreCase(string)) {
            return this.testReport(httpServletRequest, httpServletResponse);
        }
        if ("addTrigger".equalsIgnoreCase(string)) {
            return this.addTrigger(httpServletRequest, httpServletResponse);
        }
        if ("addFloodDetector".equalsIgnoreCase(string)) {
            return this.addFloodDetector(httpServletRequest, httpServletResponse);
        }
        if ("updateFloodDetector".equalsIgnoreCase(string)) {
            return this.updateFloodDetector(httpServletRequest, httpServletResponse);
        }
        if ("updateTrigger".equalsIgnoreCase(string)) {
            return this.updateTrigger(httpServletRequest, httpServletResponse);
        }
        if ("getTriggerDestinations".equalsIgnoreCase(string)) {
            return this.getTriggerDestinations(httpServletRequest, httpServletResponse);
        }
        if ("getTriggerDestination".equalsIgnoreCase(string)) {
            return this.getTriggerDestination(httpServletRequest, httpServletResponse);
        }
        if ("updateTriggerDestination".equalsIgnoreCase(string)) {
            return this.updateTriggerDestination(httpServletRequest, httpServletResponse);
        }
        if ("removeTriggerDestination".equalsIgnoreCase(string)) {
            return this.removeTriggerDestination(httpServletRequest, httpServletResponse);
        }
        if ("listPlugins".equalsIgnoreCase(string)) {
            return this.listPlugins(httpServletRequest, httpServletResponse);
        }
        if ("addPlugin".equalsIgnoreCase(string)) {
            return this.addPlugin(httpServletRequest, httpServletResponse);
        }
        if ("removePlugin".equalsIgnoreCase(string)) {
            return this.removePlugin(httpServletRequest, httpServletResponse);
        }
        if ("updatePlugin".equalsIgnoreCase(string)) {
            return this.updatePlugin(httpServletRequest, httpServletResponse);
        }
        if ("getPluginArgs".equalsIgnoreCase(string)) {
            return this.getPluginArgs(httpServletRequest, httpServletResponse);
        }
        if ("testPlugin".equalsIgnoreCase(string)) {
            return this.testPlugin(httpServletRequest, httpServletResponse);
        }
        if ("addPivotNode".equalsIgnoreCase(string)) {
            return this.addPivotNode(httpServletRequest, httpServletResponse);
        }
        if ("updatePivotNode".equalsIgnoreCase(string)) {
            return this.updatePivotNode(httpServletRequest, httpServletResponse);
        }
        if ("getPivotNode".equalsIgnoreCase(string)) {
            return this.getPivotNode(httpServletRequest, httpServletResponse);
        }
        if ("movePivotNode".equalsIgnoreCase(string)) {
            return this.movePivotNode(httpServletRequest, httpServletResponse);
        }
        if ("removePivotNode".equalsIgnoreCase(string)) {
            return this.removePivotNode(httpServletRequest, httpServletResponse);
        }
        if ("togglePivotNode".equalsIgnoreCase(string)) {
            return this.togglePivotNode(httpServletRequest, httpServletResponse);
        }
        if ("importKeyStoreCert".equalsIgnoreCase(string)) {
            return this.importKeyStoreCert(httpServletRequest, httpServletResponse);
        }
        if ("importTrustStoreCert".equalsIgnoreCase(string)) {
            return this.importTrustStoreCert(httpServletRequest, httpServletResponse);
        }
        if ("clearKeyStore".equalsIgnoreCase(string)) {
            return this.clearKeyStore(httpServletRequest, httpServletResponse);
        }
        if ("remove".equalsIgnoreCase(string)) {
            return this.remove(httpServletRequest, httpServletResponse);
        }
        if ("enable".equalsIgnoreCase(string)) {
            return this.enable(httpServletRequest, httpServletResponse);
        }
        if ("enableAll".equalsIgnoreCase(string)) {
            return this.enableAll(httpServletRequest, httpServletResponse);
        }
        if ("version".equalsIgnoreCase(string)) {
            return this.getVersion(httpServletRequest, httpServletResponse);
        }
        throw new Exception(String.format("call '%s' is not supported", string));
    }

    private ModelAndView getReceiverOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ArrayList arrayList;
        httpServletRequest.getSession().setAttribute("subtab", (Object)1);
        String string = WebUtils.getParameter(httpServletRequest, "id");
        ArrayList arrayList2 = Lists.newArrayList();
        ArrayList arrayList3 = arrayList = com.moonlit.logfaces.server.util.e.a() ? Lists.newArrayList((Object[])new String[]{"tcp", "ssl", "udp"}) : Lists.newArrayList((Object[])new String[]{"tcp", "udp"});
        if (StringUtils.isEmpty((CharSequence)string)) {
            String string2 = WebUtils.getParameter(httpServletRequest, "type");
            switch (com.moonlit.logfaces.server.core.C.valueOf(string2)) {
                case a: {
                    arrayList2.add(new OptionModel("Enabled", "enabled", "Yes", Lists.newArrayList((Object[])new String[]{"Yes", "No"}), "Enable or disable this receiver"));
                    arrayList2.add(new OptionModel("Description", "description", "My applications", "For management purposes"));
                    arrayList2.add(new OptionModel("Protocol", "protocol", z.a.name(), arrayList, "Transport protocol"));
                    arrayList2.add(new OptionModel("Format", "format", A.a.name(), A.a(), "Serialization format", "conn.format"));
                    arrayList2.add(new OptionModel("Address", "host", "any-address", v.a(), "Binding local address", "conn.address"));
                    arrayList2.add(new OptionModel("Port", "port", "55200", null, "Listeneing port number", "rx.log4j.port"));
                    arrayList2.add(new OptionModel("Time", "time", "source", Lists.newArrayList((Object[])new String[]{"source", "server"}), "Which time stamp to use", "rx.time"));
                    arrayList2.add(new OptionModel("Application", EventAttribute.domainName.name(), "", null, "Enforce application name", "rx.log4j.app"));
                    break;
                }
                case b: {
                    arrayList2.add(new OptionModel("Enabled", "enabled", "Yes", Lists.newArrayList((Object[])new String[]{"Yes", "No"}), "Enable or disable this receiver "));
                    arrayList2.add(new OptionModel("Description", "description", "My appliences", "For management purposes"));
                    arrayList2.add(new OptionModel("Protocol", "protocol", z.b.name(), arrayList, "Listeneing protocol"));
                    arrayList2.add(new OptionModel("Address", "host", "any-address", v.a(), "Binding local address", "conn.address"));
                    arrayList2.add(new OptionModel("Port", "port", "514", "Listeneing port number"));
                    arrayList2.add(new OptionModel("Pattern", "pattern", "", "Use pattern to parse", "rx.syslog.pattern"));
                    arrayList2.add(new OptionModel("Time", "time", "source", Lists.newArrayList((Object[])new String[]{"source", "server"}), "Which time stamp to use", "rx.time"));
                    arrayList2.add(new OptionModel("Application", EventAttribute.domainName.name(), "", "Default application name", "rx.syslog.domain"));
                    arrayList2.add(new OptionModel("Host resolver", "lookup", "Do nothing", com.moonlit.logfaces.server.core.i.a(), "How to resolve host names", "rx.syslog.lookup"));
                    arrayList2.add(new OptionModel("Debug", "debug", "No", Lists.newArrayList((Object[])new String[]{"Yes", "No"}), "Trace reception", "rx.syslog.debug"));
                    break;
                }
                case d: {
                    arrayList2.add(new OptionModel("Enabled", "enabled", "Yes", Lists.newArrayList((Object[])new String[]{"Yes", "No"}), "Enable or disable this receiver"));
                    arrayList2.add(new OptionModel("Description", "description", "My web apps", "For management purposes"));
                    arrayList2.add(new OptionModel("Format", "format", A.b.name(), A.a(), "Serialization format", "conn.format"));
                    arrayList2.add(new OptionModel("Path", "path", "rx1", "Servlet mapping", "conn.servlet.path"));
                    arrayList2.add(new OptionModel("Time", "time", "source", Lists.newArrayList((Object[])new String[]{"source", "server"}), "Which time stamp to use", "rx.time"));
                    arrayList2.add(new OptionModel("Application", EventAttribute.domainName.name(), "", null, "Enforce application name", "rx.log4j.app"));
                    break;
                }
                case c: {
                    arrayList2.add(new OptionModel("Enabled", "enabled", "Yes", Lists.newArrayList((Object[])new String[]{"Yes", "No"}), "Enable or disable this location"));
                    arrayList2.add(new OptionModel("Description", "description", "My logs", "For management purposes"));
                    arrayList2.add(new OptionModel("Directory", "location", "/drop1", "Drop location", "rx.dz.location"));
                    arrayList2.add(new OptionModel("CRC size", "crcLen", "512", "Size of header and footer in bytes", "rx.dz.crcsize"));
                    arrayList2.add(new OptionModel("Pattern", "pattern", "", "Pattern", "rx.dz.pattern"));
                    arrayList2.add(new OptionModel("X Pattern", "xpattern", "", "Exceptions pattern", "rx.dz.xpattern"));
                    arrayList2.add(new OptionModel("Time format", "dtf", "dd MMM yyyy HH:mm:ss", "Time format", "rx.dz.dtf"));
                    arrayList2.add(new OptionModel("Application", EventAttribute.domainName.name(), "", "Application name", "rx.dz.defaults"));
                    arrayList2.add(new OptionModel("Host", EventAttribute.hostName.name(), "", "Host name", "rx.dz.defaults"));
                    arrayList2.add(new OptionModel("Logger", EventAttribute.loggerName.name(), "", "Logger name", "rx.dz.defaults"));
                }
            }
            return new ModelAndView(this.successView, "options", (Object)arrayList2);
        }
        com.moonlit.logfaces.server.core.u u2 = this.hub.b(string);
        if (u2 == null) {
            throw new Exception("Receiver is not found, please refresh the page and try again");
        }
        n n2 = u2.c();
        switch (u2.d()) {
            case a: {
                arrayList2.add(new OptionModel("Enabled", "enabled", n2.getBoolean("enabled", false) ? "Yes" : "No", Lists.newArrayList((Object[])new String[]{"Yes", "No"}), "Enable or disable this receiver "));
                arrayList2.add(new OptionModel("Description", "description", n2.getString("description", ""), "For management purposes"));
                arrayList2.add(new OptionModel("Protocol", "protocol", n2.getString("protocol", z.a.name()), arrayList, "Transport protocol"));
                arrayList2.add(new OptionModel("Format", "format", n2.getString("format", A.a.name()), A.a(), "Serialization format", "conn.format"));
                arrayList2.add(new OptionModel("Address", "host", n2.getString("host"), v.a(), "Binding local address", "conn.address"));
                arrayList2.add(new OptionModel("Port", "port", "" + n2.getInt("port", 55201), "Listeneing port number", "rx.log4j.port"));
                arrayList2.add(new OptionModel("Time", "time", n2.getString("time", "source"), Lists.newArrayList((Object[])new String[]{"source", "server"}), "Which time stamp to use", "rx.time"));
                arrayList2.add(new OptionModel("Application", EventAttribute.domainName.name(), n2.getString(EventAttribute.domainName.name(), ""), "Enforce application name", "rx.log4j.app"));
                break;
            }
            case b: {
                arrayList2.add(new OptionModel("Enabled", "enabled", n2.getBoolean("enabled") ? "Yes" : "No", Lists.newArrayList((Object[])new String[]{"Yes", "No"}), "Enable or disable this receiver"));
                arrayList2.add(new OptionModel("Description", "description", n2.getString("description", ""), "For management purposes"));
                arrayList2.add(new OptionModel("Protocol", "protocol", n2.getString("protocol", "tcp"), arrayList, "Transport protocol"));
                arrayList2.add(new OptionModel("Address", "host", n2.getString("host"), v.a(), "Binding local address", "conn.address"));
                arrayList2.add(new OptionModel("Port", "port", "" + n2.getInt("port", 514), "Listeneing port number"));
                arrayList2.add(new OptionModel("Pattern", "pattern", n2.getString("pattern", ""), "Use pattern to parse", "rx.syslog.pattern"));
                arrayList2.add(new OptionModel("Time", "time", n2.getString("time", "source"), Lists.newArrayList((Object[])new String[]{"source", "server"}), "Which time stamp to use", "rx.time"));
                arrayList2.add(new OptionModel("Application", EventAttribute.domainName.name(), n2.getString(EventAttribute.domainName.name(), ""), "Default application name", "rx.syslog.domain"));
                arrayList2.add(new OptionModel("Host resolver", "lookup", n2.getString("lookup", "none"), com.moonlit.logfaces.server.core.i.a(), "How to resolve host names", "rx.syslog.lookup"));
                arrayList2.add(new OptionModel("Debug", "debug", n2.getBoolean("debug") ? "Yes" : "No", Lists.newArrayList((Object[])new String[]{"Yes", "No"}), "Trace reception", "rx.syslog.debug"));
                break;
            }
            case d: {
                arrayList2.add(new OptionModel("Enabled", "enabled", n2.getBoolean("enabled", false) ? "Yes" : "No", Lists.newArrayList((Object[])new String[]{"Yes", "No"}), "Enable or disable this receiver "));
                arrayList2.add(new OptionModel("Description", "description", n2.getString("description", ""), "For management purposes"));
                arrayList2.add(new OptionModel("Format", "format", n2.getString("format", A.a.name()), A.a(), "Serialization format", "conn.format"));
                arrayList2.add(new OptionModel("Path", "path", n2.getString("path", "rx1"), "Servlet mapping", "conn.servlet.path"));
                arrayList2.add(new OptionModel("Time", "time", n2.getString("time", "source"), Lists.newArrayList((Object[])new String[]{"source", "server"}), "Which time stamp to use", "rx.time"));
                arrayList2.add(new OptionModel("Application", EventAttribute.domainName.name(), n2.getString(EventAttribute.domainName.name(), ""), "Enforce application name", "rx.log4j.app"));
                break;
            }
            case c: {
                arrayList2.add(new OptionModel("Enabled", "enabled", n2.getBoolean("enabled") ? "Yes" : "No", Lists.newArrayList((Object[])new String[]{"Yes", "No"}), "Enable or disable this location"));
                arrayList2.add(new OptionModel("Description", "description", n2.getString("description", ""), "For management purposes"));
                arrayList2.add(new OptionModel("Directory", "location", n2.getString("location", ""), "Drop location", "rx.dz.location"));
                arrayList2.add(new OptionModel("CRC size", "crcLen", n2.getString("crcLen", "512"), "Size of header and footer in bytes", "rx.dz.crcsize"));
                arrayList2.add(new OptionModel("Pattern", "pattern", n2.getString("pattern", ""), "Pattern", "rx.dz.pattern"));
                arrayList2.add(new OptionModel("X Pattern", "xpattern", n2.getString("xpattern", ""), "Exceptions pattern", "rx.dz.xpattern"));
                arrayList2.add(new OptionModel("Time format", "dtf", n2.getString("dtf", ""), "Time format", "rx.dz.dtf"));
                arrayList2.add(new OptionModel("Application", EventAttribute.domainName.name(), n2.getString(EventAttribute.domainName.name(), ""), "Application name", "rx.dz.defaults"));
                arrayList2.add(new OptionModel("Host", EventAttribute.hostName.name(), n2.getString(EventAttribute.hostName.name(), ""), "Host name", "rx.dz.defaults"));
                arrayList2.add(new OptionModel("Logger", EventAttribute.loggerName.name(), n2.getString(EventAttribute.loggerName.name(), ""), "Logger name", "rx.dz.defaults"));
            }
        }
        return new ModelAndView(this.successView, "options", (Object)arrayList2);
    }

    private ModelAndView addReceiver(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        log.info("adding receiver");
        httpServletRequest.getSession().setAttribute("subtab", (Object)1);
        com.moonlit.logfaces.server.core.u u2 = this.validateReceiver(httpServletRequest);
        if (u2 != null) {
            return this.updateReceiver(httpServletRequest, httpServletResponse);
        }
        String string = WebUtils.getParameter(httpServletRequest, "type");
        n n2 = new n();
        n2.setProperty("type", string);
        switch (com.moonlit.logfaces.server.core.C.valueOf(string)) {
            case a: {
                n2.setProperty("enabled", WebUtils.getBoolean(httpServletRequest, "enabled", "yes"));
                n2.setProperty("description", WebUtils.getParameter(httpServletRequest, "description"));
                n2.setProperty("protocol", WebUtils.getParameter(httpServletRequest, "protocol"));
                n2.setProperty("format", WebUtils.getParameter(httpServletRequest, "format"));
                n2.setProperty("host", WebUtils.getParameter(httpServletRequest, "host"));
                n2.setProperty("port", WebUtils.getInt(httpServletRequest, "port", 0));
                n2.setProperty("time", WebUtils.getParameter(httpServletRequest, "time"));
                n2.setProperty(EventAttribute.domainName.name(), WebUtils.getParameter(httpServletRequest, EventAttribute.domainName.name()));
                break;
            }
            case b: {
                n2.setProperty("enabled", WebUtils.getBoolean(httpServletRequest, "enabled", "yes"));
                n2.setProperty("description", WebUtils.getParameter(httpServletRequest, "description"));
                n2.setProperty("protocol", WebUtils.getParameter(httpServletRequest, "protocol"));
                n2.setProperty("host", WebUtils.getParameter(httpServletRequest, "host"));
                n2.setProperty("port", WebUtils.getInt(httpServletRequest, "port", 0));
                n2.setProperty("pattern", WebUtils.getParameter(httpServletRequest, "pattern"));
                n2.setProperty("time", WebUtils.getParameter(httpServletRequest, "time"));
                n2.setProperty("lookup", WebUtils.getParameter(httpServletRequest, "lookup"));
                n2.setProperty(EventAttribute.domainName.name(), WebUtils.getParameter(httpServletRequest, EventAttribute.domainName.name()));
                n2.setProperty("debug", "yes".equalsIgnoreCase(WebUtils.getParameter(httpServletRequest, "debug")));
                break;
            }
            case d: {
                n2.setProperty("enabled", WebUtils.getBoolean(httpServletRequest, "enabled", "yes"));
                n2.setProperty("description", WebUtils.getParameter(httpServletRequest, "description"));
                n2.setProperty("format", WebUtils.getParameter(httpServletRequest, "format"));
                n2.setProperty("path", WebUtils.getParameter(httpServletRequest, "path"));
                n2.setProperty("time", WebUtils.getParameter(httpServletRequest, "time"));
                n2.setProperty(EventAttribute.domainName.name(), WebUtils.getParameter(httpServletRequest, EventAttribute.domainName.name()));
                break;
            }
            case c: {
                n2.setProperty("enabled", WebUtils.getBoolean(httpServletRequest, "enabled", "yes"));
                n2.setProperty("description", WebUtils.getParameter(httpServletRequest, "description"));
                n2.setProperty("protocol", z.d.name());
                n2.setProperty("location", WebUtils.getParameter(httpServletRequest, "location"));
                n2.setProperty("crcLen", WebUtils.getParameter(httpServletRequest, "crcLen"));
                n2.setProperty("pattern", WebUtils.getParameter(httpServletRequest, "pattern"));
                n2.setProperty("xpattern", WebUtils.getParameter(httpServletRequest, "xpattern"));
                n2.setProperty("dtf", WebUtils.getParameter(httpServletRequest, "dtf"));
                n2.setProperty(EventAttribute.domainName.name(), WebUtils.getParameter(httpServletRequest, EventAttribute.domainName.name()));
                n2.setProperty(EventAttribute.hostName.name(), WebUtils.getParameter(httpServletRequest, EventAttribute.hostName.name()));
                n2.setProperty(EventAttribute.loggerName.name(), WebUtils.getParameter(httpServletRequest, EventAttribute.loggerName.name()));
                n2.setProperty(EventAttribute.threadName.name(), WebUtils.getParameter(httpServletRequest, EventAttribute.threadName.name()));
            }
        }
        this.hub.a(n2);
        this.hub.g();
        return new ModelAndView(this.successView, "response", (Object)"ok");
    }

    private ModelAndView remove(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        String string = WebUtils.getParameter(httpServletRequest, "object");
        String string2 = WebUtils.getParameter(httpServletRequest, "id");
        log.info(String.format("removing %s (%s)", string, string2));
        if ("receiver".equals(string)) {
            httpServletRequest.getSession().setAttribute("subtab", (Object)1);
            this.hub.a(string2);
            this.hub.g();
        } else if ("report".equals(string)) {
            this.reps.c(Long.parseLong(string2));
            this.cfg.f();
        } else if ("trigger".equals(string)) {
            this.trigs.c(Long.parseLong(string2));
            this.cfg.f();
        } else if ("flood".equals(string)) {
            this.flood.a(Long.parseLong(string2));
            this.cfg.f();
        }
        return new ModelAndView(this.successView, "response", (Object)"ok");
    }

    private ModelAndView enable(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        String string = WebUtils.getParameter(httpServletRequest, "object");
        String string2 = WebUtils.getParameter(httpServletRequest, "id");
        log.info(String.format("toggling %s (%s)", string, string2));
        if ("receiver".equals(string)) {
            com.moonlit.logfaces.server.core.u u2 = this.hub.b(string2);
            if (u2 == null) {
                throw new Exception("no receiver");
            }
            n n2 = u2.c().a();
            boolean bl = u2.f();
            n2.setProperty("enabled", !bl);
            u2.a(n2);
            this.hub.g();
            return new ModelAndView(this.successView, "object", (Object)new ReceiverModel(u2));
        }
        if ("report".equals(string)) {
            com.moonlit.logfaces.server.reports.b b2;
            b2.a(!(b2 = this.reps.a(Long.parseLong(string2))).f());
            this.reps.a(b2);
            this.cfg.f();
            return new ModelAndView(this.successView, "object", (Object)new ReportModel(b2));
        }
        if ("trigger".equals(string)) {
            com.moonlit.logfaces.server.e.o o2 = this.trigs.b(Long.parseLong(string2));
            if (!o2.f() && o2.r().isEmpty()) {
                throw new IllegalStateException("this trigger has no defined destinations");
            }
            o2.a(!o2.f());
            this.trigs.a(o2);
            this.cfg.f();
            return new ModelAndView(this.successView, "object", (Object)new TriggerModel(o2, this.trigs.d(o2.i())));
        }
        if ("flood".equals(string)) {
            h h2;
            h2.a(!(h2 = this.flood.b((long)Integer.parseInt(string2))).b());
            this.cfg.f();
            return new ModelAndView(this.successView, "object", (Object)new FloodDetectorModel(h2));
        }
        throw new Exception("not supported object type");
    }

    private ModelAndView enableAll(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        String string = WebUtils.getParameter(httpServletRequest, "object");
        boolean bl = WebUtils.getBoolean(httpServletRequest, "enable", "true");
        log.info(String.format("%s %ss", bl ? "Enabling all " : "Disabling all", string));
        if ("receiver".equals(string)) {
            for (com.moonlit.logfaces.server.core.u u2 : this.hub.f()) {
                if (bl == u2.f()) continue;
                n n2 = u2.c().a();
                n2.setProperty("enabled", bl);
                u2.a(n2);
            }
            this.hub.g();
        } else if ("report".equals(string)) {
            for (com.moonlit.logfaces.server.reports.b b2 : this.reps.e()) {
                b2.a(bl);
                this.reps.a(b2);
            }
            this.cfg.f();
        } else if ("trigger".equals(string)) {
            for (com.moonlit.logfaces.server.e.o o2 : this.trigs.g()) {
                o2.a(bl);
                this.trigs.a(o2);
            }
            this.cfg.f();
        } else if ("alert".equals(string)) {
            com.moonlit.logfaces.server.e.a.a().a((List)null);
        } else if ("flood".equals(string)) {
            for (h h2 : this.flood.e()) {
                h2.a(bl);
            }
            this.cfg.f();
        }
        return new ModelAndView(this.successView, "response", (Object)"OK");
    }

    private ModelAndView updateReceiver(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        log.info("updating receiver");
        httpServletRequest.getSession().setAttribute("subtab", (Object)1);
        com.moonlit.logfaces.server.core.u u2 = this.validateReceiver(httpServletRequest);
        if (u2 == null) {
            throw new Exception("No receiver found");
        }
        n n2 = u2.c().a();
        switch (u2.d()) {
            case a: {
                n2.setProperty("enabled", WebUtils.getBoolean(httpServletRequest, "enabled", "yes"));
                n2.setProperty("description", WebUtils.getParameter(httpServletRequest, "description"));
                n2.setProperty("protocol", WebUtils.getParameter(httpServletRequest, "protocol"));
                n2.setProperty("format", WebUtils.getParameter(httpServletRequest, "format"));
                n2.setProperty("host", WebUtils.getParameter(httpServletRequest, "host"));
                n2.setProperty("port", WebUtils.getInt(httpServletRequest, "port", 0));
                n2.setProperty("time", WebUtils.getParameter(httpServletRequest, "time"));
                n2.setProperty(EventAttribute.domainName.name(), WebUtils.getParameter(httpServletRequest, EventAttribute.domainName.name()));
                n n3 = u2.c();
                if (n3.getString("protocol", "tcp").equals(n2.getString("protocol", "tcp")) && n3.getString("format", "xml").equals(n2.getString("format", "xml"))) break;
                this.hub.a(u2.a());
                this.hub.a(n2);
                this.hub.g();
                return new ModelAndView(this.successView, "response", (Object)"ok");
            }
            case b: {
                n2.setProperty("enabled", WebUtils.getBoolean(httpServletRequest, "enabled", "yes"));
                n2.setProperty("description", WebUtils.getParameter(httpServletRequest, "description"));
                n2.setProperty("protocol", WebUtils.getParameter(httpServletRequest, "protocol"));
                n2.setProperty("host", WebUtils.getParameter(httpServletRequest, "host"));
                n2.setProperty("port", WebUtils.getInt(httpServletRequest, "port", 0));
                n2.setProperty("pattern", WebUtils.getParameter(httpServletRequest, "pattern"));
                n2.setProperty("time", WebUtils.getParameter(httpServletRequest, "time"));
                n2.setProperty("lookup", WebUtils.getParameter(httpServletRequest, "lookup"));
                n2.setProperty(EventAttribute.domainName.name(), WebUtils.getParameter(httpServletRequest, EventAttribute.domainName.name()));
                n2.setProperty("debug", WebUtils.getBoolean(httpServletRequest, "debug", "yes"));
                if (u2.e().name().equals(n2.getString("protocol"))) break;
                this.hub.a(u2.a());
                this.hub.a(n2);
                this.hub.g();
                return new ModelAndView(this.successView, "response", (Object)"ok");
            }
            case d: {
                n2.setProperty("enabled", WebUtils.getBoolean(httpServletRequest, "enabled", "yes"));
                n2.setProperty("description", WebUtils.getParameter(httpServletRequest, "description"));
                n2.setProperty("format", WebUtils.getParameter(httpServletRequest, "format"));
                n2.setProperty("path", WebUtils.getParameter(httpServletRequest, "path"));
                n2.setProperty("time", WebUtils.getParameter(httpServletRequest, "time"));
                n2.setProperty(EventAttribute.domainName.name(), WebUtils.getParameter(httpServletRequest, EventAttribute.domainName.name()));
                break;
            }
            case c: {
                String string = n2.getString("location");
                n2.setProperty("enabled", WebUtils.getBoolean(httpServletRequest, "enabled", "yes"));
                n2.setProperty("description", WebUtils.getParameter(httpServletRequest, "description"));
                n2.setProperty("location", WebUtils.getParameter(httpServletRequest, "location"));
                n2.setProperty("crcLen", WebUtils.getParameter(httpServletRequest, "crcLen"));
                n2.setProperty("pattern", WebUtils.getParameter(httpServletRequest, "pattern"));
                n2.setProperty("xpattern", WebUtils.getParameter(httpServletRequest, "xpattern"));
                n2.setProperty("dtf", WebUtils.getParameter(httpServletRequest, "dtf"));
                n2.setProperty(EventAttribute.domainName.name(), WebUtils.getParameter(httpServletRequest, EventAttribute.domainName.name()));
                n2.setProperty(EventAttribute.hostName.name(), WebUtils.getParameter(httpServletRequest, EventAttribute.hostName.name()));
                n2.setProperty(EventAttribute.loggerName.name(), WebUtils.getParameter(httpServletRequest, EventAttribute.loggerName.name()));
                if (WebUtils.getParameter(httpServletRequest, "location").equals(string)) break;
                this.hub.a(u2.a());
                this.hub.a(n2);
                this.hub.g();
                return new ModelAndView(this.successView, "response", (Object)"ok");
            }
        }
        u2.a(n2);
        this.hub.g();
        return new ModelAndView(this.successView, "response", (Object)"ok");
    }

    private com.moonlit.logfaces.server.core.u validateReceiver(HttpServletRequest httpServletRequest) {
        String string = WebUtils.getParameter(httpServletRequest, "id");
        com.moonlit.logfaces.server.core.C c2 = null;
        com.moonlit.logfaces.server.core.u u2 = this.hub.b(string);
        c2 = u2 != null ? u2.d() : com.moonlit.logfaces.server.core.C.valueOf(WebUtils.getParameter(httpServletRequest, "type"));
        switch (c2) {
            case a: 
            case b: {
                int n2 = WebUtils.getInt(httpServletRequest, "port", 0);
                if (n2 <= 0 || n2 > 65535) {
                    throw new Exception("Port must be positive numeric value in range 1-65535");
                }
                try {
                    y.a().c(WebUtils.getParameter(httpServletRequest, "pattern"));
                    break;
                }
                catch (Exception exception) {
                    throw new Exception("Specified pattern doesn't appear to be a valid regular expression");
                }
            }
            case d: {
                String string2 = WebUtils.getParameter(httpServletRequest, "path");
                if (StringUtils.isEmpty((CharSequence)string2)) {
                    throw new Exception("Servlet mapping path must be specified");
                }
                for (com.moonlit.logfaces.server.core.u u3 : this.hub.f()) {
                    if (!u3.d().d() || u3.a().equals(string) || !u3.c().getString("path", "").equals(string2)) continue;
                    throw new Exception(String.format("Path '%s' is already mapped to by another receiver", string2));
                }
                break;
            }
            case c: {
                String string3 = WebUtils.getParameter(httpServletRequest, "location");
                for (com.moonlit.logfaces.server.core.u u4 : this.hub.f()) {
                    if (u4.a().equals(string) || !u4.c().getString("location", "").equals(httpServletRequest.getParameter("location"))) continue;
                    throw new Exception(String.format("Location %s is already monitored by another receiver", string3));
                }
                if (StringUtils.isEmpty((CharSequence)WebUtils.getParameter(httpServletRequest, "location"))) {
                    throw new Exception("Directory must be specified, for example /mydropzone1");
                }
                if (StringUtils.isEmpty((CharSequence)WebUtils.getParameter(httpServletRequest, "pattern"))) {
                    throw new Exception("Pattern must be specified for parsing the text");
                }
                try {
                    if (WebUtils.getInt(httpServletRequest, "crcLen", 0) <= 0) {
                        throw new Exception("CRC size must be positive numeric non zero value");
                    }
                }
                catch (Exception exception) {
                    throw new Exception("CRC size must be positive numeric non zero value");
                }
                try {
                    String string4 = WebUtils.getParameter(httpServletRequest, "dtf");
                    if (StringUtils.isEmpty((CharSequence)string4)) break;
                    new SimpleDateFormat(string4);
                    break;
                }
                catch (Exception exception) {
                    throw new Exception("Date time format doesn't seem to be known...");
                }
            }
        }
        return u2;
    }

    private ModelAndView generateTestMessage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        log.info("generating receiver test message");
        String string = WebUtils.getParameter(httpServletRequest, "id");
        com.moonlit.logfaces.server.core.u u2 = this.hub.b(string);
        if (u2 == null) {
            throw new Exception("no receiver");
        }
        String string2 = "";
        switch (u2.d()) {
            case a: {
                A a2 = A.valueOf(u2.c().getString("format"));
                switch (a2) {
                    case a: {
                        StringBuilder stringBuilder = new StringBuilder(256);
                        stringBuilder.append("<log4j:event logger=\"my.logger.name\"");
                        stringBuilder.append("\r\n      timestamp=\"13850538623072\"");
                        stringBuilder.append("\r\n      level=\"INFO\"");
                        stringBuilder.append("\r\n      thread=\"thread12345\"\r\n");
                        stringBuilder.append(">\r\n\r\n");
                        stringBuilder.append("  <log4j:message><![CDATA[hello world]]></log4j:message>\r\n\r\n");
                        stringBuilder.append("</log4j:event>\r\n");
                        string2 = stringBuilder.toString();
                        break;
                    }
                    case b: {
                        BasicDBObject basicDBObject = new BasicDBObject();
                        basicDBObject.put((Object)EventAttribute.loggerTimeStamp.toMongoColumn(), (Object)new Date().getTime());
                        basicDBObject.put((Object)EventAttribute.loggerLevel.toMongoColumn(), (Object)"INFO");
                        basicDBObject.put((Object)EventAttribute.threadName.toMongoColumn(), (Object)"thread12345");
                        basicDBObject.put((Object)EventAttribute.message.toMongoColumn(), (Object)"a test message");
                        basicDBObject.put((Object)EventAttribute.hostName.toMongoColumn(), (Object)"test-host");
                        basicDBObject.put((Object)EventAttribute.domainName.toMongoColumn(), (Object)"my-domain");
                        basicDBObject.put((Object)EventAttribute.loggerName.toMongoColumn(), (Object)"my.logger.name");
                        basicDBObject.put((Object)"p_user", (Object)"user1");
                        Gson gson = new GsonBuilder().setPrettyPrinting().create();
                        string2 = gson.toJson((Object)basicDBObject);
                        break;
                    }
                    case c: {
                        BasicDBObject basicDBObject = new BasicDBObject();
                        basicDBObject.put((Object)"timestamp", (Object)new Date().getTime());
                        basicDBObject.put((Object)"version", (Object)"1.1");
                        basicDBObject.put((Object)"host", (Object)"example.org");
                        basicDBObject.put((Object)"short_message", (Object)"shorty");
                        basicDBObject.put((Object)"full_message", (Object)"this is the full message");
                        basicDBObject.put((Object)"level", (Object)1);
                        basicDBObject.put((Object)"_user_id", (Object)12345);
                        basicDBObject.put((Object)"_some_info", (Object)"foo");
                        basicDBObject.put((Object)"_some_env_var", (Object)"bar");
                        Gson gson = new GsonBuilder().setPrettyPrinting().create();
                        string2 = gson.toJson((Object)basicDBObject);
                    }
                }
                break;
            }
            case b: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd HH:mm:ss", Locale.ENGLISH);
                string2 = String.format("<29>%s %s test message body", simpleDateFormat.format(new Date()), InetAddress.getLocalHost().getHostAddress());
                break;
            }
            case d: {
                BasicDBObject basicDBObject = new BasicDBObject();
                basicDBObject.put((Object)EventAttribute.loggerTimeStamp.toMongoColumn(), (Object)new Date().getTime());
                basicDBObject.put((Object)EventAttribute.loggerLevel.toMongoColumn(), (Object)"ERROR");
                basicDBObject.put((Object)EventAttribute.threadName.toMongoColumn(), (Object)"thread12345");
                basicDBObject.put((Object)EventAttribute.message.toMongoColumn(), (Object)"a test message for the web");
                basicDBObject.put((Object)EventAttribute.hostName.toMongoColumn(), (Object)"test-host");
                basicDBObject.put((Object)EventAttribute.domainName.toMongoColumn(), (Object)"my-domain");
                basicDBObject.put((Object)EventAttribute.loggerName.toMongoColumn(), (Object)"some.logger.name");
                basicDBObject.put((Object)"p_user", (Object)"user1");
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                string2 = gson.toJson((Object)basicDBObject);
                break;
            }
        }
        return new ModelAndView(this.successView, "message", (Object)string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelAndView testReceiver(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        log.info("testing receiver");
        httpServletRequest.getSession().setAttribute("subtab", (Object)1);
        String string = WebUtils.getParameter(httpServletRequest, "id");
        com.moonlit.logfaces.server.core.u u2 = this.hub.b(string);
        if (u2 == null) {
            throw new Exception("no receiver");
        }
        if (u2.d().c()) {
            return this.testParser(WebUtils.getParameter(httpServletRequest, "message"), u2.c());
        }
        C c2 = new C();
        if (u2 instanceof com.moonlit.logfaces.server.core.r) {
            ((com.moonlit.logfaces.server.core.r)((Object)u2)).a(c2);
        }
        try {
            this.feedTestEvent(WebUtils.getParameter(httpServletRequest, "message"), u2);
            Thread.sleep(100L);
            List list = c2.a();
            int n2 = 0;
            while (list.isEmpty()) {
                com.moonlit.logfaces.server.util.C.d(100L);
                list = c2.a();
                if (++n2 <= 50) continue;
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            ModelAndView modelAndView = new ModelAndView(this.successView, "event", (Object)(list.isEmpty() ? "nothings received" : gson.toJson((Object)list)));
            return modelAndView;
        }
        catch (Exception exception) {
            log.warn(String.format("testing receiver failed: %s", exception.getMessage()), (Throwable)exception);
        }
        finally {
            if (u2 instanceof com.moonlit.logfaces.server.core.r) {
                ((com.moonlit.logfaces.server.core.r)((Object)u2)).b(c2);
            }
        }
        throw new Exception("Nothing received, possible reasons:\n1. the event was discarded as invalid\n2. event hasn't reached the destination\n\nSee internal log for more details.");
    }

    private void feedTestEvent(String string, com.moonlit.logfaces.server.core.u u2) {
        log.info(String.format("feeding test event to %s", u2));
        n n2 = u2.c();
        switch (u2.e()) {
            case a: 
            case c: {
                String string2 = n2.getString("host");
                if ("any-address".equals(string2)) {
                    string2 = "localhost";
                }
                SocketFactory socketFactory = u2.e().c() ? SSLSocketFactory.getDefault() : SocketFactory.getDefault();
                Socket socket = socketFactory.createSocket(string2, n2.getInt("port"));
                PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
                ((Writer)printWriter).write(string);
                ((Writer)printWriter).flush();
                socket.close();
                return;
            }
            case b: {
                String string3 = n2.getString("host");
                if ("any-address".equals(string3)) {
                    string3 = "localhost";
                }
                DatagramSocket datagramSocket = new DatagramSocket();
                InetAddress inetAddress = InetAddress.getByName(string3);
                DatagramPacket datagramPacket = new DatagramPacket(string.getBytes(), string.getBytes().length, inetAddress, n2.getInt("port"));
                datagramSocket.send(datagramPacket);
                datagramSocket.close();
                return;
            }
            case e: {
                int n3 = com.moonlit.logfaces.server.conf.d.a().k();
                URL uRL = new URL(String.format("http://localhost:%d/receivers/%s", n3, n2.getString("path")));
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setRequestProperty("Content-type", "application/text");
                httpURLConnection.setRequestProperty("Accept", "*/*");
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(httpURLConnection.getOutputStream());
                outputStreamWriter.write(string);
                outputStreamWriter.flush();
                outputStreamWriter.close();
                IOUtils.readLines((InputStream)httpURLConnection.getInputStream(), (Charset)StandardCharsets.UTF_8);
                return;
            }
        }
        throw new Exception(String.format("receiver type %s not supported", n2.getString("type")));
    }

    private ModelAndView testParser(String string, n n2) {
        File file = com.moonlit.logfaces.server.conf.i.c();
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(string);
        fileWriter.flush();
        fileWriter.close();
        m m2 = new m();
        l l2 = new l(m2, com.moonlit.logfaces.server.conf.i.N());
        l2.a(file, n2, 0L);
        FileUtils.deleteQuietly((File)file);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return new ModelAndView(this.successView, "event", (Object)(m2.c() != null ? m2.c() : (m2.a().isEmpty() ? "there are no results from this input" : gson.toJson((Object)m2.a()))));
    }

    private ModelAndView updatePatterns(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        log.info("updating pattern library");
        b.a().a("patterns.properties");
        String string = WebUtils.getParameter(httpServletRequest, "patterns");
        String string2 = com.moonlit.logfaces.server.conf.i.N();
        FileWriter fileWriter = new FileWriter(new File(string2));
        fileWriter.write(string);
        fileWriter.flush();
        fileWriter.close();
        y.a().d();
        s.a().post((Object)com.moonlit.logfaces.server.core.l.j);
        return new ModelAndView(this.successView, "response", (Object)"ok");
    }

    private ModelAndView testRegex(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        log.info("testing regular expression");
        String string = WebUtils.getParameter(httpServletRequest, "pattern");
        String string2 = WebUtils.getParameter(httpServletRequest, "input");
        File file = com.moonlit.logfaces.server.conf.i.c();
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(string2);
        fileWriter.flush();
        fileWriter.close();
        ArrayList arrayList = Lists.newArrayList();
        l l2 = new l(new JsonController$1(this, arrayList), com.moonlit.logfaces.server.conf.i.N());
        n n2 = new n();
        n2.setProperty("pattern", string);
        n2.setProperty("xpattern", "%{JEX}");
        l2.a(file, n2, 0L);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return new ModelAndView(this.successView, "response", (Object)(arrayList.isEmpty() ? "this produced nothing.." : gson.toJson((Object)arrayList)));
    }

    private ModelAndView getHelp(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            String string = WebUtils.getParameter(httpServletRequest, "id");
            FileSystemResource fileSystemResource = new FileSystemResource(String.format("%s/WEB-INF/resources/help.html", com.moonlit.logfaces.server.conf.i.h()));
            Document document = Jsoup.parse((File)fileSystemResource.getFile(), (String)"UTF-8");
            Element element = document.getElementById(string);
            return new ModelAndView(this.successView, "content", (Object)element.html());
        }
        catch (Exception exception) {
            return new ModelAndView(this.successView, "content", (Object)"No content currently available");
        }
    }

    private ModelAndView getHints(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        List<String> list = Lists.newArrayList();
        String string = WebUtils.getParameter(httpServletRequest, "attrName", "");
        u u2 = com.moonlit.logfaces.server.database.r.a().k();
        log.trace(String.format("getting hints for %s", string));
        switch (EventAttribute.fromString(string)) {
            case loggerLevel: {
                for (LfsLevel lfsLevel : LfsLevel.toList()) {
                    list.add(lfsLevel.toString());
                }
                break;
            }
            case thrown: {
                list.add(Boolean.TRUE.toString());
                list.add(Boolean.FALSE.toString());
                break;
            }
            case domainName: {
                list = u2.o();
                list.remove("_LFS_EXCEPTION_");
                break;
            }
            case hostName: {
                list = u2.p();
                break;
            }
            case loggerName: {
                list = u2.q();
                break;
            }
            case throwableInfo: {
                list = u2.r();
                break;
            }
        }
        return new ModelAndView(this.successView, "hints", list);
    }

    private ModelAndView setBlackList(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        log.info("setting blacklist");
        String string = WebUtils.getParameter(httpServletRequest, "json");
        CriteriaFilter criteriaFilter = new com.moonlit.logfaces.server.util.a().a(string);
        a.b().a(criteriaFilter);
        this.cfg.f();
        return new ModelAndView(this.successView, "response", (Object)"ok");
    }

    private ModelAndView pair(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        String string = WebUtils.getParameter(httpServletRequest, "id");
        String string2 = WebUtils.getParameter(httpServletRequest, "pairHost");
        String string3 = WebUtils.getParameter(httpServletRequest, "pairPort");
        String string4 = WebUtils.getParameter(httpServletRequest, "pairSsl");
        d d2 = new d(string2, Integer.parseInt(string3), "yes".equalsIgnoreCase(string4));
        log.info(String.format("pairing with %s", d2));
        if (!StringUtils.isEmpty((CharSequence)string)) {
            f.a().a(string);
        }
        f.a().a(d2);
        this.cfg.f();
        if (WebUtils.getBoolean(httpServletRequest, "sync")) {
            return this.syncPairConfig(httpServletRequest, httpServletResponse);
        }
        return new ModelAndView(this.successView, "response", (Object)"ok");
    }

    private ModelAndView unpair(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        String string = WebUtils.getParameter(httpServletRequest, "pairHost", null);
        log.info(string != null ? String.format("removing paired node %s", string) : "removing all paired nodes");
        f.a().a(string);
        this.cfg.f();
        return new ModelAndView(this.successView, "response", (Object)"ok");
    }

    private ModelAndView getPairs(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        f f2 = f.a();
        ArrayList arrayList = Lists.newArrayList();
        for (d d2 : f2.e()) {
            PairModel pairModel = new PairModel();
            pairModel.setHost(d2.b());
            pairModel.setPort(d2.c());
            pairModel.setSecure(d2.g());
            pairModel.setConnected(f2.b(d2));
            pairModel.setAdminUrl(String.format("http%s://%s:%d", pairModel.isSecure() ? "s" : "", d2.b(), pairModel.getPort()));
            arrayList.add(pairModel);
        }
        return new ModelAndView(this.successView, "pairs", (Object)arrayList);
    }

    private ModelAndView syncPairConfig(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        String string = WebUtils.getParameter(httpServletRequest, "pairHost");
        log.info(String.format("synchronizing %s pair configuration", string));
        f f2 = f.a();
        com.moonlit.logfaces.server.b.a a2 = f2.b(string);
        if (a2 == null || !a2.f()) {
            throw new Exception(String.format("pair %s is not connected at this moment", string));
        }
        try {
            File file = new com.moonlit.logfaces.server.conf.o().b();
            a2.c().uploadConfiguration(true, new FileInputStream(file));
            com.moonlit.logfaces.server.util.C.d(5000L);
            a2.b();
        }
        catch (Throwable throwable) {
            throw new Exception(String.format("Unable to deploy configuration to paired node, see internal logs for more details.%n(%s)", throwable.getClass().getSimpleName()));
        }
        int n2 = 30;
        while (--n2 > 0) {
            com.moonlit.logfaces.server.util.C.d(2000L);
            a2 = f2.b(string);
            if (a2 == null || !a2.f()) continue;
            return new ModelAndView(this.successView, "response", (Object)"ok");
        }
        throw new Exception("Paired node seems to have failed to restart with new configuration, see internal logs for more details");
    }

    private ModelAndView addMdc(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String[] stringArray;
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        String string = WebUtils.getParameter(httpServletRequest, "mdc");
        log.info("adding mdc mapping " + string);
        for (String string2 : stringArray = StringUtils.split((String)string, (String)",")) {
            k.a(string2.trim());
        }
        this.cfg.f();
        return new ModelAndView(this.successView, "response", (Object)"ok");
    }

    private ModelAndView removeMdc(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        if (!this.dbx.f().b() && !this.dbx.f().a()) {
            throw new Exception("Can not remove mapped names for this database type.");
        }
        int n2 = WebUtils.getInt(httpServletRequest, "mdc", -1);
        log.info("removing mdc mapping {}", (Object)n2);
        k.a(n2, "");
        k.a();
        this.cfg.f();
        return new ModelAndView(this.successView, "response", (Object)"ok");
    }

    private ModelAndView updateMdc(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        log.info("updating mdc mapping");
        int n2 = k.e().size();
        for (int i2 = 0; i2 < n2; ++i2) {
            k.a(i2, WebUtils.getParameter(httpServletRequest, "mdc" + i2));
        }
        if (this.dbx.h()) {
            k.a();
        }
        this.cfg.f();
        return new ModelAndView(this.successView, "response", (Object)"MDC mapping applied");
    }

    private ModelAndView updateRepo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        httpServletRequest.getSession().setAttribute("subtab", (Object)1);
        log.info("updating repository configuration");
        this.cfg.f(WebUtils.getInt(httpServletRequest, "repoCap", -1));
        this.cfg.f(WebUtils.getBoolean(httpServletRequest, "repoHosts", "Auto"));
        this.cfg.f();
        s.a().post(new LfsEvent(com.moonlit.logfaces.server.core.l.g));
        return new ModelAndView(this.successView, "response", (Object)"Repository settings applied");
    }

    private ModelAndView updateHosts(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        log.info("updating hosts mapping");
        String string = WebUtils.getParameter(httpServletRequest, "hosts");
        Set set = com.moonlit.logfaces.server.conf.j.a().a(string);
        this.dbx.g().a(set);
        return new ModelAndView(this.successView, "response", (Object)"Host names applied");
    }

    private ModelAndView updateLevel(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        log.info("updating custom logger level");
        String string = WebUtils.getParameter(httpServletRequest, "name");
        int n2 = WebUtils.getInt(httpServletRequest, "value", 0);
        if (StringUtils.isEmpty((CharSequence)string)) {
            throw new Exception("Level should have a name");
        }
        if (n2 <= 0) {
            throw new Exception("Level value should be positive");
        }
        LfsLevel lfsLevel = LfsLevel.getLevel(string);
        if (lfsLevel != null) {
            LfsLevel.removeLevel(lfsLevel.intLevel());
        }
        LfsLevel.forName(string, n2);
        com.moonlit.logfaces.server.conf.d.a().f();
        return new ModelAndView(this.successView, "response", (Object)"Host names applied");
    }

    private ModelAndView removeLevel(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        log.info("removing custom logger level");
        int n2 = WebUtils.getInt(httpServletRequest, "value", 0);
        LfsLevel.removeLevel(n2);
        com.moonlit.logfaces.server.conf.d.a().f();
        return new ModelAndView(this.successView, "response", (Object)"Host names applied");
    }

    private ModelAndView enableAuthorization(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        if (!this.cfg.y().b()) {
            throw new IllegalStateException("Please enable LDAP authentication first");
        }
        boolean bl = this.cfg.z();
        log.info(String.format("%s authorization", bl ? "disabling" : "enabling"));
        this.cfg.b(!bl);
        this.cfg.f();
        LfsService.getInstance().applyAuthorization();
        return new ModelAndView(this.successView, "enabled", (Object)(!bl ? 1 : 0));
    }

    private ModelAndView listGroups(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = WebUtils.getParameter(httpServletRequest, "filter");
        log.info(String.format("listing user groups, filter: %s", string != null ? string : "none"));
        List list = com.moonlit.logfaces.server.access.i.a().a(string);
        log.info(String.format("listed %d user groups", list.size()));
        return new ModelAndView(this.successView, "groups", (Object)list);
    }

    private ModelAndView importGroups(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        log.info("importing user groups");
        String[] stringArray = httpServletRequest.getParameterValues("groups");
        if (stringArray == null) {
            return new ModelAndView(this.successView, "response", (Object)"ok");
        }
        for (String string : stringArray) {
            if (this.authorizer.a(string)) continue;
            this.authorizer.a(string, JexlCriteria.makeAllInclusiveCriteria());
        }
        this.cfg.f();
        LfsService.getInstance().applyAuthorization();
        return new ModelAndView(this.successView, "response", (Object)"ok");
    }

    private ModelAndView clearGroups(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        log.info("removing all user groups");
        this.authorizer.g();
        this.cfg.f();
        LfsService.getInstance().applyAuthorization();
        return new ModelAndView(this.successView, "response", (Object)"ok");
    }

    private ModelAndView removeGroup(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        int n2 = Integer.parseInt(WebUtils.getParameter(httpServletRequest, "id"));
        String string = this.authorizer.a(n2);
        log.info("removing user group " + string);
        this.authorizer.c(string);
        this.cfg.f();
        LfsService.getInstance().applyAuthorization();
        return new ModelAndView(this.successView, "response", (Object)"ok");
    }

    private ModelAndView updateGroup(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HttpSession httpSession = httpServletRequest.getSession();
        String string = (String)httpSession.getAttribute("groupName");
        httpSession.setAttribute("subtab", (Object)1);
        CriteriaFilter criteriaFilter = new com.moonlit.logfaces.server.util.a().a(WebUtils.getParameter(httpServletRequest, "criteria"));
        this.authorizer.a(string, criteriaFilter);
        this.cfg.f();
        LfsService.getInstance().applyAuthorization();
        return new ModelAndView(this.successView, "response", (Object)"ok");
    }

    private ModelAndView updateDb(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        int n2;
        D d2;
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        String string = WebUtils.getParameter(httpServletRequest, "schemaManaged");
        if (!StringUtils.isEmpty((CharSequence)string)) {
            this.cfg.e(string.contains("Auto"));
        }
        if (!(StringUtils.isEmpty((CharSequence)(string = WebUtils.getParameter(httpServletRequest, "capacity"))) || !(d2 = D.a(string, n2 = WebUtils.getInt(httpServletRequest, "retentionDays", 3))).d() && this.dbx.g().r())) {
            this.cfg.a(d2);
        }
        this.cfg.a(WebUtils.getInt(httpServletRequest, "commitBuffer", 100));
        this.cfg.d(WebUtils.getInt(httpServletRequest, "maxNofFailures", 3));
        this.cfg.b((long)WebUtils.getInt(httpServletRequest, "recoveryRate", 1) * 60000L);
        this.cfg.e(WebUtils.getInt(httpServletRequest, "nofRecoveryAttempts", 3));
        this.cfg.f(WebUtils.getInt(httpServletRequest, "repoCap", -1));
        this.cfg.f(WebUtils.getBoolean(httpServletRequest, "repoHosts", "Auto"));
        this.cfg.g(WebUtils.getInt(httpServletRequest, "msgCap", 128));
        this.cfg.h(WebUtils.getParameter(httpServletRequest, "maintCron"));
        if (!this.dbx.g().s().a()) {
            this.cfg.d(WebUtils.getBoolean(httpServletRequest, "countEnabled", "Enabled"));
        }
        this.cfg.f();
        s.a().post(new LfsEvent(com.moonlit.logfaces.server.core.l.g));
        if (!this.dbx.g().f()) {
            throw new Exception("Database connection is not operational");
        }
        return new ModelAndView(this.successView, "response", (Object)"ok");
    }

    private ModelAndView updateMongo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        E e2 = (E)this.dbx.g();
        com.moonlit.logfaces.server.conf.l l2 = e2.y().a();
        boolean bl = WebUtils.getBoolean(httpServletRequest, "auth", "yes");
        String string = WebUtils.getParameter(httpServletRequest, "databaseName");
        if (!StringUtils.isEmpty((CharSequence)string)) {
            l2.a(string);
        }
        l2.a(bl ? WebUtils.getParameter(httpServletRequest, "userName") : null, bl ? WebUtils.getParameter(httpServletRequest, "userDB") : null, bl ? WebUtils.getParameter(httpServletRequest, "password") : null);
        l2.b(WebUtils.getBoolean(httpServletRequest, "ssl", "yes"));
        l2.e(WebUtils.getParameter(httpServletRequest, "readPref"));
        l2.c(WebUtils.getBoolean(httpServletRequest, "forceSorting", "yes"));
        l2.c(WebUtils.getParameter(httpServletRequest, "writeConcern"));
        l2.d(WebUtils.getParameter(httpServletRequest, "readConcern"));
        com.moonlit.logfaces.server.core.d d2 = com.moonlit.logfaces.server.core.d.a(WebUtils.getParameter(httpServletRequest, "collection"));
        int n2 = 0;
        try {
            if (d2 != null) {
                if (d2.a()) {
                    n2 = Integer.parseInt(httpServletRequest.getParameter("cappedSize"));
                } else if (d2.b()) {
                    n2 = Integer.parseInt(httpServletRequest.getParameter("ttlSize"));
                } else if (d2.d()) {
                    n2 = Integer.parseInt(httpServletRequest.getParameter("partitionSize"));
                }
                if (!d2.c() && n2 <= 0) {
                    throw new NumberFormatException();
                }
                l2.a(d2, n2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("Collection parameter must be a positive non zero value");
        }
        try {
            l2.b(WebUtils.getParameter(httpServletRequest, "connections"));
        }
        catch (Exception exception) {
            throw new Exception("Failed setting connections: " + exception.getMessage());
        }
        CommandApplyMongoSettings commandApplyMongoSettings = new CommandApplyMongoSettings(l2, "");
        ((Command)commandApplyMongoSettings).process();
        if (!commandApplyMongoSettings.getStatus().equals((Object)Command$STATUS.OK)) {
            throw new Exception(commandApplyMongoSettings.getProgressInfo());
        }
        return new ModelAndView(this.successView, "response", (Object)commandApplyMongoSettings.getProgressInfo());
    }

    private ModelAndView updateBQ(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Object object;
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        String string = "Applied successfully";
        boolean bl = true;
        boolean bl2 = false;
        com.moonlit.logfaces.server.database.e e2 = (com.moonlit.logfaces.server.database.e)this.dbx.g();
        com.moonlit.logfaces.server.conf.a a2 = e2.A();
        try {
            object = new DiskFileItemFactory();
            ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)object);
            List list = servletFileUpload.parseRequest(httpServletRequest);
            String string2 = ((FileItem)list.get(1)).getString();
            if (!StringUtils.isEmpty((CharSequence)string2) && !string2.equals(a2.b())) {
                a2.a(string2);
                bl2 = true;
            }
            if (!StringUtils.isEmpty((CharSequence)(string2 = ((FileItem)list.get(2)).getString())) && !string2.equals(a2.c())) {
                a2.b(string2);
                bl2 = true;
            }
            if (!StringUtils.isEmpty((CharSequence)(string2 = ((FileItem)list.get(3)).getString())) && !string2.equals(a2.d())) {
                a2.c(string2);
                bl2 = true;
            }
            if (((FileItem)list.get(4)).getContentType() != null) {
                a2.a(((FileItem)list.get(4)).getInputStream());
                bl2 = true;
            }
            if (!StringUtils.isEmpty((CharSequence)(string2 = ((FileItem)list.get(5)).getString())) && a2.g() != StringUtils.containsIgnoreCase((CharSequence)string2, (CharSequence)z.f.name())) {
                a2.a(StringUtils.containsIgnoreCase((CharSequence)string2, (CharSequence)z.f.name()));
                bl2 = true;
            }
            try {
                int n2 = Integer.parseInt(((FileItem)list.get(6)).getString());
                if (n2 <= 0 || n2 > 100) {
                    throw new Exception();
                }
                if (n2 != a2.h()) {
                    a2.a(n2);
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                throw new Exception("Positive whole number in range of 1-100 is expected for the thread pool size");
            }
            if (bl2) {
                a2.a();
                this.dbx.e();
            }
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            string = exception.getMessage();
            bl = false;
        }
        object = Maps.newHashMap();
        object.put("rc", bl);
        object.put("message", string);
        return new ModelAndView(this.successView, "response", object);
    }

    private ModelAndView updateDbCriteria(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        w w2 = this.dbx.j();
        String string = WebUtils.getParameter(httpServletRequest, "json");
        CriteriaFilter criteriaFilter = new com.moonlit.logfaces.server.util.a().a(string);
        w2.a(criteriaFilter);
        this.cfg.f();
        return new ModelAndView(this.successView, "response", (Object)"ok");
    }

    private ModelAndView updateEmail(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        String string = WebUtils.getParameter(httpServletRequest, "emailFrom");
        String string2 = WebUtils.getParameter(httpServletRequest, "emailServer");
        String string3 = WebUtils.getParameter(httpServletRequest, "emailAccount");
        int n2 = 0;
        if (StringUtils.isEmpty((CharSequence)string2)) {
            throw new Exception("Invalid server address");
        }
        if (StringUtils.isEmpty((CharSequence)string) || !string.contains("@")) {
            throw new Exception("Invalid from e-mail address");
        }
        try {
            n2 = WebUtils.getInt(httpServletRequest, "emailPort", -1);
            if (n2 <= 0 || n2 > 65634) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            throw new Exception("SMTP port must be numeric value in range 1 - 65634");
        }
        this.cfg.c(string2);
        this.cfg.d(string3);
        this.cfg.f(string);
        this.cfg.e(WebUtils.getParameter(httpServletRequest, "emailPassword"));
        this.cfg.g(WebUtils.getParameter(httpServletRequest, "emailSecurity"));
        this.cfg.c(n2);
        this.cfg.f();
        return new ModelAndView(this.successView, "response", (Object)"SMTP settings applied");
    }

    private ModelAndView testEmail(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = WebUtils.getParameter(httpServletRequest, "email");
        log.info("sending test mail to " + string);
        try {
            String string2 = String.format("%s%n%s%n%s", "This e-mail is sent to you to verify outgoing e-mail settings on logFaces server.", "If you received this message, it means that your settings are correct", "and you are ready to receive e-mails from this server instance.");
            MultiPartEmail multiPartEmail = this.cfg.a("logFaces email test", string2, string, com.moonlit.logfaces.server.util.k.c);
            multiPartEmail.setDebug(log.isTraceEnabled());
            multiPartEmail.send();
            log.info("test mail sent to " + string);
            string2 = String.format("Testing e-mail is sent to %s", string);
            return new ModelAndView(this.successView, "response", (Object)string2);
        }
        catch (Throwable throwable) {
            throw new Exception(throwable.getCause() != null ? throwable.getCause().toString() : throwable.getMessage());
        }
    }

    private ModelAndView addReport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        httpServletRequest.getSession().setAttribute("subtab", (Object)1);
        String string = WebUtils.getParameter(httpServletRequest, "id");
        com.moonlit.logfaces.server.reports.b b2 = StringUtils.isEmpty((CharSequence)string) ? this.reps.f() : this.reps.b(Long.parseLong(string));
        return new ModelAndView(this.successView, "id", (Object)b2.b());
    }

    private ModelAndView testReport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        com.moonlit.logfaces.server.reports.b b2 = this.reps.a(WebUtils.getInt(httpServletRequest, "id", -1));
        new ReportJob().test(b2, true);
        String string = String.format("Report was executed and resulting e-mail is sent to %s. Check if e-mail is received and contains expected log data.", b2.g());
        return new ModelAndView(this.successView, "response", (Object)string);
    }

    private ModelAndView updateReport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        httpServletRequest.getSession().setAttribute("subtab", (Object)1);
        com.moonlit.logfaces.server.reports.b b2 = this.reps.a(WebUtils.getParameter(httpServletRequest, "id"));
        if (b2 == null) {
            throw new Exception();
        }
        if (WebUtils.getParameter(httpServletRequest, "cancel", null) != null) {
            if (b2.o()) {
                this.reps.c(b2.b());
                return new ModelAndView(this.successView, "response", (Object)"ok");
            }
            return new ModelAndView(this.successView, "response", (Object)"ok");
        }
        String string = WebUtils.getParameter(httpServletRequest, "name");
        if (string.isEmpty()) {
            throw new Exception("Please specify report name");
        }
        b2.b(string);
        string = WebUtils.getParameter(httpServletRequest, "cron");
        if (!CronExpression.isValidExpression((String)string)) {
            throw new Exception("'" + string + "' doesn't appear to be a valid cron expression");
        }
        b2.a(string);
        string = WebUtils.getParameter(httpServletRequest, "mailTo");
        if (string.isEmpty()) {
            throw new Exception("Please specify at least one e-mail recipient");
        }
        string = StringUtils.remove((String)string, (char)' ');
        com.moonlit.logfaces.server.util.C.b(string);
        b2.c(string);
        float f2 = WebUtils.getFloat(httpServletRequest, "sizeInHours", -1.0f);
        if (f2 < 0.0f) {
            throw new Exception("Please specify 'Time coverage' as numeric positive value");
        }
        b2.a(f2);
        int n2 = WebUtils.getInt(httpServletRequest, "zipLimit", -1);
        if (n2 < 0) {
            throw new Exception("Please specify 'zip threshold' as numeric positive value");
        }
        b2.a(n2);
        CriteriaFilter criteriaFilter = new com.moonlit.logfaces.server.util.a().a(WebUtils.getParameter(httpServletRequest, "criteria"));
        if (criteriaFilter.getRules().isEmpty()) {
            throw new Exception("Please specify some rules in 'database query', otherwise this report is pointless");
        }
        b2.a(criteriaFilter);
        b2.a(WebUtils.getBoolean(httpServletRequest, "enabled", "yes"));
        b2.g(WebUtils.getParameter(httpServletRequest, "subject"));
        b2.d(WebUtils.getParameter(httpServletRequest, "mailPriority"));
        b2.e(WebUtils.getParameter(httpServletRequest, "layoutFormat"));
        b2.b(false);
        this.reps.a(b2);
        this.cfg.f();
        return new ModelAndView(this.successView, "response", (Object)"ok");
    }

    private ModelAndView addTrigger(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        httpServletRequest.getSession().setAttribute("subtab", (Object)2);
        String string = WebUtils.getParameter(httpServletRequest, "id");
        com.moonlit.logfaces.server.e.o o2 = StringUtils.isEmpty((CharSequence)string) ? this.trigs.f() : this.trigs.a(Long.parseLong(string));
        return new ModelAndView(this.successView, "id", (Object)o2.i());
    }

    private ModelAndView updateTrigger(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        long l2;
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        httpServletRequest.getSession().setAttribute("subtab", (Object)2);
        com.moonlit.logfaces.server.e.o o2 = this.trigs.a(WebUtils.getParameter(httpServletRequest, "id"));
        if (o2 == null) {
            throw new Exception("trigger not found");
        }
        if (WebUtils.getParameter(httpServletRequest, "cancel", null) != null) {
            if (o2.t()) {
                this.trigs.c(o2.i());
                return new ModelAndView(this.successView, "response", (Object)"ok");
            }
            return new ModelAndView(this.successView, "response", (Object)"ok");
        }
        String string = WebUtils.getParameter(httpServletRequest, "description");
        if (string.length() == 0) {
            throw new Exception("Please specify trigger description, it will be included in email so that you know what notification is this");
        }
        o2.a(string);
        string = WebUtils.getParameter(httpServletRequest, "dnd");
        if (!StringUtils.isEmpty((CharSequence)string) && !CronExpression.isValidExpression((String)string)) {
            throw new Exception("Please specify 'Counter' as a whole positive non-zero number");
        }
        o2.f(string);
        try {
            o2.a(com.moonlit.logfaces.server.e.n.valueOf(WebUtils.getParameter(httpServletRequest, "type").trim()));
        }
        catch (Exception exception) {
            throw new Exception("Please specify 'Trigger type'");
        }
        try {
            if (!o2.p().a()) {
                int n2 = WebUtils.getInt(httpServletRequest, "counter", -1);
                if (n2 <= 0) {
                    throw new Exception("");
                }
                o2.a(n2);
            }
        }
        catch (Exception exception) {
            throw new Exception("Please specify 'Counter' as a whole positive non-zero number");
        }
        try {
            l2 = WebUtils.getLong(httpServletRequest, "timespan", -1L);
            if (l2 < 0L) {
                throw new Exception("");
            }
            o2.a(l2);
        }
        catch (Exception exception) {
            throw new Exception("Please specify 'Time window' as a whole positive number");
        }
        try {
            l2 = WebUtils.getLong(httpServletRequest, "frequency", -1L);
            if (l2 < 0L) {
                throw new Exception("");
            }
            o2.b(l2);
        }
        catch (Exception exception) {
            throw new Exception("Please specify 'Frequency limit' as a whole non-negative value");
        }
        try {
            if (o2.p().c()) {
                y.a().c(WebUtils.getParameter(httpServletRequest, "sexpr"));
                o2.b(WebUtils.getParameter(httpServletRequest, "sattr"));
                o2.c(WebUtils.getParameter(httpServletRequest, "sexpr"));
            }
        }
        catch (Exception exception) {
            throw new Exception("Parameter 'Split regex' doesn't appear to be a valid regular expression");
        }
        CriteriaFilter criteriaFilter = new com.moonlit.logfaces.server.util.a().a(WebUtils.getParameter(httpServletRequest, "criteria"));
        if (criteriaFilter.getRules().isEmpty()) {
            throw new Exception("Please specify some rules in 'Capture criteria', otherwise this trigger is pointless");
        }
        o2.a(criteriaFilter);
        o2.a(!o2.r().isEmpty() && WebUtils.getBoolean(httpServletRequest, "enabled", "yes"));
        o2.d(WebUtils.getParameter(httpServletRequest, "pattern"));
        o2.h(WebUtils.getParameter(httpServletRequest, "subject"));
        o2.e(WebUtils.getParameter(httpServletRequest, "message"));
        o2.b(false);
        this.trigs.a(o2);
        this.cfg.f();
        return new ModelAndView(this.successView, "response", (Object)"ok");
    }

    private ModelAndView getTriggerDestinations(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        com.moonlit.logfaces.server.e.o o2 = this.trigs.a(WebUtils.getParameter(httpServletRequest, "id"));
        ArrayList arrayList = Lists.newArrayList();
        for (com.moonlit.logfaces.server.core.h h2 : com.moonlit.logfaces.server.core.h.values()) {
            g g2 = o2.a(h2);
            if (g2 == null) {
                arrayList.add(new DestinationModel(h2));
                continue;
            }
            arrayList.add(new DestinationModel(g2));
        }
        return new ModelAndView(this.successView, "destinations", (Object)arrayList);
    }

    private ModelAndView getTriggerDestination(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        com.moonlit.logfaces.server.core.h h2 = com.moonlit.logfaces.server.core.h.valueOf(WebUtils.getParameter(httpServletRequest, "type"));
        com.moonlit.logfaces.server.e.o o2 = this.trigs.a(WebUtils.getParameter(httpServletRequest, "id"));
        if (o2 == null) {
            throw new Exception("trigger not found");
        }
        ArrayList arrayList = Lists.newArrayList();
        switch (h2) {
            case b: {
                g g2 = o2.a(h2);
                if (g2 == null) {
                    g2 = new DestinationEmail();
                }
                arrayList.add(new OptionModel("Priority", "priority", BeanUtils.getProperty((Object)g2, (String)"priority"), Lists.newArrayList((Object[])new String[]{"highest", "high", "normal", "low", "lowest"}), "Email message will be tagged with this priority"));
                arrayList.add(new OptionModel("Recipients", "recipients", BeanUtils.getProperty((Object)g2, (String)"recipients"), "Email to these addresses, use ; for separation"));
                arrayList.add(new OptionModel("Attachment", "attachment", BeanUtils.getProperty((Object)g2, (String)"attachment").equals("true") ? "Yes" : "No", Lists.newArrayList((Object[])new String[]{"Yes", "No"}), "Always attach log file with the email", "trigger.attachment"));
                arrayList.add(new OptionModel("Layout", "layout", BeanUtils.getProperty((Object)g2, (String)"layout"), "Attached log files format", "report.layout"));
                break;
            }
            case c: {
                g g3 = o2.a(h2);
                if (g3 == null) {
                    g3 = new DestinationSlack();
                }
                arrayList.add(new OptionModel("URL", "url", BeanUtils.getProperty((Object)g3, (String)"url"), "Slack web hook url", "slack.url"));
                arrayList.add(new OptionModel("Channel", "channel", BeanUtils.getProperty((Object)g3, (String)"channel"), "Slack channel", "slack.channel"));
                arrayList.add(new OptionModel("Format", "pattern", BeanUtils.getProperty((Object)g3, (String)"pattern"), "Pattern layout for relay", "slack.pattern"));
                break;
            }
            case d: {
                g g4 = o2.a(h2);
                if (g4 == null) {
                    g4 = new DestinationWebHook();
                }
                arrayList.add(new OptionModel("URL", "url", BeanUtils.getProperty((Object)g4, (String)"url"), "Web hook url", "webhook.url"));
                break;
            }
            case e: {
                DestinationPlugin destinationPlugin = (DestinationPlugin)o2.a(h2);
                if (destinationPlugin == null) {
                    destinationPlugin = new DestinationPlugin();
                }
                ArrayList arrayList2 = Lists.newArrayList();
                arrayList2.add("");
                com.moonlit.logfaces.server.d.d d2 = com.moonlit.logfaces.server.d.d.a();
                for (Object object : d2.d()) {
                    arrayList2.add(((com.moonlit.logfaces.server.d.a)object).getName());
                }
                com.moonlit.logfaces.server.d.a a2 = d2.d(destinationPlugin.getPid());
                arrayList.add(new OptionModel("Plugin", "plugin", a2 != null ? a2.getName() : "-", arrayList2, "Plugin to invoke"));
                if (a2 == null) break;
                for (String string : a2.getArgs()) {
                    arrayList.add(new OptionModel(string, "arg." + string, (String)destinationPlugin.getArgs().get(string), "invocation argument"));
                }
                break;
            }
            case a: {
                g g5 = o2.a(h2);
                if (g5 == null) {
                    g5 = new DestinationAlert();
                }
                arrayList.add(new OptionModel("Level", "level", BeanUtils.getProperty((Object)g5, (String)"level"), Lists.newArrayList((Object[])new String[]{"info", "warn", "error"}), "Alert severity level"));
            }
        }
        log.info(String.format("getting '%s' destination in trigger '%s'", new Object[]{h2, o2.b()}));
        return new ModelAndView(this.successView, "options", (Object)arrayList);
    }

    private ModelAndView updateTriggerDestination(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        com.moonlit.logfaces.server.e.o o2 = this.trigs.a(WebUtils.getParameter(httpServletRequest, "id"));
        if (o2 == null) {
            throw new Exception("trigger not found");
        }
        g g2 = com.moonlit.logfaces.server.conf.g.a(httpServletRequest);
        o2.a(g2);
        log.info(String.format("updated '%s' destination in trigger '%s'", new Object[]{g2.getType(), o2.b()}));
        return new ModelAndView(this.successView, "destination", (Object)new DestinationModel(g2));
    }

    private ModelAndView removeTriggerDestination(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        com.moonlit.logfaces.server.core.h h2 = com.moonlit.logfaces.server.core.h.valueOf(WebUtils.getParameter(httpServletRequest, "type"));
        com.moonlit.logfaces.server.e.o o2 = this.trigs.a(WebUtils.getParameter(httpServletRequest, "id"));
        if (o2 == null) {
            throw new Exception("trigger not found");
        }
        g g2 = o2.b(h2);
        log.info(String.format("removed '%s' destination from trigger '%s'", new Object[]{h2, o2.b()}));
        return new ModelAndView(this.successView, "response", (Object)g2);
    }

    private ModelAndView addFloodDetector(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        httpServletRequest.getSession().setAttribute("subtab", (Object)3);
        String string = WebUtils.getParameter(httpServletRequest, "id");
        h h2 = StringUtils.isEmpty((CharSequence)string) ? this.flood.d() : this.flood.c(Integer.parseInt(string));
        return new ModelAndView(this.successView, "id", (Object)h2.p());
    }

    private ModelAndView updateFloodDetector(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        int n2;
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        h h2 = this.flood.a(WebUtils.getParameter(httpServletRequest, "id"));
        if (h2 == null) {
            throw new Exception("detector not found");
        }
        httpServletRequest.getSession().setAttribute("subtab", (Object)3);
        if (WebUtils.getParameter(httpServletRequest, "cancel", null) != null) {
            if (h2.q()) {
                this.flood.a(h2.p());
            }
            return new ModelAndView(this.successView, "response", (Object)"ok");
        }
        String string = WebUtils.getParameter(httpServletRequest, "name");
        h2.a(string);
        h2.a(WebUtils.getBoolean(httpServletRequest, "enabled", "yes"));
        try {
            n2 = WebUtils.getInt(httpServletRequest, "window", -1);
            if (n2 <= 0) {
                throw new Exception();
            }
            h2.a(n2 * 1000);
        }
        catch (Exception exception) {
            throw new Exception("Please specify 'window' as numeric positive value");
        }
        try {
            n2 = WebUtils.getInt(httpServletRequest, "threshold", -1);
            if (n2 <= 0) {
                throw new Exception();
            }
            h2.a_(n2);
        }
        catch (Exception exception) {
            throw new Exception("Please specify 'threshold' as numeric positive value");
        }
        CriteriaFilter criteriaFilter = new com.moonlit.logfaces.server.util.a().a(WebUtils.getParameter(httpServletRequest, "criteria"));
        h2.a(criteriaFilter);
        h2.b(false);
        this.flood.a(h2);
        this.cfg.f();
        return new ModelAndView(this.successView, "response", (Object)"ok");
    }

    private List getUploadedFiles(HttpServletRequest httpServletRequest) {
        DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
        ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)diskFileItemFactory);
        List list = servletFileUpload.parseRequest(httpServletRequest);
        if (list.isEmpty()) {
            throw new Exception("no files selected");
        }
        ArrayList arrayList = Lists.newArrayList();
        for (FileItem fileItem : list) {
            File file = new File(fileItem.getName());
            File file2 = new File(String.format("%s%s%s", com.moonlit.logfaces.server.conf.i.b(), File.separator, file.getName()));
            FileUtils.copyInputStreamToFile((InputStream)fileItem.getInputStream(), (File)file2);
            arrayList.add(file2);
        }
        return arrayList;
    }

    private ModelAndView addPlugin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        log.info("adding plugin");
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        List list = this.getUploadedFiles(httpServletRequest);
        try {
            com.moonlit.logfaces.server.d.d.a().b(list);
            ModelAndView modelAndView = new ModelAndView(this.successView, "response", (Object)"ok");
            return modelAndView;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            for (File file : list) {
                FileUtils.deleteQuietly((File)file);
            }
        }
    }

    private ModelAndView updatePlugin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        List list = this.getUploadedFiles(httpServletRequest);
        int n2 = WebUtils.getInt(httpServletRequest, "pid", -1);
        log.info("updating plugin " + n2);
        try {
            com.moonlit.logfaces.server.d.d.a().a(n2, list);
            s.a().post(LfsEvent.pluginUpdated(n2));
            ModelAndView modelAndView = new ModelAndView(this.successView, "response", (Object)"ok");
            return modelAndView;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            for (File file : list) {
                FileUtils.deleteQuietly((File)file);
            }
        }
    }

    private ModelAndView listPlugins(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ArrayList arrayList = Lists.newArrayList();
        for (com.moonlit.logfaces.server.d.a a2 : com.moonlit.logfaces.server.d.d.a().d()) {
            boolean bl = o.h().c(a2.b());
            arrayList.add(new PluginModel(a2.b(), a2.getName(), a2.getArgs(), bl |= com.moonlit.logfaces.server.e.l.a().a(a2.b())));
        }
        Collections.sort(arrayList, new JsonController$2(this));
        return new ModelAndView(this.successView, "response", (Object)arrayList);
    }

    private ModelAndView removePlugin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        int n2 = WebUtils.getInt(httpServletRequest, "pid", -1);
        log.info("removing plugin " + n2);
        com.moonlit.logfaces.server.d.d.a().a(n2);
        s.a().post(LfsEvent.pluginRemoved(n2));
        return new ModelAndView(this.successView, "response", (Object)"ok");
    }

    private ModelAndView getPluginArgs(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        com.moonlit.logfaces.server.d.d d2 = com.moonlit.logfaces.server.d.d.a();
        com.moonlit.logfaces.server.d.a a2 = null;
        int n2 = WebUtils.getInt(httpServletRequest, "plugin", -1);
        int n3 = WebUtils.getInt(httpServletRequest, "pid", -1);
        if (n3 >= 0) {
            a2 = d2.d(n3);
        } else if (n2 > 0) {
            a2 = (com.moonlit.logfaces.server.d.a)d2.d().get(n2 - 1);
        } else {
            return new ModelAndView(this.successView, "response", (Object)Lists.newArrayList());
        }
        return new ModelAndView(this.successView, "response", (Object)(a2 != null ? a2.getArgs() : Lists.newArrayList()));
    }

    private ModelAndView testPlugin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        int n2;
        com.moonlit.logfaces.server.d.d d2 = com.moonlit.logfaces.server.d.d.a();
        com.moonlit.logfaces.server.d.a a2 = d2.d(n2 = WebUtils.getInt(httpServletRequest, "pid", -1));
        if (a2 == null) {
            throw new Exception("no plugin");
        }
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        List list = a2.getArgs();
        if (list != null) {
            for (String string : list) {
                String string2 = WebUtils.getParameter(httpServletRequest, string, "");
                linkedHashMap.put(string, string2);
            }
        }
        log.info("testing plugin " + n2);
        Object object = a2.validate(linkedHashMap);
        object = object != null ? object.toString() : "This plugin didn't provide any response but validated OK.";
        return new ModelAndView(this.successView, "response", object);
    }

    private ModelAndView addPivotNode(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        int n2 = WebUtils.getInt(httpServletRequest, "pid", -1);
        com.moonlit.logfaces.server.d.a a2 = com.moonlit.logfaces.server.d.d.a().d(n2);
        if (a2 == null) {
            throw new IllegalArgumentException("no plugin");
        }
        List list = a2.getArgs();
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        for (String string : list) {
            linkedHashMap.put(string, WebUtils.getParameter(httpServletRequest, "arg." + string, ""));
        }
        log.info("adding pivot node plugin " + n2);
        x x2 = o.h().a(a2.b(), linkedHashMap);
        this.cfg.f();
        return new ModelAndView(this.successView, "response", (Object)new PivotNodeModel(x2));
    }

    private ModelAndView updatePivotNode(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        int n2 = WebUtils.getInt(httpServletRequest, "node", -1);
        if (n2 == -1) {
            return this.addPivotNode(httpServletRequest, httpServletResponse);
        }
        int n3 = WebUtils.getInt(httpServletRequest, "pid", -1);
        if (n3 == -1) {
            return this.removePivotNode(httpServletRequest, httpServletResponse);
        }
        if (n2 < 2) {
            throw new IllegalArgumentException("can't modify internal nodes");
        }
        log.info(String.format("updating pivot node %d, plugin %d", n2, n3));
        com.moonlit.logfaces.server.d.a a2 = com.moonlit.logfaces.server.d.d.a().d(n3);
        if (a2 == null) {
            throw new IllegalArgumentException("no plugin");
        }
        List list = a2.getArgs();
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        for (String string : list) {
            linkedHashMap.put(string, WebUtils.getParameter(httpServletRequest, "arg." + string, ""));
        }
        x x2 = o.h().a(n2, n3, linkedHashMap);
        this.cfg.f();
        return new ModelAndView(this.successView, "response", (Object)new PivotNodeModel(x2));
    }

    private ModelAndView getPivotNode(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        x x2;
        int n2 = WebUtils.getInt(httpServletRequest, "node", -1);
        int n3 = WebUtils.getInt(httpServletRequest, "pid", -1);
        x x3 = x2 = n2 >= 0 ? (x)o.h().i().get(n2) : null;
        if (n3 >= 0 && x2 == null) {
            com.moonlit.logfaces.server.d.a a2 = com.moonlit.logfaces.server.d.d.a().d(n3);
            return new ModelAndView(this.successView, "response", (Object)new PivotNodeModel(a2));
        }
        if (n3 >= 0 && x2 != null && x2.p() != n3) {
            com.moonlit.logfaces.server.d.a a3 = com.moonlit.logfaces.server.d.d.a().d(n3);
            return new ModelAndView(this.successView, "response", (Object)new PivotNodeModel(a3));
        }
        return new ModelAndView(this.successView, "response", (Object)new PivotNodeModel(x2));
    }

    private ModelAndView movePivotNode(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        int n2 = WebUtils.getInt(httpServletRequest, "node", -1);
        boolean bl = WebUtils.getBoolean(httpServletRequest, "direction", "up");
        log.info(String.format("moving pivot node %d %s the chain", n2, bl ? "up" : "down"));
        o.h().a(n2, bl);
        this.cfg.f();
        return new ModelAndView(this.successView, "response", (Object)"ok");
    }

    private ModelAndView removePivotNode(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        int n2 = WebUtils.getInt(httpServletRequest, "node", -1);
        log.info(String.format("removing pivot node %d", n2));
        o.h().e(n2);
        this.cfg.f();
        return new ModelAndView(this.successView, "response", (Object)"ok");
    }

    private ModelAndView togglePivotNode(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        int n2 = WebUtils.getInt(httpServletRequest, "node", -1);
        x x2 = o.h().d(n2);
        log.info(String.format("toggling pivot node %d", n2));
        x2.a(!x2.f());
        this.cfg.f();
        return new ModelAndView(this.successView, "response", (Object)"ok");
    }

    private ModelAndView importKeyStoreCert(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Object object;
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        boolean bl = false;
        String string = "";
        try {
            if (WebUtils.getBoolean(httpServletRequest, "import")) {
                object = new DiskFileItemFactory();
                ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)object);
                List list = servletFileUpload.parseRequest(httpServletRequest);
                if (list.size() != 3) {
                    throw new Exception("no files selected");
                }
                FileItem fileItem = (FileItem)list.get(1);
                FileItem fileItem2 = (FileItem)list.get(2);
                com.moonlit.logfaces.server.util.e.a(fileItem.get(), fileItem2.get());
            } else {
                com.moonlit.logfaces.server.util.e.b();
            }
            bl = true;
            string = "key store is created, this server can now accept secure connections";
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            string = exception.getMessage();
        }
        object = Maps.newHashMap();
        object.put("rc", bl);
        object.put("message", string);
        return new ModelAndView(this.successView, "response", object);
    }

    private ModelAndView importTrustStoreCert(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Object object;
        boolean bl = false;
        Object object2 = "";
        try {
            object = new DiskFileItemFactory();
            ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)object);
            List list = servletFileUpload.parseRequest(httpServletRequest);
            if (list.size() != 2) {
                throw new Exception("no files selected");
            }
            String string = new String(((FileItem)list.get(0)).get());
            FileItem fileItem = (FileItem)list.get(1);
            com.moonlit.logfaces.server.util.e.a(string, fileItem.get());
            bl = true;
            object2 = "The certificate is imported succesfully into the local trust store";
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            object2 = "Failed to import certificate, error: '" + exception.getMessage() + "'";
        }
        object = Maps.newHashMap();
        object.put("rc", bl);
        object.put("message", object2);
        return new ModelAndView(this.successView, "response", object);
    }

    private ModelAndView clearKeyStore(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        boolean bl = WebUtils.getBoolean(httpServletRequest, "store", "keystore");
        com.moonlit.logfaces.server.util.e.c(bl);
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("rc", true);
        hashMap.put("message", String.format("The local %s store is cleared", bl ? "key" : "trust"));
        return new ModelAndView(this.successView, "response", (Object)hashMap);
    }

    private ModelAndView handleControl(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = WebUtils.getParameter(httpServletRequest, "what");
        if ("status".equalsIgnoreCase(string) || "restartStatus".equalsIgnoreCase(string)) {
            return this.getState(httpServletRequest, httpServletResponse);
        }
        if ("resetErrors".equalsIgnoreCase(string)) {
            com.moonlit.logfaces.server.util.m.a().c();
        } else if ("stop".equalsIgnoreCase(string)) {
            this.engine.c();
        } else if ("start".equalsIgnoreCase(string)) {
            this.engine.b();
            this.waitEngine(60, true);
        } else {
            if ("restart".equalsIgnoreCase(string)) {
                new Thread(new JsonController$3(this)).start();
                com.moonlit.logfaces.server.conf.d d2 = com.moonlit.logfaces.server.conf.d.a();
                BasicDBObject basicDBObject = new BasicDBObject();
                if (d2.K().equals("any-address")) {
                    basicDBObject.put("rebound", (Object)(d2.L() != httpServletRequest.isSecure() || d2.k() != httpServletRequest.getServerPort() ? 1 : 0));
                    basicDBObject.put("url", (Object)d2.j(httpServletRequest.getServerName()));
                } else {
                    basicDBObject.put("rebound", (Object)(!httpServletRequest.getServerName().equalsIgnoreCase(d2.N()) || d2.L() != httpServletRequest.isSecure() || d2.k() != httpServletRequest.getServerPort() ? 1 : 0));
                    basicDBObject.put("url", (Object)d2.M());
                }
                return new ModelAndView(this.successView, "response", (Object)basicDBObject);
            }
            if ("drop".equalsIgnoreCase(string)) {
                com.moonlit.logfaces.server.database.u u2 = this.dbx.g();
                if (u2 != null) {
                    u2.h();
                    u2.b(true);
                }
                c.a().f();
            } else if ("maint".equalsIgnoreCase(string)) {
                com.moonlit.logfaces.server.database.u u3 = this.dbx.g();
                if (u3 != null) {
                    u3.k();
                }
            } else if ("count".equalsIgnoreCase(string)) {
                com.moonlit.logfaces.server.database.u u4 = this.dbx.g();
                if (u4 != null) {
                    u4.b(true);
                    u4.c(true);
                }
            } else if ("resetStats".equalsIgnoreCase(string)) {
                w w2 = this.dbx.j();
                if (w2 != null && w2 instanceof com.moonlit.logfaces.server.core.c) {
                    ((com.moonlit.logfaces.server.core.c)((Object)w2)).f();
                }
                r.o().f();
            } else if ("loglevel".equalsIgnoreCase(string)) {
                com.moonlit.logfaces.server.log4j.c.a();
            } else {
                if ("getlog".equalsIgnoreCase(string)) {
                    File file = new File(com.moonlit.logfaces.server.conf.i.F());
                    FileUtils.copyFileToDirectory((File)file, (File)new File(com.moonlit.logfaces.server.conf.i.b()));
                    return new ModelAndView(this.successView, "link", (Object)String.format("temp/%s", file.getName()));
                }
                if ("getstack".equalsIgnoreCase(string)) {
                    return this.dumpThreads();
                }
                if ("gc".equalsIgnoreCase(string)) {
                    System.gc();
                } else {
                    if ("version".equalsIgnoreCase(string)) {
                        return this.checkVersion(httpServletRequest, httpServletResponse);
                    }
                    if ("serverdump".equalsIgnoreCase(string)) {
                        return this.sendServerDump(httpServletRequest, httpServletResponse);
                    }
                    if ("purgeOverflow".equalsIgnoreCase(string)) {
                        this.purgeOverflow(httpServletRequest, httpServletResponse);
                    }
                }
            }
        }
        return this.getState(httpServletRequest, httpServletResponse);
    }

    private void waitEngine(int n2, boolean bl) {
        do {
            com.moonlit.logfaces.server.util.C.d(1000L);
            if (--n2 != 0) continue;
            throw new Exception(String.format("engine failed to %s, see internal log for details.", bl ? "start" : "stop"));
        } while (this.engine.e() != bl);
    }

    private ModelAndView purgeOverflow(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        t t2 = this.dbx.l();
        if (t2 != null) {
            t2.k();
        }
        return new ModelAndView(this.successView, "response", (Object)"ok");
    }

    private ModelAndView getVersion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put("serverVersion", (Object)Revision.getRevision().toString());
        basicDBObject.put("osVersion", (Object)String.format("%s (%s), %s", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")));
        basicDBObject.put("javaVersion", (Object)System.getProperty("java.version"));
        try {
            com.moonlit.logfaces.server.database.u u2 = this.dbx.g();
            basicDBObject.put("dbProduct", u2.t().get("databaseProductName"));
            basicDBObject.put("dbDriverVersion", u2.t().get("driverVersion"));
            basicDBObject.put("dbDriverName", u2.t().get("driverName"));
            basicDBObject.put("dbVersion", u2.t().get("databaseProductVersion"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ModelAndView(this.successView, "response", (Object)basicDBObject);
    }

    private ModelAndView getState(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        DBObject dBObject = e.a().j();
        t t2 = this.dbx.l();
        if (t2 != null) {
            dBObject.put("overflowBuffer", (Object)String.format("cached events: %s, disk space: %s", t2.g(), com.moonlit.logfaces.server.util.C.c(t2.h())));
        }
        return new ModelAndView(this.successView, "response", (Object)dBObject);
    }

    private ModelAndView dumpThreads() {
        File file = new File(com.moonlit.logfaces.server.conf.i.b() + File.separator + "lfs-threads.txt");
        if (file.exists()) {
            FileUtils.forceDelete((File)file);
        }
        FileWriter fileWriter = new FileWriter(file);
        String string = System.getProperty("line.separator");
        try {
            Set<Thread> set = Thread.getAllStackTraces().keySet();
            fileWriter.write(String.format("*** Total threads: %d, active: %d ***%n%n", set.size(), Thread.activeCount()));
            fileWriter.write(String.format("%s%n%n", StringUtils.join(set, (String)string)));
            fileWriter.write(String.format("%s%n", "******** Thread dumps **********"));
            for (Thread thread : set) {
                StackTraceElement[] stackTraceElementArray;
                fileWriter.write(string + thread.getName() + string);
                for (StackTraceElement stackTraceElement : stackTraceElementArray = thread.getStackTrace()) {
                    fileWriter.write("\t" + stackTraceElement.toString() + string);
                }
            }
            ModelAndView modelAndView = new ModelAndView(this.successView, "link", (Object)String.format("temp/%s", file.getName()));
            return modelAndView;
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            throw exception;
        }
        finally {
            if (fileWriter != null) {
                ((Writer)fileWriter).flush();
                ((Writer)fileWriter).close();
            }
        }
    }

    private ModelAndView checkVersion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        BasicDBObject basicDBObject = new BasicDBObject();
        try {
            com.moonlit.logfaces.server.conf.i.a();
            com.moonlit.logfaces.server.updates.b b2 = LfsInstaller.a().b();
            Date date = com.moonlit.logfaces.server.l.e.a().k();
            Revision revision = b2.b();
            if (date.getTime() == 0L) {
                basicDBObject.put("available", (Object)false);
                basicDBObject.put("expired", (Object)false);
                basicDBObject.put("error", (Object)"This installation is not licensed");
            } else {
                basicDBObject.put("available", (Object)b2.d());
                basicDBObject.put("expired", (Object)(b2.b().getDate() > date.getTime() ? 1 : 0));
                basicDBObject.put("maintDate", (Object)new SimpleDateFormat("dd-MM-yyyy").format(date));
                basicDBObject.put("revision", (Object)String.format("%s (build #%d)", revision.toShortString(), revision.getBuild()));
                basicDBObject.put("notesUrl", (Object)System.getProperty("com.moonlit.logfaces.url.notes", "http://www.moonlit-software.com/logfaces/downloads/release-notes.txt"));
                basicDBObject.put("size", (Object)com.moonlit.logfaces.server.util.C.c(b2.c()));
            }
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            basicDBObject.put("available", (Object)false);
            basicDBObject.put("expired", (Object)false);
            basicDBObject.put("error", (Object)String.format("%s ( %s )", exception.getClass().getName(), exception.getMessage()));
        }
        return new ModelAndView(this.successView, "version", (Object)basicDBObject);
    }

    private ModelAndView sendServerDump(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        File file = new com.moonlit.logfaces.server.conf.o().a();
        return new ModelAndView(this.successView, "link", (Object)String.format("temp/%s", file.getName()));
    }

    @ExceptionHandler
    public ModelAndView handleError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Exception exception) {
        log.error(exception.getMessage(), (Throwable)exception);
        ModelAndView modelAndView = new ModelAndView(this.successView);
        modelAndView.addObject("error", (Object)ExceptionUtils.getRootCauseMessage((Throwable)exception));
        httpServletResponse.setStatus(500);
        httpServletRequest.setAttribute("exception", (Object)exception);
        return modelAndView;
    }
}

