/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.admin;

import com.google.common.collect.Lists;
import com.mongodb.DBObject;
import com.moonlit.logfaces.server.admin.Result;
import com.moonlit.logfaces.server.admin.WebUtils;
import com.moonlit.logfaces.server.admin.models.FloodDetectorModel;
import com.moonlit.logfaces.server.admin.models.MenuModel;
import com.moonlit.logfaces.server.admin.models.OptionModel;
import com.moonlit.logfaces.server.admin.models.PageType;
import com.moonlit.logfaces.server.admin.models.PairModel;
import com.moonlit.logfaces.server.admin.models.ReceiverModel;
import com.moonlit.logfaces.server.b.f;
import com.moonlit.logfaces.server.core.u;
import com.moonlit.logfaces.server.d;
import com.moonlit.logfaces.server.database.r;
import com.moonlit.logfaces.server.e;
import com.moonlit.logfaces.server.l.b;
import com.moonlit.logfaces.server.receivers.a;
import com.moonlit.logfaces.server.receivers.h;
import com.moonlit.logfaces.server.receivers.i;
import com.moonlit.logfaces.server.receivers.j;
import com.moonlit.logfaces.server.remoting.LfsService;
import com.moonlit.logfaces.server.util.Password;
import com.moonlit.logfaces.server.util.v;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@Scope(value="session")
@RequestMapping(value={""})
public class ConnectivityTabController {
    private Logger log = LogManager.getLogger((String)this.getClass().getName());
    private com.moonlit.logfaces.server.conf.d configurator = com.moonlit.logfaces.server.conf.d.a();
    private Result result;

    @RequestMapping(value={"/connectivityTab"}, method={RequestMethod.GET})
    public ModelAndView renderConnectivity(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Object object;
        Object object22;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("menu", MenuModel.build(PageType.connectivity));
        if (!e.a().e()) {
            hashMap.put("message", "Engine is not running, please start the engine from status tab or restart the server.");
            return new ModelAndView("notfeatured", "params", hashMap);
        }
        Object object3 = httpServletRequest.getParameter("subtab");
        if (object3 == null) {
            object3 = httpServletRequest.getSession().getAttribute("subtab");
            object3 = object3 != null ? object3 : Integer.valueOf(0);
        }
        hashMap.put("subtab", object3);
        HttpSession httpSession = httpServletRequest.getSession();
        httpSession.removeAttribute("subtab");
        httpSession.removeAttribute("fd");
        com.moonlit.logfaces.server.conf.d d2 = com.moonlit.logfaces.server.conf.d.a();
        User user = com.moonlit.logfaces.server.access.i.a().b("admin");
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(new OptionModel("Address", "externalBinding", d2.K(), v.a(), "Binding address to be used by external clients to reach this server", "conn.address"));
        arrayList.add(new OptionModel("Port", "externalPort", "" + d2.k(), "Listening port number"));
        if (com.moonlit.logfaces.server.util.e.a()) {
            arrayList.add(new OptionModel("SSL", "ssl", d2.L() ? "Yes" : "No", Lists.newArrayList((Object[])new String[]{"Yes", "No"}), "Access to this server from outside will be strictly over SSL", "conn.ssl"));
        }
        arrayList.add(new OptionModel("Admin user", "adminUser", user.getUsername(), "User name for administrator login"));
        OptionModel optionModel = new OptionModel("Admin password", "adminPwd", Password.b(user.getPassword()), "Password for administrator login");
        optionModel.setPassword(true);
        arrayList.add(optionModel);
        if (d2.y().b()) {
            arrayList.add(new OptionModel("Admin authentication", "adminDelegate", d2.x() ? "ldap" : "local", Lists.newArrayList((Object[])new String[]{"ldap", "local"}), "How to authenticate administrators", "conn.adminDelegate"));
        }
        hashMap.put("external", arrayList);
        j j2 = j.i();
        ArrayList arrayList2 = Lists.newArrayList();
        for (Object object22 : j2.f()) {
            object = new ReceiverModel((u)object22);
            arrayList2.add(object);
        }
        Collections.sort(arrayList2);
        hashMap.put("receivers", arrayList2);
        boolean bl = com.moonlit.logfaces.server.l.e.a().a(b.k) && !r.a().i() && LfsService.getInstance().getPairs().isEmpty();
        hashMap.put("pairingEnabled", bl);
        if (bl) {
            object22 = f.a();
            object = Lists.newArrayList();
            for (Object object4 : ((f)object22).e()) {
                Object object5 = new PairModel();
                ((PairModel)object5).setHost(((d)object4).b());
                ((PairModel)object5).setPort(((d)object4).c());
                ((PairModel)object5).setSecure(((d)object4).g());
                ((PairModel)object5).setConnected(((f)object22).b((d)object4));
                ((PairModel)object5).setAdminUrl(String.format("http%s://%s:%d", ((PairModel)object5).isSecure() ? "s" : "", ((d)object4).b(), ((PairModel)object5).getPort()));
                object.add(object5);
            }
            hashMap.put("pairs", object);
        }
        object22 = new com.moonlit.logfaces.server.util.a();
        object = ((com.moonlit.logfaces.server.util.a)object22).a(a.b().d());
        object.put("meta", (Object)((com.moonlit.logfaces.server.util.a)object22).a(true));
        hashMap.put("blacklist", StringEscapeUtils.escapeHtml4((String)object.toString()));
        ArrayList arrayList3 = Lists.newArrayList();
        for (Object object5 : i.b().e()) {
            arrayList3.add(new FloodDetectorModel((h)object5));
        }
        hashMap.put("fds", arrayList3);
        hashMap.put("bouncersEnabled", false);
        return new ModelAndView("connectivity", "params", hashMap);
    }

    @RequestMapping(value={"/updateConnectivity"}, method={RequestMethod.POST})
    public ModelAndView updateConnectivity(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (com.moonlit.logfaces.server.conf.d.P()) {
            throw new Exception("This server instance is immutable");
        }
        this.result = new Result();
        this.result.addLink("connectivityTab", "Continue");
        HttpSession httpSession = httpServletRequest.getSession();
        int n2 = WebUtils.getInt(httpServletRequest, "subtab", 0);
        httpSession.setAttribute("subtab", (Object)n2);
        httpSession.setAttribute("result", (Object)this.result);
        if (n2 == 0) {
            return this.handleExernals(httpServletRequest, httpServletResponse);
        }
        return null;
    }

    @RequestMapping(value={"/fd"}, method={RequestMethod.GET})
    public ModelAndView renderFloodDetector(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HttpSession httpSession = httpServletRequest.getSession();
        httpSession.setAttribute("subtab", (Object)3);
        long l2 = Long.parseLong(httpServletRequest.getParameter("id"));
        h h2 = i.b().b(l2);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("fid", h2.p());
        com.moonlit.logfaces.server.util.a a2 = new com.moonlit.logfaces.server.util.a();
        DBObject dBObject = a2.a(h2.m());
        dBObject.put("meta", (Object)a2.a(r.a().g().q()));
        hashMap.put("criteria", StringEscapeUtils.escapeHtml4((String)dBObject.toString()));
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(new OptionModel("Enabled", "enabled", h2.b() ? "Yes" : "No", Lists.newArrayList((Object[])new String[]{"Yes", "No"}), "Will not be used to detect flood when disabled"));
        arrayList.add(new OptionModel("Description", "name", StringEscapeUtils.escapeHtml4((String)h2.b_()), "For management purposes"));
        arrayList.add(new OptionModel("Time window (sec)", "window", "" + h2.c() / 1000L, "Time window for determining if flood occurs", "flood.window"));
        arrayList.add(new OptionModel("Threshold", "threshold", "" + h2.a_(), "How many events in time window to consider as flood", "flood.threshold"));
        hashMap.put("detector", arrayList);
        hashMap.put("title", h2.b_());
        httpSession.setAttribute("fd", (Object)h2);
        return new ModelAndView("fdView", "params", hashMap);
    }

    private ModelAndView handleExernals(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string;
        boolean bl;
        int n2;
        boolean bl2 = false;
        String string2 = WebUtils.getParameter(httpServletRequest, "externalBinding", "any-address");
        if (!this.configurator.K().equals(string2)) {
            this.configurator.i(string2);
            bl2 = true;
        }
        if ((n2 = WebUtils.getInt(httpServletRequest, "externalPort", 8050)) != this.configurator.k()) {
            this.configurator.b(n2);
            bl2 = true;
        }
        if ((bl = WebUtils.getBoolean(httpServletRequest, "ssl", "yes")) && !this.configurator.L() && !new File(System.getProperty("com.moonlit.logfaces.security.keyStore", "null")).exists()) {
            throw new Exception("SSL key store file doesn't exist.<p>SSL connection can only be enabled when key and trust store containing valid SSL certificate are configured in server environment. For more information about setting up SSL please refer to user manual.</p>");
        }
        if (bl != this.configurator.L()) {
            this.configurator.g(bl);
            bl2 = true;
        }
        try {
            string = WebUtils.getParameter(httpServletRequest, "adminUser");
            String string3 = WebUtils.getParameter(httpServletRequest, "adminPwd");
            if (StringUtils.isBlank((CharSequence)string)) {
                throw new Exception("administrator user name may not be an empty string");
            }
            if (StringUtils.isBlank((CharSequence)string3) && !this.configurator.y().b()) {
                throw new Exception("administrator password may not be an empty string");
            }
            boolean bl3 = WebUtils.getBoolean(httpServletRequest, "adminDelegate", "ldap");
            if (bl3 && this.configurator.y().b()) {
                this.testAdminLdapAccess(string);
            }
            ArrayList arrayList = Lists.newArrayList();
            arrayList.add(new SimpleGrantedAuthority(com.moonlit.logfaces.server.access.i.a));
            User user = new User(string, Password.a(string3), (Collection)arrayList);
            com.moonlit.logfaces.server.access.i.a().a(user);
            this.configurator.a(bl3);
            this.configurator.f();
        }
        catch (Exception exception) {
            this.log.error(exception.getMessage(), (Throwable)exception);
            throw new Exception("Failed configuring admin credentials, error:<br>" + exception.getMessage());
        }
        this.result.setInfo("Settings applied, no restart is required");
        if (bl2) {
            this.result.clear();
            this.result.setInfo(String.format("Server is now bound to <b>%s</b><br>For the changes to take effect the server must be restarted", this.configurator.M()));
            string = String.format("%s://%s:%d", httpServletRequest.isSecure() ? "https" : "http", httpServletRequest.getServerName(), httpServletRequest.getServerPort());
            this.result.addLink("restartServer", string, "Restart server now");
        }
        httpServletResponse.sendRedirect("result");
        return null;
    }

    private void testAdminLdapAccess(String string) {
        List list = com.moonlit.logfaces.server.access.i.a().d();
        if (!list.contains(string)) {
            this.log.warn(String.format("user [%s] is not found in directory list", string));
            throw new Exception(String.format("User '%s' is not found in name directory, you will not be able to login into administration with this user name", string));
        }
    }

    @ExceptionHandler
    public ModelAndView handleError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Exception exception) {
        this.log.error(exception.getMessage(), (Throwable)exception);
        Result result = new Result();
        result.addLink("connectivityTab", "Continue");
        result.setError(exception.getMessage());
        httpServletRequest.getSession().setAttribute("result", (Object)result);
        try {
            httpServletResponse.sendRedirect("result");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

