/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.server.admin;

import com.moonlit.logfaces.server.access.b;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdminFilter
implements Filter {
    private String encoding;
    private Pattern ignorePattern;
    private Logger log = LogManager.getLogger(this.getClass());

    public void init(FilterConfig filterConfig) {
        this.encoding = Charset.defaultCharset().displayName();
        String string = filterConfig.getInitParameter("ignoreList");
        this.ignorePattern = Pattern.compile(string);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        httpServletResponse.setCharacterEncoding(this.encoding);
        String string = httpServletRequest.getHeader("Origin");
        httpServletResponse.addHeader("Access-Control-Allow-Origin", string != null ? string : "*");
        String string2 = httpServletRequest.getRequestURI();
        if (this.ignorePattern.matcher(string2).matches()) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        String string3 = httpServletRequest.getQueryString();
        if (string3 == null || string3 != null && !string3.contains("what=status") && !string3.contains("method=getPairs")) {
            this.log.info(String.format("admin request from %s %s%s", httpServletRequest.getRemoteAddr(), httpServletRequest.getServletPath(), string3 != null ? "?" + string3 : ""));
        }
        if (string3 != null && string3.contains("what=restartStatus")) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        if (this.checkSession(httpServletRequest, httpServletResponse)) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }

    private boolean checkSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession != null && httpSession.getAttribute("authenticated") != null) {
            return true;
        }
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray != null) {
            for (Cookie cookie : cookieArray) {
                if (!cookie.getName().equals("lfsa")) continue;
                if (!b.a().a(cookie.getValue())) break;
                httpSession.setAttribute("authenticated", (Object)true);
                return true;
            }
        }
        httpServletResponse.sendRedirect("/login");
        return false;
    }
}

