/*
 * Decompiled with CFR 0.152.
 */
package com.novocode.ishell;

import com.novocode.ishell.CustomDrawnButton;
import com.novocode.ishell.InternalShell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class TitleBarButton
extends CustomDrawnButton {
    private final Color highlightShadowColor;
    private final Color lightShadowColor;
    private final Color normalShadowColor;
    private final Color darkShadowColor;
    private final Color gradEndColor;
    private final Color inactiveGradEndColor;
    private final Color widgetBackgroundColor;
    private final Color widgetForegroundColor;
    private final int style;
    private final Shell shell;
    private final Display display;
    private final InternalShell ishell;
    private int leftOff;
    private int rightOff;
    private Image image;

    public TitleBarButton(InternalShell parent, Image image) {
        this(parent, 1);
        this.image = image;
    }

    public TitleBarButton(InternalShell parent, int style) {
        super(parent, 786432);
        this.style = style;
        this.shell = this.getShell();
        this.display = this.getDisplay();
        this.ishell = parent;
        this.highlightShadowColor = this.display.getSystemColor(20);
        this.lightShadowColor = this.display.getSystemColor(19);
        this.normalShadowColor = this.display.getSystemColor(18);
        this.darkShadowColor = this.display.getSystemColor(17);
        this.gradEndColor = this.display.getSystemColor(32);
        this.inactiveGradEndColor = this.display.getSystemColor(35);
        this.widgetBackgroundColor = this.display.getSystemColor(22);
        this.widgetForegroundColor = this.display.getSystemColor(21);
        if ((style & 0x440) != 0) {
            this.rightOff = 2;
        } else {
            this.leftOff = 2;
        }
        final Listener activateListener = new Listener(){

            public void handleEvent(Event event) {
                TitleBarButton.this.redraw();
            }
        };
        final Listener deactivateListener = new Listener(){

            public void handleEvent(Event event) {
                TitleBarButton.this.redraw();
            }
        };
        this.shell.addListener(26, activateListener);
        this.shell.addListener(27, deactivateListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                TitleBarButton.this.shell.removeListener(26, activateListener);
                TitleBarButton.this.shell.removeListener(27, deactivateListener);
            }
        });
    }

    public int getStyle() {
        return this.style;
    }

    @Override
    protected void onPaint(Event event, boolean pressed) {
        int pOff;
        Color briColor;
        Color broColor;
        Color tliColor;
        Color tloColor;
        Point size = this.getSize();
        boolean active = this.shell == this.display.getActiveShell() && this.ishell.isActiveShell();
        GC gc = event.gc;
        gc.setBackground(active ? this.gradEndColor : this.inactiveGradEndColor);
        gc.fillRectangle(0, 0, size.x, size.y);
        gc.setBackground(this.widgetBackgroundColor);
        gc.fillRectangle(2, 4, size.x - 4, size.y - 6);
        if (pressed) {
            tloColor = this.darkShadowColor;
            tliColor = this.normalShadowColor;
            broColor = this.highlightShadowColor;
            briColor = this.lightShadowColor;
            pOff = 1;
        } else {
            tloColor = this.highlightShadowColor;
            tliColor = this.lightShadowColor;
            broColor = this.darkShadowColor;
            briColor = this.normalShadowColor;
            pOff = 0;
        }
        TitleBarButton.drawBevelRect(gc, this.leftOff, 2, size.x - 1 - this.leftOff - this.rightOff, size.y - 5, tloColor, broColor);
        TitleBarButton.drawBevelRect(gc, 1 + this.leftOff, 3, size.x - 3 - this.leftOff - this.rightOff, size.y - 7, tliColor, briColor);
        if (this.isEnabled()) {
            gc.setForeground(this.widgetForegroundColor);
            this.drawImage(gc, size, pOff);
        } else {
            gc.setForeground(this.highlightShadowColor);
            this.drawImage(gc, size, 1);
            gc.setForeground(this.normalShadowColor);
            this.drawImage(gc, size, 0);
        }
    }

    private void drawImage(GC gc, Point size, int pOff) {
        if ((this.style & 0x40) != 0) {
            this.drawCloseImage(gc, size, pOff);
        } else if ((this.style & 0x400) != 0) {
            if (this.ishell.getMaximized()) {
                this.drawRestoreImage(gc, size, pOff);
            } else {
                this.drawMaximizeImage(gc, size, pOff);
            }
        } else if ((this.style & 0x80) != 0) {
            this.drawMinimizeImage(gc, size, pOff);
        } else if ((this.style & 1) != 0 && this.image != null) {
            gc.drawImage(this.image, 2, pOff + 2);
        }
    }

    private static void drawBevelRect(GC gc, int x, int y, int w, int h, Color topleft, Color bottomright) {
        gc.setForeground(bottomright);
        gc.drawLine(x + w, y, x + w, y + h);
        gc.drawLine(x, y + h, x + w, y + h);
        gc.setForeground(topleft);
        gc.drawLine(x, y, x + w - 1, y);
        gc.drawLine(x, y, x, y + h - 1);
    }

    private void drawCloseImage(GC gc, Point size, int pOff) {
        gc.drawLine(pOff + this.leftOff + 4, pOff + 5, pOff + size.x - this.leftOff - this.rightOff - 6, pOff + size.y - 7);
        gc.drawLine(pOff + this.leftOff + 5, pOff + 5, pOff + size.x - this.leftOff - this.rightOff - 5, pOff + size.y - 7);
        gc.drawLine(pOff + this.leftOff + 4, pOff + size.y - 7, pOff + size.x - this.leftOff - this.rightOff - 6, pOff + 5);
        gc.drawLine(pOff + this.leftOff + 5, pOff + size.y - 7, pOff + size.x - this.leftOff - this.rightOff - 5, pOff + 5);
    }

    private void drawRestoreImage(GC gc, Point size, int pOff) {
        gc.drawRectangle(pOff + this.leftOff + 3, pOff + 7, size.x - this.leftOff - this.rightOff - 11, size.y - 13);
        gc.drawLine(pOff + this.leftOff + 4, pOff + 8, pOff + size.x - this.leftOff - this.rightOff - 9, pOff + 8);
        gc.drawLine(pOff + this.leftOff + 6, pOff + 5, pOff + size.x - this.leftOff - this.rightOff - 7, pOff + 5);
        gc.drawLine(pOff + this.leftOff + 5, pOff + 4, pOff + size.x - this.leftOff - this.rightOff - 6, pOff + 4);
        gc.drawLine(pOff + size.x - this.leftOff - this.rightOff - 7, pOff + size.y - 9, pOff + size.x - this.leftOff - this.rightOff - 6, pOff + size.y - 9);
        gc.drawLine(pOff + size.x - this.leftOff - this.rightOff - 6, pOff + size.y - 10, pOff + size.x - this.leftOff - this.rightOff - 6, pOff + 5);
        gc.drawLine(pOff + this.leftOff + 5, pOff + 5, pOff + this.leftOff + 5, pOff + 6);
    }

    private void drawMaximizeImage(GC gc, Point size, int pOff) {
        gc.drawRectangle(pOff + this.leftOff + 3, pOff + 4, size.x - this.leftOff - this.rightOff - 8, size.y - 10);
        gc.drawLine(pOff + this.leftOff + 4, pOff + 5, pOff + size.x - this.leftOff - this.rightOff - 6, pOff + 5);
    }

    private void drawMinimizeImage(GC gc, Point size, int pOff) {
        gc.drawLine(pOff + this.leftOff + 4, pOff + size.y - 6, pOff + size.x - this.leftOff - this.rightOff - 5, pOff + size.y - 6);
        gc.drawLine(pOff + this.leftOff + 4, pOff + size.y - 7, pOff + size.x - this.leftOff - this.rightOff - 5, pOff + size.y - 7);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }
}

