/*
 * Decompiled with CFR 0.152.
 */
package com.novocode.ishell;

import com.novocode.ishell.DesktopForm;
import com.novocode.ishell.InternalShell;
import com.novocode.ishell.LocalizedStrings;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public final class TitleBar
extends Canvas {
    private static final long UPDATE_DELAY = 25L;
    private static final int MINIMUM_GRAB_AREA = 2;
    private static final String ELLIPSIS = "...";
    private static final int LEFT_PADDING = 2;
    private static final int RIGHT_PADDING = 2;
    private static final int IMAGE_SIZE = 16;
    private static final int TOOL_SIZE = 14;
    private static final int TOP_PADDING = 1;
    private static final int BOTTOM_PADDING = 1;
    private int mouseDownOffsetX;
    private int mouseDownOffsetY;
    private int snapBackX;
    private int snapBackY;
    private boolean cancelled;
    private volatile long lastUpdate;
    private Timer timer = new Timer(true);
    private TimerTask timerTask;
    private final InternalShell ishell;
    private final DesktopForm desktop;
    private String text;
    private Image image;
    private final boolean styleClose;
    private final boolean styleMax;
    private final boolean styleTool;
    private final boolean styleMin;
    private final Image closeImage;
    private final Image restoreImage;
    private final Image maximizeImage;
    private final Image minimizeImage;
    private final MenuItem restoreItem;
    private final MenuItem closeItem;
    private final MenuItem maximizeItem;
    private final Menu defaultPopup;
    private final Point minGrabSize = new Point(2, 2);
    private static final int IMAGE_TYPE_CLOSE = 1;
    private static final int IMAGE_TYPE_MAXIMIZE = 2;
    private static final int IMAGE_TYPE_RESTORE = 3;
    private static final int IMAGE_TYPE_MINIMIZE = 4;

    public TitleBar(InternalShell parent, int style) {
        super((Composite)parent, TitleBar.checkStyle(style));
        this.ishell = parent;
        this.desktop = (DesktopForm)this.ishell.getParent();
        this.styleClose = (style & 0x40) != 0;
        this.styleMax = (style & 0x400) != 0;
        this.styleMin = (style & 0x80) != 0;
        this.styleTool = (style & 4) != 0;
        final Display display = this.getDisplay();
        final Shell shell = this.getShell();
        final Color gradStartColor = display.getSystemColor(31);
        final Color gradEndColor = display.getSystemColor(32);
        final Color textColor = display.getSystemColor(30);
        final Color inactiveGradStartColor = display.getSystemColor(34);
        final Color inactiveGradEndColor = display.getSystemColor(35);
        final Color inactiveTextColor = display.getSystemColor(33);
        GC gc = new GC((Drawable)this);
        int imgHeight = gc.getFontMetrics().getHeight() - 1;
        if (imgHeight % 2 == 0) {
            --imgHeight;
        }
        gc.dispose();
        this.closeImage = this.createMenuImage(1, imgHeight);
        this.restoreImage = this.createMenuImage(3, imgHeight);
        this.maximizeImage = this.createMenuImage(2, imgHeight);
        this.minimizeImage = this.createMenuImage(4, imgHeight);
        this.defaultPopup = new Menu((Control)this);
        this.restoreItem = new MenuItem(this.defaultPopup, 8);
        this.restoreItem.setText(LocalizedStrings.get("popup.restore"));
        this.restoreItem.setImage(this.restoreImage);
        this.restoreItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TitleBar.this.ishell.setMaximized(false);
            }
        });
        MenuItem minimizeItem = new MenuItem(this.defaultPopup, 8);
        minimizeItem.setText(LocalizedStrings.get("popup.minimize"));
        minimizeItem.setEnabled(this.styleMin);
        minimizeItem.setImage(this.minimizeImage);
        minimizeItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TitleBar.this.ishell.setMinimized(true);
            }
        });
        this.maximizeItem = new MenuItem(this.defaultPopup, 8);
        this.maximizeItem.setText(LocalizedStrings.get("popup.maximize"));
        this.maximizeItem.setImage(this.maximizeImage);
        this.maximizeItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TitleBar.this.ishell.setMaximized(true);
            }
        });
        new MenuItem(this.defaultPopup, 2);
        this.closeItem = new MenuItem(this.defaultPopup, 8);
        this.closeItem.setText(LocalizedStrings.get("popup.close"));
        this.closeItem.setEnabled(this.styleClose);
        this.closeItem.setImage(this.closeImage);
        this.closeItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TitleBar.this.ishell.close();
            }
        });
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                Rectangle r = TitleBar.this.getClientArea();
                if (r.width == 0 || r.height == 0) {
                    return;
                }
                boolean active = shell == display.getActiveShell() && TitleBar.this.ishell.isActiveShell();
                GC gc = event.gc;
                gc.setForeground(active ? gradStartColor : inactiveGradStartColor);
                gc.setBackground(active ? gradEndColor : inactiveGradEndColor);
                gc.fillGradientRectangle(r.x, r.y, r.width, r.height, false);
                int textLeftPadding = 2;
                if (TitleBar.this.image != null) {
                    Rectangle imageBounds = TitleBar.this.image.getBounds();
                    if (imageBounds.width > 16 || imageBounds.height > 16) {
                        gc.drawImage(TitleBar.this.image, 0, 0, imageBounds.width, imageBounds.height, 2, 1, 16, 16);
                    } else {
                        gc.drawImage(TitleBar.this.image, 2 + (16 - imageBounds.width) / 2, (r.height - imageBounds.height) / 2);
                    }
                    textLeftPadding += 18;
                }
                if (TitleBar.this.text != null && TitleBar.this.text.length() > 0) {
                    gc.setForeground(active ? textColor : inactiveTextColor);
                    Object s = TitleBar.this.text;
                    int availableWidth = r.width - textLeftPadding - 2;
                    if (gc.textExtent((String)s, (int)1).x > availableWidth) {
                        int ellipsisWidth = gc.textExtent((String)TitleBar.ELLIPSIS, (int)1).x;
                        while (((String)s).length() > 0) {
                            s = ((String)s).substring(0, ((String)s).length() - 1);
                            if (gc.textExtent((String)s, (int)1).x + ellipsisWidth > availableWidth) continue;
                            s = (String)s + TitleBar.ELLIPSIS;
                            break;
                        }
                        TitleBar.this.setToolTipText(TitleBar.this.text);
                    } else {
                        TitleBar.this.setToolTipText(null);
                    }
                    if (((String)s).length() > 0) {
                        gc.drawString((String)s, textLeftPadding, (r.height - gc.getFontMetrics().getHeight()) / 2, true);
                    }
                } else {
                    TitleBar.this.setToolTipText(null);
                }
            }
        });
        this.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (event.button == 1) {
                    if (TitleBar.this.image != null && event.x < 18) {
                        TitleBar.this.cancelled = true;
                        TitleBar.this.instrumentDefaultPopup(true);
                        TitleBar.this.defaultPopup.setLocation(TitleBar.this.toDisplay(0, TitleBar.this.getSize().y));
                        TitleBar.this.defaultPopup.setVisible(true);
                    } else {
                        TitleBar.this.mouseDownOffsetX = event.x;
                        TitleBar.this.mouseDownOffsetY = event.y;
                        Point p = TitleBar.this.ishell.getLocation();
                        TitleBar.this.snapBackX = p.x;
                        TitleBar.this.snapBackY = p.y;
                        TitleBar.this.cancelled = false;
                    }
                } else if (event.button == 3 && (event.stateMask & 0x80000) != 0 && TitleBar.this.snapBackX != Integer.MIN_VALUE && TitleBar.this.snapBackY != Integer.MIN_VALUE) {
                    TitleBar.this.ishell.setLocation(TitleBar.this.snapBackX, TitleBar.this.snapBackY);
                    TitleBar.this.snapBackX = Integer.MIN_VALUE;
                    TitleBar.this.snapBackY = Integer.MIN_VALUE;
                    TitleBar.this.cancelled = true;
                }
            }
        });
        this.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
                Menu m = TitleBar.this.getMenu();
                if (m == null || m.isDisposed()) {
                    m = TitleBar.this.defaultPopup;
                    TitleBar.this.instrumentDefaultPopup(false);
                }
                m.setLocation(event.x, event.y);
                m.setVisible(true);
            }
        });
        this.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                if (event.button == 1) {
                    if (TitleBar.this.image != null && event.x < 18) {
                        if (TitleBar.this.styleClose) {
                            TitleBar.this.ishell.close();
                        }
                    } else if (TitleBar.this.styleMax) {
                        TitleBar.this.ishell.setMaximized(!TitleBar.this.ishell.getMaximized());
                    }
                    TitleBar.this.cancelled = true;
                }
            }
        });
        this.addListener(5, new Listener(){

            public void handleEvent(final Event event) {
                if (!TitleBar.this.cancelled && (event.stateMask & 0x80000) != 0 && !TitleBar.this.ishell.getMaximized()) {
                    long now;
                    if (TitleBar.this.timerTask != null) {
                        TitleBar.this.timerTask.cancel();
                        TitleBar.this.timerTask = null;
                    }
                    if (TitleBar.this.lastUpdate + 25L < (now = System.currentTimeMillis())) {
                        TitleBar.this.performMove(event);
                        TitleBar.this.lastUpdate = now;
                    } else {
                        TitleBar.this.timerTask = new TimerTask(){

                            @Override
                            public void run() {
                                final 1 executingTask = this;
                                event.display.asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (executingTask != ((this).this).TitleBar.this.timerTask) {
                                            return;
                                        }
                                        TitleBar.this.performMove(event);
                                    }
                                });
                            }
                        };
                        TitleBar.this.timer.schedule(TitleBar.this.timerTask, 25L);
                    }
                }
            }
        });
        this.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                if (TitleBar.this.ishell.getMaximized()) {
                    return;
                }
                if (TitleBar.this.image == null || event.x >= 18) {
                    if (TitleBar.this.timerTask != null) {
                        TitleBar.this.timerTask.cancel();
                        TitleBar.this.timerTask = null;
                    }
                    if (!TitleBar.this.cancelled && (event.stateMask & 0x80000) != 0) {
                        TitleBar.this.performMove(event);
                    }
                }
            }
        });
        final Listener activateListener = new Listener(){

            public void handleEvent(Event event) {
                TitleBar.this.redraw();
            }
        };
        final Listener deactivateListener = new Listener(){

            public void handleEvent(Event event) {
                TitleBar.this.redraw();
            }
        };
        shell.addListener(26, activateListener);
        shell.addListener(27, deactivateListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                TitleBar.this.timer.cancel();
                shell.removeListener(26, activateListener);
                shell.removeListener(27, deactivateListener);
                TitleBar.this.closeImage.dispose();
                TitleBar.this.maximizeImage.dispose();
                TitleBar.this.restoreImage.dispose();
                TitleBar.this.minimizeImage.dispose();
                TitleBar.this.defaultPopup.dispose();
            }
        });
    }

    private void performMove(Event event) {
        Point p = this.ishell.getLocation();
        int newX = p.x + event.x - this.mouseDownOffsetX;
        int newY = p.y + event.y - this.mouseDownOffsetY;
        Rectangle deskCA = this.desktop.getClientArea();
        Rectangle bounds = this.getBounds();
        newX = Math.min(Math.max(newX, deskCA.x - bounds.x - bounds.width + 2), deskCA.x - bounds.x + deskCA.width - this.minGrabSize.x);
        newY = Math.min(Math.max(newY, deskCA.y - bounds.y - bounds.height + 2), deskCA.y - bounds.y + deskCA.height - 2);
        if (newX != p.x || newY != p.y) {
            this.ishell.setLocation(newX, newY);
        }
    }

    public Point getMinGrabSize() {
        return this.minGrabSize;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint == -1) {
            wHint = 50;
        }
        if (hHint == -1) {
            GC gc = new GC((Drawable)this);
            hHint = gc.getFontMetrics().getHeight();
            hHint = Math.max(hHint, this.styleTool ? 14 : 20);
            hHint += 2;
            gc.dispose();
        }
        return new Point(wHint, hHint);
    }

    private static int checkStyle(int style) {
        style = 524288;
        return style;
    }

    public boolean setFocus() {
        this.checkWidget();
        return false;
    }

    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    public void setText(String text) {
        this.checkWidget();
        this.text = text;
        this.redraw();
    }

    public String getText() {
        return this.text;
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (this.styleTool) {
            return;
        }
        this.image = image;
        this.minGrabSize.x = 2;
        if (image != null) {
            this.minGrabSize.x += 18;
        }
        this.redraw();
    }

    public Image getImage() {
        return this.image;
    }

    private void instrumentDefaultPopup(boolean onImage) {
        this.restoreItem.setEnabled(this.styleMax && this.ishell.getMaximized());
        this.maximizeItem.setEnabled(this.styleMax && !this.ishell.getMaximized());
        MenuItem def = null;
        if (onImage) {
            if (this.styleClose) {
                def = this.closeItem;
            }
        } else if (this.styleMax) {
            def = this.ishell.getMaximized() ? this.restoreItem : this.maximizeItem;
        }
        this.defaultPopup.setDefaultItem(def);
    }

    private Image createMenuImage(int type, int height) {
        Point size = new Point(height, height);
        int imgWidth = height + height / 2;
        Color fg = this.getForeground();
        Color white = this.getDisplay().getSystemColor(1);
        RGB blackRGB = new RGB(0, 0, 0);
        ImageData id = new ImageData(imgWidth, size.y, 1, new PaletteData(new RGB[]{blackRGB, fg.getRGB()}));
        ImageData maskid = new ImageData(imgWidth, size.y, 1, new PaletteData(new RGB[]{blackRGB, white.getRGB()}));
        Image img = new Image((Device)this.getDisplay(), id);
        GC gc = new GC((Drawable)img);
        gc.setForeground(fg);
        this.drawMenuImage(gc, size, type);
        gc.dispose();
        Image maskimg = new Image((Device)this.getDisplay(), maskid);
        gc = new GC((Drawable)maskimg);
        gc.setForeground(white);
        this.drawMenuImage(gc, size, type);
        gc.dispose();
        Image transp = new Image((Device)this.getDisplay(), img.getImageData(), maskimg.getImageData());
        img.dispose();
        maskimg.dispose();
        return transp;
    }

    private void drawMenuImage(GC gc, Point size, int type) {
        switch (type) {
            case 1: {
                gc.drawLine(1, 1, size.x - 2, size.y - 2);
                gc.drawLine(2, 1, size.x - 2, size.y - 3);
                gc.drawLine(1, 2, size.x - 3, size.y - 2);
                gc.drawLine(1, size.y - 2, size.x - 2, 1);
                gc.drawLine(1, size.y - 3, size.x - 3, 1);
                gc.drawLine(2, size.y - 2, size.x - 2, 2);
                break;
            }
            case 3: {
                gc.drawRectangle(0, 4, size.x - 4, size.y - 6);
                gc.drawLine(1, 5, size.x - 5, 5);
                gc.drawLine(2, 1, size.x - 2, 1);
                gc.drawLine(2, 2, size.x - 2, 2);
                gc.drawPoint(2, 3);
                gc.drawLine(size.x - 2, 3, size.x - 2, size.y - 5);
                gc.drawPoint(size.x - 3, size.y - 5);
                break;
            }
            case 2: {
                gc.drawRectangle(0, 0, size.x - 2, size.y - 2);
                gc.drawLine(1, 1, size.x - 3, 1);
                break;
            }
            case 4: {
                gc.drawLine(1, size.y - 2, size.x - 4, size.y - 2);
                gc.drawLine(1, size.y - 3, size.x - 4, size.y - 3);
            }
        }
    }

    public void dispose() {
        try {
            this.getFont().dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.dispose();
    }
}

