/*
 * Decompiled with CFR 0.152.
 */
package com.novocode.ishell;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public final class SizeGrip
extends Canvas {
    private static final int WIDTH = 13;
    private static final int HEIGHT = 13;
    private static final long UPDATE_DELAY = 25L;
    private int mouseDownOffsetX;
    private int mouseDownOffsetY;
    private int snapBackX;
    private int snapBackY;
    private boolean cancelled;
    private Cursor sizeCursor;
    private Point minSize;
    private boolean userVisible;
    private volatile long lastUpdate;
    private Timer timer;
    private TimerTask timerTask;
    private Composite resizableParent;

    public SizeGrip(Composite parent, int style) {
        this(parent, (Composite)parent.getShell(), style);
    }

    public SizeGrip(Composite parent, final Composite resizableParent, int style) {
        Listener resizeListener;
        style = SizeGrip.checkStyle(style);
        super(parent, style);
        this.userVisible = true;
        this.timer = new Timer(true);
        this.resizableParent = resizableParent;
        this.setSize(13, 13);
        this.sizeCursor = new Cursor((Device)this.getDisplay(), 8);
        this.setCursor(this.sizeCursor);
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                if (SizeGrip.this.sizeCursor != null) {
                    SizeGrip.this.sizeCursor.dispose();
                    SizeGrip.this.sizeCursor = null;
                }
            }
        });
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                Rectangle r = SizeGrip.this.getClientArea();
                if (r.width == 0 || r.height == 0) {
                    return;
                }
                Display disp = SizeGrip.this.getDisplay();
                Color shadow = disp.getSystemColor(18);
                Color highlight = disp.getSystemColor(20);
                event.gc.setLineWidth(1);
                if ((SizeGrip.this.getStyle() & 0x800000) != 0) {
                    event.gc.setBackground(highlight);
                    event.gc.fillRectangle(r.width - 3, r.height - 3, 2, 2);
                    event.gc.fillRectangle(r.width - 7, r.height - 3, 2, 2);
                    event.gc.fillRectangle(r.width - 11, r.height - 3, 2, 2);
                    event.gc.fillRectangle(r.width - 3, r.height - 7, 2, 2);
                    event.gc.fillRectangle(r.width - 7, r.height - 7, 2, 2);
                    event.gc.fillRectangle(r.width - 3, r.height - 11, 2, 2);
                    event.gc.setBackground(shadow);
                    event.gc.fillRectangle(r.width - 4, r.height - 4, 2, 2);
                    event.gc.fillRectangle(r.width - 8, r.height - 4, 2, 2);
                    event.gc.fillRectangle(r.width - 12, r.height - 4, 2, 2);
                    event.gc.fillRectangle(r.width - 4, r.height - 8, 2, 2);
                    event.gc.fillRectangle(r.width - 8, r.height - 8, 2, 2);
                    event.gc.fillRectangle(r.width - 4, r.height - 12, 2, 2);
                    event.gc.setForeground(highlight);
                } else {
                    event.gc.setForeground(shadow);
                    event.gc.drawLine(r.width - 3, r.height - 2, r.width - 2, r.height - 3);
                    event.gc.drawLine(r.width - 4, r.height - 2, r.width - 2, r.height - 4);
                    event.gc.drawLine(r.width - 7, r.height - 2, r.width - 2, r.height - 7);
                    event.gc.drawLine(r.width - 8, r.height - 2, r.width - 2, r.height - 8);
                    event.gc.drawLine(r.width - 11, r.height - 2, r.width - 2, r.height - 11);
                    event.gc.drawLine(r.width - 12, r.height - 2, r.width - 2, r.height - 12);
                    event.gc.setForeground(highlight);
                    event.gc.drawLine(r.width - 5, r.height - 2, r.width - 2, r.height - 5);
                    event.gc.drawLine(r.width - 9, r.height - 2, r.width - 2, r.height - 9);
                    event.gc.drawLine(r.width - 13, r.height - 2, r.width - 2, r.height - 13);
                }
                if ((SizeGrip.this.getStyle() & 4) != 0) {
                    if (event.width > 13) {
                        event.gc.drawLine(0, r.height - 1, r.width - 14, r.height - 1);
                    }
                    if (event.height > 13) {
                        event.gc.drawLine(r.width - 1, 0, r.width - 1, r.height - 14);
                    }
                }
            }
        });
        this.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (event.button == 1) {
                    SizeGrip.this.mouseDownOffsetX = event.x;
                    SizeGrip.this.mouseDownOffsetY = event.y;
                    Point p = resizableParent.getSize();
                    SizeGrip.this.snapBackX = p.x;
                    SizeGrip.this.snapBackY = p.y;
                    SizeGrip.this.cancelled = false;
                } else if (event.button == 3 && (event.stateMask & 0x80000) != 0 && SizeGrip.this.snapBackX > 0 && SizeGrip.this.snapBackY > 0) {
                    resizableParent.setSize(SizeGrip.this.snapBackX, SizeGrip.this.snapBackY);
                    SizeGrip.this.snapBackX = 0;
                    SizeGrip.this.snapBackY = 0;
                    SizeGrip.this.cancelled = true;
                }
            }
        });
        this.addListener(5, new Listener(){

            public void handleEvent(final Event event) {
                if (!SizeGrip.this.cancelled && (event.stateMask & 0x80000) != 0) {
                    long now;
                    if (SizeGrip.this.timerTask != null) {
                        SizeGrip.this.timerTask.cancel();
                        SizeGrip.this.timerTask = null;
                    }
                    if (SizeGrip.this.lastUpdate + 25L < (now = System.currentTimeMillis())) {
                        SizeGrip.this.performResize(event);
                        SizeGrip.this.lastUpdate = now;
                    } else {
                        SizeGrip.this.timerTask = new TimerTask(){

                            @Override
                            public void run() {
                                final 1 executingTask = this;
                                event.display.asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (executingTask != ((this).this).SizeGrip.this.timerTask) {
                                            return;
                                        }
                                        SizeGrip.this.performResize(event);
                                    }
                                });
                            }
                        };
                        SizeGrip.this.timer.schedule(SizeGrip.this.timerTask, 25L);
                    }
                }
            }
        });
        this.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                if (SizeGrip.this.timerTask != null) {
                    SizeGrip.this.timerTask.cancel();
                    SizeGrip.this.timerTask = null;
                }
                if (!SizeGrip.this.cancelled && (event.stateMask & 0x80000) != 0) {
                    SizeGrip.this.performResize(event);
                }
            }
        });
        Listener listener = resizeListener = resizableParent instanceof Shell ? new Listener(){

            public void handleEvent(Event event) {
                SizeGrip.this.updateVisibility();
            }
        } : null;
        if (resizeListener != null) {
            resizableParent.addListener(11, resizeListener);
        }
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                SizeGrip.this.timer.cancel();
                if (resizeListener != null) {
                    resizableParent.removeListener(11, resizeListener);
                }
            }
        });
        this.updateVisibility();
    }

    private void performResize(Event event) {
        Rectangle ca = this.resizableParent instanceof Shell ? this.getDisplay().getClientArea() : this.getDisplay().map((Control)this.resizableParent.getParent(), null, this.resizableParent.getParent().getClientArea());
        Point limit = this.toControl(ca.x + ca.width - 1, ca.y + ca.height - 1);
        event.x = Math.min(event.x, limit.x);
        event.y = Math.min(event.y, limit.y);
        Point p = this.resizableParent.getSize();
        int newX = p.x + event.x - this.mouseDownOffsetX;
        int newY = p.y + event.y - this.mouseDownOffsetY;
        if (this.minSize != null) {
            newX = Math.max(this.minSize.x, newX);
            newY = Math.max(this.minSize.y, newY);
        }
        if (newX != p.x || newY != p.y) {
            this.resizableParent.setSize(newX, newY);
        }
    }

    private void updateVisibility() {
        if (this.resizableParent instanceof Shell) {
            boolean newVis;
            boolean vis = super.getVisible();
            boolean max = ((Shell)this.resizableParent).getMaximized();
            boolean bl = newVis = this.userVisible && !max;
            if (vis != newVis) {
                super.setVisible(newVis);
            }
        } else if (this.userVisible != super.getVisible()) {
            super.setVisible(this.userVisible);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint == -1) {
            wHint = 13;
        }
        if (hHint == -1) {
            hHint = 13;
        }
        return new Point(wHint, hHint);
    }

    private static int checkStyle(int style) {
        int mask = 0x800004;
        return style &= mask;
    }

    public boolean setFocus() {
        this.checkWidget();
        return false;
    }

    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    public void setMinimumShellSize(Point p) {
        this.checkWidget();
        this.minSize = p;
    }

    public void setMinimumShellSize(int width, int height) {
        this.checkWidget();
        this.minSize = new Point(width, height);
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.userVisible;
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        this.userVisible = visible;
        this.updateVisibility();
    }
}

