/*
 * Decompiled with CFR 0.152.
 */
package com.novocode.ishell;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SizeBorder
extends Canvas {
    private static final long UPDATE_DELAY = 25L;
    private static final int AREA_NONE = 0;
    private static final int AREA_N = 1;
    private static final int AREA_S = 2;
    private static final int AREA_E = 4;
    private static final int AREA_W = 8;
    private static final int AREA_NW = 9;
    private static final int AREA_NE = 5;
    private static final int AREA_SE = 6;
    private static final int AREA_SW = 10;
    private Rectangle snapBack;
    private boolean cancelled = true;
    private volatile long lastUpdate;
    private Timer timer = new Timer(true);
    private TimerTask timerTask;
    private Composite resizableParent;
    private Point minSize;
    private Point mouseDownOffset;
    private int borderWidth = 4;
    private int cornerSize = 16;
    private Display display;
    private Cursor cursor;
    private Cursor cursorNWSE;
    private Cursor cursorNESW;
    private Cursor cursorWE;
    private Cursor cursorNS;
    private int currentArea;

    public SizeBorder(Composite parent, int style) {
        this(parent, (Composite)parent.getShell(), style);
    }

    public SizeBorder(Composite parent, final Composite resizableParent, int style) {
        super(parent, SizeBorder.checkStyle(style));
        this.resizableParent = resizableParent;
        this.display = this.getDisplay();
        this.cursorNWSE = new Cursor((Device)this.getDisplay(), 8);
        this.cursorNESW = new Cursor((Device)this.getDisplay(), 6);
        this.cursorWE = new Cursor((Device)this.getDisplay(), 9);
        this.cursorNS = new Cursor((Device)this.getDisplay(), 7);
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                SizeBorder.this.cursorNWSE.dispose();
                SizeBorder.this.cursorNESW.dispose();
                SizeBorder.this.cursorWE.dispose();
                SizeBorder.this.cursorNS.dispose();
            }
        });
        if ((style & 0x800) != 0) {
            final Color highlightShadowColor = this.display.getSystemColor(20);
            final Color lightShadowColor = this.display.getSystemColor(19);
            final Color normalShadowColor = this.display.getSystemColor(18);
            final Color darkShadowColor = this.display.getSystemColor(17);
            this.addListener(9, new Listener(){

                public void handleEvent(Event event) {
                    Rectangle r = SizeBorder.this.getClientArea();
                    if (r.width == 0 || r.height == 0) {
                        return;
                    }
                    SizeBorder.drawBevelRect(event.gc, r.x, r.y, r.width - 1, r.height - 1, lightShadowColor, darkShadowColor);
                    SizeBorder.drawBevelRect(event.gc, r.x + 1, r.y + 1, r.width - 3, r.height - 3, highlightShadowColor, normalShadowColor);
                }
            });
        }
        this.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (event.button == 1) {
                    SizeBorder.this.currentArea = SizeBorder.this.areaAtPoint(event.x, event.y);
                    if (SizeBorder.this.currentArea == 0) {
                        return;
                    }
                    SizeBorder.this.mouseDownOffset = resizableParent instanceof Shell ? SizeBorder.this.toDisplay(event.x, event.y) : SizeBorder.this.display.map((Control)SizeBorder.this, (Control)resizableParent.getParent(), event.x, event.y);
                    SizeBorder.this.snapBack = resizableParent.getBounds();
                    SizeBorder.this.cancelled = false;
                } else if (event.button == 3 && (event.stateMask & 0x80000) != 0 && SizeBorder.this.snapBack != null) {
                    resizableParent.setBounds(SizeBorder.this.snapBack);
                    SizeBorder.this.snapBack = null;
                    SizeBorder.this.cancelled = true;
                }
            }
        });
        this.addListener(5, new Listener(){

            public void handleEvent(final Event event) {
                if ((event.stateMask & 0x80000) == 0) {
                    SizeBorder.this.updateCursor(SizeBorder.this.areaAtPoint(event.x, event.y));
                }
                if (!SizeBorder.this.cancelled && (event.stateMask & 0x80000) != 0) {
                    long now;
                    if (SizeBorder.this.timerTask != null) {
                        SizeBorder.this.timerTask.cancel();
                        SizeBorder.this.timerTask = null;
                    }
                    if (SizeBorder.this.lastUpdate + 25L < (now = System.currentTimeMillis())) {
                        SizeBorder.this.performResize(event);
                        SizeBorder.this.lastUpdate = now;
                    } else {
                        SizeBorder.this.timerTask = new TimerTask(){

                            @Override
                            public void run() {
                                final 1 executingTask = this;
                                event.display.asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (executingTask != ((this).this).SizeBorder.this.timerTask) {
                                            return;
                                        }
                                        SizeBorder.this.performResize(event);
                                    }
                                });
                            }
                        };
                        SizeBorder.this.timer.schedule(SizeBorder.this.timerTask, 25L);
                    }
                }
            }
        });
        this.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                if (SizeBorder.this.timerTask != null) {
                    SizeBorder.this.timerTask.cancel();
                    SizeBorder.this.timerTask = null;
                }
                if (!SizeBorder.this.cancelled && (event.stateMask & 0x80000) != 0) {
                    SizeBorder.this.performResize(event);
                }
            }
        });
        this.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                Point p = SizeBorder.this.toControl(SizeBorder.this.display.getCursorLocation());
                SizeBorder.this.updateCursor(SizeBorder.this.areaAtPoint(p.x, p.y));
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                SizeBorder.this.timer.cancel();
            }
        });
    }

    private static int checkStyle(int style) {
        style = 524288;
        return style;
    }

    private void performResize(Event event) {
        int minH;
        int minW;
        Rectangle ca = this.resizableParent instanceof Shell ? this.getDisplay().getClientArea() : this.getDisplay().map((Control)this.resizableParent.getParent(), null, this.resizableParent.getParent().getClientArea());
        Point caOffset = this.toControl(ca.x, ca.y);
        event.x = Math.max(Math.min(event.x, caOffset.x + ca.width - 1), caOffset.x);
        event.y = Math.max(Math.min(event.y, caOffset.y + ca.height - 1), caOffset.y);
        Point movement = this.resizableParent instanceof Shell ? this.toDisplay(event.x, event.y) : this.display.map((Control)this, (Control)this.resizableParent.getParent(), event.x, event.y);
        movement.x -= this.mouseDownOffset.x;
        movement.y -= this.mouseDownOffset.y;
        int newW = this.snapBack.width;
        int newH = this.snapBack.height;
        int newX = this.snapBack.x;
        int newY = this.snapBack.y;
        if ((this.currentArea & 4) != 0) {
            newW += movement.x;
        } else if ((this.currentArea & 8) != 0) {
            newX += this.snapBack.width - (newW -= movement.x);
        }
        if ((this.currentArea & 2) != 0) {
            newH += movement.y;
        } else if ((this.currentArea & 1) != 0) {
            newY += this.snapBack.height - (newH -= movement.y);
        }
        if (this.minSize != null) {
            minW = this.minSize.x;
            minH = this.minSize.y;
        } else {
            minW = 0;
            minH = 0;
        }
        int maxX = this.snapBack.x + this.snapBack.width - minW;
        int maxY = this.snapBack.y + this.snapBack.height - minH;
        newW = Math.max(minW, newW);
        newH = Math.max(minH, newH);
        newX = Math.min(maxX, newX);
        newY = Math.min(maxY, newY);
        this.resizableParent.setBounds(newX, newY, newW, newH);
    }

    private void updateCursor(int area) {
        Cursor c = null;
        switch (area) {
            case 1: 
            case 2: {
                c = this.cursorNS;
                break;
            }
            case 4: 
            case 8: {
                c = this.cursorWE;
                break;
            }
            case 6: 
            case 9: {
                c = this.cursorNWSE;
                break;
            }
            case 5: 
            case 10: {
                c = this.cursorNESW;
            }
        }
        if (this.cursor == c) {
            return;
        }
        this.cursor = c;
        this.setCursor(c);
    }

    private int areaAtPoint(int x, int y) {
        Point size = this.getSize();
        if (x < this.borderWidth) {
            if (y < this.cornerSize) {
                return 9;
            }
            if (y >= size.y - this.cornerSize) {
                return 10;
            }
            return 8;
        }
        if (x >= size.x - this.borderWidth) {
            if (y >= size.y - this.cornerSize) {
                return 6;
            }
            if (y < this.cornerSize) {
                return 5;
            }
            return 4;
        }
        if (y < this.borderWidth) {
            if (x < this.cornerSize) {
                return 9;
            }
            if (x >= size.x - this.cornerSize) {
                return 5;
            }
            return 1;
        }
        if (y >= size.y - this.borderWidth) {
            if (x >= size.x - this.cornerSize) {
                return 6;
            }
            if (x < this.cornerSize) {
                return 10;
            }
            return 2;
        }
        return 0;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint == -1) {
            wHint = 0;
        }
        if (hHint == -1) {
            hHint = 0;
        }
        return new Point(wHint, hHint);
    }

    public boolean setFocus() {
        this.checkWidget();
        return false;
    }

    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    public void setMinimumShellSize(Point p) {
        this.checkWidget();
        this.minSize = p;
    }

    public void setMinimumShellSize(int width, int height) {
        this.checkWidget();
        this.minSize = new Point(width, height);
    }

    public void setBorderWidth(int width) {
        this.checkWidget();
        this.borderWidth = width;
        Point p = this.toControl(this.display.getCursorLocation());
        this.updateCursor(this.areaAtPoint(p.x, p.y));
    }

    public void setCornerSize(int size) {
        this.checkWidget();
        this.cornerSize = size;
        Point p = this.toControl(this.display.getCursorLocation());
        this.updateCursor(this.areaAtPoint(p.x, p.y));
    }

    private static void drawBevelRect(GC gc, int x, int y, int w, int h, Color topleft, Color bottomright) {
        gc.setForeground(bottomright);
        gc.drawLine(x + w, y, x + w, y + h);
        gc.drawLine(x, y + h, x + w, y + h);
        gc.setForeground(topleft);
        gc.drawLine(x, y, x + w - 1, y);
        gc.drawLine(x, y, x, y + h - 1);
    }
}

