/*
 * Decompiled with CFR 0.152.
 */
package com.novocode.ishell;

import com.moonlit.logfaces.client.ImageHolder;
import com.novocode.ishell.DesktopForm;
import com.novocode.ishell.SizeBorder;
import com.novocode.ishell.SizeGrip;
import com.novocode.ishell.TitleBar;
import com.novocode.ishell.TitleBarButton;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;

public class InternalShell
extends Composite {
    private static final int BORDER_SIZE = 4;
    protected Rectangle bounds;
    protected Composite contentPane;
    protected TitleBar titleBar;
    private SizeGrip sizeGrip;
    private SizeBorder sizeBorder;
    private int minWidth = 112;
    private int minHeight;
    private DesktopForm desktop;
    private boolean maximized;
    private Rectangle pluralizedBounds;
    private final int titleHeight;
    private final int style;
    private TitleBarButton closeButton;
    private TitleBarButton maxButton;
    private TitleBarButton minButton;
    private TitleBarButton setupButton;
    private TitleBarButton refreshButton;
    private TitleBarButton fetchButton;
    Control focusControl;

    public InternalShell(DesktopForm parent, int style) {
        super((Composite)parent, InternalShell.checkStyle(style));
        FormData fd;
        this.desktop = parent;
        this.style = style;
        this.setBackground(this.getDisplay().getSystemColor(22));
        FormLayout layout = new FormLayout();
        this.setLayout((Layout)layout);
        this.titleBar = new TitleBar(this, style & 0x4D4);
        this.titleHeight = this.titleBar.computeSize((int)-1, (int)-1, (boolean)true).y;
        TitleBarButton leftButton = null;
        if ((style & 0x4C0) != 0) {
            this.closeButton = new TitleBarButton(this, 64);
            if ((style & 0x40) == 0) {
                this.closeButton.setEnabled(false);
            }
            this.closeButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    InternalShell.this.close();
                }
            });
            fd = new FormData(this.titleHeight, this.titleHeight);
            fd.right = new FormAttachment(100, -4);
            fd.top = new FormAttachment(0, 4);
            this.closeButton.setLayoutData(fd);
            leftButton = this.closeButton;
            if ((style & 0x400) != 0) {
                this.maxButton = new TitleBarButton(this, 1024);
                if ((style & 0x400) == 0) {
                    this.maxButton.setEnabled(false);
                }
                this.maxButton.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        InternalShell.this.setMaximized(!InternalShell.this.maximized);
                    }
                });
                fd = new FormData(this.titleHeight, this.titleHeight);
                fd.right = leftButton != null ? new FormAttachment((Control)leftButton) : new FormAttachment(100, -4);
                fd.top = new FormAttachment(0, 4);
                this.maxButton.setLayoutData(fd);
                leftButton = this.maxButton;
            }
            if ((style & 0x80) != 0) {
                this.minButton = new TitleBarButton(this, 128);
                if ((style & 0x80) == 0) {
                    this.minButton.setEnabled(false);
                }
                this.minButton.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        InternalShell.this.setMinimized(true);
                    }
                });
                fd = new FormData(this.titleHeight, this.titleHeight);
                fd.right = leftButton != null ? new FormAttachment((Control)leftButton) : new FormAttachment(100, -4);
                fd.top = new FormAttachment(0, 4);
                this.minButton.setLayoutData(fd);
                leftButton = this.minButton;
            }
        }
        if ((style & 0x10000) != 0) {
            this.setupButton = new TitleBarButton(this, ImageHolder.getInstance().getImage("icons/eclipse3_task.gif"));
            this.setupButton.setEnabled(true);
            this.setupButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    InternalShell.this.setup();
                }
            });
            fd = new FormData(this.titleHeight, this.titleHeight);
            fd.right = new FormAttachment(leftButton);
            fd.top = new FormAttachment(0, 4);
            this.setupButton.setLayoutData(fd);
            this.setupButton.setToolTipText("Setup");
            this.refreshButton = new TitleBarButton(this, ImageHolder.getInstance().getImage("icons/eclipse3_refresh.gif"));
            this.refreshButton.setEnabled(true);
            this.refreshButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    InternalShell.this.refresh();
                }
            });
            fd = new FormData(this.titleHeight, this.titleHeight);
            fd.right = new FormAttachment((Control)this.setupButton);
            fd.top = new FormAttachment(0, 4);
            this.refreshButton.setLayoutData(fd);
            this.refreshButton.setToolTipText("Refresh content");
            this.fetchButton = new TitleBarButton(this, ImageHolder.getInstance().getImage("icons/query.gif"));
            this.fetchButton.setEnabled(true);
            this.fetchButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    InternalShell.this.fetch();
                }
            });
            fd = new FormData(this.titleHeight, this.titleHeight);
            fd.right = new FormAttachment((Control)this.refreshButton);
            fd.top = new FormAttachment(0, 4);
            this.fetchButton.setLayoutData(fd);
            this.fetchButton.setToolTipText("Fetch all");
            leftButton = this.fetchButton;
        }
        fd = new FormData();
        fd.left = new FormAttachment(0, 4);
        fd.right = leftButton != null ? new FormAttachment(leftButton) : new FormAttachment(100, -4);
        fd.top = new FormAttachment(0, 4);
        this.titleBar.setLayoutData(fd);
        this.contentPane = new Composite((Composite)this, 0);
        fd = new FormData();
        fd.left = new FormAttachment(0, 4);
        fd.right = new FormAttachment(100, -4);
        fd.top = new FormAttachment((Control)this.titleBar, 1);
        fd.bottom = new FormAttachment(100, -4);
        this.contentPane.setLayoutData((Object)fd);
        this.sizeBorder = new SizeBorder(this, this, 2048);
        this.sizeBorder.setBorderWidth(4);
        fd = new FormData();
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(100);
        fd.top = new FormAttachment(0);
        fd.bottom = new FormAttachment(100);
        this.sizeBorder.setLayoutData(fd);
        this.minHeight = this.titleHeight + 8;
        this.sizeBorder.setMinimumShellSize(this.minWidth, this.minHeight);
        this.sizeBorder.setCornerSize(this.titleHeight + 4);
        if ((style & 0x10) == 0) {
            this.sizeBorder.setEnabled(false);
        }
        this.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                InternalShell.this.bounds = InternalShell.this.getBounds();
            }

            public void controlResized(ControlEvent e) {
                InternalShell.this.bounds = InternalShell.this.getBounds();
            }
        });
        this.setVisible(false);
        this.desktop.manage(this);
    }

    private static int checkStyle(int style) {
        int mask = 0x400000;
        return style &= mask;
    }

    public int getStyle() {
        return this.style;
    }

    public Composite getContentPane() {
        return this.contentPane;
    }

    public void setText(String s) {
        this.titleBar.setText(s);
    }

    public String getText() {
        return this.titleBar.getText();
    }

    public void setCustomMenu(Menu menu) {
        this.titleBar.setMenu(menu);
    }

    public Menu getCustomMenu() {
        return this.titleBar.getMenu();
    }

    public void setImage(Image image) {
        this.titleBar.setImage(image);
    }

    public Image getImage() {
        return this.titleBar.getImage();
    }

    public void createSizeGrip(int style) {
        this.checkWidget();
        if (this.sizeGrip != null) {
            throw new SWTException("SizeGrip was already created");
        }
        if ((this.style & 0x10) == 0) {
            throw new SWTException("Cannot create SizeGrip for InternalShell without style RESIZE");
        }
        this.sizeGrip = new SizeGrip(this, this, style);
        this.sizeGrip.setBackground(this.contentPane.getBackground());
        this.sizeGrip.moveAbove((Control)this.contentPane);
        FormData fd = new FormData();
        fd.right = new FormAttachment(100, -4);
        fd.bottom = new FormAttachment(100, -4);
        this.sizeGrip.setLayoutData(fd);
        this.sizeGrip.setMinimumShellSize(this.minWidth, this.minHeight);
        if (this.isVisible()) {
            this.layout(true);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point p = super.computeSize(wHint, hHint, changed);
        if (p.x < this.minWidth) {
            p.x = this.minWidth;
        }
        if (p.y < this.minHeight) {
            p.y = this.minHeight;
        }
        return p;
    }

    public void setSize(int width, int height) {
        if (width < this.minWidth) {
            width = this.minWidth;
        }
        if (height < this.minHeight) {
            height = this.minHeight;
        }
        super.setSize(width, height);
    }

    public void setBounds(int x, int y, int width, int height) {
        if (width < this.minWidth) {
            width = this.minWidth;
        }
        if (height < this.minHeight) {
            height = this.minHeight;
        }
        super.setBounds(x, y, width, height);
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
        super.setBounds(bounds);
    }

    public void setMinimumSize(int width, int height) {
        this.checkWidget();
        this.minWidth = width;
        this.minHeight = height;
        this.sizeGrip.setMinimumShellSize(this.minWidth, this.minHeight);
        this.sizeBorder.setMinimumShellSize(this.minWidth, this.minHeight);
        Point size = this.getSize();
        if (size.x < this.minWidth || size.y < this.minHeight) {
            this.setSize(Math.max(this.minWidth, size.x), Math.max(this.minHeight, size.y));
        }
    }

    public void close() {
        if (this.isDisposed()) {
            return;
        }
        Event event = new Event();
        this.notifyListeners(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
    }

    public void open() {
        this.pack();
        this.desktop.activate(this);
        this.setVisible(true);
        this.setFocus();
    }

    public void setVisible(boolean visible) {
        if (this.isDisposed()) {
            return;
        }
        if (!visible) {
            this.desktop.shellVisibilityChanged(this, false);
        }
        super.setVisible(visible);
        if (visible) {
            this.desktop.shellVisibilityChanged(this, true);
        }
    }

    public void setActive() {
        this.desktop.activate(this);
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
        if (this.maximized == maximized) {
            return;
        }
        this.setMaximizedWithoutNotification(maximized);
        this.desktop.shellMaximizedOrRestored(this, maximized);
    }

    public void setMinimized(boolean minimized) {
        this.checkWidget();
        boolean wasMaximized = this.maximized;
        this.setVisible(!minimized);
        this.maximized = wasMaximized;
    }

    public boolean getMinimized() {
        return this.getVisible();
    }

    void setMaximizedWithoutNotification(boolean maximized) {
        if (this.maximized == maximized) {
            return;
        }
        this.maximized = maximized;
        if (maximized) {
            this.pluralizedBounds = this.getBounds();
            this.desktopResized(this.desktop.getClientArea());
        } else {
            this.setBounds(this.pluralizedBounds);
        }
        if (this.sizeGrip != null && !this.sizeGrip.isDisposed()) {
            this.sizeGrip.setVisible(!maximized);
        }
        if (!this.sizeBorder.isDisposed()) {
            this.sizeBorder.setEnabled(!maximized && (this.style & 0x10) != 0);
        }
        if (this.maxButton != null && !this.maxButton.isDisposed()) {
            this.maxButton.redraw();
        }
    }

    public boolean getMaximized() {
        this.checkWidget();
        return this.maximized;
    }

    void redrawDecorationsAfterActivityChange() {
        if (!this.titleBar.isDisposed()) {
            this.titleBar.redraw();
        }
        if (this.closeButton != null && !this.closeButton.isDisposed()) {
            this.closeButton.redraw();
        }
        if (this.maxButton != null && !this.maxButton.isDisposed()) {
            this.maxButton.redraw();
        }
        if (this.minButton != null && !this.minButton.isDisposed()) {
            this.minButton.redraw();
        }
    }

    void desktopResized(Rectangle deskCA) {
        if (this.maximized) {
            int hideTitle = this.desktop.getShowMaximizedTitle() ? 0 : this.titleHeight + 1;
            this.setBounds(deskCA.x - 4, deskCA.y - 4 - hideTitle, deskCA.width + 8, deskCA.height + 8 + hideTitle);
        }
    }

    public boolean setFocus() {
        if (this.focusControl != null && this.focusControl != this && !this.focusControl.isDisposed()) {
            return this.focusControl.setFocus();
        }
        return super.setFocus();
    }

    public boolean isActiveShell() {
        return this.desktop.getActiveShell() == this;
    }

    public void fetch() {
    }

    public void refresh() {
    }

    public void setup() {
    }

    public void enableControls(boolean enable) {
        if (this.isDisposed()) {
            return;
        }
        this.titleBar.setVisible(enable);
        if (this.closeButton != null) {
            this.closeButton.setVisible(enable);
        }
        if (this.setupButton != null) {
            this.setupButton.setVisible(enable);
        }
        if (this.refreshButton != null) {
            this.refreshButton.setVisible(enable);
        }
        if (this.fetchButton != null) {
            this.fetchButton.setVisible(enable);
        }
        if (this.minButton != null) {
            this.minButton.setVisible(enable);
        }
        if (this.maxButton != null) {
            this.maxButton.setVisible(enable);
        }
    }

    public void forceVisibleLocation(Rectangle deskCA) {
        Point p = this.getLocation();
        Point minGrabSize = this.titleBar.getMinGrabSize();
        int x = p.x;
        int y = p.y;
        int minX = minGrabSize.x + 4;
        int minY = minGrabSize.y + 4;
        x = Math.min(Math.max(x, deskCA.x + minY), deskCA.x + deskCA.width - minX);
        y = Math.min(Math.max(y, deskCA.y + minY), deskCA.y + deskCA.height - minY);
        if (x != p.x || y != p.y) {
            this.setLocation(x, y);
        }
    }
}

