/*
 * Decompiled with CFR 0.152.
 */
package com.novocode.ishell;

import com.novocode.ishell.DesktopListener;
import com.novocode.ishell.InternalShell;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class DesktopForm
extends Composite {
    private static final InternalShell[] EMPTY_INTERNALSHELL_ARRAY = new InternalShell[0];
    private static final int FIRST_SHELL_LOCATION = 32;
    private static final int SHELL_LOCATION_OFFSET = 16;
    private InternalShell activeShell;
    private List<DesktopListener> desktopListeners = new ArrayList<DesktopListener>();
    private List<InternalShell> allShells = new ArrayList<InternalShell>();
    private List<InternalShell> visibleShells = new ArrayList<InternalShell>();
    private int nextShellLocation = 32;
    private boolean showMaximizedTitle;
    private boolean autoMaximize = true;
    private boolean enableCtrlTab = true;
    private boolean allowDeactivate;

    public DesktopForm(Composite parent, int style) {
        super(parent, style);
        final Display display = this.getDisplay();
        final Shell shell = this.getShell();
        Color bg = display.getSystemColor(34);
        this.setBackground(bg);
        int brightness = bg.getRed() + bg.getGreen() + bg.getBlue();
        this.setForeground(display.getSystemColor(brightness > 400 ? 2 : 1));
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle ca = DesktopForm.this.getClientArea();
                Control[] controlArray = DesktopForm.this.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    if (c instanceof InternalShell) {
                        ((InternalShell)c).desktopResized(ca);
                    }
                    ++n2;
                }
            }
        });
        final Listener mouseDownFilter = new Listener(){

            public void handleEvent(Event event) {
                if (!(event.widget instanceof Control)) {
                    return;
                }
                Control c = (Control)event.widget;
                if (c.getShell() != shell) {
                    return;
                }
                boolean[] desktopHit = new boolean[1];
                InternalShell ishell = DesktopForm.this.getInternalShell(c, desktopHit);
                if (desktopHit[0] && DesktopForm.this.allowDeactivate) {
                    DesktopForm.this.activate(null);
                }
                if (ishell == null) {
                    return;
                }
                DesktopForm.this.activate(ishell);
            }
        };
        final Listener focusInFilter = new Listener(){

            public void handleEvent(Event event) {
                if (!(event.widget instanceof Control)) {
                    return;
                }
                Control c = (Control)event.widget;
                if (c.getShell() != shell) {
                    return;
                }
                boolean[] desktopHit = new boolean[1];
                InternalShell ishell = DesktopForm.this.getInternalShell(c, desktopHit);
                if (desktopHit[0] && DesktopForm.this.allowDeactivate) {
                    DesktopForm.this.activate(null);
                }
                if (ishell == null) {
                    return;
                }
                ishell.focusControl = c;
            }
        };
        final Listener traverseFilter = new Listener(){

            public void handleEvent(Event event) {
                if (!DesktopForm.this.enableCtrlTab) {
                    return;
                }
                if (!event.doit) {
                    return;
                }
                if ((event.stateMask & 0x40000) == 0) {
                    return;
                }
                if (event.detail != 16 && event.detail != 8) {
                    return;
                }
                if (!(event.widget instanceof Control)) {
                    return;
                }
                Control c = (Control)event.widget;
                if (c.getShell() != shell) {
                    return;
                }
                boolean[] desktopHit = new boolean[1];
                InternalShell ishell = DesktopForm.this.getInternalShell(c, desktopHit);
                if (ishell != null || desktopHit[0]) {
                    if (event.detail == 16) {
                        DesktopForm.this.activateNextShell();
                    } else {
                        DesktopForm.this.activatePreviousShell();
                    }
                    event.doit = false;
                }
            }
        };
        display.addFilter(3, mouseDownFilter);
        display.addFilter(15, focusInFilter);
        display.addFilter(31, traverseFilter);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                display.removeFilter(3, mouseDownFilter);
                display.removeFilter(15, focusInFilter);
                display.removeFilter(31, traverseFilter);
            }
        });
    }

    void manage(final InternalShell ishell) {
        Rectangle bounds = this.getBounds();
        if (this.nextShellLocation > bounds.height - 100 || this.nextShellLocation > bounds.width - 100) {
            this.nextShellLocation = 32;
        }
        ishell.setLocation(bounds.x + this.nextShellLocation, bounds.y + this.nextShellLocation);
        this.nextShellLocation += 16;
        ishell.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DesktopForm.this.allShells.remove((Object)ishell);
                DesktopForm.this.visibleShells.remove((Object)ishell);
                if (ishell == DesktopForm.this.activeShell) {
                    DesktopForm.this.activateTopmostVisibleShellExcept(ishell);
                    if (DesktopForm.this.autoMaximize && !DesktopForm.this.hasVisibleMaximizedShell()) {
                        DesktopForm.this.setAllVisibleMaximized(false);
                    }
                }
                DesktopForm.this.notifyDesktopListenersDispose(ishell);
            }
        });
        this.allShells.add(ishell);
        if (ishell.isVisible()) {
            this.visibleShells.add(ishell);
        }
        this.notifyDesktopListenersCreate(ishell);
    }

    private InternalShell activateTopmostVisibleShellExcept(InternalShell except) {
        Control[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            Control c = children[i];
            if (c != except && c instanceof InternalShell && c.isVisible()) {
                InternalShell ishell = (InternalShell)c;
                this.activate(ishell);
                return ishell;
            }
            ++i;
        }
        this.activeShell = null;
        this.notifyDesktopListenersActivate(null);
        return null;
    }

    void activate(InternalShell ishell) {
        if (ishell == this.activeShell) {
            return;
        }
        this.checkWidget();
        if (ishell != null) {
            if (!ishell.isVisible()) {
                ishell.setVisible(true);
            }
            if ((ishell.getStyle() & 0x4000) != 0) {
                ishell.moveAbove(null);
            } else {
                InternalShell firstRegular = this.getTopmostRegularShell();
                if (firstRegular != null && firstRegular != ishell) {
                    ishell.moveAbove((Control)firstRegular);
                } else {
                    Control[] children = this.getChildren();
                    if (children.length > 0) {
                        ishell.moveAbove(children[0]);
                    }
                }
            }
        }
        InternalShell oldActiveShell = this.activeShell;
        this.activeShell = ishell;
        if (oldActiveShell != null) {
            oldActiveShell.redrawDecorationsAfterActivityChange();
        }
        if (ishell != null) {
            if (this.activeShell.isVisible()) {
                this.activeShell.redrawDecorationsAfterActivityChange();
            }
            this.setTabList(new Control[]{this.activeShell});
            this.activeShell.setFocus();
        } else {
            this.setTabList(new Control[0]);
            this.forceFocus();
        }
        this.notifyDesktopListenersActivate(ishell);
    }

    private InternalShell getTopmostRegularShell() {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof InternalShell && (c.getStyle() & 0x4000) == 0) {
                return (InternalShell)c;
            }
            ++n2;
        }
        return null;
    }

    private InternalShell getBottommostOnTopShell() {
        Control[] ch = this.getChildren();
        int i = ch.length - 1;
        while (i >= 0) {
            Control c = ch[i];
            if (c instanceof InternalShell && (c.getStyle() & 0x4000) != 0) {
                return (InternalShell)c;
            }
            --i;
        }
        return null;
    }

    void shellVisibilityChanged(InternalShell ishell, boolean visible) {
        if (visible) {
            if (!this.visibleShells.contains((Object)ishell)) {
                this.visibleShells.add(ishell);
                if (this.autoMaximize && !ishell.getMaximized() && (ishell.getStyle() & 0x400) != 0 && this.hasVisibleMaximizedShell()) {
                    ishell.setMaximizedWithoutNotification(true);
                }
            }
            if (ishell.getMaximized()) {
                ishell.desktopResized(this.getClientArea());
            }
        } else {
            this.visibleShells.remove((Object)ishell);
            if (ishell == this.activeShell) {
                this.activateTopmostVisibleShellExcept(ishell);
                if (this.autoMaximize && !this.hasVisibleMaximizedShell()) {
                    this.setAllVisibleMaximized(false);
                }
            }
        }
    }

    private InternalShell getInternalShell(Control c, boolean[] desktopHit) {
        while (c != null && c != this) {
            if (c instanceof InternalShell && ((InternalShell)c).getParent() == this) {
                return (InternalShell)c;
            }
            c = c.getParent();
        }
        if (desktopHit != null && c == this) {
            desktopHit[0] = true;
        }
        return null;
    }

    public InternalShell getActiveShell() {
        return this.activeShell;
    }

    public InternalShell[] getVisibleShells() {
        this.checkWidget();
        return this.visibleShells.toArray(EMPTY_INTERNALSHELL_ARRAY);
    }

    public InternalShell[] getShells() {
        this.checkWidget();
        return this.allShells.toArray(EMPTY_INTERNALSHELL_ARRAY);
    }

    public void setShowMaximizedTitle(boolean b) {
        this.checkWidget();
        this.showMaximizedTitle = b;
        Rectangle ca = this.getClientArea();
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof InternalShell) {
                ((InternalShell)c).desktopResized(ca);
            }
            ++n2;
        }
    }

    public boolean getShowMaximizedTitle() {
        this.checkWidget();
        return this.showMaximizedTitle;
    }

    public void setAutoMaximize(boolean b) {
        this.checkWidget();
        this.autoMaximize = b;
        boolean hasMax = false;
        for (InternalShell is : this.visibleShells) {
            if (!is.getMaximized()) continue;
            hasMax = true;
            break;
        }
        if (hasMax) {
            for (InternalShell is : this.visibleShells) {
                if ((is.getStyle() & 0x400) == 0) continue;
                is.setMaximized(true);
            }
        }
    }

    public boolean getAutoMaximize() {
        this.checkWidget();
        return this.autoMaximize;
    }

    public void setEnableCtrlTab(boolean b) {
        this.checkWidget();
        this.enableCtrlTab = b;
    }

    public boolean getEnableCtrlTab() {
        return this.enableCtrlTab;
    }

    public void setAllowDeactivate(boolean b) {
        this.checkWidget();
        this.allowDeactivate = b;
        if (!this.allowDeactivate && this.activeShell == null) {
            this.activateTopmostVisibleShellExcept(null);
        }
    }

    public boolean getAllowDeactivate() {
        return this.allowDeactivate;
    }

    void shellMaximizedOrRestored(InternalShell ishell, boolean maximized) {
        this.setAllVisibleMaximized(maximized);
    }

    private void setAllVisibleMaximized(boolean maximized) {
        if (this.autoMaximize) {
            Control[] controlArray = this.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalShell ishell;
                Control c = controlArray[n2];
                if (c instanceof InternalShell && ((ishell = (InternalShell)c).getStyle() & 0x400) != 0 && ishell.isVisible()) {
                    ((InternalShell)c).setMaximizedWithoutNotification(maximized);
                }
                ++n2;
            }
        }
    }

    private void activateNextShell() {
        if (this.activeShell == null) {
            this.activateTopmostVisibleShellExcept(null);
            return;
        }
        if (this.visibleShells.size() < 2) {
            return;
        }
        InternalShell topReg = this.getTopmostRegularShell();
        InternalShell botTop = this.getBottommostOnTopShell();
        if ((this.activeShell.getStyle() & 0x4000) != 0) {
            this.activeShell.moveBelow((Control)botTop);
            if (topReg != null) {
                this.activate(topReg);
            } else {
                this.activateTopmostVisibleShellExcept(null);
            }
        } else {
            this.activeShell.moveBelow(null);
            this.activateTopmostVisibleShellExcept(null);
        }
    }

    private void activatePreviousShell() {
        if (this.activeShell == null) {
            this.activateTopmostVisibleShellExcept(null);
            return;
        }
        if (this.visibleShells.size() < 2) {
            return;
        }
        InternalShell topReg = this.getTopmostRegularShell();
        InternalShell botTop = this.getBottommostOnTopShell();
        if (this.activeShell == topReg && botTop != null) {
            this.activate(botTop);
        } else {
            Control[] ch = this.getChildren();
            int i = ch.length - 1;
            while (i >= 0) {
                if (ch[i] instanceof InternalShell && ch[i].isVisible()) {
                    this.activate((InternalShell)ch[i]);
                    break;
                }
                --i;
            }
        }
    }

    public void addDesktopListener(DesktopListener l) {
        this.desktopListeners.add(l);
    }

    public void removeDesktopListener(DesktopListener l) {
        this.desktopListeners.remove(l);
    }

    private void notifyDesktopListenersCreate(InternalShell ishell) {
        Event event = new Event();
        event.widget = ishell;
        for (DesktopListener l : this.desktopListeners) {
            l.shellCreated(event);
        }
    }

    private void notifyDesktopListenersDispose(InternalShell ishell) {
        Event event = new Event();
        event.widget = ishell;
        for (DesktopListener l : this.desktopListeners) {
            l.shellDisposed(event);
        }
    }

    private void notifyDesktopListenersActivate(InternalShell ishell) {
        Event event = new Event();
        event.widget = ishell;
        for (DesktopListener l : this.desktopListeners) {
            l.shellActivated(event);
        }
    }

    private boolean hasVisibleMaximizedShell() {
        for (InternalShell is : this.visibleShells) {
            if (!is.getMaximized()) continue;
            return true;
        }
        return false;
    }
}

