/*
 * Decompiled with CFR 0.152.
 */
package com.novocode.ishell;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class CustomDrawnButton
extends Canvas {
    private boolean pressed;
    private final Display display = this.getDisplay();
    private boolean drawnMouseIn = false;

    public CustomDrawnButton(Composite parent, int style) {
        super(parent, style);
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                boolean mouseIn = CustomDrawnButton.this.mouseIn();
                CustomDrawnButton.this.onPaint(event, CustomDrawnButton.this.pressed && mouseIn);
                CustomDrawnButton.this.drawnMouseIn = mouseIn;
            }
        });
        this.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (event.button == 1) {
                    CustomDrawnButton.this.pressed = true;
                    CustomDrawnButton.this.redraw();
                } else if (event.button == 3 && (event.stateMask & 0x80000) != 0) {
                    CustomDrawnButton.this.pressed = false;
                    CustomDrawnButton.this.redraw();
                }
            }
        });
        this.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                if (CustomDrawnButton.this.pressed && (event.stateMask & 0x80000) != 0) {
                    CustomDrawnButton.this.pressed = false;
                    if (CustomDrawnButton.this.mouseIn()) {
                        Event selectionEvent = new Event();
                        CustomDrawnButton.this.notifyListeners(13, selectionEvent);
                    }
                    if (!CustomDrawnButton.this.isDisposed()) {
                        CustomDrawnButton.this.redraw();
                    }
                }
            }
        });
        this.addListener(5, new Listener(){

            public void handleEvent(Event event) {
                if (!CustomDrawnButton.this.pressed) {
                    return;
                }
                boolean mouseIn = CustomDrawnButton.this.mouseIn();
                if (mouseIn == CustomDrawnButton.this.drawnMouseIn) {
                    return;
                }
                CustomDrawnButton.this.redraw();
            }
        });
    }

    private boolean mouseIn() {
        Point p = this.toControl(this.display.getCursorLocation());
        if (p.x < -1 || p.y < -1) {
            return false;
        }
        Point size = this.getSize();
        return p.x <= size.x + 1 && p.y <= size.y + 1;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint == -1) {
            wHint = 0;
        }
        if (hHint == -1) {
            hHint = 0;
        }
        return new Point(wHint, hHint);
    }

    public boolean setFocus() {
        this.checkWidget();
        return false;
    }

    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    protected abstract void onPaint(Event var1, boolean var2);
}

