/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.widgets;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TooltipHandler {
    private Shell tipShell;
    private Label label;

    public TooltipHandler(Shell parent) {
        this.tipShell = new Shell(parent, 18436);
        this.tipShell.setLayout((Layout)new FillLayout());
        this.label = new Label((Composite)this.tipShell, 0);
        this.label.setForeground(Display.getCurrent().getSystemColor(28));
        this.label.setBackground(Display.getCurrent().getSystemColor(29));
        this.tipShell.pack();
        this.tipShell.setVisible(false);
        this.label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                TooltipHandler.this.tipShell.setVisible(false);
            }
        });
    }

    public void showTooltip(boolean leftSide, int x, int y, String tip) {
        this.label.setText(tip);
        this.tipShell.setVisible(true);
        Point size = this.tipShell.computeSize(-1, -1);
        if (leftSide) {
            this.tipShell.setBounds(x, y, size.x + 5, size.y + 10);
        } else {
            this.tipShell.setBounds(x - size.x, y, size.x + 5, size.y + 10);
        }
        this.label.setForeground(Display.getCurrent().getSystemColor(28));
        this.label.setBackground(Display.getCurrent().getSystemColor(29));
    }

    public void changeBackground(Color bg) {
        this.label.setBackground(bg);
        if ((double)(bg.getRed() + bg.getGreen() + bg.getBlue()) <= 450.0) {
            this.label.setForeground(Display.getCurrent().getSystemColor(1));
        } else {
            this.label.setForeground(Display.getCurrent().getSystemColor(2));
        }
    }

    public static Color lighter(Color color, double fraction) {
        int red = (int)Math.round((double)color.getRed() * (1.0 + fraction));
        int green = (int)Math.round((double)color.getGreen() * (1.0 + fraction));
        int blue = (int)Math.round((double)color.getBlue() * (1.0 + fraction));
        if (red < 0) {
            red = 0;
        } else if (red > 255) {
            red = 255;
        }
        if (green < 0) {
            green = 0;
        } else if (green > 255) {
            green = 255;
        }
        if (blue < 0) {
            blue = 0;
        } else if (blue > 255) {
            blue = 255;
        }
        return new Color(null, red, green, blue);
    }

    public void hideTooltip() {
        this.tipShell.setVisible(false);
    }

    public void dispose() {
        this.label.dispose();
        this.tipShell.dispose();
    }
}

