/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.widgets;

import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.model.TagVO;
import com.moonlit.logfaces.client.model.TagsModel;
import com.moonlit.logfaces.client.widgets.CriteriaComposite;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.JexlCriteria;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TagsComposite
extends Composite {
    private ImageHolder images = ImageHolder.getInstance();
    private TagsModel model = TagsModel.getInstance();
    private TagVO currentTag;
    private CriteriaComposite criteriaComposite;
    private Combo tagsCombo;
    private Label colorPicker;
    private Button enabled;

    public TagsComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        this.createToolbarComposite();
        this.createCriteriaComposite();
        this.populate(this.model.size() == 0 ? null : this.model.getTags().get(0));
        this.pack();
    }

    private void createToolbarComposite() {
        Composite toolbar = new Composite((Composite)this, 0);
        toolbar.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout layout = new GridLayout();
        layout.numColumns = 8;
        layout.horizontalSpacing = 3;
        layout.verticalSpacing = 1;
        toolbar.setLayout((Layout)layout);
        GridData gd = new GridData(3, 2, false, true, 1, 1);
        gd.widthHint = 32;
        gd.heightHint = 32;
        this.colorPicker = new Label(toolbar, 0);
        this.colorPicker.setToolTipText("click to change the tag color");
        this.colorPicker.setLayoutData((Object)gd);
        this.colorPicker.setBackground(this.getBackground());
        this.colorPicker.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (TagsComposite.this.currentTag == null) {
                    return;
                }
                ColorDialog dlg = new ColorDialog(TagsComposite.this.getShell());
                dlg.setRGB(TagsComposite.this.currentTag.getColor().getRGB());
                RGB rgb = dlg.open();
                if (rgb == null) {
                    return;
                }
                TagsComposite.this.currentTag.setColor(new Color(null, rgb));
                TagsComposite.this.colorPicker.setBackground(TagsComposite.this.currentTag.getColor());
                TagsComposite.this.model.store(TagsComposite.this.currentTag);
            }
        });
        this.tagsCombo = new Combo(toolbar, 4);
        this.tagsCombo.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        this.tagsCombo.setVisibleItemCount(this.model.size());
        this.tagsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TagsComposite.this.applyCriteria();
                int sel = TagsComposite.this.tagsCombo.getSelectionIndex();
                if (sel == -1) {
                    TagsComposite.this.currentTag = null;
                    TagsComposite.this.colorPicker.setBackground(TagsComposite.this.getBackground());
                    TagsComposite.this.tagsCombo.setText("");
                    TagsComposite.this.enabled.setSelection(false);
                    TagsComposite.this.criteriaComposite.setCriteria(null);
                    TagsComposite.this.criteriaComposite.setVisible(false);
                    return;
                }
                TagsComposite.this.currentTag = TagsComposite.this.model.get(TagsComposite.this.tagsCombo.getText());
                if (TagsComposite.this.currentTag == null) {
                    return;
                }
                TagsComposite.this.currentTag = TagsComposite.this.currentTag.clone();
                TagsComposite.this.enabled.setSelection(TagsComposite.this.currentTag.isEnabled());
                TagsComposite.this.colorPicker.setBackground(TagsComposite.this.currentTag.getColor());
                if (TagsComposite.this.criteriaComposite != null) {
                    TagsComposite.this.criteriaComposite.setCriteria(TagsComposite.this.currentTag.getCriteria().clone());
                    TagsComposite.this.criteriaComposite.setVisible(true);
                }
            }
        });
        this.enabled = new Button(toolbar, 32);
        this.enabled.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.enabled.setText("enabled");
        this.enabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TagsComposite.this.currentTag == null) {
                    return;
                }
                TagsComposite.this.currentTag.setEnabled(TagsComposite.this.enabled.getSelection());
                TagsComposite.this.model.store(TagsComposite.this.currentTag);
            }
        });
        Button button = new Button(toolbar, 0);
        button.setToolTipText("Create new tag");
        button.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        button.setImage(this.images.getImage("icons/add.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog input = new InputDialog(TagsComposite.this.getShell(), "Create new tag", "Tag name:", "", null);
                if (input.open() != 0 || input.getValue().length() == 0) {
                    return;
                }
                TagsComposite.this.currentTag = TagsComposite.this.model.create(input.getValue()).clone();
                TagsComposite.this.populate(TagsComposite.this.currentTag);
            }
        });
        button = new Button(toolbar, 0);
        button.setToolTipText("Duplicate this tag");
        button.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        button.setImage(this.images.getImage("/icons/copy.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TagsComposite.this.currentTag == null) {
                    return;
                }
                InputDialog input = new InputDialog(TagsComposite.this.getShell(), "Duplicate tag", "Tag name:", String.format("%s (copy)", TagsComposite.this.currentTag.getName()), null);
                if (input.open() != 0 || input.getValue().length() == 0) {
                    return;
                }
                TagVO clone = TagsComposite.this.model.create(input.getValue()).clone();
                clone.setCriteria(TagsComposite.this.currentTag.getCriteria());
                clone.setColor(TagsComposite.this.currentTag.getColor());
                clone.setEnabled(TagsComposite.this.currentTag.isEnabled());
                TagsComposite.this.model.store(clone);
                TagsComposite.this.populate(clone);
            }
        });
        button = new Button(toolbar, 0);
        button.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        button.setToolTipText("rename the tag");
        button.setImage(this.images.getImage("icons/eclipse3_edit.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TagsComposite.this.currentTag == null) {
                    return;
                }
                InputDialog input = new InputDialog(TagsComposite.this.getShell(), "Rename tag", "Tag name:", TagsComposite.this.currentTag.getName(), null);
                if (input.open() != 0 || input.getValue().length() == 0) {
                    return;
                }
                TagsComposite.this.currentTag = TagsComposite.this.model.rename(TagsComposite.this.tagsCombo.getText(), input.getValue()).clone();
                TagsComposite.this.populate(TagsComposite.this.currentTag);
            }
        });
        button = new Button(toolbar, 0);
        button.setToolTipText("delete the tag");
        button.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        button.setImage(this.images.getImage("icons/close.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TagsComposite.this.currentTag == null) {
                    return;
                }
                if (!MessageDialog.openQuestion((Shell)TagsComposite.this.getShell(), (String)"Please confirm", (String)String.format("Delete the '%s' tag ?", TagsComposite.this.tagsCombo.getText()))) {
                    return;
                }
                TagsComposite.this.model.remove(TagsComposite.this.currentTag.getName());
                TagsComposite.this.currentTag = null;
                TagsComposite.this.populate(null);
            }
        });
        button = new Button(toolbar, 0);
        button.setToolTipText("remove all tags");
        button.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        button.setImage(this.images.getImage("icons/eclipse3_clear.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TagsComposite.this.tagsCombo.getItemCount() == 0) {
                    return;
                }
                if (!MessageDialog.openQuestion((Shell)TagsComposite.this.getShell(), (String)"Please confirm", (String)"Remove ALL tags ?")) {
                    return;
                }
                TagsComposite.this.model.clear();
                TagsComposite.this.currentTag = null;
                TagsComposite.this.populate(null);
            }
        });
        toolbar.pack();
    }

    private void populate(TagVO selectedTag) {
        this.tagsCombo.removeAll();
        this.tagsCombo.setVisibleItemCount(this.model.size());
        for (TagVO t : this.model.getTags()) {
            this.tagsCombo.add(t.getName());
            if (!t.equals(selectedTag)) continue;
            this.tagsCombo.select(this.tagsCombo.getItemCount() - 1);
        }
        this.tagsCombo.notifyListeners(13, null);
    }

    private void createCriteriaComposite() {
        this.criteriaComposite = new CriteriaComposite((Composite)this, (CriteriaFilter)new JexlCriteria());
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        gd.heightHint = 300;
        gd.widthHint = 550;
        this.criteriaComposite.setLayoutData(gd);
        this.criteriaComposite.pack();
        this.criteriaComposite.setVisible(false);
    }

    public void applyCriteria() {
        if (this.criteriaComposite != null && this.currentTag != null) {
            CriteriaFilter current = this.criteriaComposite.getCriteria();
            this.currentTag.setCriteria(current);
            this.model.store(this.currentTag);
        }
    }
}

