/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.widgets;

import com.moonlit.logfaces.client.model.TagVO;
import com.moonlit.logfaces.client.widgets.CriteriaComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TagComposite
extends Composite {
    private CriteriaComposite criteriaComposite;
    private Text nameField;
    private Label colorPicker;
    private TagVO tag;

    public TagComposite(Composite parent, TagVO tag) {
        super(parent, 0);
        this.tag = tag;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        this.createToolbarComposite();
        this.createCriteriaComposite();
        this.pack();
    }

    private void createToolbarComposite() {
        Composite toolbar = new Composite((Composite)this, 0);
        toolbar.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        toolbar.setLayout((Layout)layout);
        GridData gd = new GridData(3, 2, false, true, 1, 1);
        gd.widthHint = 32;
        gd.heightHint = 32;
        this.colorPicker = new Label(toolbar, 0);
        this.colorPicker.setToolTipText("click to change the tag color");
        this.colorPicker.setLayoutData((Object)gd);
        this.colorPicker.setBackground(this.tag.getColor());
        this.colorPicker.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ColorDialog dlg = new ColorDialog(TagComposite.this.getShell());
                dlg.setRGB(TagComposite.this.tag.getColor().getRGB());
                RGB rgb = dlg.open();
                if (rgb == null) {
                    return;
                }
                TagComposite.this.tag.setColor(new Color(null, rgb));
                TagComposite.this.colorPicker.setBackground(TagComposite.this.tag.getColor());
            }
        });
        final Button button = new Button(toolbar, 32);
        button.setText("enabled");
        button.setSelection(this.tag.isEnabled());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TagComposite.this.tag.setEnabled(button.getSelection());
            }
        });
        this.nameField = new Text(toolbar, 2048);
        this.nameField.setToolTipText("tag name");
        this.nameField.setText(this.tag.getName());
        this.nameField.selectAll();
        this.nameField.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        Label label = new Label(toolbar, 0);
        label.setText("Specify below the filter critiria for this tag:");
        label.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        toolbar.pack();
    }

    private void createCriteriaComposite() {
        this.criteriaComposite = new CriteriaComposite((Composite)this, this.tag.getCriteria());
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        gd.heightHint = 300;
        gd.widthHint = 550;
        this.criteriaComposite.setLayoutData(gd);
        this.criteriaComposite.pack();
    }

    public void save() {
        this.criteriaComposite.getCriteria();
        this.tag.setName(this.nameField.getText());
    }
}

