/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.widgets;

import com.moonlit.logfaces.client.widgets.ConditionComposite;
import com.moonlit.logfaces.client.widgets.CriteriaComposite;
import com.moonlit.logfaces.server.criteria.Condition;
import com.moonlit.logfaces.server.criteria.Rule;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RuleComposite
extends Composite {
    private Rule rule;
    private Composite content;
    private CriteriaComposite parent;
    private Label andLabel;
    private List<ConditionComposite> composites = new ArrayList<ConditionComposite>();

    public RuleComposite(CriteriaComposite parent, Rule rule) {
        super(parent.getContent(), 1);
        this.parent = parent;
        this.rule = rule;
        this.create();
    }

    public void prompt() {
        if (this.composites.size() != 1) {
            return;
        }
        this.composites.get(0).prompt();
    }

    public void apply() {
        for (ConditionComposite cc : this.composites) {
            cc.apply();
            Condition cond = cc.getCondition();
            if (cond.getAttribute() != null && cond.getOperation() != null) continue;
            this.rule.removeCondition(cond);
        }
    }

    private void create() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.numColumns = 1;
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.andLabel = new Label((Composite)this, 0);
        this.andLabel.setLayoutData((Object)new GridData(2, 2, true, false, 1, 1));
        this.content = new Group((Composite)this, 0);
        this.content.setLayout((Layout)gridLayout);
        this.content.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        for (Condition condition : this.rule.getConditions()) {
            this.addCondition(condition);
        }
    }

    public void setFirst(boolean first) {
        this.andLabel.setText(first ? "Capture log events when:" : "OR");
        this.layout(true);
    }

    public void addCondition(Condition condition) {
        ConditionComposite composite = new ConditionComposite(this, condition);
        composite.setLayoutData(new GridData(4, 2, true, false, 1, 1));
        this.composites.add(composite);
        composite.setFirst(this.composites.size() == 1);
        this.parent.layout(true);
    }

    public void newCondition() {
        Condition condition = this.rule.newCondition();
        ConditionComposite composite = new ConditionComposite(this, condition);
        composite.setLayoutData(new GridData(4, 2, true, false, 1, 1));
        this.composites.add(composite);
        composite.setFirst(this.composites.size() == 1);
        this.parent.layout(true);
        this.parent.showControl((Control)composite);
        composite.prompt();
    }

    public void removeCondition(ConditionComposite composite) {
        this.rule.removeCondition(composite.getCondition());
        this.composites.remove((Object)composite);
        composite.dispose();
        if (this.composites.size() != 0) {
            this.composites.get(0).setFirst(true);
            this.parent.layout(true);
        } else {
            this.parent.removeRule(this);
        }
    }

    public Composite getContent() {
        return this.content;
    }

    public Rule getRule() {
        return this.rule;
    }
}

