/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.widgets;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.actions.ImportPluginsAction;
import com.moonlit.logfaces.client.jobs.SyncPluginsJob;
import com.moonlit.logfaces.client.model.PluginVO;
import com.moonlit.logfaces.client.model.PluginsDelegate;
import com.moonlit.logfaces.client.utils.Compatibility;
import com.moonlit.logfaces.client.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PluginsComposite
extends Composite {
    private static Logger log = LogManager.getLogger(PluginsComposite.class);
    private ImageHolder images = ImageHolder.getInstance();
    private Button buttonAdd;
    private Button buttonImport;
    private Button buttonRemove;
    private Button buttonSync;
    private Table table;

    public PluginsComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        this.setLayout((Layout)gridLayout);
        this.createView();
        this.populateTable();
        this.pack();
    }

    private void createView() {
        Label label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData(1, 2, true, false, 1, 1));
        label.setText("Currently used plugins:");
        this.buttonAdd = new Button((Composite)this, 0);
        this.buttonAdd.setToolTipText("Add plugin from local files");
        this.buttonAdd.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        this.buttonAdd.setImage(this.images.getImage("icons/add.gif"));
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginsComposite.this.addPlugin();
            }
        });
        this.buttonImport = new Button((Composite)this, 0);
        this.buttonImport.setToolTipText("Import plugins from server");
        this.buttonImport.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        this.buttonImport.setImage(this.images.getImage("/icons/eclipse3_import.gif"));
        this.buttonImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginsComposite.this.importPlugins();
            }
        });
        this.buttonRemove = new Button((Composite)this, 0);
        this.buttonRemove.setToolTipText("Remove selected plugins");
        this.buttonRemove.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        this.buttonRemove.setImage(this.images.getImage("icons/close.gif"));
        this.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginsComposite.this.removePlugins();
            }
        });
        this.buttonSync = new Button((Composite)this, 0);
        this.buttonSync.setToolTipText("Synchronize local plugins with server");
        this.buttonSync.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        this.buttonSync.setImage(this.images.getImage("/icons/eclipse3_update.gif"));
        this.buttonSync.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginsComposite.this.syncPlugins();
            }
        });
        this.table = new Table((Composite)this, 68354);
        GridData gridData = new GridData(4, 4, true, true, 5, 1);
        gridData.heightHint = 200;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(false);
        this.table.setHeaderVisible(false);
        this.enableControls(true);
    }

    private void populateTable() {
        ImageHolder images = ImageHolder.getInstance();
        this.table.removeAll();
        for (PluginVO pvo : PluginsDelegate.getInstance().getWorkspacePlugins()) {
            TableItem item = new TableItem(this.table, 0);
            item.setImage(0, images.getImage("/icons/plugin.gif"));
            item.setText(0, pvo.getName());
            item.setData((Object)pvo);
        }
    }

    private void enableControls(boolean enable) {
        this.buttonAdd.setEnabled(enable && !Application.isServerMode());
        this.buttonImport.setEnabled(enable && !Application.isServerMode() && Compatibility.canUsePlugins());
        this.buttonSync.setEnabled(enable && !Application.isServerMode() && Compatibility.canUsePlugins());
        this.buttonRemove.setEnabled(enable);
        this.table.setEnabled(enable);
    }

    private void addPlugin() {
        Utils.displayOneTimeTipModal("tip_addplugin", "You will be prompted to select plugin files for storing in this workpsace.\nMake sure to select ALL dependencies relevant for the plugin.\n\n(this message will not appear again)");
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        FileDialog dialog = new FileDialog(window.getShell(), 4098);
        dialog.setText("Select plugin files");
        dialog.setFilterExtensions(new String[]{"*.*"});
        dialog.setFilterNames(new String[]{"All files (*.*)"});
        if (dialog.open() == null) {
            return;
        }
        try {
            this.enableControls(false);
            ArrayList files = Lists.newArrayList();
            String[] stringArray = dialog.getFileNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                files.add(new File(String.format("%s%s%s", dialog.getFilterPath(), File.separator, name)));
                ++n2;
            }
            PluginsDelegate.getInstance().addPlugin(files);
            this.populateTable();
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            Utils.displayException("Failed", e.getMessage(), e);
        }
        this.enableControls(true);
    }

    private void importPlugins() {
        this.enableControls(false);
        new ImportPluginsAction(new Runnable(){

            @Override
            public void run() {
                PluginsComposite.this.enableControls(true);
                PluginsComposite.this.populateTable();
            }
        }).run();
    }

    private void syncPlugins() {
        if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)"Please confirm", (String)"This will download and replace all existing plugins from server")) {
            return;
        }
        this.enableControls(false);
        SyncPluginsJob job = new SyncPluginsJob(new Runnable(){

            @Override
            public void run() {
                PluginsComposite.this.enableControls(true);
                PluginsComposite.this.populateTable();
            }
        });
        job.setUser(true);
        job.schedule();
    }

    private void removePlugins() {
        TableItem[] selection = this.table.getSelection();
        if (selection == null || selection.length == 0) {
            return;
        }
        TableItem[] tableItemArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            PluginVO pvo = (PluginVO)item.getData();
            PluginsDelegate.getInstance().remove(pvo);
            ++n2;
        }
        this.populateTable();
    }
}

