/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.widgets;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.dialogs.PatternsTestDialog;
import com.moonlit.logfaces.client.model.ParserVO;
import com.moonlit.logfaces.client.model.ParsersModel;
import com.moonlit.logfaces.client.net.ConnectionProfile;
import com.moonlit.logfaces.client.net.LfsConnector;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class ParsersComposite
extends Composite {
    private ImageHolder images = ImageHolder.getInstance();
    private ParsersModel model = ParsersModel.getInstance();
    private ParserVO currentParser;
    private Button buttonAdd;
    private Button buttonImport;
    private Button buttonRemove;
    private Button buttonRename;
    private Button buttonClear;
    private Button buttonDuplicate;
    private Button buttonTest;
    private Combo combo;
    private Combo comboPattern;
    private Combo comboXpattern;
    private Combo comboDtf;

    public ParsersComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 8;
        this.setLayout((Layout)gridLayout);
        this.createToolbarComposite();
        this.createParserComposite();
        this.populate(this.model.size() == 0 ? null : this.model.getParsers().get(0));
        this.pack();
    }

    public void apply() {
        if (this.currentParser == null) {
            return;
        }
        this.currentParser.setPattern(this.comboPattern.getText());
        this.currentParser.setPatternEx(this.comboXpattern.getText());
        this.currentParser.setDtf(this.comboDtf.getText());
        this.model.store(this.currentParser);
    }

    private void createToolbarComposite() {
        Label label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        label.setText("Parser name");
        GridData gd = new GridData(4, 2, true, false, 1, 1);
        gd.widthHint = 150;
        this.combo = new Combo((Composite)this, 8);
        this.combo.setLayoutData((Object)gd);
        this.combo.setVisibleItemCount(this.model.size());
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParsersComposite.this.apply();
                ParsersComposite.this.currentParser = ParsersComposite.this.model.get(ParsersComposite.this.combo.getText());
                ParsersComposite.this.currentParser = ParsersComposite.this.currentParser != null ? ParsersComposite.this.currentParser.clone() : null;
                ParsersComposite.this.combo.setText(ParsersComposite.this.currentParser != null ? ParsersComposite.this.currentParser.getName() : "");
                ParsersComposite.this.displayParser();
            }
        });
        this.buttonAdd = new Button((Composite)this, 0);
        this.buttonAdd.setToolTipText("Define new parser");
        this.buttonAdd.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.buttonAdd.setImage(this.images.getImage("icons/add.gif"));
        this.buttonAdd.setFocus();
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog input = new InputDialog(ParsersComposite.this.getShell(), "Define new parser", "Parser name is something useful for you to remember it by", "my special log files", null);
                if (input.open() != 0 || input.getValue().length() == 0) {
                    return;
                }
                ParsersComposite.this.populate(ParsersComposite.this.model.create(input.getValue()));
            }
        });
        this.buttonImport = new Button((Composite)this, 0);
        this.buttonImport.setToolTipText("Import log parser from current server connection");
        this.buttonImport.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.buttonImport.setImage(this.images.getImage("/icons/eclipse3_import.gif"));
        this.buttonImport.setEnabled(!Application.isServerMode());
        this.buttonImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LfsConnector connector = LfsConnector.getInstance();
                Map parsers = connector.getConnection().getParsers(connector.getSid());
                if (parsers.isEmpty()) {
                    MessageDialog.openInformation((Shell)ParsersComposite.this.getShell(), (String)"No parsers available", (String)"There are no parsers defined at this server instance.\n(note that parsers are taken from DropZone receivers)");
                    return;
                }
                ArrayList list = Lists.newArrayList(parsers.keySet());
                ListDialog dlg = new ListDialog(ParsersComposite.this.getShell());
                dlg.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                dlg.setInitialSelections(new Object[]{list.get(0)});
                dlg.setLabelProvider((ILabelProvider)new LabelProvider());
                dlg.setInput((Object)list);
                dlg.setTitle("Currently available parsers");
                dlg.setMessage(String.format("Those are log parsers currently used on server %s.\nSelect one to import into your environment", ConnectionProfile.getInstance().getServerHost()));
                if (dlg.open() != 0) {
                    return;
                }
                String name = (String)dlg.getResult()[0];
                Map params = (Map)parsers.get(name);
                ParserVO parser = ParsersComposite.this.model.create(name);
                parser.setPattern((String)params.get("pattern"));
                parser.setPatternEx((String)params.get("xpattern"));
                parser.setDtf((String)params.get("dtf"));
                ParsersComposite.this.populate(parser);
            }
        });
        this.buttonDuplicate = new Button((Composite)this, 0);
        this.buttonDuplicate.setToolTipText("Duplicate this parser");
        this.buttonDuplicate.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.buttonDuplicate.setImage(this.images.getImage("/icons/copy.gif"));
        this.buttonDuplicate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ParsersComposite.this.currentParser == null) {
                    return;
                }
                InputDialog input = new InputDialog(ParsersComposite.this.getShell(), "Duplicate parser", "Parser name:", String.format("%s (copy)", ParsersComposite.this.currentParser.getName()), null);
                if (input.open() != 0 || input.getValue().length() == 0) {
                    return;
                }
                ParserVO parser = ParsersComposite.this.currentParser.clone();
                parser.setName(input.getValue());
                ParsersComposite.this.model.store(parser);
                ParsersComposite.this.populate(parser);
            }
        });
        this.buttonRename = new Button((Composite)this, 0);
        this.buttonRename.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.buttonRename.setToolTipText("rename this parser");
        this.buttonRename.setImage(this.images.getImage("icons/eclipse3_edit.gif"));
        this.buttonRename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ParsersComposite.this.currentParser == null) {
                    return;
                }
                InputDialog input = new InputDialog(ParsersComposite.this.getShell(), "Rename parser", "Parser name:", ParsersComposite.this.currentParser.getName(), null);
                if (input.open() != 0 || input.getValue().length() == 0) {
                    return;
                }
                ParsersComposite.this.currentParser = ParsersComposite.this.model.rename(ParsersComposite.this.combo.getText(), input.getValue());
                ParsersComposite.this.populate(ParsersComposite.this.currentParser);
            }
        });
        this.buttonRemove = new Button((Composite)this, 0);
        this.buttonRemove.setToolTipText("delete this parser");
        this.buttonRemove.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.buttonRemove.setImage(this.images.getImage("icons/close.gif"));
        this.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ParsersComposite.this.currentParser == null) {
                    return;
                }
                if (!MessageDialog.openQuestion((Shell)ParsersComposite.this.getShell(), (String)"Please confirm", (String)String.format("Delete the '%s' parser ?", ParsersComposite.this.combo.getText()))) {
                    return;
                }
                ParsersComposite.this.model.remove(ParsersComposite.this.currentParser.getName());
                ParserVO parser = ParsersComposite.this.model.size() == 0 ? null : ParsersComposite.this.model.getParsers().get(0);
                ParsersComposite.this.populate(parser);
            }
        });
        this.buttonClear = new Button((Composite)this, 0);
        this.buttonClear.setToolTipText("remove all parsers");
        this.buttonClear.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.buttonClear.setImage(this.images.getImage("icons/eclipse3_clear.gif"));
        this.buttonClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ParsersComposite.this.combo.getItemCount() == 0) {
                    return;
                }
                if (!MessageDialog.openQuestion((Shell)ParsersComposite.this.getShell(), (String)"Please confirm", (String)"Remove ALL parsers ?")) {
                    return;
                }
                ParsersComposite.this.model.clear();
                ParsersComposite.this.populate(null);
            }
        });
    }

    private void createParserComposite() {
        Label label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        label.setText("Main pattern");
        label.setToolTipText("Regular expression for parsing log lines\nThis is a main regular expression pattern to be applied for each\ntext line in parsed log files");
        GridData gd = new GridData(4, 2, true, true, 7, 1);
        gd.widthHint = 150;
        this.comboPattern = new Combo((Composite)this, 4);
        this.comboPattern.setToolTipText("Regular expression for parsing log lines\nThis is a main regular expression pattern to be applied for each\ntext line in parsed log files");
        this.comboPattern.setLayoutData((Object)gd);
        for (String string : this.model.getOptions("pattern")) {
            this.comboPattern.add(string);
        }
        label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        label.setText("X pattern (optional)");
        label.setToolTipText("Regular expression for parsing multi-line stack traces\nThis is an optional parameter, leave blank if not sure");
        this.comboXpattern = new Combo((Composite)this, 4);
        this.comboXpattern.setToolTipText("Regular expression for parsing multi-line stack traces\nThis is an optional parameter, leave blank if not sure");
        this.comboXpattern.setLayoutData((Object)new GridData(4, 2, true, true, 7, 1));
        for (String string : this.model.getOptions("patternx")) {
            this.comboXpattern.add(string);
        }
        label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        label.setText("Date time format");
        label.setToolTipText("Format of the date time stamp for converting text into time\nThis format is individual for most log files.\nFor example: DD-MM-YYYY hh:mm:ss");
        this.comboDtf = new Combo((Composite)this, 4);
        this.comboDtf.setToolTipText("Format of the date time stamp for converting text into time\nThis format is individual for most log files.\nFor example: DD-MM-YYYY hh:mm:ss");
        this.comboDtf.setLayoutData((Object)new GridData(4, 2, true, true, 7, 1));
        for (String string : this.model.getOptions("dtf")) {
            this.comboDtf.add(string);
        }
        label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        label.setText("");
        this.buttonTest = new Button((Composite)this, 0);
        this.buttonTest.setText("TEST");
        this.buttonTest.setToolTipText("Test this parser with some input\nOnce you are satisfied with the result, the parser is ready for use.");
        this.buttonTest.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        this.buttonTest.setImage(this.images.getButtonImage("icons/level_debug3.gif"));
        this.buttonTest.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParsersComposite.this.apply();
                if (ParsersComposite.this.currentParser == null) {
                    return;
                }
                PatternsTestDialog dialog = new PatternsTestDialog(ParsersComposite.this.getShell(), ParsersComposite.this.currentParser);
                dialog.open();
            }
        });
    }

    private void populate(ParserVO current) {
        this.combo.removeAll();
        this.combo.setVisibleItemCount(this.model.size());
        for (ParserVO parser : this.model.getParsers()) {
            this.combo.add(parser.getName());
            if (!parser.equals(current)) continue;
            this.combo.select(this.combo.getItemCount() - 1);
        }
        this.currentParser = current;
        this.displayParser();
    }

    private void displayParser() {
        this.combo.setEnabled(this.model.size() > 0);
        this.buttonRemove.setEnabled(this.currentParser != null);
        this.buttonRename.setEnabled(this.currentParser != null);
        this.buttonClear.setEnabled(this.model.size() > 0);
        this.buttonDuplicate.setEnabled(this.currentParser != null);
        this.comboPattern.setEnabled(this.currentParser != null);
        this.comboXpattern.setEnabled(this.currentParser != null);
        this.comboDtf.setEnabled(this.currentParser != null);
        this.comboPattern.setText(this.currentParser != null ? this.currentParser.getPattern() : "");
        this.comboXpattern.setText(this.currentParser != null ? this.currentParser.getPatternEx() : "");
        this.comboDtf.setText(this.currentParser != null ? this.currentParser.getDtf() : "");
        this.buttonTest.setEnabled(this.currentParser != null);
    }
}

