/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.widgets;

import com.moonlit.logfaces.client.editors.LogView;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.client.model.TagVO;
import com.moonlit.logfaces.client.model.TagsModel;
import com.moonlit.logfaces.client.model.data.Annotation;
import com.moonlit.logfaces.client.model.data.AnnotationType;
import com.moonlit.logfaces.client.utils.ContextMenuBuilder;
import com.moonlit.logfaces.client.widgets.OverviewBar;
import com.moonlit.logfaces.server.core.LogEvent;
import java.text.SimpleDateFormat;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class OverviewTagBar
extends OverviewBar {
    protected Rectangle rect = new Rectangle(0, 0, 0, 0);
    protected SimpleDateFormat timeFormat = new SimpleDateFormat("dd MMM HH:mm:ss | ");
    protected TagsModel tagsModel = TagsModel.getInstance();
    private boolean showTags;

    public OverviewTagBar(Composite parent, LogView view) {
        super(parent, view);
    }

    @Override
    protected void doPaint(GC gc) {
        if (this.model == null) {
            return;
        }
        Point canvasSize = this.canvas.getSize();
        int modelSize = this.model.getSize();
        if (modelSize * this.itemHight < canvasSize.y) {
            return;
        }
        this.positions.clear();
        if (this.showTags) {
            for (Annotation annotation : this.model.getAnnotations(AnnotationType.TAG)) {
                this.paint(annotation, gc, canvasSize, modelSize);
            }
        }
        for (Annotation annotation : this.model.getAnnotations(AnnotationType.BOOKMARK)) {
            this.paint(annotation, gc, canvasSize, modelSize);
        }
    }

    protected void paint(Annotation annotation, GC gc, Point canvasSize, int modelSize) {
        Color color = this.getColor(annotation);
        if (color == null) {
            return;
        }
        Color stroke = color;
        int yy = Math.min(annotation.getLocation() * canvasSize.y / modelSize, canvasSize.y - this.ANNOTATION_HEIGHT);
        this.positions.put(yy, annotation);
        gc.setBackground(color);
        gc.fillRectangle(this.INSET, yy, canvasSize.x - 2 * this.INSET, this.ANNOTATION_HEIGHT);
        gc.setForeground(stroke);
        this.rect.x = this.INSET;
        this.rect.y = yy;
        this.rect.width = canvasSize.x - 2 * this.INSET;
        this.rect.height = this.ANNOTATION_HEIGHT;
        gc.setLineWidth(0);
        gc.drawRectangle(this.rect);
    }

    protected Color getColor(Annotation annotation) {
        if (annotation.isBookmark()) {
            return EventStyles.BG_DRILL;
        }
        if (annotation.isTag()) {
            TagVO tag = this.tagsModel.findOne(annotation.getEvent());
            return tag != null ? tag.getColor() : null;
        }
        return null;
    }

    @Override
    protected void handleMouseDown(MouseEvent event) {
        TagVO tag;
        this.tooltip.hideTooltip();
        Annotation annotation = this.mouse2annotation(event.y);
        if (annotation == null) {
            this.tooltip.hideTooltip();
            return;
        }
        if (event.button > 1 && (tag = this.tagsModel.findOne(annotation.getEvent())) != null) {
            ContextMenuBuilder.buildForTags((Control)this.canvas, this.view, tag);
        }
        this.view.handleOverviewSelection(annotation.getLocation(), event.y);
    }

    @Override
    protected void handleMouseMove(MouseEvent me) {
        this.canvas.setCursor(this.defaultCursor);
        this.tooltip.hideTooltip();
        Annotation annotation = this.mouse2annotation(me.y);
        if (annotation != null) {
            this.canvas.setCursor(this.handCursor);
            if (me.x > 0 && me.x < this.canvas.getSize().x) {
                Point p = Display.getCurrent().getCursorLocation();
                LogEvent event = annotation.getEvent();
                String message = StringUtils.abbreviate((String)event.getMessage(), (int)120);
                String title = annotation.isBookmark() ? "bookmark" : (String)event.getProperties().get("tags");
                this.tooltip.showTooltip(true, p.x + 12, p.y + 20, String.format("%s: %s", title, message));
                this.tooltip.changeBackground(this.getColor(annotation));
            }
        }
    }

    @Override
    protected Annotation mouse2annotation(int y) {
        int i = y - this.ANNOTATION_HEIGHT;
        while (i <= y + this.ANNOTATION_HEIGHT) {
            Annotation annotation = (Annotation)this.positions.get(i);
            if (annotation != null) {
                return annotation;
            }
            ++i;
        }
        return null;
    }

    public boolean isShowTags() {
        return this.showTags;
    }

    public void setShowTags(boolean showTags) {
        this.showTags = showTags;
    }
}

