/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.widgets;

import com.moonlit.logfaces.client.editors.LogView;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.client.model.data.Annotation;
import com.moonlit.logfaces.client.model.data.AnnotationType;
import com.moonlit.logfaces.client.widgets.OverviewBar;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class OverviewLevelBar
extends OverviewBar {
    protected SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    protected Map<AnnotationType, Color> colors = new HashMap<AnnotationType, Color>();

    public OverviewLevelBar(Composite parent, LogView view) {
        super(parent, view);
        this.colors.put(AnnotationType.BOOKMARK, new Color(null, 0, 0, 140));
        this.colors.put(AnnotationType.ERROR, EventStyles.RULER_ERROR);
        this.colors.put(AnnotationType.WARNING, EventStyles.RULER_WARN);
        this.colors.put(AnnotationType.FATAL, EventStyles.RULER_FATAL);
        this.colors.put(AnnotationType.EXCEPTION, EventStyles.RULER_EXCEPT);
    }

    @Override
    protected void doPaint(GC gc) {
        if (this.model == null) {
            return;
        }
        Point size = this.canvas.getSize();
        if (this.model.getSize() * this.itemHight < size.y) {
            return;
        }
        this.positions.clear();
        Rectangle r = new Rectangle(0, 0, 0, 0);
        int hh = this.ANNOTATION_HEIGHT;
        int modelSize = this.model.getSize();
        for (Annotation annotation : this.model.getAnnotations(AnnotationType.ERROR)) {
            Color fill;
            Color stroke = fill = this.colors.get((Object)annotation.getType());
            int yy = Math.min(annotation.getLocation() * size.y / modelSize, size.y - hh);
            this.positions.put(yy, annotation);
            gc.setBackground(fill);
            gc.fillRectangle(this.INSET, yy, size.x - 2 * this.INSET, hh);
            gc.setForeground(stroke);
            r.x = this.INSET;
            r.y = yy;
            r.width = size.x - 2 * this.INSET;
            r.height = hh;
            gc.setLineWidth(0);
            gc.drawRectangle(r);
        }
    }

    @Override
    protected void handleMouseDown(MouseEvent event) {
        Annotation annotation = this.mouse2annotation(event);
        if (annotation != null) {
            this.view.handleOverviewSelection(annotation.getLocation(), event.y);
        }
        this.tooltip.hideTooltip();
    }

    @Override
    protected void handleMouseMove(MouseEvent mevent) {
        this.canvas.setCursor(this.defaultCursor);
        this.tooltip.hideTooltip();
        Annotation annotation = this.mouse2annotation(mevent);
        if (annotation != null) {
            this.canvas.setCursor(this.handCursor);
            if (mevent.x > 0 && mevent.x < this.canvas.getSize().x) {
                Point p = Display.getCurrent().getCursorLocation();
                LogEvent event = annotation.getEvent();
                String message = StringUtils.abbreviate((String)event.getMessage(), (int)120);
                this.tooltip.showTooltip(false, p.x + 12, p.y + 20, String.format("%s %s, %s, %s%n%s", this.timeFormat.format(new Date(event.getLoggerTimeStamp())), LfsLevel.toLevel((int)event.getLoggerLevel()).name(), event.getHostName(), event.getDomainName(), message));
                this.tooltip.changeBackground(EventStyles.getInstance().getStyle(event).getBackground());
                if (event instanceof LoggingEventVO && ((LoggingEventVO)event).isThrown()) {
                    this.tooltip.changeBackground(EventStyles.getInstance().getDarkerBackground(event.getLoggerLevel()));
                }
            }
        }
    }

    protected Annotation mouse2annotation(MouseEvent event) {
        int i = event.y - this.ANNOTATION_HEIGHT;
        while (i <= event.y + this.ANNOTATION_HEIGHT) {
            Annotation annotation = (Annotation)this.positions.get(i);
            if (annotation != null) {
                return annotation;
            }
            ++i;
        }
        return null;
    }
}

